/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.TIMESTAMP;

class NTFAQEvent
extends AQNotificationEvent {
    private String registrationString;
    private int namespace;
    private byte[] payload;
    private String queueName = null;
    private byte[] messageId = null;
    private String consumerName = null;
    private NTFConnection conn;
    private AQMessagePropertiesI msgProp;
    private AQNotificationEvent.EventType eventType = AQNotificationEvent.EventType.REGULAR;
    private ByteBuffer dataBuffer;
    private boolean isReady = false;
    private short databaseVersion;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:27_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFAQEvent(NTFConnection _conn, short _databaseVersion) throws IOException {
        super(_conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_conn));
                OracleLog.recursiveTrace = false;
            }
            this.conn = _conn;
            int lengthDataHandle = this.conn.readInt();
            byte[] data = new byte[lengthDataHandle];
            this.conn.readBuffer(data, 0, lengthDataHandle);
            this.dataBuffer = ByteBuffer.wrap(data);
            this.databaseVersion = _databaseVersion;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEvent() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte registrationType = this.dataBuffer.get();
            int registrationLength = this.dataBuffer.getInt();
            byte[] registrationBuffer = new byte[registrationLength];
            this.dataBuffer.get(registrationBuffer, 0, registrationLength);
            this.registrationString = this.conn.charset.toString(registrationBuffer, 0, registrationLength);
            byte namespaceType = this.dataBuffer.get();
            int namespaceLength = this.dataBuffer.getInt();
            byte[] namespaceBuffer = new byte[namespaceLength];
            this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
            this.namespace = namespaceBuffer[0];
            byte notificationType = this.dataBuffer.get();
            int notificationLength = this.dataBuffer.getInt();
            if (notificationLength > 0) {
                this.payload = new byte[notificationLength];
                this.dataBuffer.get(this.payload, 0, notificationLength);
            } else {
                this.payload = null;
            }
            if (this.dataBuffer.hasRemaining()) {
                int deliveryMode = 0;
                if (this.databaseVersion >= 10200) {
                    byte deliveryModeType = this.dataBuffer.get();
                    int deliveryModeLength = this.dataBuffer.getInt();
                    deliveryMode = this.dataBuffer.getInt();
                }
                byte queueNameType = this.dataBuffer.get();
                int queueNameLength = this.dataBuffer.getInt();
                byte[] queueNameBuffer = new byte[queueNameLength];
                this.dataBuffer.get(queueNameBuffer, 0, queueNameLength);
                this.queueName = this.conn.charset.toString(queueNameBuffer, 0, queueNameLength);
                byte messageIdType = this.dataBuffer.get();
                int messageIdLength = this.dataBuffer.getInt();
                this.messageId = new byte[messageIdLength];
                this.dataBuffer.get(this.messageId, 0, messageIdLength);
                byte consumerNameType = this.dataBuffer.get();
                int consumerNameLength = this.dataBuffer.getInt();
                byte[] consumerNameBuffer = new byte[consumerNameLength];
                this.dataBuffer.get(consumerNameBuffer, 0, consumerNameLength);
                this.consumerName = this.conn.charset.toString(consumerNameBuffer, 0, consumerNameLength);
                byte prioritySignType = this.dataBuffer.get();
                int prioritySignLength = this.dataBuffer.getInt();
                byte[] prioritySign = new byte[prioritySignLength];
                this.dataBuffer.get(prioritySign, 0, prioritySignLength);
                byte priorityType = this.dataBuffer.get();
                int priorityLength = this.dataBuffer.getInt();
                int priority_l = this.dataBuffer.getInt();
                if (prioritySign[0] == 1) {
                    priority_l = -priority_l;
                }
                int priority = priority_l;
                byte delayType = this.dataBuffer.get();
                int delayLength = this.dataBuffer.getInt();
                int delay = this.dataBuffer.getInt();
                byte expirationSignType = this.dataBuffer.get();
                int expirationSignLength = this.dataBuffer.getInt();
                byte[] expirationSign = new byte[expirationSignLength];
                this.dataBuffer.get(expirationSign, 0, expirationSignLength);
                byte expirationType = this.dataBuffer.get();
                int expirationLength = this.dataBuffer.getInt();
                int expiration_l = this.dataBuffer.getInt();
                if (expirationSign[0] == 1) {
                    expiration_l = -expiration_l;
                }
                int expiration = expiration_l;
                byte attemptsType = this.dataBuffer.get();
                int attemptsLength = this.dataBuffer.getInt();
                int attempts = this.dataBuffer.getInt();
                byte timestampType = this.dataBuffer.get();
                int timestampLength = this.dataBuffer.getInt();
                byte[] timestampBytes = new byte[timestampLength];
                this.dataBuffer.get(timestampBytes, 0, timestampLength);
                TIMESTAMP timestamp = new TIMESTAMP(timestampBytes);
                byte stateBType = this.dataBuffer.get();
                int stateBLength = this.dataBuffer.getInt();
                byte[] stateB = new byte[stateBLength];
                this.dataBuffer.get(stateB, 0, stateBLength);
                byte state = stateB[0];
                byte exceptionQueueType = this.dataBuffer.get();
                int exceptionQueueLength = this.dataBuffer.getInt();
                byte[] exceptionQueueBuffer = new byte[exceptionQueueLength];
                this.dataBuffer.get(exceptionQueueBuffer, 0, exceptionQueueLength);
                String exceptionQueue = this.conn.charset.toString(exceptionQueueBuffer, 0, exceptionQueueLength);
                byte correlationIdType = this.dataBuffer.get();
                int correlationIdLength = this.dataBuffer.getInt();
                byte[] correlationIdBuff = new byte[correlationIdLength];
                this.dataBuffer.get(correlationIdBuff, 0, correlationIdLength);
                String correlationId = this.conn.charset.toString(correlationIdBuff, 0, correlationIdLength);
                byte originalMessageIdType = this.dataBuffer.get();
                int originalMessageIdLength = this.dataBuffer.getInt();
                byte[] originalMessageId = null;
                if (originalMessageIdLength > 0) {
                    originalMessageId = new byte[originalMessageIdLength];
                    this.dataBuffer.get(originalMessageId, 0, originalMessageIdLength);
                }
                byte agentNameType = this.dataBuffer.get();
                int agentNameLength = this.dataBuffer.getInt();
                byte[] agentNameBuffer = new byte[agentNameLength];
                this.dataBuffer.get(agentNameBuffer, 0, agentNameLength);
                String agentName = this.conn.charset.toString(agentNameBuffer, 0, agentNameLength);
                byte agentAddressType = this.dataBuffer.get();
                int agentAddressLength = this.dataBuffer.getInt();
                byte[] agentAddressBuffer = new byte[agentAddressLength];
                this.dataBuffer.get(agentAddressBuffer, 0, agentAddressLength);
                String agentAddress = this.conn.charset.toString(agentAddressBuffer, 0, agentAddressLength);
                byte agentProtocolType = this.dataBuffer.get();
                int agentProtocolLength = this.dataBuffer.getInt();
                byte agentProtocol = this.dataBuffer.get();
                this.msgProp = new AQMessagePropertiesI();
                this.msgProp.setAttempts(attempts);
                this.msgProp.setCorrelation(correlationId);
                this.msgProp.setDelay(delay);
                this.msgProp.setEnqueueTime(timestamp.timestampValue());
                this.msgProp.setMessageState(AQMessageProperties.MessageState.getMessageState(state));
                if (this.databaseVersion >= 10200) {
                    this.msgProp.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(deliveryMode));
                }
                this.msgProp.setPreviousQueueMessageId(originalMessageId);
                AQAgentI senderAgent = new AQAgentI();
                senderAgent.setAddress(agentAddress);
                senderAgent.setName(agentName);
                senderAgent.setProtocol(agentProtocol);
                this.msgProp.setSender(senderAgent);
                this.msgProp.setPriority(priority);
                this.msgProp.setExpiration(expiration);
                this.msgProp.setExceptionQueue(exceptionQueue);
            }
            this.isReady = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQMessageProperties getMessageProperties() throws SQLException {
        AQMessagePropertiesI aQMessagePropertiesI;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.msgProp);
                    OracleLog.recursiveTrace = false;
                }
                aQMessagePropertiesI = this.msgProp;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return aQMessagePropertiesI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRegistration() throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.registrationString);
                    OracleLog.recursiveTrace = false;
                }
                string = this.registrationString;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQNotificationEvent.EventType getEventType() {
        AQNotificationEvent.EventType eventType;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (Object)((Object)this.eventType));
                    OracleLog.recursiveTrace = false;
                }
                eventType = this.eventType;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEventType(AQNotificationEvent.EventType _type) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument((Object)_type));
                OracleLog.recursiveTrace = false;
            }
            this.eventType = _type;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPayload() throws SQLException {
        byte[] byArray;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.payload);
                    OracleLog.recursiveTrace = false;
                }
                byArray = this.payload;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQueueName() throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.queueName);
                    OracleLog.recursiveTrace = false;
                }
                string = this.queueName;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMessageId() throws SQLException {
        byte[] byArray;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.messageId);
                    OracleLog.recursiveTrace = false;
                }
                byArray = this.messageId;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConsumerName() throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.consumerName);
                    OracleLog.recursiveTrace = false;
                }
                string = this.consumerName;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionInformation() {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.conn.connectionDescription);
                    OracleLog.recursiveTrace = false;
                }
                string = this.conn.connectionDescription;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String string;
        block13: {
            block12: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        NTFAQEvent.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.isReady) break block12;
                    try {
                        this.initEvent();
                    }
                    catch (SQLException ex) {
                        String string2 = ex.getMessage();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return string2;
                    }
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
            sb.append("Event type              : " + (Object)((Object)this.eventType) + "\n");
            sb.append("Namespace               : " + this.namespace + "\n");
            sb.append("Registration            : " + this.registrationString + "\n");
            sb.append("Queue name              : " + this.queueName + "\n");
            sb.append("Consumer name           : " + this.consumerName + "\n");
            if (this.payload != null) {
                sb.append("Payload length          : " + this.payload.length + "\n");
                sb.append("Payload (first 50 bytes): " + NTFAQEvent.byteBufferToHexString(this.payload, 50) + "\n");
            } else {
                sb.append("Payload                 : null\n");
            }
            sb.append("Message ID              : " + NTFAQEvent.byteBufferToHexString(this.messageId, 50) + "\n");
            if (this.msgProp != null) {
                sb.append(this.msgProp.toString());
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + sb.toString());
                OracleLog.recursiveTrace = false;
            }
            string = sb.toString();
            if (!TRACE || OracleLog.recursiveTrace) break block13;
            OracleLog.recursiveTrace = true;
            NTFAQEvent.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String byteBufferToHexString(byte[] buffer, int maxNbOfBytes) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(maxNbOfBytes));
                OracleLog.recursiveTrace = false;
            }
            if (buffer == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFAQEvent.logger().log(OracleLog.TRACE_30, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            boolean isFirst = true;
            StringBuffer sb = new StringBuffer();
            for (int offset = 0; offset < buffer.length && offset < maxNbOfBytes; ++offset) {
                if (!isFirst) {
                    sb.append(' ');
                } else {
                    isFirst = false;
                }
                String hexrep = Integer.toHexString(buffer[offset] & 0xFF);
                if (hexrep.length() == 1) {
                    hexrep = "0" + hexrep;
                }
                sb.append(hexrep);
            }
            String ret = sb.toString();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_30, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFAQEvent.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFAQEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

