/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.driver.OracleLog;

class NTFDCNQueryChanges
implements QueryChangeDescription {
    private final long queryId;
    private final QueryChangeDescription.QueryChangeEventType queryopflags;
    private final int numberOfTables;
    private final NTFDCNTableChanges[] tcdesc;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:27_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNQueryChanges(ByteBuffer data, int csid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(csid));
                OracleLog.recursiveTrace = false;
            }
            long queryId1 = data.getInt();
            long queryId2 = data.getInt();
            this.queryId = queryId1 | queryId2 << 32;
            this.queryopflags = QueryChangeDescription.QueryChangeEventType.getQueryChangeEventType(data.getInt());
            this.numberOfTables = data.getShort();
            this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
            for (int j2 = 0; j2 < this.tcdesc.length; ++j2) {
                this.tcdesc[j2] = new NTFDCNTableChanges(data, csid);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueryId() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "return: " + this.queryId);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.queryId;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryChangeDescription.QueryChangeEventType getQueryChangeEventType() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "return: " + (Object)((Object)this.queryopflags));
                OracleLog.recursiveTrace = false;
            }
            QueryChangeDescription.QueryChangeEventType queryChangeEventType = this.queryopflags;
            return queryChangeEventType;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "return: " + this.tcdesc);
                OracleLog.recursiveTrace = false;
            }
            TableChangeDescription[] tableChangeDescriptionArray = this.tcdesc;
            return tableChangeDescriptionArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFDCNQueryChanges.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNQueryChanges.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("  query ID=" + this.queryId + ", query change event type=" + (Object)((Object)this.queryopflags) + "\n");
                TableChangeDescription[] rdesc = this.getTableChangeDescription();
                if (rdesc != null) {
                    sb.append("  Table Change Description (length=" + rdesc.length + "):");
                    for (int i2 = 0; i2 < rdesc.length; ++i2) {
                        sb.append(rdesc[i2].toString());
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNQueryChanges.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + sb.toString());
                    OracleLog.recursiveTrace = false;
                }
                string = sb.toString();
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFDCNQueryChanges.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFDCNQueryChanges.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNQueryChanges"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

