/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;

abstract class NTFRegistration {
    private final boolean jdbcGetsNotification;
    private final String clientHost;
    private final int clientTCPPort;
    private final Properties options;
    private final boolean isPurgeOnNTF;
    private final String username;
    private final int namespace;
    private final int jdbcRegId;
    private final String dbName;
    private final short databaseVersion;
    private NotificationRegistration.RegistrationState state;
    private NTFEventListener[] listeners = new NTFEventListener[0];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:27_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    NTFRegistration(int _jdbcRegId, int _namespace, boolean _jdbcGetsNotification, String _dbName, String _clientHost, int _clientTCPPort, Properties _options, String _username, short _databaseVersion) {
        this.namespace = _namespace;
        this.clientHost = _clientHost;
        this.clientTCPPort = _clientTCPPort;
        this.options = _options;
        this.jdbcRegId = _jdbcRegId;
        this.username = _username;
        this.jdbcGetsNotification = _jdbcGetsNotification;
        this.dbName = _dbName;
        this.state = NotificationRegistration.RegistrationState.ACTIVE;
        this.isPurgeOnNTF = this.options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0;
        this.databaseVersion = _databaseVersion;
    }

    short getDatabaseVersion() {
        return this.databaseVersion;
    }

    synchronized void addListener(NTFEventListener l2) throws SQLException {
        if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(Level.SEVERE, "Throwing SQLException: 251");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 251);
        }
        if (!this.jdbcGetsNotification) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(Level.SEVERE, "Throwing SQLException: 247");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 247);
        }
        int length = this.listeners.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.listeners[i2].getListener() != l2.getListener()) continue;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(Level.SEVERE, "Throwing SQLException: 248");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 248);
        }
        NTFEventListener[] listeners2 = new NTFEventListener[length + 1];
        System.arraycopy(this.listeners, 0, listeners2, 0, length);
        listeners2[length] = l2;
        this.listeners = listeners2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeListener(EventListener l2) throws SQLException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFRegistration.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int i2 = 0;
                int length = this.listeners.length;
                for (i2 = 0; i2 < length && this.listeners[i2].getListener() != l2; ++i2) {
                }
                if (i2 == length) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        NTFRegistration.logger().log(Level.SEVERE, "Throwing SQLException: 249");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 249);
                }
                NTFEventListener[] listeners2 = new NTFEventListener[length - 1];
                int offset = 0;
                for (i2 = 0; i2 < length; ++i2) {
                    if (this.listeners[i2].getListener() == l2) continue;
                    listeners2[offset++] = this.listeners[i2];
                }
                this.listeners = listeners2;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    NTFRegistration.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            NTFRegistration.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(final NTFDCNEvent event) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(event));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_20, "Debug: DCNRegistration got an event.");
                OracleLog.recursiveTrace = false;
            }
            NTFEventListener[] localListeners = this.listeners;
            int length = localListeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Executor exec = localListeners[i2].getExecutor();
                if (exec != null) {
                    final DatabaseChangeListener l2 = localListeners[i2].getDCNListener();
                    exec.execute(new Runnable(){

                        @Override
                        public void run() {
                            l2.onDatabaseChangeNotification(event);
                        }
                    });
                    continue;
                }
                localListeners[i2].getDCNListener().onDatabaseChangeNotification(event);
            }
            if (event.isDeregistrationEvent() || this.isPurgeOnNTF) {
                PhysicalConnection.ntfManager.removeRegistration(this);
                PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
                PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
                this.state = NotificationRegistration.RegistrationState.CLOSED;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(final NTFAQEvent event) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(event));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_20, "Debug: DCNRegistration got an event.");
                OracleLog.recursiveTrace = false;
            }
            NTFEventListener[] localListeners = this.listeners;
            int length = localListeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Executor exec = localListeners[i2].getExecutor();
                if (exec != null) {
                    final AQNotificationListener l2 = localListeners[i2].getAQListener();
                    exec.execute(new Runnable(){

                        @Override
                        public void run() {
                            l2.onAQNotification(event);
                        }
                    });
                    continue;
                }
                localListeners[i2].getAQListener().onAQNotification(event);
            }
            if (event.getEventType() == AQNotificationEvent.EventType.DEREG || this.isPurgeOnNTF) {
                PhysicalConnection.ntfManager.removeRegistration(this);
                PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
                PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
                this.state = NotificationRegistration.RegistrationState.CLOSED;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public Properties getRegistrationOptions() {
        return this.options;
    }

    int getJdbcRegId() {
        return this.jdbcRegId;
    }

    public String getUserName() {
        return this.username;
    }

    String getClientHost() {
        return this.clientHost;
    }

    int getClientTCPPort() {
        return this.clientTCPPort;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public NotificationRegistration.RegistrationState getState() {
        return this.state;
    }

    protected void setState(NotificationRegistration.RegistrationState _state) {
        this.state = _state;
    }

    int getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFRegistration.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFRegistration"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

