/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleReturnResultSet
extends BaseResultSet {
    OracleStatement statement;
    Accessor[] returnAccessors;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:30_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleReturnResultSet(OracleStatement s2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleReturnResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2));
                OracleLog.recursiveTrace = false;
            }
            this.statement = s2;
            this.closed = false;
            this.returnAccessors = new Accessor[s2.numReturnParams];
            int j2 = 0;
            for (int i2 = 0; i2 < s2.numberOfBindPositions; ++i2) {
                Accessor accessor = s2.returnParamAccessors[i2];
                if (accessor == null) continue;
                this.returnAccessors[j2++] = accessor;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleReturnResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block16: {
                block14: {
                    boolean bl2;
                    block15: {
                        block12: {
                            boolean bl3;
                            block13: {
                                try {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                        OracleLog.recursiveTrace = false;
                                    }
                                    if (!this.closed) break block12;
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    bl3 = false;
                                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                                    OracleLog.recursiveTrace = true;
                                }
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return bl3;
                        }
                        if (!this.statement.returnParamsFetched) {
                            this.statement.fetchDmlReturnParams();
                            this.statement.setupReturnParamAccessors();
                        }
                        ++this.statement.currentRow;
                        ++this.statement.totalRowsVisited;
                        if (this.statement.currentRow < this.statement.rowsDmlReturned) break block14;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = false;
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    super.close();
                    this.statement.returnResultSet = null;
                    this.statement.numReturnParams = 0;
                    this.statement.totalRowsVisited = 0;
                    this.statement.currentRow = -1;
                    this.statement.returnParamsFetched = false;
                    this.statement.rowsDmlReturned = 0;
                    this.statement.returnParamBytes = null;
                    this.statement.returnParamChars = null;
                    this.statement.returnParamIndicators = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block13: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (this.statement.currentRow == -1 || this.statement.lastIndex == 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 24");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24);
                    }
                    boolean __result__ = this.returnAccessors[this.statement.lastIndex - 1].isNull(this.statement.currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            AutoKeyInfo autoKeyInfo;
            block15: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (!this.statement.isAutoGeneratedKey) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 10");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    }
                    if (this.statement.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
                    }
                    AutoKeyInfo info = this.statement.autoKeyInfo;
                    info.statement = this.statement;
                    info.connection = this.statement.connection;
                    info.initMetaData(this);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + info);
                        OracleLog.recursiveTrace = false;
                    }
                    autoKeyInfo = info;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return autoKeyInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.statement);
                        OracleLog.recursiveTrace = false;
                    }
                    oracleStatement = this.statement;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oracleStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            String string;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    String __result__ = this.returnAccessors[columnIndex - 1].getString(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    string = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    boolean __result__ = this.returnAccessors[columnIndex - 1].getBoolean(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            byte by;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    byte __result__ = this.returnAccessors[columnIndex - 1].getByte(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    by = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            short s2;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    short __result__ = this.returnAccessors[columnIndex - 1].getShort(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    s2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n2;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    int __result__ = this.returnAccessors[columnIndex - 1].getInt(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            long l2;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    long __result__ = this.returnAccessors[columnIndex - 1].getLong(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    l2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            float f2;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    float __result__ = this.returnAccessors[columnIndex - 1].getFloat(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    f2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            double d2;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    double __result__ = this.returnAccessors[columnIndex - 1].getDouble(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    d2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(scale));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    BigDecimal __result__ = this.returnAccessors[columnIndex - 1].getBigDecimal(currentRow, scale);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bigDecimal = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    byte[] __result__ = this.returnAccessors[columnIndex - 1].getBytes(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    byArray = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Date date;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    Date __result__ = this.returnAccessors[columnIndex - 1].getDate(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    date = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Time time;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    Time __result__ = this.returnAccessors[columnIndex - 1].getTime(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    time = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    Timestamp __result__ = this.returnAccessors[columnIndex - 1].getTimestamp(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    timestamp = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    inputStream = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    inputStream = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    inputStream = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Object object;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    Object __result__ = this.returnAccessors[columnIndex - 1].getObject(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    object = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    resultSet = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Datum datum;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    Datum __result__ = this.returnAccessors[columnIndex - 1].getOracleObject(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    datum = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            ROWID rOWID;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    ROWID __result__ = this.returnAccessors[columnIndex - 1].getROWID(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    rOWID = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            NUMBER nUMBER;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    NUMBER __result__ = this.returnAccessors[columnIndex - 1].getNUMBER(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    nUMBER = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            DATE dATE;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    DATE __result__ = this.returnAccessors[columnIndex - 1].getDATE(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    dATE = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    ARRAY __result__ = this.returnAccessors[columnIndex - 1].getARRAY(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    aRRAY = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            STRUCT sTRUCT;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    STRUCT __result__ = this.returnAccessors[columnIndex - 1].getSTRUCT(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    sTRUCT = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            OPAQUE oPAQUE;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    oPAQUE = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            REF rEF;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    REF __result__ = this.returnAccessors[columnIndex - 1].getREF(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    rEF = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            CHAR cHAR;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    CHAR __result__ = this.returnAccessors[columnIndex - 1].getCHAR(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    cHAR = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            RAW rAW;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    RAW __result__ = this.returnAccessors[columnIndex - 1].getRAW(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    rAW = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    BLOB __result__ = this.returnAccessors[columnIndex - 1].getBLOB(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    CLOB __result__ = this.returnAccessors[columnIndex - 1].getCLOB(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    cLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    BFILE __result__ = this.returnAccessors[columnIndex - 1].getBFILE(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bFILE = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    BFILE __result__ = this.getBFILE(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bFILE = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    customDatum = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    ORAData __result__ = this.returnAccessors[columnIndex - 1].getORAData(currentRow, factory);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    oRAData = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Object object;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(map));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    Object __result__ = this.returnAccessors[columnIndex - 1].getObject(currentRow, map);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    object = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            REF rEF;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    REF __result__ = this.getREF(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    rEF = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    BLOB __result__ = this.getBLOB(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    CLOB __result__ = this.getCLOB(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    cLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Array array;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    array = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            Reader reader;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    reader = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal bigDecimal;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                BigDecimal __result__ = this.returnAccessors[columnIndex - 1].getBigDecimal(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bigDecimal = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                Date __result__ = this.returnAccessors[columnIndex - 1].getDate(currentRow, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                date = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                Time __result__ = this.returnAccessors[columnIndex - 1].getTime(currentRow, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                time = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                Timestamp __result__ = this.returnAccessors[columnIndex - 1].getTimestamp(currentRow, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                timestamp = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        INTERVALYM iNTERVALYM;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                INTERVALYM __result__ = this.returnAccessors[columnIndex - 1].getINTERVALYM(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                iNTERVALYM = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return iNTERVALYM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        INTERVALDS iNTERVALDS;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                INTERVALDS __result__ = this.returnAccessors[columnIndex - 1].getINTERVALDS(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                iNTERVALDS = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return iNTERVALDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                TIMESTAMP __result__ = this.returnAccessors[columnIndex - 1].getTIMESTAMP(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMP = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                TIMESTAMPTZ __result__ = this.returnAccessors[columnIndex - 1].getTIMESTAMPTZ(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                TIMESTAMPLTZ __result__ = this.returnAccessors[columnIndex - 1].getTIMESTAMPLTZ(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPLTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            URL uRL;
            block15: {
                try {
                    int currentRow;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    if ((currentRow = this.statement.currentRow) < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                    }
                    this.statement.lastIndex = columnIndex;
                    URL __result__ = this.returnAccessors[columnIndex - 1].getURL(currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    uRL = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = !this.isEmptyResultSet() && this.closed;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.getRow() == 1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.getRow() == this.statement.rowsDmlReturned;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.statement.totalRowsVisited);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.statement.totalRowsVisited;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n2;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnName));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = -1;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rows));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        int n2;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = -1;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmptyResultSet() {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.statement.rowsDmlReturned == 0;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        NClob nClob;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                NClob __result__ = (NClob)((Object)this.returnAccessors[columnIndex - 1].getCLOB(currentRow));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nClob = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int columnIndex) throws SQLException {
        String string;
        block11: {
            try {
                int currentRow;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                }
                if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if ((currentRow = this.statement.currentRow) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 14");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 14);
                }
                this.statement.lastIndex = columnIndex;
                String __result__ = this.returnAccessors[columnIndex - 1].getString(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        Reader reader;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                reader = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        ROWID rOWID;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                ROWID __result__ = this.getROWID(columnIndex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                rOWID = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return rOWID;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            String string;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23getCursorName");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    string = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleReturnResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleReturnResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleConnection __result__ = this.statement.getConnectionDuringExceptionHandling();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleReturnResultSet.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = __result__;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleReturnResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleReturnResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

