/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;

abstract class OracleTimeout {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:30_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    OracleTimeout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OracleTimeout newTimeout(String name) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeout.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name));
                OracleLog.recursiveTrace = false;
            }
            OracleTimeoutThreadPerVM instance = new OracleTimeoutThreadPerVM(name);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeout.logger().log(OracleLog.TRACE_16, "return: " + instance);
                OracleLog.recursiveTrace = false;
            }
            OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = instance;
            return oracleTimeoutThreadPerVM;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeout.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    abstract void setTimeout(long var1, OracleStatement var3) throws SQLException;

    abstract void cancelTimeout() throws SQLException;

    abstract void close() throws SQLException;

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

