/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:30_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTimeoutPollingThread() {
        super(threadName);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.setDaemon(true);
            this.setPriority(10);
            this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
            this.count = 0;
            this.sleepMillis = Long.parseLong(PhysicalConnection.getSystemPropertyPollInterval());
            this.start();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTimeout(OracleTimeoutThreadPerVM t) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(t));
                OracleLog.recursiveTrace = false;
            }
            int i2 = 0;
            if (this.count >= this.knownTimeouts.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_20, "Debug: growing knownTimeouts--new size = " + this.knownTimeouts.length * 4);
                    OracleLog.recursiveTrace = false;
                }
                OracleTimeoutThreadPerVM[] bigger = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
                System.arraycopy(this.knownTimeouts, 0, bigger, 0, this.knownTimeouts.length);
                i2 = this.knownTimeouts.length;
                this.knownTimeouts = bigger;
            }
            while (i2 < this.knownTimeouts.length) {
                if (this.knownTimeouts[i2] == null) {
                    this.knownTimeouts[i2] = t;
                    ++this.count;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_20, "Debug: added at " + i2);
                        OracleLog.recursiveTrace = false;
                    }
                    break;
                }
                ++i2;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeTimeout(OracleTimeoutThreadPerVM t) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(t));
                OracleLog.recursiveTrace = false;
            }
            for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                if (this.knownTimeouts[i2] != t) continue;
                this.knownTimeouts[i2] = null;
                --this.count;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_20, "Debug: removed from " + i2);
                    OracleLog.recursiveTrace = false;
                }
                break;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pollOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollOnce() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.count > 0) {
                long now = System.currentTimeMillis();
                for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                    try {
                        if (this.knownTimeouts[i2] == null) continue;
                        this.knownTimeouts[i2].interruptIfAppropriate(now);
                        continue;
                    }
                    catch (NullPointerException e2) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutPollingThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeoutPollingThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

