/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;
import oracle.jdbc.internal.OracleConnection;

class OracleTimeoutThreadPerVM
extends OracleTimeout {
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:30_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleTimeoutThreadPerVM(String name) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name));
                OracleLog.recursiveTrace = false;
            }
            this.name = name;
            this.interruptAfter = Long.MAX_VALUE;
            watchdog.addTimeout(this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            watchdog.removeTimeout(this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void setTimeout(long milliseconds, OracleStatement stmt) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(milliseconds) + ", " + OracleLog.argument(stmt));
                OracleLog.recursiveTrace = false;
            }
            if (this.interruptAfter != Long.MAX_VALUE) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTimeoutThreadPerVM.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 131");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 131);
            }
            this.statement = stmt;
            this.interruptAfter = System.currentTimeMillis() + milliseconds;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void cancelTimeout() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.statement = null;
            this.interruptAfter = Long.MAX_VALUE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfAppropriate(long now) {
        block14: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(now));
                    OracleLog.recursiveTrace = false;
                }
                if (now <= this.interruptAfter) break block14;
                OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = this;
                synchronized (oracleTimeoutThreadPerVM) {
                    if (now > this.interruptAfter) {
                        block15: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_20, "Debug: CANCELING thread :" + this.name);
                                OracleLog.recursiveTrace = false;
                            }
                            if (this.statement.connection.spawnNewThreadToCancel) {
                                final OracleStatement s2 = this.statement;
                                Thread t = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        block2: {
                                            try {
                                                s2.cancel();
                                            }
                                            catch (Throwable e2) {
                                                if (!TRACE || OracleLog.recursiveTrace) break block2;
                                                OracleLog.recursiveTrace = true;
                                                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_10, "Event: spawning thread failed: " + e2);
                                                OracleLog.recursiveTrace = false;
                                            }
                                        }
                                    }
                                });
                                t.setName("interruptIfAppropriate_" + this);
                                t.setDaemon(true);
                                t.setPriority(10);
                                t.start();
                            } else {
                                try {
                                    this.statement.cancel();
                                }
                                catch (Throwable e2) {
                                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                                    OracleLog.recursiveTrace = true;
                                    OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_10, "Event: statement cancel failed: " + e2);
                                    OracleLog.recursiveTrace = false;
                                }
                            }
                        }
                        this.statement = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeoutThreadPerVM"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

