/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    int elementInternalType;
    int maxNumberOfElements;
    int elementMaxLen;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    int ibtMetaIndex;
    int ibtByteLength;
    int ibtCharLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:30_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlsqlIndexTableAccessor(OracleStatement stmt, int elemSqlType, int elemInternalType, int elemMaxLen, int maxNumOfElements, short form, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemInternalType) + ", " + OracleLog.argument(elemMaxLen) + ", " + OracleLog.argument(maxNumOfElements) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 998, 998, form, forBind);
            this.elementInternalType = elemInternalType;
            this.maxNumberOfElements = maxNumOfElements;
            this.elementMaxLen = elemMaxLen;
            this.initForDataAccess(elemSqlType, elemMaxLen, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            switch (this.elementInternalType) {
                case 1: 
                case 96: {
                    this.internalTypeMaxLength = 2000;
                    this.elementMaxLen = (max_len == 0 ? this.internalTypeMaxLength : max_len) + 1;
                    this.ibtCharLength = this.elementMaxLen * this.maxNumberOfElements;
                    this.elementInternalType = 9;
                    return;
                }
                case 6: {
                    this.internalTypeMaxLength = 21;
                    this.elementMaxLen = this.internalTypeMaxLength + 1;
                    this.ibtByteLength = this.elementMaxLen * this.maxNumberOfElements;
                    return;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 97");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    return;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getPlsqlIndexTable(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            Object[] result = null;
            short[] ibtBindIndicators = this.statement.ibtBindIndicators;
            int actualElements = (ibtBindIndicators[this.ibtMetaIndex + 4] >> 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
            int offset = this.ibtValueIndex;
            switch (this.elementInternalType) {
                case 9: {
                    result = new String[actualElements];
                    char[] ibtBindChars = this.statement.ibtBindChars;
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        result[i2] = ibtBindIndicators[this.ibtIndicatorIndex + i2] == -1 ? null : new String(ibtBindChars, offset + 1, ibtBindChars[offset] >> 1);
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                case 6: {
                    result = new BigDecimal[actualElements];
                    byte[] ibtBindBytes = this.statement.ibtBindBytes;
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        if (ibtBindIndicators[this.ibtIndicatorIndex + i3] == -1) {
                            result[i3] = null;
                        } else {
                            byte len = ibtBindBytes[offset];
                            byte[] val = new byte[len];
                            System.arraycopy(ibtBindBytes, offset + 1, val, 0, len);
                            result[i3] = oracle.sql.NUMBER.toBigDecimal(val);
                        }
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 97");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum[] getOraclePlsqlIndexTable(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            Datum[] result = null;
            short[] ibtBindIndicators = this.statement.ibtBindIndicators;
            int actualElements = (ibtBindIndicators[this.ibtMetaIndex + 4] >> 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
            int offset = this.ibtValueIndex;
            switch (this.elementInternalType) {
                case 9: {
                    result = new CHAR[actualElements];
                    CharacterSet charset = CharacterSet.make(2000);
                    char[] ibtBindChars = this.statement.ibtBindChars;
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        if (ibtBindIndicators[this.ibtIndicatorIndex + i2] == -1) {
                            result[i2] = null;
                        } else {
                            char len = ibtBindChars[offset];
                            byte[] b2 = new byte[len];
                            DBConversion.javaCharsToUcs2Bytes(ibtBindChars, offset + 1, b2, 0, len >> 1);
                            result[i2] = new CHAR(b2, charset);
                        }
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                case 6: {
                    result = new NUMBER[actualElements];
                    byte[] ibtBindBytes = this.statement.ibtBindBytes;
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        if (ibtBindIndicators[this.ibtIndicatorIndex + i3] == -1) {
                            result[i3] = null;
                        } else {
                            byte len = ibtBindBytes[offset];
                            byte[] val = new byte[len];
                            System.arraycopy(ibtBindBytes, offset + 1, val, 0, len);
                            result[i3] = new NUMBER(val);
                        }
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 97");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = result;
            return datumArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PlsqlIndexTableAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIndexTableAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

