/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;
import oracle.sql.RAW;

class RawCommonAccessor
extends Accessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:31_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    RawCommonAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = Integer.MAX_VALUE;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        try {
            byte[] b_array;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((b_array = this.getBytes(currentRow)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            int len = b_array.length;
            if (len == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            String __result__ = RepConversion.bArray2String(b_array);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        try {
            byte[] b2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            PhysicalConnection conn = this.statement.connection;
            InputStream __result__ = conn.conversion.ConvertStream(new ByteArrayInputStream(b2), 2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            InputStream inputStream = __result__;
            return inputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        try {
            byte[] b2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            PhysicalConnection conn = this.statement.connection;
            InputStream __result__ = conn.conversion.ConvertStream(new ByteArrayInputStream(b2), 3);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            InputStream inputStream = __result__;
            return inputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        try {
            byte[] b2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Reader reader = null;
                return reader;
            }
            int rlen = b2.length;
            char[] charBuf = new char[rlen << 1];
            DBConversion cfr_ignored_0 = this.statement.connection.conversion;
            int chars_read = DBConversion.RAWBytesToHexChars(b2, rlen, charBuf);
            CharArrayReader __result__ = new CharArrayReader(charBuf, 0, chars_read);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CharArrayReader charArrayReader = __result__;
            return charArrayReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        try {
            byte[] b2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            ByteArrayInputStream __result__ = new ByteArrayInputStream(b2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ByteArrayInputStream byteArrayInputStream = __result__;
            return byteArrayInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            byte[] __result__ = this.getBytes(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            byte[] __result__ = this.getBytes(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            RAW __result__ = this.getRAW(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            RAW rAW = __result__;
            return rAW;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RAW getRAW(int currentRow) throws SQLException {
        try {
            byte[] b2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((b2 = this.getBytes(currentRow)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                RAW rAW = null;
                return rAW;
            }
            RAW __result__ = new RAW(b2);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            RAW rAW = __result__;
            return rAW;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                RawCommonAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.RawCommonAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

