/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:31_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScrollableResultSet(ScrollRsetStatement stmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                OracleLog.recursiveTrace = false;
            }
            this.connection = ((OracleStatement)stmt).connection;
            this.resultSet = rset;
            this.metadata = null;
            this.scrollStmt = stmt;
            this.rsetType = type;
            this.rsetConcurency = update;
            this.autoRefetch = stmt.getAutoRefetch();
            this.beginColumnIndex = ScrollableResultSet.needIdentifier(type, update) ? 1 : 0;
            this.columnCount = 0;
            this.wasNull = -1;
            this.rsetCache = stmt.getResultSetCache();
            if (this.rsetCache == null) {
                this.rsetCache = new OracleResultSetCacheImpl();
            } else {
                try {
                    this.rsetCache.clear();
                }
                catch (IOException e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                }
            }
            this.currentRow = 0;
            this.numRowsCached = 0;
            this.allRowsCached = false;
            this.lastRefetchSz = 0;
            this.refetchRowids = null;
            this.refetchStmt = null;
            this.usrFetchDirection = 1000;
            this.getInternalMetadata();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block22: {
                block19: {
                    block20: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!this.closed) break block19;
                            if (!TRACE || OracleLog.recursiveTrace) break block20;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                super.close();
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.refetchStmt != null) {
                    this.refetchStmt.close();
                }
                if (this.scrollStmt != null) {
                    this.scrollStmt.notifyCloseRset();
                }
                if (this.refetchRowids != null) {
                    this.refetchRowids.removeAllElements();
                }
                this.resultSet = null;
                this.scrollStmt = null;
                this.refetchStmt = null;
                this.refetchRowids = null;
                this.metadata = null;
                try {
                    if (this.rsetCache != null) {
                        this.rsetCache.clear();
                        this.rsetCache.close();
                    }
                }
                catch (IOException e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                }
                finally {
                    this.rsetCache = null;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block22;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.wasNull == -1) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 24");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24);
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (this.wasNull == 1));
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl2 = bl = this.wasNull == 1;
                    if (!TRACE || OracleLog.recursiveTrace) break block11;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Statement statement;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (Statement)((Object)this.scrollStmt));
                        OracleLog.recursiveTrace = false;
                    }
                    statement = (Statement)((Object)this.scrollStmt);
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBeginColumnIndex() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.beginColumnIndex = 0;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getResultSet() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.resultSet);
                        OracleLog.recursiveTrace = false;
                    }
                    oracleResultSetImpl = this.resultSet;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return oracleResultSetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int removeRowInCache(int rowIdx) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowIdx));
                    OracleLog.recursiveTrace = false;
                }
                if (!this.isEmptyResultSet() && this.isValidRow(rowIdx)) {
                    this.removeCachedRowAt(rowIdx);
                    --this.numRowsCached;
                    if (rowIdx >= this.currentRow) {
                        --this.currentRow;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    int n3 = 1;
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int refreshRowsInCache(int beginIdx, int count, int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block17: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(direction));
                        OracleLog.recursiveTrace = false;
                    }
                    OracleResultSetImpl refetchRset = null;
                    int actualRefetchSize = 0;
                    actualRefetchSize = this.get_refetch_size(beginIdx, count, direction);
                    try {
                        if (actualRefetchSize > 0) {
                            if (actualRefetchSize != this.lastRefetchSz) {
                                if (this.refetchStmt != null) {
                                    this.refetchStmt.close();
                                }
                                this.refetchStmt = this.prepare_refetch_statement(actualRefetchSize);
                                this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                                this.lastRefetchSz = actualRefetchSize;
                            }
                            this.prepare_refetch_binds(this.refetchStmt, actualRefetchSize);
                            refetchRset = (OracleResultSetImpl)this.refetchStmt.executeQuery();
                            this.save_refetch_results(refetchRset, beginIdx, actualRefetchSize, direction);
                        }
                    }
                    finally {
                        if (refetchRset != null) {
                            refetchRset.close();
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + actualRefetchSize);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = actualRefetchSize;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!this.isEmptyResultSet()) break block9;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = false;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
                boolean __result__ = this.isValidRow(this.currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block9: {
                try {
                    boolean __result__;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl2 = __result__ = !this.isEmptyResultSet() && this.currentRow < 1;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block9: {
                try {
                    boolean __result__;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl2 = __result__ = !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (this.currentRow == 1));
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl2 = bl = this.currentRow == 1;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (!this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1)));
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl2 = bl = !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block8: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (!this.isEmptyResultSet()) {
                        this.currentRow = 0;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block8;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block8: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (!this.isEmptyResultSet()) {
                        this.currentRow = this.getLastRow() + 1;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block8;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!this.isEmptyResultSet()) break block9;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = false;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                this.currentRow = 1;
                boolean __result__ = this.isValidRow(this.currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!this.isEmptyResultSet()) break block9;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = false;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                this.currentRow = this.getLastRow();
                boolean __result__ = this.isValidRow(this.currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block11: {
                block9: {
                    int n3;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!this.isValidRow(this.currentRow)) break block9;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.currentRow);
                                OracleLog.recursiveTrace = false;
                            }
                            n3 = this.currentRow;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block16: {
                block14: {
                    boolean bl2;
                    block15: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(row));
                                OracleLog.recursiveTrace = false;
                            }
                            if (row == 0) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 68" + "absolute(" + row + ")");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "absolute(" + row + ")");
                            }
                            if (!this.isEmptyResultSet()) break block14;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = false;
                            if (!TRACE || OracleLog.recursiveTrace) break block15;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (row > 0) {
                    this.currentRow = row;
                } else if (row < 0) {
                    this.currentRow = this.getLastRow() + 1 + row;
                }
                boolean __result__ = this.isValidRow(this.currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean relative(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block16: {
                block14: {
                    boolean bl2;
                    block15: {
                        block12: {
                            boolean bl3;
                            block13: {
                                try {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rows));
                                        OracleLog.recursiveTrace = false;
                                    }
                                    if (!this.isEmptyResultSet()) break block12;
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    bl3 = false;
                                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                                    OracleLog.recursiveTrace = true;
                                }
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return bl3;
                        }
                        if (!this.isValidRow(this.currentRow)) break block14;
                        this.currentRow += rows;
                        boolean __result__ = this.isValidRow(this.currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 82relative");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 82, "relative");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!this.isEmptyResultSet()) break block9;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = false;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
                boolean __result__ = this.isValidRow(this.currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            block13: {
                try {
                    Datum value;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    this.wasNull = -1;
                    if (!this.isValidRow(this.currentRow)) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    int n2 = this.wasNull = (value = this.getCachedDatumValueAt(this.currentRow, columnIndex + this.beginColumnIndex)) == null ? 1 : 0;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + value);
                        OracleLog.recursiveTrace = false;
                    }
                    datum = value;
                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return datum;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getString(int columnIndex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            boolean __result__ = datum.booleanValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte by;
            block11: {
                block9: {
                    byte by2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            byte __result__ = datum.byteValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            by2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return by2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                by = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            block11: {
                try {
                    long result;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if ((result = this.getLong(columnIndex)) > 65537L || result < -65538L) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 26getShort");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (short)result);
                        OracleLog.recursiveTrace = false;
                    }
                    s2 = (short)result;
                    if (!TRACE || OracleLog.recursiveTrace) break block11;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block11: {
                block9: {
                    int n3;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            int __result__ = datum.intValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            n3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long l2;
            block11: {
                block9: {
                    long l3;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            long __result__ = datum.longValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            l3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return l3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                l2 = 0L;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            float f2;
            block11: {
                block9: {
                    float f3;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            float __result__ = datum.floatValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            f3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return f3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                f2 = 0.0f;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            double d2;
            block13: {
                block11: {
                    double d3;
                    block12: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block11;
                            double __result__ = datum.doubleValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            d3 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block12;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return d3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                d2 = 0.0;
                if (!TRACE || OracleLog.recursiveTrace) break block13;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BigDecimal bigDecimal;
            block11: {
                block9: {
                    BigDecimal bigDecimal2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            BigDecimal __result__ = datum.bigDecimalValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            bigDecimal2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bigDecimal2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                bigDecimal = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl31
                        if (!(datum instanceof RAW)) break block13;
                        __result__ = ((RAW)datum).shareBytes();
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        var5_6 = __result__;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var5_6;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getBytes");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
lbl31:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var6_7) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var6_7;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            block14: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum datum = this.getOracleObject(columnIndex);
                    Date d2 = null;
                    if (datum != null) {
                        ResultSetMetaData rsmd = this.getInternalMetadata();
                        switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                            case -101: {
                                d2 = ((TIMESTAMPTZ)datum).dateValue(this.connection);
                                break;
                            }
                            case -102: {
                                d2 = ((TIMESTAMPLTZ)datum).dateValue(this.connection);
                                break;
                            }
                            default: {
                                d2 = datum.dateValue();
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + d2);
                        OracleLog.recursiveTrace = false;
                    }
                    date = d2;
                    if (!TRACE || OracleLog.recursiveTrace) break block14;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            block15: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum datum = this.getOracleObject(columnIndex);
                    Time d2 = null;
                    if (datum != null) {
                        ResultSetMetaData rsmd = this.getInternalMetadata();
                        switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                            case 93: {
                                d2 = ((TIMESTAMP)datum).timeValue();
                                break;
                            }
                            case -101: {
                                d2 = ((TIMESTAMPTZ)datum).timeValue(this.connection);
                                break;
                            }
                            case -102: {
                                d2 = ((TIMESTAMPLTZ)datum).timeValue(this.connection);
                                break;
                            }
                            default: {
                                d2 = datum.timeValue();
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + d2);
                        OracleLog.recursiveTrace = false;
                    }
                    time = d2;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            block15: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum datum = this.getOracleObject(columnIndex);
                    Timestamp d2 = null;
                    if (datum != null) {
                        ResultSetMetaData rsmd = this.getInternalMetadata();
                        switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                            case 93: {
                                d2 = ((TIMESTAMP)datum).timestampValue();
                                break;
                            }
                            case -101: {
                                d2 = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                                break;
                            }
                            case -102: {
                                d2 = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, ((OracleStatement)this.scrollStmt).getDefaultCalendar());
                                break;
                            }
                            default: {
                                d2 = datum.timestampValue();
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + d2);
                        OracleLog.recursiveTrace = false;
                    }
                    timestamp = d2;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block11: {
                block9: {
                    InputStream inputStream2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            InputStream __result__ = datum.asciiStreamValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            inputStream2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return inputStream2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                inputStream = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block14: {
                    block13: {
                        try {
                            if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                            dbconv = this.connection.conversion;
                            bytes = datum.shareBytes();
                            if (datum instanceof RAW) {
                                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3));
                                    OracleLog.recursiveTrace = false;
                                }
                                var6_6 = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3);
                                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block13;
                                OracleLog.recursiveTrace = true;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var7_8) {
                            if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw var7_8;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var6_6;
lbl-1000:
                    // 1 sources

                    {
                        if (!(datum instanceof CHAR)) ** GOTO lbl-1000
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1));
                            OracleLog.recursiveTrace = false;
                        }
                        var6_7 = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1);
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                    }
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var6_7;
lbl-1000:
                // 1 sources

                {
                    if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getUnicodeStream");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
lbl50:
                    // 2 sources

                    if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    var4_4 = null;
                    if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            block11: {
                block9: {
                    InputStream inputStream2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            InputStream __result__ = datum.binaryStreamValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            inputStream2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return inputStream2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                inputStream = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object object;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                Object __result__ = this.getObject(columnIndex, this.connection.getTypeMap());
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                object = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Reader reader;
            block11: {
                block9: {
                    Reader reader2;
                    block10: {
                        try {
                            Datum datum;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) break block9;
                            Reader __result__ = datum.characterStreamValue();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            reader2 = __result__;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return reader2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                reader = null;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal bigDecimal;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                BigDecimal __result__ = this.getBigDecimal(columnIndex, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bigDecimal = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            block15: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Object returnValue = null;
                    Datum datum = this.getOracleObject(columnIndex);
                    if (datum != null) {
                        int type = this.getInternalMetadata().getColumnType(columnIndex + this.beginColumnIndex);
                        switch (type) {
                            case 2002: {
                                returnValue = ((STRUCT)datum).toJdbc(map);
                                break;
                            }
                            case 91: {
                                if (this.connection.mapDateToTimestamp) {
                                    returnValue = datum.toJdbc();
                                    break;
                                }
                                returnValue = datum.dateValue();
                                break;
                            }
                            default: {
                                returnValue = datum.toJdbc();
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + returnValue);
                        OracleLog.recursiveTrace = false;
                    }
                    object = returnValue;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    REF __result__ = this.getREF(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    rEF = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    BLOB __result__ = this.getBLOB(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    CLOB __result__ = this.getCLOB(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    cLOB = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    ARRAY __result__ = this.getARRAY(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    aRRAY = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            block17: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum datum = this.getOracleObject(columnIndex);
                    Date d2 = null;
                    if (datum != null) {
                        ResultSetMetaData rsmd = this.getInternalMetadata();
                        switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                            case 93: {
                                d2 = new Date(((TIMESTAMP)datum).timestampValue(cal).getTime());
                                break;
                            }
                            case -101: {
                                d2 = new Date(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                                break;
                            }
                            case -102: {
                                d2 = new Date(((TIMESTAMPLTZ)datum).timestampValue(this.connection, cal).getTime());
                                break;
                            }
                            case 91: {
                                d2 = ((DATE)datum).dateValue(cal);
                                break;
                            }
                            default: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDate");
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + d2);
                        OracleLog.recursiveTrace = false;
                    }
                    date = d2;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            block17: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum datum = this.getOracleObject(columnIndex);
                    Time d2 = null;
                    if (datum != null) {
                        ResultSetMetaData rsmd = this.getInternalMetadata();
                        switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                            case 93: {
                                d2 = new Time(((TIMESTAMP)datum).timestampValue(cal).getTime());
                                break;
                            }
                            case -101: {
                                d2 = new Time(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                                break;
                            }
                            case -102: {
                                d2 = new Time(((TIMESTAMPLTZ)datum).timestampValue(this.connection, cal).getTime());
                                break;
                            }
                            case 91: {
                                d2 = ((DATE)datum).timeValue(cal);
                                break;
                            }
                            default: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTime");
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + d2);
                        OracleLog.recursiveTrace = false;
                    }
                    time = d2;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            block17: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum datum = this.getOracleObject(columnIndex);
                    Timestamp ts = null;
                    if (datum != null) {
                        ResultSetMetaData rsmd = this.getInternalMetadata();
                        switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                            case 93: {
                                ts = ((TIMESTAMP)datum).timestampValue(cal);
                                break;
                            }
                            case -101: {
                                ts = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                                break;
                            }
                            case -102: {
                                ts = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, cal);
                                break;
                            }
                            case 91: {
                                ts = ((DATE)datum).timestampValue(cal);
                                break;
                            }
                            default: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTimestamp");
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ts);
                        OracleLog.recursiveTrace = false;
                    }
                    timestamp = ts;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            block15: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    URL result = null;
                    int colType = this.getInternalMetadata().getColumnType(columnIndex + this.beginColumnIndex);
                    int dbTypeCode = SQLUtil.getInternalType(colType);
                    if (dbTypeCode == 96 || dbTypeCode == 1 || dbTypeCode == 8) {
                        try {
                            result = new URL(this.getString(columnIndex));
                        }
                        catch (MalformedURLException exc) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 136");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 136);
                        }
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 1Conversion to java.net.URL not supported.");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Conversion to java.net.URL not supported.");
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                        OracleLog.recursiveTrace = false;
                    }
                    uRL = result;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getCursor");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    resultSet = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof ROWID)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (ROWID)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (ROWID)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getROWID");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof NUMBER)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (NUMBER)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (NUMBER)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getNUMBER");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block14: {
                    block13: {
                        try {
                            if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                                OracleLog.recursiveTrace = false;
                            }
                            if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl47
                            if (datum instanceof DATE) {
                                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (DATE)datum);
                                    OracleLog.recursiveTrace = false;
                                }
                                var4_4 = (DATE)datum;
                                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block13;
                                OracleLog.recursiveTrace = true;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var6_8) {
                            if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw var6_8;
                        }
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
lbl-1000:
                    // 1 sources

                    {
                        if (!(datum instanceof TIMESTAMP)) ** GOTO lbl-1000
                        __result__ = TIMESTAMP.toDATE(datum.getBytes());
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        var5_7 = __result__;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                    }
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var5_7;
lbl-1000:
                // 1 sources

                {
                    if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getDATE");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
lbl47:
                    // 2 sources

                    if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    var4_6 = null;
                    if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof TIMESTAMP)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (TIMESTAMP)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (TIMESTAMP)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getTIMESTAMP");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof TIMESTAMPTZ)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (TIMESTAMPTZ)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (TIMESTAMPTZ)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getTIMESTAMPTZ");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof TIMESTAMPLTZ)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (TIMESTAMPLTZ)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (TIMESTAMPLTZ)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getTIMESTAMPLTZ");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof INTERVALDS)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (INTERVALDS)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (INTERVALDS)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getINTERVALDS");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof INTERVALYM)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (INTERVALYM)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (INTERVALYM)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getINTERVALYM");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof ARRAY)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (ARRAY)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (ARRAY)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getARRAY");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof STRUCT)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (STRUCT)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (STRUCT)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getSTRUCT");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof OPAQUE)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (OPAQUE)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (OPAQUE)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getOPAQUE");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public REF getREF(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof REF)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (REF)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (REF)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getREF");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof CHAR)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (CHAR)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (CHAR)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getCHAR");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof RAW)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (RAW)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (RAW)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getRAW");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof BLOB)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (BLOB)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (BLOB)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getBLOB");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof CLOB)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (CLOB)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (CLOB)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getCLOB");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block15: {
                block13: {
                    block14: {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl30
                        if (!(datum instanceof BFILE)) break block13;
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (BFILE)datum);
                            OracleLog.recursiveTrace = false;
                        }
                        var4_4 = (BFILE)datum;
                        if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return var4_4;
                }
                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 4getBFILE");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
lbl30:
                // 2 sources

                if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var4_5 = null;
                if (!ScrollableResultSet.TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
                {
                    catch (Throwable var5_6) {
                        if (ScrollableResultSet.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var5_6;
                    }
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    BFILE __result__ = this.getBFILE(columnIndex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bFILE = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum d2 = this.getOracleObject(columnIndex);
                    CustomDatum __result__ = factory.create(d2, 0);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    customDatum = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Datum d2 = this.getOracleObject(columnIndex);
                    ORAData __result__ = factory.create(d2, 0);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    oRAData = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        NClob nClob;
        block7: {
            try {
                CLOB c2;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (!((c2 = this.getCLOB(columnIndex)) instanceof NClob)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 184");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 184);
                }
                NClob __result__ = (NClob)((Object)c2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nClob = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int columnIndex) throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                String __result__ = this.getString(columnIndex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        Reader reader;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                Reader __result__ = this.getCharacterStream(columnIndex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                reader = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        ROWID rOWID;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                ROWID __result__ = this.getROWID(columnIndex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                rOWID = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return rOWID;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetMetaData oracleResultSetMetaData;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    oracleResultSetMetaData = new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oracleResultSetMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block11: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnName));
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 10");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    }
                    int __result__ = this.resultSet.findColumn(columnName) - this.beginColumnIndex;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block11;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block12: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(direction));
                        OracleLog.recursiveTrace = false;
                    }
                    if (direction == 1000) {
                        this.usrFetchDirection = direction;
                    } else if (direction == 1001 || direction == 1002) {
                        this.usrFetchDirection = direction;
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 68setFetchDirection");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block12;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1000");
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = 1000;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rows));
                        OracleLog.recursiveTrace = false;
                    }
                    this.resultSet.setFetchSize(rows);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    int __result__ = this.resultSet.getFetchSize();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getType() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.rsetType);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.rsetType;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConcurrency() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.rsetConcurency);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.rsetConcurency;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23refreshRow");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow");
                }
                if (this.isValidRow(this.currentRow)) {
                    int direction = this.getFetchDirection();
                    try {
                        this.refreshRowsInCache(this.currentRow, this.getFetchSize(), direction);
                    }
                    catch (SQLException e2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2 + 90 + "Unsupported syntax for refreshRow()");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2, 90, "Unsupported syntax for refreshRow()");
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 82refreshRow");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 82, "refreshRow");
                }
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentRowValueAt(Object caller, int columnIdx, Object value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(caller) + ", " + OracleLog.argument(columnIdx) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            if (caller instanceof UpdatableResultSet) {
                this.putCachedValueAt(this.currentRow, columnIdx, value);
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmptyResultSet() throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.numRowsCached != 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (this.numRowsCached == 0 && this.allRowsCached) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = __result__ = !this.isValidRow(1);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidRow(int idx) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(idx));
                OracleLog.recursiveTrace = false;
            }
            if (idx > 0 && idx <= this.numRowsCached) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (idx <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            boolean __result__ = this.cacheRowAt(idx);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheRowAt(int idx) throws SQLException {
        try {
            boolean bl;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(idx));
                OracleLog.recursiveTrace = false;
            }
            while (this.numRowsCached < idx && this.resultSet.next()) {
                for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                    byte[] bytes = this.resultSet.privateGetBytes(i2 + 1);
                    this.putCachedValueAt(this.numRowsCached + 1, i2 + 1, bytes);
                }
                ++this.numRowsCached;
            }
            if (this.numRowsCached < idx) {
                this.allRowsCached = true;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                OracleLog.recursiveTrace = false;
            }
            bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cacheAllRows() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            while (this.resultSet.next()) {
                for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                    this.putCachedValueAt(this.numRowsCached + 1, i2 + 1, this.resultSet.privateGetBytes(i2 + 1));
                }
                ++this.numRowsCached;
            }
            this.allRowsCached = true;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.numRowsCached);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.numRowsCached;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnCount() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.columnCount == 0) {
                int numberOfArgs = this.resultSet.statement.numberOfDefinePositions;
                this.columnCount = this.resultSet.statement.accessors != null && numberOfArgs > 0 ? numberOfArgs : this.getInternalMetadata().getColumnCount();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.columnCount);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.columnCount;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetMetaData getInternalMetadata() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.metadata == null) {
                this.metadata = this.resultSet.getMetaData();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.metadata);
                OracleLog.recursiveTrace = false;
            }
            ResultSetMetaData resultSetMetaData = this.metadata;
            return resultSetMetaData;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastRow() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.allRowsCached) {
                this.cacheAllRows();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.numRowsCached);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.numRowsCached;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int get_refetch_size(int beginIdx, int count, int direction) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(direction));
                OracleLog.recursiveTrace = false;
            }
            int _direction = direction == 1001 ? -1 : 1;
            int realRefreshSz = 0;
            if (this.refetchRowids == null) {
                this.refetchRowids = new Vector(10);
            } else {
                this.refetchRowids.removeAllElements();
            }
            while (realRefreshSz < count && this.isValidRow(beginIdx + realRefreshSz * _direction)) {
                this.refetchRowids.addElement(this.getCachedDatumValueAt(beginIdx + realRefreshSz * _direction, 1));
                ++realRefreshSz;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + realRefreshSz);
                OracleLog.recursiveTrace = false;
            }
            int n2 = realRefreshSz;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePreparedStatement prepare_refetch_statement(int realRefreshSz) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(realRefreshSz));
                OracleLog.recursiveTrace = false;
            }
            if (realRefreshSz < 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PreparedStatement pstmt = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, realRefreshSz));
            OraclePreparedStatement __result__ = (OraclePreparedStatement)((OraclePreparedStatementWrapper)pstmt).preparedStatement;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OraclePreparedStatement oraclePreparedStatement = __result__;
            return oraclePreparedStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare_refetch_binds(OraclePreparedStatement refetchStmt, int realRefreshSz) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(refetchStmt) + ", " + OracleLog.argument(realRefreshSz));
                OracleLog.recursiveTrace = false;
            }
            int _numSubQueryBinds = this.scrollStmt.copyBinds(refetchStmt, 0);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_20, "Debug: numSubQueryBinds=" + _numSubQueryBinds);
                OracleLog.recursiveTrace = false;
            }
            for (int i2 = 0; i2 < realRefreshSz; ++i2) {
                refetchStmt.setROWID(_numSubQueryBinds + i2 + 1, (ROWID)this.refetchRowids.elementAt(i2));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save_refetch_results(OracleResultSetImpl refetchRset, int _beginIdx, int _realFetchSz, int direction) throws SQLException {
        try {
            int _direction;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(refetchRset) + ", " + OracleLog.argument(_beginIdx) + ", " + OracleLog.argument(_realFetchSz) + ", " + OracleLog.argument(direction));
                OracleLog.recursiveTrace = false;
            }
            int n2 = _direction = direction == 1001 ? -1 : 1;
            while (refetchRset.next()) {
                ROWID thisRowid = refetchRset.getROWID(1);
                boolean found = false;
                int thisRow = _beginIdx;
                while (!found && thisRow < _beginIdx + _realFetchSz * _direction) {
                    if (((ROWID)this.getCachedDatumValueAt(thisRow, 1)).stringValue().equals(thisRowid.stringValue())) {
                        found = true;
                        continue;
                    }
                    thisRow += _direction;
                }
                if (!found) continue;
                for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                    this.putCachedValueAt(thisRow, i2 + 1, refetchRset.privateGetBytes(i2 + 1));
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCachedValueAt(int row, int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(row) + ", " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            try {
                Object __result__ = this.rsetCache.get(row, column);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Object object = __result__;
                return object;
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Object var3_5 = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var3_5;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum getCachedDatumValueAt(int row, int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(row) + ", " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            Object value = null;
            try {
                value = this.rsetCache.get(row, column);
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            Datum datumValue = null;
            if (value != null) {
                if (value instanceof Datum) {
                    datumValue = (Datum)value;
                } else if (((byte[])value).length > 0) {
                    int _colType = this.getInternalMetadata().getColumnType(column);
                    int _colLength = this.getInternalMetadata().getColumnDisplaySize(column);
                    int max = this.scrollStmt.getMaxFieldSize();
                    if (max > 0 && max < _colLength) {
                        _colLength = max;
                    }
                    String _sqlType = null;
                    if (_colType == 2006 || _colType == 2002 || _colType == 2008 || _colType == 2007 || _colType == 2003) {
                        _sqlType = this.getInternalMetadata().getColumnTypeName(column);
                    }
                    int sqlTypeCode = SQLUtil.getInternalType(_colType);
                    short form = this.resultSet.statement.accessors[column - 1].formOfUse;
                    datumValue = form == 2 && (sqlTypeCode == 96 || sqlTypeCode == 1 || sqlTypeCode == 8 || sqlTypeCode == 112) ? SQLUtil.makeNDatum(this.connection, (byte[])value, sqlTypeCode, _sqlType, form, _colLength) : SQLUtil.makeDatum((OracleConnection)this.connection, (byte[])value, sqlTypeCode, _sqlType, _colLength);
                    try {
                        this.rsetCache.put(row, column, datumValue);
                    }
                    catch (IOException e3) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e3);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e3);
                    }
                } else {
                    try {
                        this.rsetCache.put(row, column, null);
                    }
                    catch (IOException e4) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e4);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e4);
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + datumValue);
                OracleLog.recursiveTrace = false;
            }
            Datum datum = datumValue;
            return datum;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedValueAt(int row, int column, Object value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(row) + ", " + OracleLog.argument(column) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.rsetCache.put(row, column, value);
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedRowAt(int row) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(row));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.rsetCache.remove(row);
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needIdentifier(int type, int concur) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(concur));
                OracleLog.recursiveTrace = false;
            }
            if (type == 1003 && concur == 1007 || type == 1004 && concur == 1007) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needCache(int type, int concur) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(concur));
                OracleLog.recursiveTrace = false;
            }
            if (type == 1003 || type == 1004 && concur == 1007) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supportRefreshRow(int type, int concur) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(concur));
                OracleLog.recursiveTrace = false;
            }
            if (type == 1003 || type == 1004 && concur == 1007) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getFirstUserColumnIndex() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.beginColumnIndex);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.beginColumnIndex;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            String string;
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 23getCursorName");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    string = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement getOracleStatement() throws SQLException {
        try {
            OracleStatement __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleStatement oracleStatement = __result__ = this.resultSet == null ? null : this.resultSet.getOracleStatement();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleStatement oracleStatement2 = __result__;
            return oracleStatement2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

