/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarcharBinder;

class StringBinder
extends VarcharBinder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:29_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    StringBinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StringBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                OracleLog.recursiveTrace = false;
            }
            String[] strs = stmt.parameterString[rank];
            String value = strs[bindPosition];
            if (clearPriorBindValues) {
                strs[bindPosition] = null;
            }
            if (value == null) {
                bindIndicators[indoffset] = -1;
            } else {
                bindIndicators[indoffset] = 0;
                int l2 = value.length();
                value.getChars(0, l2, bindChars, charoffset + 1);
                bindChars[charoffset] = (char)(l2 <<= 1);
                bindIndicators[lenoffset] = l2 > 65532 ? -2 : (short)(l2 + 2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StringBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.StringBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

