/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class T2CInputStream
extends OracleInputStream {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:31_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, byte[] var7, int var8, char[] var9, int var10, short[] var11, int var12);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T2CInputStream(OracleStatement stmt, int index, Accessor a2) {
        super(stmt, index, a2);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(a2));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CInputStream.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T2CInputStream(int index) {
        super(null, index, null);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CInputStream.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n2;
            block14: {
                try {
                    int dataSize;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if ((dataSize = this.t2cGetBytes(this.statement.c_state, this.columnIndex, this.buf, this.chunkSize, this.statement.accessors, this.statement.defineBytes, this.statement.accessorByteOffset, this.statement.defineChars, this.statement.accessorCharOffset, this.statement.defineIndicators, this.statement.accessorShortOffset)) == -2) {
                        try {
                            this.accessor.setNull(this.statement.currentRow);
                        }
                        catch (SQLException e2) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T2CInputStream.logger().log(Level.SEVERE, "Throwing java.io.IOException: " + e2.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                            throw new IOException(e2.getMessage());
                        }
                        dataSize = 0;
                    }
                    if (dataSize <= 0) {
                        dataSize = -1;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CInputStream.logger().log(OracleLog.TRACE_30, "return: " + dataSize);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = dataSize;
                    if (!TRACE || OracleLog.recursiveTrace) break block14;
                    OracleLog.recursiveTrace = true;
                    T2CInputStream.logger().log(OracleLog.TRACE_30, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CInputStream.logger().log(OracleLog.TRACE_30, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

