/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4C7Oversion
extends T4CTTIfun {
    byte[] rdbmsVersion = new byte[]{78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116};
    boolean rdbmsVersionO2U = false;
    int bufLen = 256;
    boolean retVerLenO2U = false;
    int retVerLen = 0;
    boolean retVerNumO2U = false;
    long retVerNum = 0L;
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:32_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4C7Oversion(T4CMAREngine _mrengine, T4CTTIoer _oer, T4CConnection _connection) throws IOException, SQLException {
        super((byte)3, 0, (short)59);
        this.setMarshalingEngine(_mrengine);
        this.oer = _oer;
        this.rdbmsVersionO2U = true;
        this.retVerLenO2U = true;
        this.retVerNumO2U = true;
        this.connection = _connection;
    }

    void receive() throws SQLException, IOException {
        boolean rpaProcessed = false;
        block7: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            if (rpaProcessed) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    T4C7Oversion.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            }
                            this.retVerLen = this.meg.unmarshalUB2();
                            this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
                            if (this.rdbmsVersion == null) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    T4C7Oversion.logger().log(Level.SEVERE, "Throwing SQLException: 438");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 438);
                            }
                            this.retVerNum = this.meg.unmarshalUB4();
                            rpaProcessed = true;
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block7;
                        }
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block7;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block7;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4C7Oversion.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
    }

    byte[] getVersion() {
        return this.rdbmsVersion;
    }

    short getVersionNumber() {
        int ver = 0;
        ver = (int)((long)ver + (this.retVerNum >>> 24 & 0xFFL) * 1000L);
        ver = (int)((long)ver + (this.retVerNum >>> 20 & 0xFL) * 100L);
        ver = (int)((long)ver + (this.retVerNum >>> 12 & 0xFL) * 10L);
        ver = (int)((long)ver + (this.retVerNum >>> 8 & 0xFL));
        return (short)ver;
    }

    long getVersionNumberasIs() {
        return this.retVerNum;
    }

    @Override
    void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalO2U(this.rdbmsVersionO2U);
        this.meg.marshalSWORD(this.bufLen);
        this.meg.marshalO2U(this.retVerLenO2U);
        this.meg.marshalO2U(this.retVerNumO2U);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4C7Oversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4C7Oversion.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4C7Oversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C7Oversion"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

