/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:32_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4C8TTIClob(T4CMAREngine mengine, T4CTTIoer _oer) {
        super(mengine, _oer);
    }

    long read(byte[] lobLocator, long offset, long numChars, boolean isNCLOB, char[] outBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        byte[] myBuffer = null;
        this.initializeLobdef();
        if ((lobLocator[6] & 0x80) == 128) {
            this.varWidthChar = true;
        }
        myBuffer = this.varWidthChar ? new byte[(int)numChars * 2] : new byte[(int)numChars * 3];
        if ((lobLocator[7] & 0x40) > 0) {
            this.littleEndianClob = true;
        }
        this.lobops = 2L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numChars;
        this.sendLobamt = true;
        this.outBuffer = myBuffer;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        long charsRead = this.lobamt;
        long bytesConverted = 0L;
        if (this.varWidthChar) {
            if (this.meg.databaseVersion < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.ucs2BytesToJavaChars(myBuffer, myBuffer.length, outBuffer);
            } else if (this.littleEndianClob) {
                CharacterSet.convertAL16UTF16LEBytesToJavaChars(myBuffer, 0, outBuffer, 0, (int)this.lobBytesRead, true);
            } else {
                CharacterSet.convertAL16UTF16BytesToJavaChars(myBuffer, 0, outBuffer, 0, (int)this.lobBytesRead, true);
            }
        } else if (!isNCLOB) {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.CHARBytesToJavaChars(myBuffer, 0, outBuffer, 0, this.nBytes, outBuffer.length);
        } else {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.NCHARBytesToJavaChars(myBuffer, 0, outBuffer, 0, this.nBytes, outBuffer.length);
        }
        return charsRead;
    }

    long write(byte[] lobLocator, long offset, boolean isNCLOB, char[] inBuffer, long offsetInBuffer, long numChars) throws SQLException, IOException {
        boolean varChar = false;
        if ((lobLocator[6] & 0x80) == 128) {
            varChar = true;
        }
        if ((lobLocator[7] & 0x40) == 64) {
            this.littleEndianClob = true;
        }
        long bytesConverted = 0L;
        byte[] myBuffer = null;
        if (varChar) {
            myBuffer = new byte[(int)numChars * 2];
            if (this.meg.databaseVersion < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.javaCharsToUcs2Bytes(inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
            } else if (this.littleEndianClob) {
                CharacterSet.convertJavaCharsToAL16UTF16LEBytes(inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
            } else {
                CharacterSet.convertJavaCharsToAL16UTF16Bytes(inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
            }
        } else {
            myBuffer = new byte[(int)numChars * 3];
            bytesConverted = !isNCLOB ? (long)this.meg.conv.javaCharsToCHARBytes(inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars) : (long)this.meg.conv.javaCharsToNCHARBytes(inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numChars;
        this.sendLobamt = true;
        this.inBuffer = myBuffer;
        this.marshalFunHeader();
        this.marshalOlobops();
        if (varChar) {
            if (this.meg.databaseVersion < 10101) {
                this.lobd.marshalLobDataUB2(myBuffer, 0L, numChars);
            } else {
                this.lobd.marshalLobData(myBuffer, 0L, numChars * 2L);
            }
        } else {
            this.lobd.marshalLobData(myBuffer, 0L, bytesConverted);
        }
        this.receiveReply();
        long charsWritten = this.lobamt;
        return charsWritten;
    }

    @Override
    Datum createTemporaryLob(Connection conn, boolean cache, int duration) throws SQLException, IOException {
        return this.createTemporaryLob(conn, cache, duration, (short)1);
    }

    Datum createTemporaryLob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException, IOException {
        if (duration == 12) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4C8TTIClob.logger().log(Level.SEVERE, "Throwing SQLException: 158");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 158);
        }
        CLOB clob = null;
        this.initializeLobdef();
        this.lobops = 272L;
        this.sourceLobLocator = new byte[86];
        this.sourceLobLocator[1] = 84;
        this.lobamt = 10L;
        this.sendLobamt = true;
        this.sourceOffset = form_of_use == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = duration;
        this.nullO2U = true;
        short s2 = this.characterSet = form_of_use == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.meg.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = cache ? 1 : 0;
            this.lobscnl = 1;
        }
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        if (this.sourceLobLocator != null) {
            clob = form_of_use == 1 ? new CLOB((OracleConnection)conn, this.sourceLobLocator) : new NCLOB((OracleConnection)conn, this.sourceLobLocator);
        }
        return clob;
    }

    @Override
    boolean open(byte[] lobLocator, int mode) throws SQLException, IOException {
        boolean wasOpened = false;
        int kokl_mode = 2;
        if (mode == 0) {
            kokl_mode = 1;
        }
        wasOpened = this._open(lobLocator, kokl_mode, 32768);
        return wasOpened;
    }

    @Override
    boolean close(byte[] lobLocator) throws SQLException, IOException {
        boolean wasClosed = false;
        wasClosed = this._close(lobLocator, 65536);
        return wasClosed;
    }

    @Override
    boolean isOpen(byte[] lobLocator) throws SQLException, IOException {
        boolean open = false;
        open = this._isOpen(lobLocator, 69632);
        return open;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTIClob"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

