/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIokpn;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIoxssao;
import oracle.jdbc.driver.T4CTTIoxsscs;
import oracle.jdbc.driver.T4CTTIoxssso;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIspfp;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.driver.T4Caqdq;
import oracle.jdbc.driver.T4Caqe;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;

class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final int STREAM_CHUNK_SIZE = 255;
    static final int REFCURSOR_SIZE = 5;
    long LOGON_MODE = 0L;
    static final long SYSDBA = 8L;
    static final long SYSOPER = 16L;
    static final long SYSASM = 128L;
    boolean isLoggedOn;
    private String password;
    Communication net;
    boolean readAsNonStream;
    T4CTTIoer oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4C8TTIdty dty;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIspfp spfp;
    T4CTTIoauthenticate auth;
    T4C8Odscrarr describe;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4C7Ocommoncall commoncall;
    T4Caqe aqe;
    T4Caqdq aqdq;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4CTTIoses oses;
    T4CTTIoping oping;
    T4CTTIokpn okpn;
    byte[] EMPTY_BYTE = new byte[0];
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    T4CTTIoxsscs oxsscs;
    T4CTTIoxssso oxssso;
    T4CTTIoxssao oxssao;
    int[] cursorToClose;
    int cursorToCloseOffset;
    int[] queryToClose;
    int queryToCloseOffset;
    int[] lusFunctionId;
    byte[][] lusSessionId;
    String[] lusNamespace;
    String[] lusAttributeName;
    KeywordValue[][] lusInKeyVal;
    int[] lusInFlags;
    int lusOffset;
    int sessionId;
    int serialNumber;
    byte[] sccap;
    byte[] srcap;
    Hashtable namespaces;
    byte[] internalName;
    byte[] externalName;
    String databaseVersionString;
    short databaseVersion;
    static final int MAX_SIZE_VSESSION_OSUSER = 30;
    static final int MAX_SIZE_VSESSION_PROCESS = 24;
    static final int MAX_SIZE_VSESSION_MACHINE = 64;
    static final int MAX_SIZE_VSESSION_TERMINAL = 30;
    static final int MAX_SIZE_VSESSION_PROGRAM = 48;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:32_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                OracleLog.recursiveTrace = false;
            }
            this.cursorToClose = new int[4];
            this.cursorToCloseOffset = 0;
            this.queryToClose = new int[10];
            this.queryToCloseOffset = 0;
            this.lusFunctionId = new int[10];
            this.lusSessionId = new byte[10][];
            this.lusNamespace = new String[10];
            this.lusAttributeName = new String[10];
            this.lusInKeyVal = new KeywordValue[10][];
            this.lusInFlags = new int[10];
            this.lusOffset = 0;
            this.minVcsBindSize = 0;
            this.streamChunkSize = 255;
            this.namespaces = new Hashtable(5);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    final void initializePassword(String p2) throws SQLException {
        this.password = p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void logon() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.isLoggedOn) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 428");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 428);
                }
                if (this.database == null) {
                    this.database = DEFAULT_CONNECT_STRING;
                }
                this.connect(this.database);
                this.all8 = new T4C8Oall(this.mare, this, this.oer);
                this.okpn = new T4CTTIokpn(this.mare, this.oer, this);
                this.close8 = new T4C8Oclose(this.mare);
                this.sto = new T4CTTIsto(this.mare, this.oer, this);
                this.spfp = new T4CTTIspfp(this.mare, this.oer, this);
                this.commoncall = new T4C7Ocommoncall(this.mare, this.oer, this);
                this.describe = new T4C8Odscrarr(this.mare, this.oer);
                this.bfileMsg = new T4C8TTIBfile(this.mare, this.oer);
                this.blobMsg = new T4C8TTIBlob(this.mare, this.oer);
                this.clobMsg = new T4C8TTIClob(this.mare, this.oer);
                this.otxen = new T4CTTIOtxen(this.mare, this.oer, this);
                this.otxse = new T4CTTIOtxse(this.mare, this.oer, this);
                this.oping = new T4CTTIoping(this.mare, this.oer, this);
                this.k2rpc = new T4CTTIk2rpc(this.mare, this.oer, this);
                this.oses = new T4CTTIoses(this.mare);
                this.okeyval = new T4CTTIokeyval(this.mare);
                this.oxsscs = new T4CTTIoxsscs(this.mare, this.oer, this);
                this.oxssso = new T4CTTIoxssso(this.mare, this.oer, this);
                this.oxssao = new T4CTTIoxssao(this.mare, this.oer, this);
                this.aqe = new T4Caqe(this.mare, this, this.oer);
                this.aqdq = new T4Caqdq(this.mare, this, this.oer);
                this.oscid = new T4CTTIoscid(this.mare);
                this.dty = new T4C8TTIdty(this.mare);
                if (this.logonCap != null && this.logonCap.trim().equals("o3")) {
                    this.dty.CTcap[4] = 0;
                }
                this.dty.marshal(this.sccap);
                this.dty.receive();
                this.LOGON_MODE = 0L;
                if (this.internalLogon != null) {
                    if (this.internalLogon.equalsIgnoreCase("sysoper")) {
                        this.LOGON_MODE = 64L;
                    } else if (this.internalLogon.equalsIgnoreCase("sysdba")) {
                        this.LOGON_MODE = 32L;
                    } else if (this.internalLogon.equalsIgnoreCase("sysasm")) {
                        this.LOGON_MODE = 0x400000L;
                    }
                }
                if (this.prelimAuth) {
                    this.LOGON_MODE |= 0x80L;
                }
                this.auth = new T4CTTIoauthenticate(this.mare, this.resourceManagerId, this.oer, this);
                if (this.userName != null && this.userName.length() != 0) {
                    this.auth.marshalOsesskey(this.userName, this.LOGON_MODE);
                    this.auth.receiveOsesskey();
                }
                this.auth.marshalOauth(this.userName, this.password, this.LOGON_MODE);
                this.auth.receiveOauth();
                this.sessionId = this.getSessionId();
                this.serialNumber = this.getSerialNumber();
                this.internalName = this.auth.internalName;
                this.externalName = this.auth.externalName;
                this.instanceName = this.sessionProperties.getProperty("AUTH_INSTANCENAME");
                if (!this.prelimAuth) {
                    T4C7Oversion ver = new T4C7Oversion(this.mare, this.oer, this);
                    ver.marshal();
                    ver.receive();
                    byte[] resultBytes = ver.getVersion();
                    try {
                        this.databaseVersionString = new String(resultBytes, "UTF8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    }
                    this.mare.databaseVersion = this.databaseVersion = ver.getVersionNumber();
                }
                this.isLoggedOn = true;
            }
            catch (NetException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            catch (SQLException se) {
                block30: {
                    try {
                        this.net.disconnect();
                    }
                    catch (Exception e3) {
                        if (!TRACE || OracleLog.recursiveTrace) break block30;
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_20, "Debug: T4CConnection.logon: Exception in net.disconnect: " + e3);
                        OracleLog.recursiveTrace = false;
                    }
                }
                this.isLoggedOn = false;
                throw se;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIOException(IOException ea) throws SQLException {
        try {
            block7: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ea));
                    OracleLog.recursiveTrace = false;
                }
                try {
                    this.mare.pipeState = -1;
                    this.net.disconnect();
                }
                catch (Exception e2) {
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_20, "Debug: T4CConnection.handleIOException: Exception in net.disconnect: " + e2);
                    OracleLog.recursiveTrace = false;
                }
            }
            this.isLoggedOn = false;
            this.lifecycle = 4;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void logoff() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                this.assertLoggedOn("T4CConnection.logoff");
                if (this.lifecycle == 8) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                this.sendPiggyBackedMessages();
                this.commoncall.init((short)9);
                this.commoncall.marshal();
                this.commoncall.receive();
                this.net.disconnect();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (this.lifecycle != 8) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            finally {
                this.isLoggedOn = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doCommit(int flags) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flags));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.assertLoggedOn("T4CConnection.do_commit");
                this.sendPiggyBackedMessages();
                if (flags == 0) {
                    this.commoncall.init((short)14);
                    this.commoncall.marshal();
                    this.commoncall.receive();
                } else {
                    int txnflgs = 0;
                    if ((flags & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
                        txnflgs = txnflgs | 2 | 1;
                    } else if ((flags & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
                        txnflgs |= 2;
                    }
                    if ((flags & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                        txnflgs = txnflgs | 8 | 4;
                    } else if ((flags & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
                        txnflgs |= 8;
                    }
                    this.otxen.marshal(1, null, null, 0, 0, 0, 0, 4, txnflgs);
                    int[] errorNb = new int[1];
                    int outState = this.otxen.receive(errorNb);
                    if (outState != 2 && outState == 4) {
                        // empty if block
                    }
                }
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doRollback() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                this.assertLoggedOn("T4CConnection.do_rollback");
                this.sendPiggyBackedMessages();
                this.commoncall.init((short)15);
                this.commoncall.marshal();
                this.commoncall.receive();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doSetAutoCommit(boolean on) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(OracleStatement stmt) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("T4CConnection.open");
            stmt.setCursorId(0);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized String doGetDatabaseProductVersion() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.databaseVersionString);
                OracleLog.recursiveTrace = false;
            }
            String string = this.databaseVersionString;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized short doGetVersionNumber() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("T4CConnection.do_getVersionNumber");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.databaseVersion);
                OracleLog.recursiveTrace = false;
            }
            short s2 = this.databaseVersion;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(parent));
                OracleLog.recursiveTrace = false;
            }
            T4CStatement newstmt = new T4CStatement(this, -1, -1);
            try {
                int cursor = this.mare.unmarshalRefCursor(bytes);
                newstmt.setCursorId(cursor);
                newstmt.isOpen = true;
                newstmt.sqlObject = parent.sqlObject;
                newstmt.serverCursor = true;
                parent.addChild(newstmt);
                newstmt.prepareForNewResults(true, false);
            }
            catch (IOException e2) {
                this.handleIOException(e2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            newstmt.sqlStringChanged = false;
            newstmt.needToParse = false;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + newstmt);
                OracleLog.recursiveTrace = false;
            }
            T4CStatement t4CStatement = newstmt;
            return t4CStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void cancelOperationOnServer() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                switch (this.mare.pipeState) {
                    case -1: {
                        if (!TRACE) return;
                        if (OracleLog.recursiveTrace) return;
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                        return;
                    }
                    case 1: {
                        this.net.sendBreak();
                        break;
                    }
                    case 2: {
                        this.net.sendInterrupt();
                        break;
                    }
                }
                this.mare.sentCancel = true;
                return;
            }
            catch (NetException ne) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ne);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ne);
                return;
            }
            catch (IOException ne) {
                this.handleIOException(ne);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ne);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ne);
                return;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(String database) throws IOException, SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(database));
                OracleLog.recursiveTrace = false;
            }
            if (database == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 433");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 433);
            }
            Properties nsProperties = new Properties();
            if (this.thinNetProfile != null) {
                nsProperties.setProperty("oracle.net.profile", this.thinNetProfile);
            }
            if (this.thinNetAuthenticationServices != null) {
                nsProperties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
            }
            if (this.thinNetAuthenticationKrb5Mutual != null) {
                nsProperties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
            }
            if (this.thinNetAuthenticationKrb5CcName != null) {
                nsProperties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
            }
            if (this.thinNetEncryptionLevel != null) {
                nsProperties.setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
            }
            if (this.thinNetEncryptionTypes != null) {
                nsProperties.setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
            }
            if (this.thinNetChecksumLevel != null) {
                nsProperties.setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
            }
            if (this.thinNetChecksumTypes != null) {
                nsProperties.setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
            }
            if (this.thinNetCryptoSeed != null) {
                nsProperties.setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
            }
            if (this.thinTcpNoDelay) {
                nsProperties.setProperty("TCP.NODELAY", "YES");
            }
            if (this.thinReadTimeout != null) {
                nsProperties.setProperty("oracle.net.READ_TIMEOUT", this.thinReadTimeout);
            }
            if (this.thinNetConnectTimeout != null) {
                nsProperties.setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
            }
            if (this.thinSslServerDnMatch != null) {
                nsProperties.setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
            }
            if (this.walletLocation != null) {
                nsProperties.setProperty("oracle.net.wallet_location", this.walletLocation);
            }
            if (this.walletPassword != null) {
                nsProperties.setProperty("oracle.net.wallet_password", this.walletPassword);
            }
            if (this.thinSslVersion != null) {
                nsProperties.setProperty("oracle.net.ssl_version", this.thinSslVersion);
            }
            if (this.thinSslCipherSuites != null) {
                nsProperties.setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
            }
            if (this.thinJavaxNetSslKeystore != null) {
                nsProperties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
            }
            if (this.thinJavaxNetSslKeystoretype != null) {
                nsProperties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
            }
            if (this.thinJavaxNetSslKeystorepassword != null) {
                nsProperties.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
            }
            if (this.thinJavaxNetSslTruststore != null) {
                nsProperties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
            }
            if (this.thinJavaxNetSslTruststoretype != null) {
                nsProperties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
            }
            if (this.thinJavaxNetSslTruststorepassword != null) {
                nsProperties.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
            }
            if (this.thinSslKeymanagerfactoryAlgorithm != null) {
                nsProperties.setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
            }
            if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
                nsProperties.setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
            }
            if (this.thinNetOldsyntax != null) {
                nsProperties.setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
            }
            if (this.thinNamingContextInitial != null) {
                nsProperties.setProperty("java.naming.factory.initial", this.thinNamingContextInitial);
            }
            if (this.thinNamingProviderUrl != null) {
                nsProperties.setProperty("java.naming.provider.url", this.thinNamingProviderUrl);
            }
            if (this.thinNamingSecurityAuthentication != null) {
                nsProperties.setProperty("java.naming.security.authentication", this.thinNamingSecurityAuthentication);
            }
            if (this.thinNamingSecurityPrincipal != null) {
                nsProperties.setProperty("java.naming.security.principal", this.thinNamingSecurityPrincipal);
            }
            if (this.thinNamingSecurityCredentials != null) {
                nsProperties.setProperty("java.naming.security.credentials", this.thinNamingSecurityCredentials);
            }
            if (this.thinNetDisableOutOfBandBreak) {
                nsProperties.setProperty("DISABLE_OOB", "" + this.thinNetDisableOutOfBandBreak);
            }
            nsProperties.setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
            this.net = new NSProtocol();
            this.net.connect(database, nsProperties);
            this.mare = new T4CMAREngine(this.net);
            this.mare.setConnectionDuringExceptionHandling(this);
            this.oer = new T4CTTIoer(this.mare, this);
            this.pro = new T4C8TTIpro(this.mare);
            this.pro.marshal();
            this.sccap = this.pro.receive();
            this.srcap = this.pro.getServerRuntimeCapabilities();
            byte serverTTCVersion = this.sccap[7];
            this.mare.versionNumber = serverTTCVersion >= 5 ? (short)11000 : (serverTTCVersion >= 4 ? (short)10200 : (serverTTCVersion >= 3 ? (short)10000 : (short)9200));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                this.pro.printServerInfo();
                OracleLog.recursiveTrace = false;
            }
            short oVersion = this.pro.getOracleVersion();
            short ServerCharSet = this.pro.getCharacterSet();
            short accessCharSet = DBConversion.findDriverCharSet(ServerCharSet, oVersion);
            this.conversion = new DBConversion(ServerCharSet, accessCharSet, this.pro.getncharCHARSET());
            this.mare.types.setServerConversion(accessCharSet != ServerCharSet);
            if (DBConversion.isCharSetMultibyte(accessCharSet)) {
                if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                    this.mare.types.setFlags((byte)1);
                } else {
                    this.mare.types.setFlags((byte)2);
                }
            } else {
                this.mare.types.setFlags(this.pro.getFlags());
            }
            this.mare.conv = this.conversion;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doStartup(int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            try {
                int stomode = 0;
                if (mode == OracleConnection.DatabaseStartupMode.FORCE.getMode()) {
                    stomode = 16;
                } else if (mode == OracleConnection.DatabaseStartupMode.RESTRICT.getMode()) {
                    stomode = 1;
                }
                this.spfp.marshal();
                this.spfp.receive();
                this.sto.marshalStartup(stomode);
                this.sto.receive();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doShutdown(int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            try {
                int stomode = 4;
                if (mode == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode()) {
                    stomode = 128;
                } else if (mode == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode()) {
                    stomode = 256;
                } else if (mode == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode()) {
                    stomode = 2;
                } else if (mode == OracleConnection.DatabaseShutdownMode.FINAL.getMode()) {
                    stomode = 8;
                } else if (mode == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
                    stomode = 64;
                }
                this.sendPiggyBackedMessages();
                this.sto.marshalShutdown(stomode);
                this.sto.receive();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPiggyBackedMessages() throws SQLException, IOException {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.sendPiggyBackedClose();
            if (this.endToEndAnyChanged && this.mare.versionNumber >= 10000) {
                this.oscid.marshal(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
                for (i2 = 0; i2 < 4; ++i2) {
                    if (!this.endToEndHasChanged[i2]) continue;
                    this.endToEndHasChanged[i2] = false;
                }
            }
            this.endToEndAnyChanged = false;
            if (!this.namespaces.isEmpty()) {
                if (this.mare.versionNumber >= 10200) {
                    Object[] namespacesArr = this.namespaces.values().toArray();
                    for (int i3 = 0; i3 < namespacesArr.length; ++i3) {
                        this.okeyval.marshal((Namespace)namespacesArr[i3]);
                    }
                }
                this.namespaces.clear();
            }
            if (this.lusOffset > 0) {
                for (i2 = 0; i2 < this.lusOffset; ++i2) {
                    this.oxssao.marshal(this.lusFunctionId[i2], this.lusSessionId[i2], this.lusNamespace[i2], this.lusAttributeName[i2], this.lusInKeyVal[i2], this.lusInFlags[i2]);
                }
                this.lusOffset = 0;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPiggyBackedClose() throws SQLException, IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.queryToCloseOffset > 0) {
                this.close8.initCloseQuery();
                this.close8.marshal(this.queryToClose, this.queryToCloseOffset);
                this.queryToCloseOffset = 0;
            }
            if (this.cursorToCloseOffset > 0) {
                this.close8.initCloseStatement();
                this.close8.marshal(this.cursorToClose, this.cursorToCloseOffset);
                this.cursorToCloseOffset = 0;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doProxySession(int type, Properties prop) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.sendPiggyBackedMessages();
                this.auth.marshalOauth(type, prop, this.sessionId, this.serialNumber);
                this.auth.receiveOauth();
                int prox_session_id = this.getSessionId();
                int prox_serial_nb = this.getSerialNumber();
                this.oses.marshal(prox_session_id, prox_serial_nb, 1);
                this.savedUser = this.userName;
                this.userName = type == 1 ? prop.getProperty("PROXY_USER_NAME") : null;
                this.isProxy = true;
            }
            catch (IOException ioe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ioe);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioe);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeProxySession() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                this.sendPiggyBackedMessages();
                this.commoncall.init((short)9);
                this.commoncall.marshal();
                this.commoncall.receive();
                this.oses.marshal(this.sessionId, this.serialNumber, 1);
                this.userName = this.savedUser;
            }
            catch (IOException ioe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ioe);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioe);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServerSessionInfo() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.getVersionNumber() < 10200) {
                this.queryFCFProperties(this.sessionProperties);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.sessionProperties);
                OracleLog.recursiveTrace = false;
            }
            Properties properties = this.sessionProperties;
            return properties;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string;
        block6: {
            try {
                String ret;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if ((ret = this.getServerSessionInfo().getProperty("SESSION_TIME_ZONE")) == null) {
                    ret = super.getSessionTimeZoneOffset();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                string = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            T4CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    int getSessionId() {
        int sessionId = -1;
        String valueStr = this.sessionProperties.getProperty("AUTH_SESSION_ID");
        try {
            sessionId = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sessionId;
    }

    int getSerialNumber() {
        int serialNumber = -1;
        String valueStr = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
        try {
            serialNumber = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        byte by;
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                byte ret = 0;
                if (whatProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
                    if (this.srcap == null || this.srcap.length < 6) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 256");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 256);
                    }
                    ret = this.srcap[5];
                } else if (whatProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
                    if (this.srcap == null || this.srcap.length < 4) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 256");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 256);
                    }
                    ret = this.srcap[3];
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                by = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            T4CConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long length(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("length");
            this.assertNotNull(bfile.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.bfileMsg.getLength(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long position(BFILE bfile, byte[] pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.hasPattern(bfile, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BFILE bfile, BFILE pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.isSubLob(bfile, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getBytes(BFILE bfile, long pos, int length, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getBytes");
            if (pos < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68getBytes()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
            }
            if (length <= 0 || bytes == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    result = this.bfileMsg.read(bfile.shareBytes(), pos, length, bytes);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = (int)result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getName");
            this.assertNotNull(bfile.shareBytes(), "getName");
            String result = LobPlsqlUtil.fileGetName(bfile);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDirAlias(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getDirAlias");
            this.assertNotNull(bfile.shareBytes(), "getDirAlias");
            String result = LobPlsqlUtil.fileGetDirAlias(bfile);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void openFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("openFile");
            this.assertNotNull(bfile.shareBytes(), "openFile");
            this.needLine();
            try {
                this.bfileMsg.open(bfile.shareBytes(), 11);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isFileOpen(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("openFile");
            this.assertNotNull(bfile.shareBytes(), "openFile");
            this.needLine();
            boolean result = false;
            try {
                result = this.bfileMsg.isOpen(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean fileExists(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("fileExists");
            this.assertNotNull(bfile.shareBytes(), "fileExists");
            this.needLine();
            boolean result = false;
            try {
                result = this.bfileMsg.doesExist(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("closeFile");
            this.assertNotNull(bfile.shareBytes(), "closeFile");
            this.needLine();
            try {
                this.bfileMsg.close(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(BFILE bfile, int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("open");
            this.assertNotNull(bfile.shareBytes(), "open");
            this.needLine();
            try {
                this.bfileMsg.open(bfile.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("close");
            this.assertNotNull(bfile.shareBytes(), "close");
            this.needLine();
            try {
                this.bfileMsg.close(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen(BFILE bfile) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("isOpen");
            this.assertNotNull(bfile.shareBytes(), "isOpen");
            this.needLine();
            boolean result = false;
            try {
                result = this.bfileMsg.isOpen(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BFILE bfile, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleBlobInputStream oracleBlobInputStream = __result__;
                return oracleBlobInputStream;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newConversionInputStream(BFILE bfile, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.assertNotNull(bfile.shareBytes(), "newConversionInputStream");
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = result;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newConversionReader(BFILE bfile, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.assertNotNull(bfile.shareBytes(), "newConversionReader");
            OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader oracleConversionReader = result;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long length(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("length");
            this.assertNotNull(blob.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.blobMsg.getLength(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BLOB blob, byte[] pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("position");
            this.assertNotNull(blob.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.hasPattern(blob, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BLOB blob, BLOB pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("position");
            this.assertNotNull(blob.shareBytes(), "position");
            this.assertNotNull(pattern.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.isSubLob(blob, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getBytes(BLOB blob, long pos, int length, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getBytes");
            this.assertNotNull(blob.shareBytes(), "getBytes");
            if (pos < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68getBytes()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
            }
            if (length <= 0 || bytes == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    result = this.blobMsg.read(blob.shareBytes(), pos, length, bytes);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = (int)result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int putBytes(BLOB blob, long pos, byte[] bytes, int bytesOffset, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytesOffset) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("putBytes");
            this.assertNotNull(blob.shareBytes(), "putBytes");
            if (pos < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68putBytes()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "putBytes()");
            }
            if (bytes == null || length <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    result = this.blobMsg.write(blob.shareBytes(), pos, bytes, bytesOffset, length);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = (int)result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getChunkSize(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getChunkSize");
            this.assertNotNull(blob.shareBytes(), "getChunkSize");
            this.needLine();
            long result = 0L;
            try {
                result = this.blobMsg.getChunkSize(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void trim(BLOB blob, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("trim");
            this.assertNotNull(blob.shareBytes(), "trim");
            if (length < 0L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68trim()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
            }
            this.needLine();
            try {
                this.blobMsg.trim(blob.shareBytes(), length);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("createTemporaryBlob");
            this.needLine();
            BLOB result = null;
            try {
                result = (BLOB)this.blobMsg.createTemporaryLob(this, cache, duration);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            BLOB bLOB = result;
            return bLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void freeTemporary(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("freeTemporary");
            this.assertNotNull(blob.shareBytes(), "freeTemporary");
            this.needLine();
            try {
                this.blobMsg.freeTemporaryLob(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            boolean result = false;
            byte[] locator = blob.shareBytes();
            if ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
                result = true;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(BLOB blob, int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("open");
            this.assertNotNull(blob.shareBytes(), "open");
            this.needLine();
            try {
                this.blobMsg.open(blob.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("close");
            this.assertNotNull(blob.shareBytes(), "close");
            this.needLine();
            try {
                this.blobMsg.close(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen(BLOB blob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("isOpen");
            this.assertNotNull(blob.shareBytes(), "isOpen");
            this.needLine();
            boolean result = false;
            try {
                result = this.blobMsg.isOpen(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleBlobInputStream oracleBlobInputStream = __result__;
                return oracleBlobInputStream;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BLOB blob, int chunkSize, long pos, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize, pos, length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleBlobOutputStream oracleBlobOutputStream = __result__;
                return oracleBlobOutputStream;
            }
            OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleBlobOutputStream oracleBlobOutputStream = __result__;
            return oracleBlobOutputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newConversionInputStream(BLOB blob, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.assertNotNull(blob.shareBytes(), "newConversionInputStream");
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = result;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newConversionReader(BLOB blob, int conversionType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                OracleLog.recursiveTrace = false;
            }
            this.assertNotNull(blob.shareBytes(), "newConversionReader");
            OracleConversionReader result = new OracleConversionReader(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader oracleConversionReader = result;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long length(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("length");
            this.assertNotNull(clob.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.clobMsg.getLength(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(CLOB clob, String pattern, long start) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (pattern == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            this.assertLoggedOn("position");
            this.assertNotNull(clob.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            char[] chars = new char[pattern.length()];
            pattern.getChars(0, chars.length, chars, 0);
            long result = LobPlsqlUtil.hasPattern(clob, chars, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(CLOB clob, CLOB pattern, long start) throws SQLException {
        try {
            long result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                OracleLog.recursiveTrace = false;
            }
            if (pattern == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            this.assertLoggedOn("position");
            this.assertNotNull(clob.shareBytes(), "position");
            this.assertNotNull(pattern.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68position()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            }
            long l2 = result = (result = LobPlsqlUtil.isSubLob(clob, pattern, start)) == 0L ? -1L : result;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getChars(CLOB clob, long pos, int length, char[] chars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(chars));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getChars");
            this.assertNotNull(clob.shareBytes(), "getChars");
            if (pos < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68getChars()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "getChars()");
            }
            if (length <= 0 || chars == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    boolean isNCLOB = clob.isNCLOB();
                    result = this.clobMsg.read(clob.shareBytes(), pos, length, isNCLOB, chars);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = (int)result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int putChars(CLOB clob, long pos, char[] chars, int charsOffset, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(charsOffset) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("putChars");
            this.assertNotNull(clob.shareBytes(), "putChars");
            if (pos < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68putChars()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "putChars()");
            }
            if (chars == null || length <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    boolean isNCLOB = clob.isNCLOB();
                    result = this.clobMsg.write(clob.shareBytes(), pos, isNCLOB, chars, charsOffset, length);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n3 = (int)result;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getChunkSize(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("getChunkSize");
            this.assertNotNull(clob.shareBytes(), "getChunkSize");
            this.needLine();
            long result = 0L;
            try {
                result = this.clobMsg.getChunkSize(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + (int)result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void trim(CLOB clob, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("trim");
            this.assertNotNull(clob.shareBytes(), "trim");
            if (length < 0L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68trim()");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
            }
            this.needLine();
            try {
                this.clobMsg.trim(clob.shareBytes(), length);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration) + ", " + OracleLog.argument(form_of_use));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("createTemporaryClob");
            this.needLine();
            CLOB result = null;
            try {
                result = (CLOB)this.clobMsg.createTemporaryLob(this, cache, duration, form_of_use);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            CLOB cLOB = result;
            return cLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void freeTemporary(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("freeTemporary");
            this.assertNotNull(clob.shareBytes(), "freeTemporary");
            this.needLine();
            try {
                this.clobMsg.freeTemporaryLob(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            boolean result = false;
            byte[] locator = clob.shareBytes();
            if ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
                result = true;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(CLOB clob, int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("open");
            this.assertNotNull(clob.shareBytes(), "open");
            this.needLine();
            try {
                this.clobMsg.open(clob.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("close");
            this.assertNotNull(clob.shareBytes(), "close");
            this.needLine();
            try {
                this.clobMsg.close(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen(CLOB clob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
            this.assertLoggedOn("isOpen");
            this.assertNotNull(clob.shareBytes(), "isOpen");
            boolean result = false;
            this.needLine();
            try {
                result = this.clobMsg.isOpen(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobInputStream oracleClobInputStream = __result__;
                return oracleClobInputStream;
            }
            OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobInputStream oracleClobInputStream = __result__;
            return oracleClobInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobOutputStream oracleClobOutputStream = __result__;
                return oracleClobOutputStream;
            }
            OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobOutputStream oracleClobOutputStream = __result__;
            return oracleClobOutputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newReader(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobReader __result__ = new OracleClobReader(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobReader oracleClobReader = __result__;
                return oracleClobReader;
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobReader oracleClobReader = __result__;
            return oracleClobReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newReader(CLOB clob, int chunkSize, long pos, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos, length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobReader oracleClobReader = __result__;
            return oracleClobReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer newWriter(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                OracleLog.recursiveTrace = false;
            }
            if (pos == 0L) {
                OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleClobWriter oracleClobWriter = __result__;
                return oracleClobWriter;
            }
            OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize, pos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleClobWriter oracleClobWriter = __result__;
            return oracleClobWriter;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertLoggedOn(String caller) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(caller));
                OracleLog.recursiveTrace = false;
            }
            if (!this.isLoggedOn) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 430");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 430);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNotNull(byte[] bytes, String caller) throws NullPointerException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(caller));
                OracleLog.recursiveTrace = false;
            }
            if (bytes == null) {
                throw new NullPointerException("bytes are null");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void internalClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            super.internalClose();
            this.isLoggedOn = false;
            try {
                if (this.net != null) {
                    this.net.disconnect();
                }
            }
            catch (Exception e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_20, "Debug: T4CConnection.logon: Exception in net.disconnect: " + e2);
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doAbort() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                this.net.abort();
            }
            catch (NetException ne) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ne);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ne);
            }
            catch (IOException ne) {
                this.handleIOException(ne);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ne);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ne);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            T4CStatement t4cStmt = new T4CStatement(this, -1, -1);
            t4cStmt.open();
            String tableName = info.getTableName();
            String sql = "SELECT * FROM " + tableName;
            t4cStmt.sqlObject.initialize(sql);
            Accessor[] accessors = null;
            try {
                this.describe.init(t4cStmt, 0);
                this.describe.sqltext = t4cStmt.sqlObject.getSqlBytes(false, false);
                this.describe.marshal();
                accessors = this.describe.receive(accessors);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            int numColumns = this.describe.numuds;
            info.allocateSpaceForDescribedData(numColumns);
            for (int i2 = 0; i2 < numColumns; ++i2) {
                Accessor accessor = accessors[i2];
                String columnName = accessor.columnName;
                int type = accessor.describeType;
                int maxLength = accessor.describeMaxLength;
                boolean nullable = accessor.nullable;
                short formOfUse = accessor.formOfUse;
                int precision = accessor.precision;
                int scale = accessor.scale;
                String typeName = accessor.describeTypeName;
                info.fillDescribedData(i2, columnName, type, maxLength, nullable, formOfUse, precision, scale, typeName);
            }
            t4cStmt.close();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            Namespace ns;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            if ((ns = (Namespace)this.namespaces.get(nameSpace)) == null) {
                ns = new Namespace(nameSpace);
                this.namespaces.put(nameSpace, ns);
            }
            ns.setAttribute(attribute, value);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nameSpace));
                OracleLog.recursiveTrace = false;
            }
            Namespace ns = new Namespace(nameSpace);
            ns.clear();
            this.namespaces.put(nameSpace, ns);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pc));
                OracleLog.recursiveTrace = false;
            }
            super.getPropertyForPooledConnection(pc, this.password);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getPasswordInternal(T4CXAResource caller) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(caller));
                OracleLog.recursiveTrace = false;
            }
            caller.setPasswordInternal(this.password);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doEnqueue(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI prop, byte[] payloadTDO, byte[] payload, byte[][] msgId, boolean isRawPayload) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(enqueueOptions) + ", " + OracleLog.argument(prop) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgId) + ", " + OracleLog.argument(isRawPayload));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.needLine();
                this.sendPiggyBackedMessages();
                this.aqe.marshal(queueName, enqueueOptions, prop, payload, payloadTDO, isRawPayload);
                this.aqe.receive(enqueueOptions, msgId);
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ioex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized boolean doDequeue(String queueName, AQDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, byte[] payloadTDO, byte[][] payload, byte[][] msgid, boolean isRawQueue) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(dequeueOptions) + ", " + OracleLog.argument(msgProp) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgid) + ", " + OracleLog.argument(isRawQueue));
                OracleLog.recursiveTrace = false;
            }
            boolean hasAMessageBeenDequeued = false;
            try {
                this.needLine();
                this.sendPiggyBackedMessages();
                this.aqdq.marshal(queueName, dequeueOptions, payloadTDO);
                hasAMessageBeenDequeued = this.aqdq.receive(dequeueOptions, payload, msgProp, msgid, isRawQueue);
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ioex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + hasAMessageBeenDequeued);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = hasAMessageBeenDequeued;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    synchronized int doPingDatabase() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.mare.versionNumber >= 10102) {
                try {
                    this.needLine();
                    this.sendPiggyBackedMessages();
                    this.oping.marshal();
                    this.oping.receive();
                }
                catch (IOException ioe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_16, "return: -1");
                        OracleLog.recursiveTrace = false;
                    }
                    int n2 = -1;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n2;
                }
                catch (SQLException ioe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_16, "return: -1");
                        OracleLog.recursiveTrace = false;
                    }
                    int n3 = -1;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int ioe = 0;
                return ioe;
            }
            int __result__ = super.doPingDatabase();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n4 = __result__;
            return n4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized NTFAQRegistration[] doRegisterAQNotification(String[] name, String dcnhost, int tcpport, Properties[] options) throws SQLException {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options));
                OracleLog.recursiveTrace = false;
            }
            int nbOfRegistration = name.length;
            int[] jdbcRegIdArr = new int[nbOfRegistration];
            byte[][] contextArr = new byte[nbOfRegistration][];
            int[] namespaceArr = new int[nbOfRegistration];
            int[] payloadTypeArr = new int[nbOfRegistration];
            int[] qosFlagsArr = new int[nbOfRegistration];
            int[] timeoutArr = new int[nbOfRegistration];
            int[] dbchangeOpFilterArr = new int[nbOfRegistration];
            int[] dbchangeTxnLagArr = new int[nbOfRegistration];
            int[] dbchangeRegistrationIdArr = new int[nbOfRegistration];
            boolean forceFindPort = false;
            if (tcpport == 0) {
                forceFindPort = true;
                tcpport = 47632;
            }
            int[] tcpportArr = new int[]{tcpport};
            boolean isNewClient = PhysicalConnection.ntfManager.listenOnPortT4C(tcpportArr, forceFindPort);
            tcpport = tcpportArr[0];
            for (int i3 = 0; i3 < nbOfRegistration; ++i3) {
                jdbcRegIdArr[i3] = PhysicalConnection.ntfManager.getNextJdbcRegId();
                contextArr[i3] = new byte[4];
                contextArr[i3][0] = (byte)((jdbcRegIdArr[i3] & 0xFF000000) >> 24);
                contextArr[i3][1] = (byte)((jdbcRegIdArr[i3] & 0xFF0000) >> 16);
                contextArr[i3][2] = (byte)((jdbcRegIdArr[i3] & 0xFF00) >> 8);
                contextArr[i3][3] = (byte)(jdbcRegIdArr[i3] & 0xFF);
                namespaceArr[i3] = 1;
                payloadTypeArr[i3] = 23;
                if (options.length <= i3 || options[i3] == null) continue;
                if (options[i3].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                    int n2 = i3;
                    qosFlagsArr[n2] = qosFlagsArr[n2] | 1;
                }
                if (options[i3].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                    int n3 = i3;
                    qosFlagsArr[n3] = qosFlagsArr[n3] | 0x10;
                }
                if (options[i3].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0) {
                    int n4 = i3;
                    qosFlagsArr[n4] = qosFlagsArr[n4] | 2;
                }
                timeoutArr[i3] = this.readNTFtimeout(options[i3]);
            }
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + dcnhost + ")(PORT=" + tcpport + "))?PR=0";
            try {
                try {
                    int mod = isNewClient ? 1 : 0;
                    this.sendPiggyBackedMessages();
                    this.okpn.marshal(1, mod, this.userName, location, nbOfRegistration, namespaceArr, name, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr);
                    this.okpn.receive();
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            catch (SQLException generalEx) {
                if (isNewClient) {
                    PhysicalConnection.ntfManager.cleanListenersT4C(tcpport);
                }
                throw generalEx;
            }
            NTFAQRegistration[] registrations = new NTFAQRegistration[nbOfRegistration];
            for (i2 = 0; i2 < nbOfRegistration; ++i2) {
                registrations[i2] = new NTFAQRegistration(jdbcRegIdArr[i2], true, this.instanceName, this.userName, dcnhost, tcpport, options[i2], name[i2], this.databaseVersion);
            }
            for (i2 = 0; i2 < registrations.length; ++i2) {
                PhysicalConnection.ntfManager.addRegistration(registrations[i2]);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + registrations);
                OracleLog.recursiveTrace = false;
            }
            NTFAQRegistration[] nTFAQRegistrationArray = registrations;
            return nTFAQRegistrationArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doUnregisterAQNotification(NTFAQRegistration registration) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registration));
                OracleLog.recursiveTrace = false;
            }
            String host = registration.getClientHost();
            int port = registration.getClientTCPPort();
            if (host == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            PhysicalConnection.ntfManager.removeRegistration(registration);
            PhysicalConnection.ntfManager.freeJdbcRegId(registration.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(registration.getClientTCPPort());
            registration.setState(NotificationRegistration.RegistrationState.CLOSED);
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))?PR=0";
            int[] namespaceArr = new int[]{1};
            String[] registeredAgentNameArr = new String[]{registration.getQueueName()};
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{0};
            int[] dbchangeTxnLagArr = new int[]{0};
            int[] dbchangeRegistrationIdArr = new int[]{0};
            byte[][] contextArr = new byte[1][];
            int jdbcRegIdArr = registration.getJdbcRegId();
            contextArr[0] = new byte[4];
            contextArr[0][0] = (byte)((jdbcRegIdArr & 0xFF000000) >> 24);
            contextArr[0][1] = (byte)((jdbcRegIdArr & 0xFF0000) >> 16);
            contextArr[0][2] = (byte)((jdbcRegIdArr & 0xFF00) >> 8);
            contextArr[0][3] = (byte)(jdbcRegIdArr & 0xFF);
            try {
                this.sendPiggyBackedMessages();
                this.okpn.marshal(2, 0, this.userName, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr);
                this.okpn.receive();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized NTFDCNRegistration doRegisterDatabaseChangeNotification(String dcnhost, int tcpport, Properties options, int kpdnrtmout, int kpdcntxl) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options) + ", " + OracleLog.argument(kpdnrtmout) + ", " + OracleLog.argument(kpdcntxl));
                OracleLog.recursiveTrace = false;
            }
            int kpdcnflg = 0;
            int kpdnrqos = 0;
            boolean forceFindPort = false;
            if (tcpport == 0) {
                forceFindPort = true;
                tcpport = 47632;
            }
            int[] tcpportArr = new int[]{tcpport};
            boolean isNewClient = PhysicalConnection.ntfManager.listenOnPortT4C(tcpportArr, forceFindPort);
            tcpport = tcpportArr[0];
            if (options.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                kpdnrqos |= 1;
            }
            if (options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                kpdnrqos |= 0x10;
            }
            if (options.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0) {
                kpdcnflg |= 0x10;
            }
            if (options.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0) {
                kpdcnflg |= 0x20;
            }
            if (options.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0) {
                kpdcnflg |= 0x40;
            }
            boolean ignoreInsert = false;
            boolean ignoreUpdate = false;
            boolean ignoreDelete = false;
            if (options.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0) {
                ignoreInsert = true;
            }
            if (options.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0) {
                ignoreUpdate = true;
            }
            if (options.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0) {
                ignoreDelete = true;
            }
            if (ignoreInsert || ignoreUpdate || ignoreDelete) {
                kpdcnflg |= 0xF;
                if (ignoreInsert) {
                    kpdcnflg -= 2;
                }
                if (ignoreUpdate) {
                    kpdcnflg -= 4;
                }
                if (ignoreDelete) {
                    kpdcnflg -= 8;
                }
            }
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + dcnhost + ")(PORT=" + tcpport + "))?PR=0";
            int[] namespaceArr = new int[]{2};
            String[] registeredAgentNameArr = new String[1];
            int[] payloadTypeArr = new int[]{23};
            int[] qosFlagsArr = new int[]{kpdnrqos};
            int[] timeoutArr = new int[]{kpdnrtmout};
            int[] dbchangeOpFilterArr = new int[]{kpdcnflg};
            int[] dbchangeTxnLagArr = new int[]{kpdcntxl};
            int[] dbchangeRegistrationIdArr = new int[]{0};
            int jdbcRegId = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byte[][] contextArr = new byte[][]{new byte[4]};
            contextArr[0][0] = (byte)((jdbcRegId & 0xFF000000) >> 24);
            contextArr[0][1] = (byte)((jdbcRegId & 0xFF0000) >> 16);
            contextArr[0][2] = (byte)((jdbcRegId & 0xFF00) >> 8);
            contextArr[0][3] = (byte)(jdbcRegId & 0xFF);
            int regid = 0;
            try {
                try {
                    int mod = isNewClient ? 1 : 0;
                    this.sendPiggyBackedMessages();
                    this.okpn.marshal(1, mod, this.userName, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr);
                    regid = this.okpn.receive();
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
            }
            catch (SQLException generalEx) {
                if (isNewClient) {
                    PhysicalConnection.ntfManager.cleanListenersT4C(tcpport);
                }
                throw generalEx;
            }
            NTFDCNRegistration registration = new NTFDCNRegistration(jdbcRegId, true, this.instanceName, regid, this.userName, dcnhost, tcpport, options, this.databaseVersion);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + registration);
                OracleLog.recursiveTrace = false;
            }
            NTFDCNRegistration nTFDCNRegistration = registration;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doUnregisterDatabaseChangeNotification(int registrationId, String host, int port) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registrationId) + ", " + OracleLog.argument(host) + ", " + OracleLog.argument(port));
                OracleLog.recursiveTrace = false;
            }
            if (host == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))?PR=0";
            int[] namespaceArr = new int[]{2};
            String[] registeredAgentNameArr = new String[1];
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{0};
            int[] dbchangeTxnLagArr = new int[]{0};
            int[] dbchangeRegistrationIdArr = new int[]{registrationId};
            byte[][] contextArr = new byte[1][];
            try {
                this.sendPiggyBackedMessages();
                this.okpn.marshal(2, 0, null, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr);
                this.okpn.receive();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doUnregisterDatabaseChangeNotification(NTFDCNRegistration dcnregistration) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dcnregistration));
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection.ntfManager.removeRegistration(dcnregistration);
            PhysicalConnection.ntfManager.freeJdbcRegId(dcnregistration.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(dcnregistration.getClientTCPPort());
            dcnregistration.setState(NotificationRegistration.RegistrationState.CLOSED);
            this.doUnregisterDatabaseChangeNotification(dcnregistration.getRegistrationId(), dcnregistration.getClientHost(), dcnregistration.getClientTCPPort());
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] createLightweightUserSession(String userName, KeywordValue[] inKeyVal, int inFlags, KeywordValue[][] outKeyVal, int[] outFlags) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                OracleLog.recursiveTrace = false;
            }
            if (outKeyVal.length != 1 || outFlags.length != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            byte[] ret = null;
            try {
                this.sendPiggyBackedMessages();
                this.oxsscs.marshal(userName, inKeyVal, inFlags);
                byte[][] sessionId = new byte[1][];
                this.oxsscs.receive(sessionId, outKeyVal, outFlags);
                ret = sessionId[0];
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void executeLightweightUserSessionFunction(int functionId, byte[] sessionId, KeywordValue[] inKeyVal, int inFlags, KeywordValue[][] outKeyVal, int[] outFlags) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                OracleLog.recursiveTrace = false;
            }
            if (outKeyVal.length != 1 || outFlags.length != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            try {
                this.sendPiggyBackedMessages();
                this.oxssso.marshal(functionId, sessionId, inKeyVal, inFlags);
                this.oxssso.receive(outKeyVal, outFlags);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void executeLightweightUserSessionAttributeFunction(int functionId, byte[] sessionId, String namespace, String attributeName, KeywordValue[] inKeyVal, int inFlags) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(namespace) + ", " + OracleLog.argument(attributeName) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags));
                OracleLog.recursiveTrace = false;
            }
            if (this.lusOffset == this.lusFunctionId.length) {
                int currentLength = this.lusFunctionId.length;
                int[] lusFunctionId2 = new int[currentLength * 2];
                System.arraycopy(this.lusFunctionId, 0, lusFunctionId2, 0, currentLength);
                byte[][] lusSessionId2 = new byte[currentLength * 2][];
                System.arraycopy(this.lusSessionId, 0, lusSessionId2, 0, currentLength);
                String[] lusNamespace2 = new String[currentLength * 2];
                System.arraycopy(this.lusNamespace, 0, lusNamespace2, 0, currentLength);
                String[] lusAttributeName2 = new String[currentLength * 2];
                System.arraycopy(this.lusAttributeName, 0, lusAttributeName2, 0, currentLength);
                KeywordValue[][] lusInKeyVal2 = new KeywordValue[currentLength * 2][];
                System.arraycopy(this.lusInKeyVal, 0, lusInKeyVal2, 0, currentLength);
                int[] lusInFlags2 = new int[currentLength * 2];
                System.arraycopy(this.lusInFlags, 0, lusInFlags2, 0, currentLength);
                this.lusFunctionId = lusFunctionId2;
                this.lusSessionId = lusSessionId2;
                this.lusNamespace = lusNamespace2;
                this.lusAttributeName = lusAttributeName2;
                this.lusInKeyVal = lusInKeyVal2;
                this.lusInFlags = lusInFlags2;
            }
            this.lusFunctionId[this.lusOffset] = functionId;
            this.lusSessionId[this.lusOffset] = sessionId;
            this.lusNamespace[this.lusOffset] = namespace;
            this.lusAttributeName[this.lusOffset] = attributeName;
            this.lusInKeyVal[this.lusOffset] = inKeyVal;
            this.lusInFlags[this.lusOffset] = inFlags;
            ++this.lusOffset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.net.getDataIntegrityName());
                OracleLog.recursiveTrace = false;
            }
            String string = this.net.getDataIntegrityName();
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.net.getEncryptionName());
                OracleLog.recursiveTrace = false;
            }
            String string = this.net.getEncryptionName();
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "return: " + this.net.getAuthenticationAdaptorName());
                OracleLog.recursiveTrace = false;
            }
            String string = this.net.getAuthenticationAdaptorName();
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    void validateConnectionProperties() throws SQLException {
        super.validateConnectionProperties();
        String pattern = ".*[\\00\\(\\)].*";
        if (this.thinVsessionOsuser != null && (this.thinVsessionOsuser.matches(pattern) || this.thinVsessionOsuser.length() > 30)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'");
        }
        if (this.thinVsessionTerminal != null && (this.thinVsessionTerminal.matches(pattern) || this.thinVsessionTerminal.length() > 30)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'");
        }
        if (this.thinVsessionMachine != null && (this.thinVsessionMachine.matches(pattern) || this.thinVsessionMachine.length() > 64)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'");
        }
        if (this.thinVsessionProgram != null && (this.thinVsessionProgram.matches(pattern) || this.thinVsessionProgram.length() > 48)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'");
        }
        if (this.thinVsessionProcess != null && (this.thinVsessionProcess.matches(pattern) || this.thinVsessionProcess.length() > 24)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'");
        }
        if (this.thinVsessionIname != null && this.thinVsessionIname.matches(pattern)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'");
        }
        if (this.thinVsessionEname != null && this.thinVsessionEname.matches(pattern)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 190, "Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'");
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

