/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short versionNumber = (short)-1;
    short databaseVersion = (short)-1;
    byte proSvrVer;
    boolean sentCancel = false;
    static final int FREE = -1;
    static final int SEND = 1;
    static final int RECEIVE = 2;
    int pipeState = -1;
    InputStream inStream;
    OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final int[] retLen = new int[1];
    AtomicReference<OracleConnection> connForException = new AtomicReference();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:33_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    static String toHex(long value, int bytes) {
        String result;
        switch (bytes) {
            case 1: {
                result = "00" + Long.toString(value & 0xFFL, 16);
                break;
            }
            case 2: {
                result = "0000" + Long.toString(value & 0xFFFFL, 16);
                break;
            }
            case 3: {
                result = "000000" + Long.toString(value & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                result = "00000000" + Long.toString(value & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                result = "0000000000" + Long.toString(value & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                result = "000000000000" + Long.toString(value & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                result = "00000000000000" + Long.toString(value & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(value >> 32, 4) + T4CMAREngine.toHex(value, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + result.substring(result.length() - 2 * bytes);
    }

    static String toHex(byte value) {
        String result = "00" + Integer.toHexString(value & 0xFF);
        return "0x" + result.substring(result.length() - 2);
    }

    static String toHex(short value) {
        return T4CMAREngine.toHex(value, 2);
    }

    static String toHex(int value) {
        return T4CMAREngine.toHex(value, 4);
    }

    static String toHex(byte[] value, int length) {
        if (value == null) {
            return "null";
        }
        if (length > value.length) {
            return "byte array not long enough";
        }
        String result = "[";
        int len = Math.min(64, length);
        for (int i2 = 0; i2 < len; ++i2) {
            result = result + T4CMAREngine.toHex(value[i2]) + " ";
        }
        if (len < length) {
            result = result + "...";
        }
        return result + "]";
    }

    static String toHex(byte[] value) {
        if (value == null) {
            return "null";
        }
        return T4CMAREngine.toHex(value, value.length);
    }

    T4CMAREngine(Communication net) throws SQLException, IOException {
        if (net == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 433");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 433);
        }
        this.net = net;
        try {
            this.inStream = net.getInputStream();
            this.outStream = net.getOutputStream();
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        this.types = new T4CTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    void marshalSB1(byte value) throws IOException {
        this.outStream.write(value);
    }

    void marshalUB1(short value) throws IOException {
        this.outStream.write((byte)(value & 0xFF));
    }

    void marshalSB2(short value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer2, (byte)1);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer2, 0, bytes);
        }
    }

    void marshalUB2(int value) throws IOException {
        this.marshalSB2((short)(value & 0xFFFF));
    }

    void marshalSB4(int value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)2);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer4, 0, bytes);
        }
    }

    void marshalUB4(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalSB8(long value) throws IOException {
        byte bytes = this.value2Buffer(value, this.tmpBuffer8, (byte)3);
        if (bytes != 0) {
            this.outStream.write(this.tmpBuffer8, 0, bytes);
        }
    }

    void marshalSWORD(int value) throws IOException {
        this.marshalSB4(value);
    }

    void marshalUWORD(long value) throws IOException {
        this.marshalSB4((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalB1Array(byte[] value) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value);
        }
    }

    void marshalB1Array(byte[] value, int off, int len) throws IOException {
        if (value.length > 0) {
            this.outStream.write(value, off, len);
        }
    }

    void marshalUB4Array(long[] value) throws IOException {
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.marshalSB4((int)(value[i2] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    void marshalO2U(boolean notnull) throws IOException {
        if (notnull) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    void marshalCHR(byte[] value) throws IOException {
        this.marshalCHR(value, 0, value.length);
    }

    void marshalCHR(byte[] value, int offset, int length) throws IOException {
        if (length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(value, offset, length);
            } else {
                this.outStream.write(value, offset, length);
            }
        }
    }

    void marshalCLR(byte[] value, int valueLen) throws IOException {
        this.marshalCLR(value, 0, valueLen);
    }

    void marshalCLR(byte[] value, int offset, int valueLen) throws IOException {
        if (valueLen > 64) {
            int len;
            int nbBytesWritten = 0;
            this.outStream.write(-2);
            do {
                int bytesLeft;
                len = (bytesLeft = valueLen - nbBytesWritten) > 64 ? 64 : bytesLeft;
                this.outStream.write((byte)(len & 0xFF));
                this.outStream.write(value, offset + nbBytesWritten, len);
            } while ((nbBytesWritten += len) < valueLen);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(valueLen & 0xFF));
            if (value.length != 0) {
                this.outStream.write(value, offset, valueLen);
            }
        }
    }

    void marshalKEYVAL(byte[][] keys, int[] keysSize, byte[][] values, int[] valuesSize, byte[] kvalflg, int nb) throws SQLException, IOException {
        for (int i2 = 0; i2 < nb; ++i2) {
            if (keys[i2] != null && keysSize[i2] > 0) {
                this.marshalUB4(keysSize[i2]);
                this.marshalCLR(keys[i2], 0, keysSize[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (values[i2] != null && valuesSize[i2] > 0) {
                this.marshalUB4(valuesSize[i2]);
                this.marshalCLR(values[i2], 0, valuesSize[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (kvalflg[i2] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    void marshalKEYVAL(byte[][] keys, byte[][] values, byte[] kvalflg, int nb) throws SQLException, IOException {
        int[] keysSize = new int[nb];
        int[] valuesSize = new int[nb];
        for (int i2 = 0; i2 < nb; ++i2) {
            if (keys[i2] != null) {
                keysSize[i2] = keys[i2].length;
            }
            if (values[i2] == null) continue;
            valuesSize[i2] = values[i2].length;
        }
        this.marshalKEYVAL(keys, keysSize, values, valuesSize, kvalflg, nb);
    }

    void marshalDALC(byte[] buffer) throws SQLException, IOException {
        if (buffer == null || buffer.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & buffer.length);
            this.marshalCLR(buffer, buffer.length);
        }
    }

    void marshalKPDKV(byte[][] textValues, byte[][] binaryValues, int[] keywords) throws SQLException, IOException {
        for (int i2 = 0; i2 < textValues.length; ++i2) {
            if (textValues[i2] != null) {
                this.marshalUB4(textValues[i2].length);
                this.marshalCLR(textValues[i2], 0, textValues[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            if (binaryValues[i2] != null) {
                this.marshalUB4(binaryValues[i2].length);
                this.marshalCLR(binaryValues[i2], 0, binaryValues[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            this.marshalUB2(keywords[i2]);
        }
    }

    void unmarshalKPDKV(byte[][] textValues, int[] textValuesLength, byte[][] binaryValues, int[] keywords) throws SQLException, IOException {
        int tempLength = 0;
        int[] tempAr = new int[1];
        for (int i2 = 0; i2 < textValues.length; ++i2) {
            tempLength = (int)this.unmarshalUB4();
            if (tempLength > 0) {
                textValues[i2] = new byte[tempLength];
                this.unmarshalCLR(textValues[i2], 0, tempAr, tempLength);
                textValuesLength[i2] = tempAr[0];
            }
            if ((tempLength = (int)this.unmarshalUB4()) > 0) {
                binaryValues[i2] = new byte[tempLength];
                this.unmarshalCLR(binaryValues[i2], 0, tempAr, tempLength);
            }
            keywords[i2] = this.unmarshalUB2();
        }
    }

    void addPtr(byte value) throws IOException {
        if ((this.types.rep[4] & 1) > 0) {
            this.outStream.write(value);
        } else {
            byte bytes = this.value2Buffer(value, this.tmpBuffer4, (byte)4);
            if (bytes != 0) {
                this.outStream.write(this.tmpBuffer4, 0, bytes);
            }
        }
    }

    byte value2Buffer(int value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean zeros = true;
        byte bytes = 0;
        for (int i2 = outBuffer.length - 1; i2 >= 0; --i2) {
            outBuffer[bytes] = (byte)(value >>> 8 * i2 & 0xFF);
            if ((this.types.rep[repOffset] & 1) > 0) {
                if (zeros && outBuffer[bytes] == 0) continue;
                zeros = false;
                bytes = (byte)(bytes + 1);
                continue;
            }
            bytes = (byte)(bytes + 1);
        }
        if ((this.types.rep[repOffset] & 1) > 0) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    byte value2Buffer(long value, byte[] outBuffer, byte repOffset) throws IOException {
        boolean zeros = true;
        byte bytes = 0;
        for (int i2 = outBuffer.length - 1; i2 >= 0; --i2) {
            outBuffer[bytes] = (byte)(value >>> 8 * i2 & 0xFFL);
            if ((this.types.rep[repOffset] & 1) > 0) {
                if (zeros && outBuffer[bytes] == 0) continue;
                zeros = false;
                bytes = (byte)(bytes + 1);
                continue;
            }
            bytes = (byte)(bytes + 1);
        }
        if ((this.types.rep[repOffset] & 1) > 0) {
            this.outStream.write(bytes);
        }
        if ((this.types.rep[repOffset] & 2) > 0) {
            this.reverseArray(outBuffer, bytes);
        }
        return bytes;
    }

    void reverseArray(byte[] buffer, byte bytes) {
        for (int i2 = 0; i2 < bytes / 2; ++i2) {
            byte tmp = buffer[i2];
            buffer[i2] = buffer[bytes - 1 - i2];
            buffer[bytes - 1 - i2] = tmp;
        }
    }

    byte unmarshalSB1() throws SQLException, IOException {
        byte result = (byte)this.unmarshalUB1();
        return result;
    }

    short unmarshalUB1() throws SQLException, IOException {
        short value = 0;
        try {
            this.pipeState = 2;
            value = (short)this.inStream.read();
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        finally {
            this.pipeState = -1;
        }
        if (value < 0) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
        }
        return value;
    }

    short unmarshalSB2() throws SQLException, IOException {
        short result = (short)this.unmarshalUB2();
        return result;
    }

    int unmarshalUB2() throws SQLException, IOException {
        int value = (int)this.buffer2Value((byte)1);
        return value & 0xFFFF;
    }

    int unmarshalUCS2(byte[] ucs2Char, long offset) throws SQLException, IOException {
        int value = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((value & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(value & 0xFF);
        if (offset + 1L < (long)ucs2Char.length) {
            ucs2Char[(int)offset] = this.tmpBuffer2[0];
            ucs2Char[(int)offset + 1] = this.tmpBuffer2[1];
        } else {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 438");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 438);
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    int unmarshalSB4() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    long unmarshalUB4() throws SQLException, IOException {
        long value = this.buffer2Value((byte)2);
        return value;
    }

    int unmarshalSB4(byte[] buffer) throws SQLException, IOException {
        long value = this.buffer2Value((byte)2, new ByteArrayInputStream(buffer));
        return (int)value;
    }

    long unmarshalSB8() throws SQLException, IOException {
        long value = this.buffer2Value((byte)3);
        return value;
    }

    int unmarshalRefCursor(byte[] buffer) throws SQLException, IOException {
        int result = this.unmarshalSB4(buffer);
        return result;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int result = (int)this.unmarshalUB4();
        return result;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long result = this.unmarshalUB4();
        return result;
    }

    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n2];
        if (n2 > 0) {
            try {
                this.pipeState = 2;
                if (this.inStream.read(tmpBuffer) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
                }
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
            finally {
                this.pipeState = -1;
            }
        }
        return tmpBuffer;
    }

    int unmarshalNBytes(byte[] buf, int off, int n2) throws SQLException, IOException {
        int bytes;
        for (bytes = 0; bytes < n2; bytes += this.getNBytes(buf, off + bytes, n2 - bytes)) {
        }
        return bytes;
    }

    int getNBytes(byte[] buf, int off, int len) throws SQLException, IOException {
        int cnt = 0;
        try {
            this.pipeState = 2;
            cnt = this.inStream.read(buf, off, len);
            if (cnt < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        finally {
            this.pipeState = -1;
        }
        return cnt;
    }

    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n2];
        try {
            this.pipeState = 2;
            if (this.inStream.read(tmpBuffer) < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
        }
        catch (BreakNetException e2) {
            this.net.sendReset();
            throw e2;
        }
        finally {
            this.pipeState = -1;
        }
        return tmpBuffer;
    }

    byte[] unmarshalTEXT(int bytes) throws SQLException, IOException {
        byte[] buffer;
        int offset = 0;
        byte[] tmpBuffer = new byte[bytes];
        while (offset < bytes) {
            try {
                this.pipeState = 2;
                if (this.inStream.read(tmpBuffer, offset, 1) < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
                }
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
            finally {
                this.pipeState = -1;
            }
            if (tmpBuffer[offset++] != 0) continue;
        }
        if (tmpBuffer.length == --offset) {
            buffer = tmpBuffer;
        } else {
            buffer = new byte[offset];
            System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
        }
        return buffer;
    }

    byte[] unmarshalCHR(int retLength) throws SQLException, IOException {
        byte[] resBuffer = null;
        if (this.types.isConvNeeded()) {
            resBuffer = this.unmarshalCLR(retLength, this.retLen);
            if (resBuffer.length != this.retLen[0]) {
                byte[] tmpBuf = new byte[this.retLen[0]];
                System.arraycopy(resBuffer, 0, tmpBuf, 0, this.retLen[0]);
                resBuffer = tmpBuf;
            }
        } else {
            resBuffer = this.getNBytes(retLength);
        }
        return resBuffer;
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize) throws SQLException, IOException {
        this.unmarshalCLR(bytes, offsetRow, intArray, maxSize, 0);
    }

    void unmarshalCLR(byte[] bytes, int offsetRow, int[] intArray, int maxSize, int ignoreNBytes) throws SQLException, IOException {
        int nbBytesWritten;
        int offset;
        block24: {
            int lastread;
            int nbOfBytesIgnored;
            int keepThem;
            boolean optimized;
            int locallen;
            int len;
            block23: {
                len = 0;
                locallen = 0;
                offset = offsetRow;
                optimized = false;
                nbBytesWritten = 0;
                keepThem = 0;
                nbOfBytesIgnored = 0;
                lastread = -1;
                len = this.unmarshalUB1();
                if (len < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                }
                if (len == 0) {
                    intArray[0] = 0;
                    return;
                }
                if (this.escapeSequenceNull(len)) {
                    intArray[0] = 0;
                    return;
                }
                if (len == 254) break block23;
                if (ignoreNBytes - nbOfBytesIgnored >= len) {
                    this.unmarshalBuffer(this.ignored, 0, len);
                    nbOfBytesIgnored += len;
                    len = 0;
                } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                    this.unmarshalBuffer(this.ignored, 0, ignoreNBytes - nbOfBytesIgnored);
                    len -= ignoreNBytes - nbOfBytesIgnored;
                    nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                }
                if (len <= 0) break block24;
                keepThem = Math.min(maxSize - nbBytesWritten, len);
                offset = this.unmarshalBuffer(bytes, offset, keepThem);
                nbBytesWritten += keepThem;
                int rest = len - keepThem;
                if (rest <= 0) break block24;
                this.unmarshalBuffer(this.ignored, 0, rest);
                break block24;
            }
            lastread = -1;
            block5: while (lastread == -1 || (len = this.unmarshalUB1()) > 0) {
                if (len == 254) {
                    switch (lastread) {
                        case -1: {
                            lastread = 1;
                            continue block5;
                        }
                        case 1: {
                            lastread = 0;
                            break;
                        }
                        case 0: {
                            if (optimized) {
                                lastread = 0;
                                break;
                            }
                            lastread = 0;
                            continue block5;
                        }
                    }
                }
                if (offset == -1) {
                    this.unmarshalBuffer(this.ignored, 0, len);
                } else {
                    locallen = len;
                    if (ignoreNBytes - nbOfBytesIgnored >= locallen) {
                        this.unmarshalBuffer(this.ignored, 0, locallen);
                        nbOfBytesIgnored += locallen;
                        locallen = 0;
                    } else if (ignoreNBytes - nbOfBytesIgnored > 0) {
                        this.unmarshalBuffer(this.ignored, 0, ignoreNBytes - nbOfBytesIgnored);
                        locallen -= ignoreNBytes - nbOfBytesIgnored;
                        nbOfBytesIgnored += ignoreNBytes - nbOfBytesIgnored;
                    }
                    if (locallen > 0) {
                        keepThem = Math.min(maxSize - nbBytesWritten, locallen);
                        offset = this.unmarshalBuffer(bytes, offset, keepThem);
                        nbBytesWritten += keepThem;
                        int rest = locallen - keepThem;
                        if (rest > 0) {
                            this.unmarshalBuffer(this.ignored, 0, rest);
                        }
                    }
                }
                lastread = 0;
                if (len <= 252) continue;
                optimized = true;
            }
        }
        if (intArray != null) {
            intArray[0] = offset != -1 ? nbBytesWritten : bytes.length - offsetRow;
        }
    }

    byte[] unmarshalCLR(int buflen, int[] intArray) throws SQLException, IOException {
        byte[] tmpBuf = new byte[buflen * this.conv.c2sNlsRatio];
        this.unmarshalCLR(tmpBuf, 0, intArray, buflen);
        return tmpBuf;
    }

    int[] unmarshalKEYVAL(byte[][] keys, byte[][] values, int nb) throws SQLException, IOException {
        byte[] buff = new byte[1000];
        int[] length = new int[1];
        int[] kvalflg = new int[nb];
        for (int i2 = 0; i2 < nb; ++i2) {
            int len = this.unmarshalSB4();
            if (len > 0) {
                this.unmarshalCLR(buff, 0, length);
                keys[i2] = new byte[length[0]];
                System.arraycopy(buff, 0, keys[i2], 0, length[0]);
            }
            if ((len = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(buff, 0, length);
                values[i2] = new byte[length[0]];
                System.arraycopy(buff, 0, values[i2], 0, length[0]);
            }
            kvalflg[i2] = this.unmarshalSB4();
        }
        buff = null;
        return kvalflg;
    }

    int unmarshalBuffer(byte[] _byteValue, int offset, int len) throws SQLException, IOException {
        if (len <= 0) {
            return offset;
        }
        if (_byteValue.length < offset + len) {
            this.unmarshalNBytes(_byteValue, offset, _byteValue.length - offset);
            this.unmarshalNBytes(this.ignored, 0, offset + len - _byteValue.length);
            offset = -1;
        } else {
            this.unmarshalNBytes(_byteValue, offset, len);
            offset += len;
        }
        return offset;
    }

    byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short len = 0;
        short totalLen = 0;
        byte[] finalBuffer = null;
        Vector<byte[]> refVector = new Vector<byte[]>(10, 10);
        short bytes = this.unmarshalUB1();
        if (bytes < 0) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
        }
        if (bytes == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(bytes)) {
            byte[] tmpBuf;
            if (bytes == 254) {
                while ((len = this.unmarshalUB1()) > 0) {
                    if (len == 254 && this.types.isServerConversion()) continue;
                    totalLen = (short)(totalLen + len);
                    tmpBuf = new byte[len];
                    this.unmarshalBuffer(tmpBuf, 0, len);
                    refVector.addElement(tmpBuf);
                }
            } else {
                totalLen = bytes;
                tmpBuf = new byte[bytes];
                this.unmarshalBuffer(tmpBuf, 0, bytes);
                refVector.addElement(tmpBuf);
            }
            finalBuffer = new byte[totalLen];
            int start = 0;
            while (refVector.size() > 0) {
                int arrayLen = ((byte[])refVector.elementAt(0)).length;
                System.arraycopy(refVector.elementAt(0), 0, finalBuffer, start, arrayLen);
                start += arrayLen;
                refVector.removeElementAt(0);
            }
        } else {
            finalBuffer = null;
        }
        return finalBuffer;
    }

    boolean escapeSequenceNull(int bytes) throws SQLException {
        boolean is_null = false;
        switch (bytes) {
            case 0: {
                is_null = true;
                break;
            }
            case 253: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
            case 255: {
                is_null = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return is_null;
    }

    int processIndicator(boolean isNull, int dataSize) throws SQLException, IOException {
        short ind = this.unmarshalSB2();
        int res = 0;
        if (!isNull) {
            res = ind == 0 ? dataSize : (ind == -2 || ind > 0 ? (int)ind : 65536 + ind);
        }
        return res;
    }

    long unmarshalDALC(byte[] buffer, int offset, int[] returnLength) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        if (len > 0L) {
            this.unmarshalCLR(buffer, offset, returnLength);
        }
        return len;
    }

    byte[] unmarshalDALC() throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, this.retLen)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    byte[] unmarshalDALC(int[] CLRRetLen) throws SQLException, IOException {
        long len = this.unmarshalUB4();
        byte[] buffer = new byte[(int)(0xFFFFFFFFFFFFFFFFL & len)];
        if (buffer.length > 0) {
            if ((buffer = this.unmarshalCLR(buffer.length, CLRRetLen)) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
        } else {
            buffer = new byte[]{};
        }
        return buffer;
    }

    long buffer2Value(byte repOffset) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            try {
                this.pipeState = 2;
                bufLength = this.inStream.read();
            }
            catch (BreakNetException e2) {
                this.net.sendReset();
                throw e2;
            }
            finally {
                this.pipeState = -1;
            }
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4 || repOffset == 3 && bufLength > 8) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 412");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 412);
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        } else if (repOffset == 3) {
            bufLength = 8;
        }
        switch (bufLength) {
            case 1: {
                tmpBuffer = this.tmpBuffer1;
                break;
            }
            case 2: {
                tmpBuffer = this.tmpBuffer2;
                break;
            }
            case 3: {
                tmpBuffer = this.tmpBuffer3;
                break;
            }
            case 4: {
                tmpBuffer = this.tmpBuffer4;
                break;
            }
            case 5: {
                tmpBuffer = this.tmpBuffer5;
                break;
            }
            case 6: {
                tmpBuffer = this.tmpBuffer6;
                break;
            }
            case 7: {
                tmpBuffer = this.tmpBuffer7;
                break;
            }
            case 8: {
                tmpBuffer = this.tmpBuffer8;
                break;
            }
            default: {
                tmpBuffer = new byte[bufLength];
            }
        }
        try {
            this.pipeState = 2;
            if (this.inStream.read(tmpBuffer) < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
        }
        catch (BreakNetException e3) {
            this.net.sendReset();
            throw e3;
        }
        finally {
            this.pipeState = -1;
        }
        for (int i2 = 0; i2 < tmpBuffer.length; ++i2) {
            long tmpLong = (this.types.rep[repOffset] & 2) > 0 ? (long)(tmpBuffer[tmpBuffer.length - 1 - i2] & 0xFF) & 0xFFL : (long)(tmpBuffer[i2] & 0xFF) & 0xFFL;
            value |= tmpLong << 8 * (tmpBuffer.length - 1 - i2);
        }
        if (repOffset != 3) {
            value &= 0xFFFFFFFFFFFFFFFFL;
        }
        if (negative) {
            value = -value;
        }
        return value;
    }

    long buffer2Value(byte repOffset, ByteArrayInputStream in) throws SQLException, IOException {
        byte[] tmpBuffer;
        int bufLength = 0;
        long value = 0L;
        boolean negative = false;
        if ((this.types.rep[repOffset] & 1) > 0) {
            bufLength = in.read();
            if ((bufLength & 0x80) > 0) {
                bufLength &= 0x7F;
                negative = true;
            }
            if (bufLength < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
            if (bufLength == 0) {
                return 0L;
            }
            if (repOffset == 1 && bufLength > 2 || repOffset == 2 && bufLength > 4) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 412");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 412);
            }
        } else if (repOffset == 1) {
            bufLength = 2;
        } else if (repOffset == 2) {
            bufLength = 4;
        }
        if (in.read(tmpBuffer = new byte[bufLength]) < 0) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(Level.SEVERE, "Throwing SQLException: 410");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
        }
        for (int i2 = 0; i2 < tmpBuffer.length; ++i2) {
            short tmpByte = (this.types.rep[repOffset] & 2) > 0 ? (short)(tmpBuffer[tmpBuffer.length - 1 - i2] & 0xFF) : (short)(tmpBuffer[i2] & 0xFF);
            value |= (long)(tmpByte << 8 * (tmpBuffer.length - 1 - i2));
        }
        value &= 0xFFFFFFFFFFFFFFFFL;
        if (negative) {
            value = -value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(OracleLog.TRACE_16, "return: " + this.connForException.get());
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = this.connForException.get();
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionDuringExceptionHandling(OracleConnection conn) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.connForException.set(conn);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CMAREngine.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CMAREngine"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

