/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4CTTIOtxen
extends T4CTTIfun {
    static final int OTXCOMIT = 1;
    static final int OTXABORT = 2;
    static final int OTXPREPA = 3;
    static final int OTXFORGT = 4;
    static final int OTXRECOV = 5;
    static final int OTXMLPRE = 6;
    static final int K2CMDprepare = 0;
    static final int K2CMDrqcommit = 1;
    static final int K2CMDcommit = 2;
    static final int K2CMDabort = 3;
    static final int K2CMDrdonly = 4;
    static final int K2CMDforget = 5;
    static final int K2CMDrecovered = 7;
    static final int K2CMDtimeout = 8;
    static final int K2STAidle = 0;
    static final int K2STAcollecting = 1;
    static final int K2STAprepared = 2;
    static final int K2STAcommitted = 3;
    static final int K2STAhabort = 4;
    static final int K2STAhcommit = 5;
    static final int K2STAhdamage = 6;
    static final int K2STAtimeout = 7;
    static final int K2STAinactive = 9;
    static final int K2STAactive = 10;
    static final int K2STAptprepared = 11;
    static final int K2STAptcommitted = 12;
    static final int K2STAmax = 13;
    static final int OTXNDEF_F_CWRBATCH = 1;
    static final int OTXNDEF_F_CWRBATOPT = 2;
    static final int OTXNDEF_F_CWRNOWAIT = 4;
    static final int OTXNDEF_F_CWRWATOPT = 8;
    static final int OTXNDEF_F_CWRBATMSK = 3;
    static final int OTXNDEF_F_CWRWATMSK = 12;
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:34_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIOtxen(T4CMAREngine _mrengine, T4CTTIoer _oer, T4CConnection _conn) throws SQLException {
        super((byte)3, 0, (short)104);
        this.oer = _oer;
        this.setMarshalingEngine(_mrengine);
        this.connection = _conn;
    }

    void marshal(int operation, byte[] transactionContext, byte[] xid, int formatId, int gtridLength, int bqualLength, int timeout, int inState, int txnflg) throws IOException, SQLException {
        if (operation != 1 && operation != 2 && operation != 3 && operation != 4 && operation != 5 && operation != 6) {
            throw new SQLException("Invalid operation.");
        }
        super.marshalFunHeader();
        int txnopc = operation;
        this.meg.marshalSWORD(txnopc);
        if (transactionContext == null) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        if (transactionContext == null) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(transactionContext.length);
        }
        this.meg.marshalUB4(formatId);
        this.meg.marshalUB4(gtridLength);
        this.meg.marshalUB4(bqualLength);
        if (xid != null) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (xid != null) {
            this.meg.marshalUB4(xid.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUWORD(timeout);
        this.meg.marshalUB4(inState);
        this.meg.marshalPTR();
        if (this.meg.versionNumber >= 10200) {
            this.meg.marshalUB4(txnflg);
        }
        if (transactionContext != null) {
            this.meg.marshalB1Array(transactionContext);
        }
        if (xid != null) {
            this.meg.marshalB1Array(xid);
        }
    }

    int receive(int[] errorNumber) throws IOException, SQLException {
        int outState = -1;
        errorNumber[0] = -1;
        block7: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            outState = (int)this.meg.unmarshalUB4();
                            break;
                        }
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block7;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block7;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError(false);
                            errorNumber[0] = this.oer.retCode;
                            break block7;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIOtxen.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        return outState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIOtxen.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIOtxen.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIOtxen.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIOtxen"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

