/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIiov
extends T4CTTIMsg {
    T4C8TTIrxh rxh;
    T4CTTIrxd rxd;
    byte bindtype = 0;
    byte[] iovector;
    int bindcnt = 0;
    int inbinds = 0;
    int outbinds = 0;
    static final byte BV_IN_V = 32;
    static final byte BV_OUT_V = 16;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:34_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIiov(T4CMAREngine _mrengine, T4C8TTIrxh _rxh, T4CTTIrxd _rxd) throws SQLException, IOException {
        this.setMarshalingEngine(_mrengine);
        this.rxh = _rxh;
        this.rxd = _rxd;
    }

    void init() throws SQLException, IOException {
    }

    Accessor[] processRXD(Accessor[] outBindAccessors, int number_of_bind_positions, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bindIndicatorSubRange, DBConversion conversion, byte[] tmpBindsByteArray, byte[] ioVector, InputStream[][] parameterStream, byte[][][] parameterDatum, OracleTypeADT[][] parameterOtype, OracleStatement oracleStatement, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators) throws SQLException, IOException {
        if (ioVector != null) {
            for (int i2 = 0; i2 < ioVector.length; ++i2) {
                if ((ioVector[i2] & 0x10) != 0 && (outBindAccessors == null || outBindAccessors.length <= i2 || outBindAccessors[i2] == null)) {
                    int type;
                    int subRangeOffset = bindIndicatorSubRange + 5 + 10 * i2;
                    int external_type = type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    if (type == 9) {
                        type = 1;
                    }
                    Accessor acc = oracleStatement.allocateAccessor(type, type, i2, 0, (short)0, null, false);
                    acc.rowSpaceIndicator = null;
                    if (acc.defineType == 109 || acc.defineType == 111) {
                        acc.setOffsets(1);
                    }
                    if (outBindAccessors == null) {
                        outBindAccessors = new Accessor[i2 + 1];
                        outBindAccessors[i2] = acc;
                        continue;
                    }
                    if (outBindAccessors.length <= i2) {
                        Accessor[] outBindAccessorsNew = new Accessor[i2 + 1];
                        outBindAccessorsNew[i2] = acc;
                        for (int ii = 0; ii < outBindAccessors.length; ++ii) {
                            if (outBindAccessors[ii] == null) continue;
                            outBindAccessorsNew[ii] = outBindAccessors[ii];
                        }
                        outBindAccessors = outBindAccessorsNew;
                        continue;
                    }
                    outBindAccessors[i2] = acc;
                    continue;
                }
                if ((ioVector[i2] & 0x10) != 0 || outBindAccessors == null || i2 >= outBindAccessors.length || outBindAccessors[i2] == null) continue;
                outBindAccessors[i2].isUseLess = true;
            }
        }
        return outBindAccessors;
    }

    void unmarshalV10() throws IOException, SQLException {
        this.rxh.unmarshalV10(this.rxd);
        this.bindcnt = this.rxh.numRqsts;
        this.iovector = new byte[this.bindcnt];
        for (int i2 = 0; i2 < this.bindcnt; ++i2) {
            this.bindtype = this.meg.unmarshalSB1();
            if (this.bindtype == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CTTIiov.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
            if ((this.bindtype & 0x20) > 0) {
                int n2 = i2;
                this.iovector[n2] = (byte)(this.iovector[n2] | 0x20);
                ++this.inbinds;
            }
            if ((this.bindtype & 0x10) <= 0) continue;
            int n3 = i2;
            this.iovector[n3] = (byte)(this.iovector[n3] | 0x10);
            ++this.outbinds;
        }
    }

    byte[] getIOVector() {
        return this.iovector;
    }

    boolean isIOVectorEmpty() {
        return this.iovector.length == 0;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIiov"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

