/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4CTTIokpn
extends T4CTTIfun {
    static final int REGISTER_KPNDEF = 1;
    static final int UNREGISTER_KPNDEF = 2;
    static final int POST_KPNDEF = 3;
    static final int EXISTINGCLIENT_KPNDEF = 0;
    static final int NEWCLIENT_KPNDEF = 1;
    static final int KPUN_PRS_RAW = 1;
    static final int KPUN_VER_10200 = 2;
    static final int OCI_SUBSCR_NAMESPACE_ANONYMOUS = 0;
    static final int OCI_SUBSCR_NAMESPACE_AQ = 1;
    static final int OCI_SUBSCR_NAMESPACE_DBCHANGE = 2;
    static final int OCI_SUBSCR_NAMESPACE_MAX = 3;
    static final int KPD_CHNF_OPFILTER = 1;
    static final int KPD_CHNF_INSERT = 2;
    static final int KPD_CHNF_UPDATE = 4;
    static final int KPD_CHNF_DELETE = 8;
    static final int KPD_CHNF_ROWID = 16;
    static final int KPD_CQ_QUERYNF = 32;
    static final int KPD_CQ_BEST_EFFORT = 64;
    static final int KPD_CQ_CLQRYCACHE = 128;
    static final int KPD_CHNF_INVALID_REGID = 0;
    static final int SUBSCR_QOS_RELIABLE = 1;
    static final int SUBSCR_QOS_PAYLOAD = 2;
    static final int SUBSCR_QOS_REPLICATE = 4;
    static final int SUBSCR_QOS_SECURE = 8;
    static final int SUBSCR_QOS_PURGE_ON_NTFN = 16;
    static final int SUBSCR_QOS_MULTICBK = 32;
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:34_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIokpn(T4CMAREngine _mare, T4CTTIoer _oer, T4CConnection _conn) throws SQLException {
        super((byte)3, 0, (short)125);
        this.oer = _oer;
        this.setMarshalingEngine(_mare);
        this.connection = _conn;
    }

    void marshal(int opcode, int mode, String user, String location, int nbOfRegistrationInfo, int[] namespace, String[] registeredAgentName, byte[][] kpdnrcx, int[] payloadType, int[] qosFlags, int[] timeout, int[] dbchangeOpFilter, int[] dbchangeTxnLag, int[] dbchangeRegistrationId) throws IOException, SQLException {
        int presentation = 1;
        int kpnver = 2;
        super.marshalFunHeader();
        this.meg.marshalUB1((byte)opcode);
        this.meg.marshalUB4(mode);
        byte[] userArr = null;
        if (user != null) {
            userArr = this.meg.conv.StringToCharBytes(user);
            this.meg.marshalPTR();
            this.meg.marshalUB4(userArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        byte[] locationArr = null;
        if (location != null) {
            locationArr = this.meg.conv.StringToCharBytes(location);
            this.meg.marshalPTR();
            this.meg.marshalUB4(locationArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        this.meg.marshalUB4(nbOfRegistrationInfo);
        this.meg.marshalUB2(presentation);
        this.meg.marshalUB2(kpnver);
        if (this.meg.versionNumber >= 10200) {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
        }
        if (userArr != null) {
            this.meg.marshalCHR(userArr);
        }
        if (locationArr != null) {
            this.meg.marshalCHR(locationArr);
        }
        for (int i2 = 0; i2 < nbOfRegistrationInfo; ++i2) {
            this.meg.marshalUB4(namespace[i2]);
            byte[] kpdnrnm = new byte[]{};
            if (registeredAgentName[i2] != null) {
                kpdnrnm = this.meg.conv.StringToCharBytes(registeredAgentName[i2]);
            }
            if (kpdnrnm.length > 0) {
                this.meg.marshalUB4(kpdnrnm.length);
                this.meg.marshalCLR(kpdnrnm, 0, kpdnrnm.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            if (kpdnrcx[i2] != null && kpdnrcx[i2].length > 0) {
                this.meg.marshalUB4(kpdnrcx[i2].length);
                this.meg.marshalCLR(kpdnrcx[i2], 0, kpdnrcx[i2].length);
            } else {
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB4(payloadType[i2]);
            if (this.meg.versionNumber < 10200) continue;
            this.meg.marshalUB4(qosFlags[i2]);
            byte[] kpdnrpaycb = new byte[]{};
            this.meg.marshalUB4(kpdnrpaycb.length);
            if (kpdnrpaycb.length > 0) {
                this.meg.marshalCLR(kpdnrpaycb, kpdnrpaycb.length);
            }
            this.meg.marshalUB4(timeout[i2]);
            int kpdnsd = 0;
            this.meg.marshalUB4(kpdnsd);
            this.meg.marshalUB4(dbchangeOpFilter[i2]);
            this.meg.marshalUB4(dbchangeTxnLag[i2]);
            this.meg.marshalUB4(dbchangeRegistrationId[i2]);
        }
    }

    int receive() throws SQLException, IOException {
        int regid = 0;
        boolean rpaProcessed = false;
        block7: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block7;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block7;
                        }
                        case 8: {
                            int size = (int)this.meg.unmarshalUB4();
                            for (int i2 = 0; i2 < size; ++i2) {
                                this.meg.unmarshalUB4();
                            }
                            int[] regidArr = new int[size];
                            for (int i3 = 0; i3 < size; ++i3) {
                                regidArr[i3] = (int)this.meg.unmarshalUB4();
                            }
                            regid = regidArr[0];
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block7;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIokpn.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        return regid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIokpn.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIokpn.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIokpn.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIokpn"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

