/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4CTTIsto
extends T4CTTIfun {
    static final int OV6STRT = 48;
    static final int OV6STOP = 49;
    static final int STOMFDBA = 1;
    static final int STOMFACA = 2;
    static final int STOMFALO = 4;
    static final int STOMFSHU = 8;
    static final int STOMFFRC = 16;
    static final int STOMFPOL = 32;
    static final int STOMFABO = 64;
    static final int STOMFATX = 128;
    static final int STOMFLTX = 256;
    static final int STOSDONE = 1;
    static final int STOSINPR = 2;
    static final int STOSERR = 3;
    T4CTTIoer oer;
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:35_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIsto(T4CMAREngine _mrengine, T4CTTIoer _oer, T4CConnection _connection) throws IOException, SQLException {
        super((byte)3, 0, (short)0);
        this.oer = _oer;
        this.connection = _connection;
        this.setMarshalingEngine(_mrengine);
    }

    void marshalStartup(int mode) throws IOException, SQLException {
        this.funCode = (short)48;
        super.marshalFunHeader();
        this.meg.marshalSWORD(mode);
        this.meg.marshalPTR();
    }

    void marshalShutdown(int mode) throws IOException, SQLException {
        this.funCode = (short)49;
        super.marshalFunHeader();
        this.meg.marshalSWORD(mode);
        this.meg.marshalPTR();
    }

    int receive() throws SQLException, IOException {
        int mode = 0;
        block7: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block7;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block7;
                        }
                        case 8: {
                            mode = (int)this.meg.unmarshalUB4();
                            if (mode != 3) continue block7;
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block7;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIsto.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIsto.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIsto.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIsto.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIsto"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

