/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4Caqdq
extends T4CTTIfun {
    T4CConnection connection;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:35_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4Caqdq(T4CMAREngine _mrengine, T4CConnection _connection, T4CTTIoer _oer) throws IOException, SQLException {
        super((byte)3, 0, (short)122);
        this.setMarshalingEngine(_mrengine);
        this.connection = _connection;
        this.oer = _oer;
        this.toh = new T4Ctoh();
        this.aqm = new T4CTTIaqm(_mrengine, this.toh);
    }

    void marshal(String queueName, AQDequeueOptions dequeueOptions, byte[] payloadToid) throws SQLException, IOException {
        super.marshalFunHeader();
        byte[] queueNameBytes = null;
        if (queueName != null && queueName.length() != 0) {
            queueNameBytes = this.meg.conv.StringToCharBytes(queueName);
            this.meg.marshalPTR();
            this.meg.marshalSWORD(queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        boolean sendConsumerName = false;
        byte[] consumerNameBytes = null;
        String consumerNameStr = dequeueOptions.getConsumerName();
        if (consumerNameStr != null && consumerNameStr.length() > 0) {
            consumerNameBytes = this.meg.conv.StringToCharBytes(consumerNameStr);
            sendConsumerName = true;
        }
        if (sendConsumerName) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(consumerNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSB4(dequeueOptions.getDequeueMode().getCode());
        this.meg.marshalSB4(dequeueOptions.getNavigation().getCode());
        this.meg.marshalSB4(dequeueOptions.getVisibility().getCode());
        this.meg.marshalSB4(dequeueOptions.getWait());
        byte[] mesgId = dequeueOptions.getDequeueMessageId();
        boolean sendMsgId = false;
        if (mesgId != null && mesgId.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(mesgId.length);
            sendMsgId = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        String correlation = dequeueOptions.getCorrelation();
        byte[] correlationBytes = null;
        boolean sendCorrelation = false;
        if (correlation != null && correlation.length() != 0) {
            correlationBytes = this.meg.conv.StringToCharBytes(correlation);
            this.meg.marshalPTR();
            this.meg.marshalSWORD(correlationBytes.length);
            sendCorrelation = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalPTR();
        this.meg.marshalSWORD(payloadToid.length);
        this.meg.marshalUB2(1);
        this.meg.marshalPTR();
        if (dequeueOptions.getRetrieveMessageId()) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int aqdflg = 0;
        if (this.connection.autocommit) {
            aqdflg = 32;
        }
        if (dequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
            aqdflg |= 2;
        } else if (dequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
            aqdflg |= 0x10;
        }
        this.meg.marshalUB4(aqdflg);
        boolean sendCondition = false;
        String condition = dequeueOptions.getCondition();
        byte[] conditionBytes = null;
        if (condition != null && condition.length() > 0) {
            sendCondition = true;
            conditionBytes = this.meg.conv.StringToCharBytes(condition);
            this.meg.marshalPTR();
            this.meg.marshalSWORD(conditionBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        boolean sendExtensions = false;
        int nbExtensions = 0;
        Object extensionTextValues = null;
        Object extensionBinaryValues = null;
        int[] extensionKeywords = null;
        String transformation = dequeueOptions.getTransformation();
        if (transformation != null && transformation.length() > 0) {
            nbExtensions = 1;
            sendExtensions = true;
            extensionTextValues = new byte[nbExtensions][];
            extensionBinaryValues = new byte[nbExtensions][];
            extensionKeywords = new int[nbExtensions];
            extensionTextValues[0] = this.meg.conv.StringToCharBytes(transformation);
            extensionBinaryValues[0] = null;
            extensionKeywords[0] = 196;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(nbExtensions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalCHR(queueNameBytes);
        if (sendConsumerName) {
            this.meg.marshalCHR(consumerNameBytes);
        }
        if (sendMsgId) {
            this.meg.marshalB1Array(mesgId);
        }
        if (sendCorrelation) {
            this.meg.marshalCHR(correlationBytes);
        }
        this.meg.marshalB1Array(payloadToid);
        if (sendCondition) {
            this.meg.marshalCHR(conditionBytes);
        }
        if (sendExtensions) {
            this.meg.marshalKPDKV((byte[][])extensionTextValues, (byte[][])extensionBinaryValues, extensionKeywords);
        }
    }

    boolean receive(AQDequeueOptions dequeueOptions, byte[][] payload, AQMessagePropertiesI properties, byte[][] msgid, boolean isRawQueue) throws SQLException, IOException {
        boolean hasAMessageBeenDequeued = false;
        block9: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            hasAMessageBeenDequeued = true;
                            int msgPropLength = (int)this.meg.unmarshalUB4();
                            if (msgPropLength > 0) {
                                this.aqm.initToDefaultValues();
                                this.aqm.receive(this.meg);
                                properties.setPriority(this.aqm.aqmpri);
                                properties.setDelay(this.aqm.aqmdel);
                                properties.setExpiration(this.aqm.aqmexp);
                                properties.setCorrelation(this.aqm.aqmcor);
                                properties.setAttempts(this.aqm.aqmatt);
                                properties.setExceptionQueue(this.aqm.aqmeqn);
                                properties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
                                properties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
                                properties.setSender(this.aqm.senderAgent);
                                properties.setPreviousQueueMessageId(this.aqm.originalMsgId);
                                properties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
                                properties.setTransactionGroup(this.aqm.aqmeti);
                            }
                            int aqdrel = (int)this.meg.unmarshalUB4();
                            this.toh.unmarshal(this.meg);
                            int lengthOfPayload = this.toh.imageLength;
                            if (lengthOfPayload > 0) {
                                int[] intAr;
                                byte[] image;
                                int bufferToAllocate = lengthOfPayload;
                                if (isRawQueue) {
                                    if (lengthOfPayload > 4) {
                                        bufferToAllocate -= 4;
                                    }
                                    bufferToAllocate = Math.min(bufferToAllocate, dequeueOptions.getMaximumBufferLength());
                                    image = new byte[bufferToAllocate];
                                    intAr = new int[1];
                                    if (lengthOfPayload > 4) {
                                        this.meg.unmarshalCLR(image, 0, intAr, image.length, 4);
                                    } else {
                                        this.meg.unmarshalCLR(image, 0, intAr, image.length);
                                    }
                                    payload[0] = image;
                                } else {
                                    image = new byte[bufferToAllocate];
                                    intAr = new int[1];
                                    this.meg.unmarshalCLR(image, 0, intAr, image.length);
                                    payload[0] = image;
                                }
                            }
                            if (!dequeueOptions.getRetrieveMessageId()) continue block9;
                            byte[] aqdmsi = new byte[16];
                            this.meg.unmarshalBuffer(aqdmsi, 0, 16);
                            msgid[0] = aqdmsi;
                            break;
                        }
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block9;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block9;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            if (this.oer.retCode == 25228) break block9;
                            this.oer.processError();
                            break block9;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4Caqdq.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        return hasAMessageBeenDequeued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4Caqdq.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4Caqdq.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4Caqdq.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4Caqdq"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

