/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection connection;
    SQLName sqlName = null;
    transient OracleTypeADT parent = null;
    transient int idx;
    transient TypeDescriptor descriptor = null;
    static String getUserTypeTreeSql = "select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
    String sqlHint = null;
    static String getAllTypeTreeSql = "select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:21_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleNamedType() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleNamedType(String name, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.setConnectionInternal(conn);
            this.sqlName = new SQLName(name, conn);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleNamedType(OracleTypeADT parent, int idx, OracleConnection conn) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(parent) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.setConnectionInternal(conn);
            this.parent = parent;
            this.idx = idx;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.getFullName(false);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullName(boolean force) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(force));
                OracleLog.recursiveTrace = false;
            }
            String temp_fullName = null;
            if (force || this.sqlName == null) {
                if (this.parent != null && (temp_fullName = this.parent.getAttributeType(this.idx)) != null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleNamedType.logger().log(OracleLog.TRACE_32, "Debug: getFullName going to db.");
                        OracleLog.recursiveTrace = false;
                    }
                    this.sqlName = new SQLName(temp_fullName, this.connection);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleNamedType.logger().log(Level.SEVERE, "Throwing SQLException: 1Unable to resolve name");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to resolve name");
                }
            }
            String __result__ = this.sqlName.getName();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            String __result__ = this.sqlName.getSchema();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSimpleName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            String __result__ = this.sqlName.getSimpleName();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasName() throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = this.sqlName != null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeADT getParent() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + this.parent);
                OracleLog.recursiveTrace = false;
            }
            OracleTypeADT oracleTypeADT = this.parent;
            return oracleTypeADT;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(OracleTypeADT parent) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(parent));
                OracleLog.recursiveTrace = false;
            }
            this.parent = parent;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrder() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + this.idx);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.idx;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrder(int order) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(order));
                OracleLog.recursiveTrace = false;
            }
            this.idx = order;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnection getConnection() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = this.connection;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.setConnectionInternal(conn);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionInternal(OracleConnection conn) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.connection = conn;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(objmap));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Datum datum = null;
            return datum;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int type, Map objmap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(cnt) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(objmap));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Datum datum = null;
            return datum;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] linearize(Datum data) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(data));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDescriptor getDescriptor() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + this.descriptor);
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor typeDescriptor = this.descriptor;
            return typeDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescriptor(TypeDescriptor desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            this.descriptor = desc;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeVersion() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: 1");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(out));
                OracleLog.recursiveTrace = false;
            }
            try {
                out.writeUTF(this.getFullName());
            }
            catch (SQLException e2) {
                DatabaseError.SQLToIOException(e2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            String name = in.readUTF();
            try {
                this.sqlName = new SQLName(name, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.parent = null;
            this.idx = -1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixupConnection(OracleConnection fixupConn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(fixupConn));
                OracleLog.recursiveTrace = false;
            }
            if (this.connection == null) {
                this.setConnection(fixupConn);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent));
                OracleLog.recursiveTrace = false;
            }
            this.printXML(pw, indent, false);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent) + ", " + OracleLog.argument(fetchAllMetaDataAsNeeded));
                OracleLog.recursiveTrace = false;
            }
            for (int i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("<OracleNamedType/>");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNamesRecursively() throws SQLException {
        try {
            Map typesTreeMap;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((typesTreeMap = this.createTypesTreeMap()).size() > 0) {
                this.initChildNamesRecursively(typesTreeMap);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNames(String schemaName, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(schemaName) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            this.sqlName = new SQLName(schemaName, typeName, this.connection);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSqlName(SQLName x) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            this.sqlName = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map createTypesTreeMap() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Map nodeMap = null;
            String currentUserName = this.connection.getDefaultSchemaNameForNamedTypes();
            if (this.sqlName.getSchema().equals(currentUserName)) {
                nodeMap = this.getNodeMapFromUserTypes();
            }
            if (nodeMap == null) {
                nodeMap = this.getNodeMapFromAllTypes();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + nodeMap);
                OracleLog.recursiveTrace = false;
            }
            Map map = nodeMap;
            return map;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSqlHint() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlHint == null) {
                this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "return: " + this.sqlHint);
                OracleLog.recursiveTrace = false;
            }
            String string = this.sqlHint;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromUserTypes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            HashMap<SQLName, TypeTreeElement> nodeMap = new HashMap<SQLName, TypeTreeElement>();
            Statement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = this.connection.prepareStatement(this.getSqlHint() + getUserTypeTreeSql);
                pstmt.setString(1, this.sqlName.getSimpleName());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    int depth = rst.getInt(1);
                    String parentTypeName = rst.getString(2);
                    String childTypeName = rst.getString(3);
                    int attrNumber = rst.getInt(4);
                    String childTypeOwner = rst.getString(5);
                    if (childTypeOwner != null && !childTypeOwner.equals(this.sqlName.getSchema())) {
                        nodeMap = null;
                        break;
                    }
                    if (parentTypeName.length() <= 0) continue;
                    SQLName parentSqlName = new SQLName(this.sqlName.getSchema(), parentTypeName, this.connection);
                    TypeTreeElement node = null;
                    if (nodeMap.containsKey(parentSqlName)) {
                        node = (TypeTreeElement)nodeMap.get(parentSqlName);
                    } else {
                        node = new TypeTreeElement(this.sqlName.getSchema(), parentTypeName);
                        nodeMap.put(parentSqlName, node);
                    }
                    node.putChild(this.sqlName.getSchema(), childTypeName, attrNumber);
                }
            }
            finally {
                if (rst != null) {
                    rst.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + nodeMap);
                OracleLog.recursiveTrace = false;
            }
            HashMap<SQLName, TypeTreeElement> hashMap = nodeMap;
            return hashMap;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromAllTypes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            HashMap<SQLName, TypeTreeElement> nodeMap = new HashMap<SQLName, TypeTreeElement>();
            Statement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = this.connection.prepareStatement(this.getSqlHint() + getAllTypeTreeSql);
                pstmt.setString(1, this.sqlName.getSimpleName());
                pstmt.setString(2, this.sqlName.getSchema());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String parentTypeName = rst.getString(1);
                    String parentOwnerName = rst.getString(2);
                    String childTypeName = rst.getString(3);
                    int attrNumber = rst.getInt(4);
                    String childOwnerName = rst.getString(5);
                    if (childOwnerName == null) {
                        childOwnerName = "SYS";
                    }
                    if (parentTypeName.length() <= 0) continue;
                    SQLName parentSQLName = new SQLName(parentOwnerName, parentTypeName, this.connection);
                    TypeTreeElement node = null;
                    if (nodeMap.containsKey(parentSQLName)) {
                        node = (TypeTreeElement)nodeMap.get(parentSQLName);
                    } else {
                        node = new TypeTreeElement(parentOwnerName, parentTypeName);
                        nodeMap.put(parentSQLName, node);
                    }
                    node.putChild(childOwnerName, childTypeName, attrNumber);
                }
            }
            finally {
                if (rst != null) {
                    rst.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "return: " + nodeMap);
                OracleLog.recursiveTrace = false;
            }
            HashMap<SQLName, TypeTreeElement> hashMap = nodeMap;
            return hashMap;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = this.connection;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleNamedType.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleNamedType"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

