/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance = null;
    protected Hashtable m_connCache = null;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription = false;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:36_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleConnectionCacheManager() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.m_connCache = new Hashtable();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        OracleConnectionCacheManager oracleConnectionCacheManager;
        block9: {
            try {
                block8: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        if (cacheManagerInstance == null) {
                            cacheManagerInstance = new OracleConnectionCacheManager();
                        }
                    }
                    catch (RuntimeException re) {
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_10, "Event: OracleConnectionCacheManager.getConnectionCacheManagerInstance(): RuntimeException : " + re.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + cacheManagerInstance);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnectionCacheManager = cacheManagerInstance;
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnectionCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createCache(OracleDataSource ods, Properties cacheProperties) throws SQLException {
        String string;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(ods) + ", " + OracleLog.argument(cacheProperties));
                    OracleLog.recursiveTrace = false;
                }
                String connectionCacheName = null;
                if (ods == null || !ods.getConnectionCachingEnabled()) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 137");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 137);
                }
                connectionCacheName = ods.connCacheName != null ? ods.connCacheName : ods.dataSourceName + "#0x" + Integer.toHexString(this.m_connCache.size());
                this.createCache(connectionCacheName, ods, cacheProperties);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + connectionCacheName);
                    OracleLog.recursiveTrace = false;
                }
                string = connectionCacheName;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache(String cacheName, OracleDataSource ods, Properties cacheProperties) throws SQLException {
        block21: {
            try {
                boolean _odsIsFcfEnabled;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(ods) + ", " + OracleLog.argument(cacheProperties));
                    OracleLog.recursiveTrace = false;
                }
                if (ods == null || !ods.getConnectionCachingEnabled()) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 137");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 137);
                }
                if (cacheName == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 138");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 138);
                }
                if (this.m_connCache.containsKey(cacheName)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 140");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 140);
                }
                if ((_odsIsFcfEnabled = ods.getFastConnectionFailoverEnabled()) && this.failoverEventHandlerThread == null) {
                    final String onsConfigStr = ods.getONSConfiguration();
                    if (onsConfigStr != null && !onsConfigStr.equals("")) {
                        OracleConnectionCacheManager oracleConnectionCacheManager = this;
                        synchronized (oracleConnectionCacheManager) {
                            if (!isONSInitializedForRemoteSubscription) {
                                try {
                                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws ONSException {
                                            ONS ons = new ONS(onsConfigStr);
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException onsexc) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 175" + onsexc);
                                        OracleLog.recursiveTrace = false;
                                    }
                                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 175, onsexc);
                                }
                                isONSInitializedForRemoteSubscription = true;
                            }
                        }
                    }
                    this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
                }
                OracleImplicitConnectionCache icc = new OracleImplicitConnectionCache(ods, cacheProperties);
                icc.cacheName = cacheName;
                ods.odsCache = icc;
                this.m_connCache.put(cacheName, icc);
                if (_odsIsFcfEnabled) {
                    this.checkAndStartThread(this.failoverEventHandlerThread);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block21;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String cacheName, long waitTimeout) throws SQLException {
        block12: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(waitTimeout));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(cacheName) : null;
                if (oicc != null) {
                    block11: {
                        oicc.disableConnectionCache();
                        if (waitTimeout > 0L) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(waitTimeout * 1000L);
                            }
                            catch (InterruptedException ea) {
                                if (!TRACE || OracleLog.recursiveTrace) break block11;
                                OracleLog.recursiveTrace = true;
                                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager.removeCache() - Exception Occurred : " + ea.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                        }
                    }
                    if (oicc.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                        this.cleanupFCFThreads(oicc);
                    }
                    oicc.closeConnectionCache(waitTimeout < 0L ? 32 : 1);
                    oicc = null;
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeCache(String cacheName, Properties cacheProperties) throws SQLException {
        block8: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(cacheProperties));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    this.disableCache(cacheName);
                    oicc.reinitializeCacheConnections(cacheProperties);
                    this.enableCache(cacheName);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsCache(String cacheName) throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = this.m_connCache.containsKey(cacheName);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCache(String cacheName) throws SQLException {
        block8: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    oicc.enableConnectionCache();
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCache(String cacheName) throws SQLException {
        block8: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    oicc.disableConnectionCache();
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache(String cacheName, int mode) throws SQLException {
        block12: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(mode));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    switch (mode) {
                        case 4096: 
                        case 8192: {
                            oicc.refreshCacheConnections(mode);
                            break;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                            break;
                        }
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache(String cacheName, boolean cleanupCheckedOutConnections) throws SQLException {
        block8: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(cleanupCheckedOutConnections));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    oicc.purgeCacheConnections(cleanupCheckedOutConnections, 1);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCacheProperties(String cacheName) throws SQLException {
        Properties properties;
        block9: {
            block7: {
                Properties properties2;
                block8: {
                    try {
                        OracleImplicitConnectionCache oicc;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                            OracleLog.recursiveTrace = false;
                        }
                        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                        if (oicc == null) break block7;
                        properties2 = oicc.getConnectionCacheProperties();
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return properties2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            properties = null;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCacheNameList() throws SQLException {
        String[] stringArray;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String[] sArray = this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + sArray);
                    OracleLog.recursiveTrace = false;
                }
                stringArray = sArray;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableConnections(String cacheName) throws SQLException {
        int n2;
        block9: {
            block7: {
                int n3;
                block8: {
                    try {
                        OracleImplicitConnectionCache oicc;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                            OracleLog.recursiveTrace = false;
                        }
                        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                        if (oicc == null) break block7;
                        n3 = oicc.cacheSize;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            n2 = 0;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfActiveConnections(String cacheName) throws SQLException {
        int n2;
        block9: {
            block7: {
                int n3;
                block8: {
                    try {
                        OracleImplicitConnectionCache oicc;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                            OracleLog.recursiveTrace = false;
                        }
                        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                        if (oicc == null) break block7;
                        n3 = oicc.getNumberOfCheckedOutConnections();
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            n2 = 0;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionPoolDataSource(String cacheName, ConnectionPoolDataSource ds) throws SQLException {
        block11: {
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(ds));
                    OracleLog.recursiveTrace = false;
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    if (oicc.cacheSize > 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 78");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 78);
                    } else {
                        ((OracleConnectionPoolDataSource)ds).makeURL();
                        ((OracleConnectionPoolDataSource)ds).setURL(((OracleConnectionPoolDataSource)ds).url);
                        oicc.connectionPoolDS = (OracleConnectionPoolDataSource)ds;
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 141");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 141);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAndHandleEvent(int eventType, byte[] eventBody) throws SQLException {
        try {
            StringTokenizer strTokens;
            int cardinality;
            String status;
            String hostNameKey;
            String dbUniqNameKey;
            String instNameKey;
            String svcName;
            block20: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(eventBody));
                    OracleLog.recursiveTrace = false;
                }
                svcName = null;
                instNameKey = null;
                dbUniqNameKey = null;
                hostNameKey = null;
                status = null;
                cardinality = 0;
                strTokens = null;
                try {
                    strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
                }
                catch (UnsupportedEncodingException e2) {
                    if (!TRACE || OracleLog.recursiveTrace) break block20;
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager : verifyAndHandleEvent() - UTF-8 Encoding Exception" + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                val = null;
                st = strTokens.nextToken();
                if (st.equals("=") && strTokens.hasMoreTokens()) {
                    val = strTokens.nextToken();
                } else {
                    key = st;
                }
                if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 146");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 146);
                }
                if (key.equalsIgnoreCase("service") && val != null) {
                    svcName = val;
                }
                if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                    instNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("database") && val != null) {
                    dbUniqNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("host") && val != null) {
                    hostNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("status") && val != null) {
                    status = val;
                }
                if (!key.equalsIgnoreCase("card") || val == null) continue;
                try {
                    cardinality = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager : verifyAndHandleEvent() - Cardinality value= " + val + " : Error : " + nfe.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            this.invokeFailoverProcessingThreads(eventType, svcName, instNameKey, dbUniqNameKey, hostNameKey, status, cardinality);
            strTokens = null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFailoverProcessingThreads(int eventType, String svcName, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(svcName) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                OracleLog.recursiveTrace = false;
            }
            OracleImplicitConnectionCache oicc2 = null;
            boolean serviceEvent = false;
            boolean hostEvent = false;
            if (eventType == 256) {
                serviceEvent = true;
            }
            if (eventType == 512) {
                hostEvent = true;
            }
            for (OracleImplicitConnectionCache oicc2 : this.m_connCache.values()) {
                if ((!serviceEvent || !svcName.equalsIgnoreCase(oicc2.dataSourceServiceName)) && !hostEvent) continue;
                OracleFailoverWorkerThread workerTh = new OracleFailoverWorkerThread(oicc2, eventType, instNameKey, dbUniqNameKey, hostNameKey, status, card);
                this.checkAndStartThread(workerTh);
                oicc2.failoverWorkerThread = workerTh;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndStartThread(Thread thr) throws SQLException {
        try {
            block9: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(thr));
                    OracleLog.recursiveTrace = false;
                }
                try {
                    if (!thr.isAlive()) {
                        thr.setDaemon(true);
                        thr.start();
                    }
                }
                catch (IllegalThreadStateException ie) {
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager.checkAndStartThread() - IllegalThreadStateException occurred:" + ie.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean failoverEnabledCacheExists() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.failoverEnabledCacheCount > 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRuntimeLoadBalancingEvent(String service, byte[] eventBody) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(service) + ", " + OracleLog.argument(eventBody));
                OracleLog.recursiveTrace = false;
            }
            OracleImplicitConnectionCache icc = null;
            Enumeration iccSet = this.m_connCache.elements();
            while (iccSet.hasMoreElements()) {
                try {
                    icc = (OracleImplicitConnectionCache)iccSet.nextElement();
                    if (!service.equalsIgnoreCase(icc.dataSourceServiceName)) continue;
                    if (eventBody == null) {
                        icc.zapRLBInfo();
                        continue;
                    }
                    this.retrieveServiceMetrics(icc, eventBody);
                }
                catch (Exception e2) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: (RLB)OracleConnectionCacheManager.parseRuntimeLoadBalancingEvent():" + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveServiceMetrics(OracleImplicitConnectionCache icc, byte[] eventBody) throws SQLException {
        try {
            boolean updateNecessary;
            int flag;
            int percent;
            String dbUniqNameKey;
            String instNameKey;
            StringTokenizer strTokens;
            block24: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(icc) + ", " + OracleLog.argument(eventBody));
                    OracleLog.recursiveTrace = false;
                }
                strTokens = null;
                instNameKey = null;
                dbUniqNameKey = null;
                percent = 0;
                flag = 0;
                updateNecessary = false;
                try {
                    strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
                }
                catch (UnsupportedEncodingException e2) {
                    if (!TRACE || OracleLog.recursiveTrace) break block24;
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager : retrieveServiceMetrics() - (RLB)UTF-8 Encoding Exception:" + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                block25: {
                    val = null;
                    st = strTokens.nextToken();
                    if (st.equals("=") && strTokens.hasMoreTokens()) {
                        val = strTokens.nextToken();
                    } else {
                        if (st.equals("}")) {
                            if (!updateNecessary) continue;
                            icc.updateDatabaseInstance(dbUniqNameKey, instNameKey, percent, flag);
                            updateNecessary = false;
                            continue;
                        }
                        if (st.equals("{") || st.equals(" ")) continue;
                        key = st;
                        updateNecessary = true;
                    }
                    if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, "Throwing SQLException: 146");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 146);
                    }
                    if (key.equalsIgnoreCase("database") && val != null) {
                        dbUniqNameKey = val.toLowerCase().intern();
                    }
                    if (key.equalsIgnoreCase("instance") && val != null) {
                        instNameKey = val.toLowerCase().intern();
                    }
                    if (key.equalsIgnoreCase("percent") && val != null) {
                        try {
                            percent = Integer.parseInt(val);
                            if (percent == 0) {
                                percent = 1;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (!TRACE || OracleLog.recursiveTrace) break block25;
                            OracleLog.recursiveTrace = true;
                            OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: (RLB)OracleConnectionCacheManager.retrieveServiceMetrics() - Exception occurred : (RLB)percent value= " + val + nfe.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                }
                if (!key.equalsIgnoreCase("flag") || val == null) continue;
                if (val.equalsIgnoreCase("good")) {
                    flag = 1;
                    continue;
                }
                if (val.equalsIgnoreCase("violating")) {
                    flag = 3;
                    continue;
                }
                if (val.equalsIgnoreCase("NO_DATA")) {
                    flag = 4;
                    continue;
                }
                if (val.equalsIgnoreCase("UNKNOWN")) {
                    flag = 2;
                    continue;
                }
                if (!val.equalsIgnoreCase("BLOCKED")) continue;
                flag = 5;
            }
            icc.processDatabaseInstances();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupFCFThreads(OracleImplicitConnectionCache oicc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cleanupFCFWorkerThread(oicc);
            oicc.cleanupRLBThreads();
            if (this.failoverEnabledCacheCount <= 0) {
                this.cleanupFCFEventHandlerThread();
            }
            --this.failoverEnabledCacheCount;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oicc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oicc));
                OracleLog.recursiveTrace = false;
            }
            if (oicc.failoverWorkerThread != null) {
                block10: {
                    try {
                        if (oicc.failoverWorkerThread.isAlive()) {
                            oicc.failoverWorkerThread.join();
                        }
                    }
                    catch (InterruptedException e2) {
                        if (!TRACE || OracleLog.recursiveTrace) break block10;
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager.cleanupFCFWorkerThread() - Exception occurred:" + e2.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                oicc.failoverWorkerThread = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupFCFEventHandlerThread() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.failoverEventHandlerThread != null) {
                block9: {
                    try {
                        this.failoverEventHandlerThread.interrupt();
                    }
                    catch (Exception e2) {
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, "Debug: OracleConnectionCacheManager.cleanupFCFEventHandlerThread() - Exception occurred:" + e2.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                this.failoverEventHandlerThread = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFatalConnectionError(SQLException se) {
        boolean bl;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(se));
                    OracleLog.recursiveTrace = false;
                }
                boolean retCode = false;
                int errCode = se.getErrorCode();
                if (errCode == 3113 || errCode == 3114 || errCode == 1033 || errCode == 1034 || errCode == 1089 || errCode == 1090 || errCode == 17002) {
                    retCode = true;
                }
                if (!retCode && this.fatalErrorCodes != null) {
                    for (int i2 = 0; i2 < this.fatalErrorCodes.length; ++i2) {
                        if (errCode != this.fatalErrorCodes[i2]) continue;
                        retCode = true;
                        break;
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + retCode);
                    OracleLog.recursiveTrace = false;
                }
                bl = retCode;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionErrorCodes(int[] fatalErrorCodes) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(fatalErrorCodes));
                    OracleLog.recursiveTrace = false;
                }
                if (fatalErrorCodes != null) {
                    this.fatalErrorCodes = fatalErrorCodes;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getConnectionErrorCodes() throws SQLException {
        int[] nArray;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.fatalErrorCodes);
                    OracleLog.recursiveTrace = false;
                }
                nArray = this.fatalErrorCodes;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatistics(String cacheName) throws SQLException {
        Map map;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cacheName));
                    OracleLog.recursiveTrace = false;
                }
                Map map2 = null;
                OracleImplicitConnectionCache icc = null;
                if (this.m_connCache != null && (icc = (OracleImplicitConnectionCache)this.m_connCache.get(cacheName)) != null) {
                    map2 = icc.getStatistics();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + map2);
                    OracleLog.recursiveTrace = false;
                }
                map = map2;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionCacheManager.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

