/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:37_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAHeteroResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        block6: {
            this.rmid = -1;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(pm_conn) + ", " + OracleLog.argument(xaconn));
                    OracleLog.recursiveTrace = false;
                }
                this.connection = pm_conn;
                this.xaconnection = xaconn;
                if (this.connection == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -7");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-7);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flags) throws XAException {
        block19: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flags));
                    OracleLog.recursiveTrace = false;
                }
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.start(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                int isolFlag = flags & 0xFF00;
                if (((flags &= 0xFFFF00FF) & 0x8200002) != flags) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.start(): XAER_INVAL: invalid flag");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.start():XAER_INVAL: invalid Isolation flag");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                if ((isolFlag & 0xFF00) != 0 && (flags & 0x8200000) != 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                try {
                    this.saveAndAlterAutoCommitModeForGlobalTransaction();
                    int formatId = xid.getFormatId();
                    byte[] gTrid = xid.getGlobalTransactionId();
                    byte[] bQual = xid.getBranchQualifier();
                    int status = this.t2cDoXaStart(formatId, gTrid, bQual, this.rmid, flags |= isolFlag, 0);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.start(): return status = " + status);
                        OracleLog.recursiveTrace = false;
                    }
                    this.checkStatus(status);
                    this.enterGlobalTxnMode();
                }
                catch (XAException ea) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    throw ea;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block19;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        block15: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                    OracleLog.recursiveTrace = false;
                }
                try {
                    if (xid == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.end(): XAER_INVAL: xid is null");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    int validFlags = 638582786;
                    if ((flag & validFlags) != flag) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.end(): XAER_INVAL: invalid flag");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    int formatId = xid.getFormatId();
                    byte[] gTrid = xid.getGlobalTransactionId();
                    byte[] bQual = xid.getBranchQualifier();
                    this.exitGlobalTxnMode();
                    int status = this.t2cDoXaEnd(formatId, gTrid, bQual, this.rmid, flag, 0);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.end(): return status = " + status);
                        OracleLog.recursiveTrace = false;
                    }
                    this.checkStatus(status);
                }
                finally {
                    this.restoreAutoCommitModeForGlobalTransaction();
                }
                if (!TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(onePhase));
                    OracleLog.recursiveTrace = false;
                }
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.commit(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                int flags = onePhase ? 0x40000000 : 0;
                int formatId = xid.getFormatId();
                byte[] gTrid = xid.getGlobalTransactionId();
                byte[] bQual = xid.getBranchQualifier();
                int status = this.t2cDoXaCommit(formatId, gTrid, bQual, this.rmid, flags, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.commit(): return status = " + status);
                    OracleLog.recursiveTrace = false;
                }
                this.checkStatus(status);
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        int n2;
        block10: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.prepare(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                int formatId = xid.getFormatId();
                byte[] gTrid = xid.getGlobalTransactionId();
                byte[] bQual = xid.getBranchQualifier();
                int status = this.t2cDoXaPrepare(formatId, gTrid, bQual, this.rmid, 0, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.prepare(): return status = " + status);
                    OracleLog.recursiveTrace = false;
                }
                if (status != 0 && status != 3) {
                    this.checkStatus(status);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + status);
                    OracleLog.recursiveTrace = false;
                }
                n2 = status;
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.forget(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                int formatId = xid.getFormatId();
                byte[] gTrid = xid.getGlobalTransactionId();
                byte[] bQual = xid.getBranchQualifier();
                int status = this.t2cDoXaForget(formatId, gTrid, bQual, this.rmid, 0, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.forget(): return status = " + status);
                    OracleLog.recursiveTrace = false;
                }
                this.checkStatus(status);
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.rollback(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                int formatId = xid.getFormatId();
                byte[] gTrid = xid.getGlobalTransactionId();
                byte[] bQual = xid.getBranchQualifier();
                int status = this.t2cDoXaRollback(formatId, gTrid, bQual, this.rmid, 0, 0);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAHeteroResource.rollback(): return status = " + status);
                    OracleLog.recursiveTrace = false;
                }
                this.checkStatus(status);
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAHeteroResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    private native int t2cDoXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setRmid(int rmid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rmid));
                OracleLog.recursiveTrace = false;
            }
            this.rmid = rmid;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getRmid() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "return: " + this.rmid);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.rmid;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedBytes(Xid xid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            try {
                byte[] __result__ = Util.serializeObject(xid);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return byArray;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus(int status) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(status));
                OracleLog.recursiveTrace = false;
            }
            if (status != 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAHeteroResource.logger().log(Level.SEVERE, "Throwing XAException: " + status);
                    OracleLog.recursiveTrace = false;
                }
                throw new XAException(status);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAHeteroResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAHeteroResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

