/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version;
    private boolean needStackingForCommitRollbackPrepare;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:37_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource() {
        block4: {
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        block10: {
            super(pm_conn, xaconn);
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            try {
                block9: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(pm_conn) + ", " + OracleLog.argument(xaconn));
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        this.m_version = ((OracleConnection)pm_conn).getVersionNumber();
                        this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
                    }
                    catch (SQLException sqe) {
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource(pm_conn, xaconn): getVersionNumber() -- SQLException");
                        OracleLog.recursiveTrace = false;
                    }
                }
                if (this.m_version < 8170) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource(pm_conn): Java XA not supported for this server version");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flag) throws XAException {
        block19: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                    OracleLog.recursiveTrace = false;
                }
                int returnVal = -1;
                Object cstmt = null;
                try {
                    if (xid == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.start(): XAER_INVAL: xid is null");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    int isolFlag = flag & 0xFF00;
                    int otherFlag = (flag &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
                    if (((flag &= 0xFFFEFFFF) & 0x8200002) != flag || otherFlag != 0 && (otherFlag & 0x10000) != 65536) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.start(): XAER_INVAL: invalid flag");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.start(): XAER_INVAL: invalid Isolation flag");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    if ((flag & 0x8200000) != 0 && ((isolFlag & 0xFF00) != 0 || (otherFlag & 0x10000) != 0)) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    this.saveAndAlterAutoCommitModeForGlobalTransaction();
                    returnVal = this.doStart(xid, flag |= isolFlag | otherFlag);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.start(): return status returnVal = " + returnVal);
                        OracleLog.recursiveTrace = false;
                    }
                    this.checkError(returnVal);
                    boolean[] isLocallySuspended = new boolean[]{false};
                    super.createOrUpdateXid(xid, false, isLocallySuspended);
                }
                catch (XAException ea) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    throw ea;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block19;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStart(Xid xid, int flag) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            int returnVal = -1;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_start_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, this.timeout);
                cstmt.setInt(6, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.start() returnVal=" + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                if (returnVal == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        block27: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                    OracleLog.recursiveTrace = false;
                }
                int returnVal = -1;
                boolean needToResume = false;
                try {
                    if (xid == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.end(): XAER_INVAL: xid is null");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    int validFlags = 638582786;
                    if ((flag & validFlags) != flag) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.end(): XAER_INVAL: invalid flag");
                            OracleLog.recursiveTrace = false;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(-5);
                    }
                    boolean currentXidSuspended = this.isCurrentXidSuspended(xid);
                    Xid stackedXid = super.suspendStacked(xid, flag);
                    boolean[] flags = new boolean[]{false, false};
                    boolean foundXid = true;
                    if (flag == 0x2000000) {
                        super.createOrUpdateXid(xid, true, flags);
                    } else if (stackedXid != null) {
                        foundXid = super.updateXidList(xid, flags);
                        needToResume = flags[1];
                    }
                    if (!needToResume) {
                        if (!foundXid && flag == 0x4000000) {
                            needToResume = true;
                        } else if (currentXidSuspended) {
                            needToResume = true;
                        }
                    }
                    if (needToResume && (returnVal = this.doStart(xid, 0x8000000)) != 0) {
                        super.resumeStacked(stackedXid);
                        this.checkError(returnVal);
                    }
                    returnVal = this.doEnd(xid, flag, flags[0]);
                    if (flag == 0x4000000 && returnVal == 0) {
                        this.removeXidFromList(xid);
                        this.currentXidListEntry = null;
                    }
                    if (stackedXid != null) {
                        super.resumeStacked(stackedXid);
                    } else if (this.isXidListEmpty()) {
                        this.exitGlobalTxnMode();
                        this.currentXidListEntry = null;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.end(): return status returnVal = " + returnVal);
                        OracleLog.recursiveTrace = false;
                    }
                    this.checkError(returnVal);
                }
                finally {
                    this.restoreAutoCommitModeForGlobalTransaction();
                }
                if (!TRACE || OracleLog.recursiveTrace) break block27;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag) + ", " + OracleLog.argument(isLocallySuspended));
                OracleLog.recursiveTrace = false;
            }
            CallableStatement cstmt = null;
            int returnVal = -1;
            try {
                cstmt = this.connection.prepareCall(xa_end_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.end() returnVal=" + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                if (returnVal == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block17: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(onePhase));
                    OracleLog.recursiveTrace = false;
                }
                int returnVal = -1;
                boolean stateout = false;
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.commit(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                int cPhase = onePhase ? 1 : 0;
                Xid stackedXid = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    stackedXid = super.suspendStacked(xid);
                } else {
                    this.exitGlobalTxnMode();
                    this.currentXidListEntry = null;
                }
                returnVal = this.doCommit(xid, cPhase);
                if (returnVal != 0 && OracleXAException.errorConvert(returnVal, -7) == -7) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.commit(): Error during commit is fatal so, close the connection.");
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        this.connection.close();
                    }
                    catch (SQLException ea) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.commit(): connection.close yielded: " + ea.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.commit(): return status returnVal = " + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                this.checkError(returnVal, -7);
                if (!TRACE || OracleLog.recursiveTrace) break block17;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doCommit(Xid xid, int cPhase) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(cPhase));
                OracleLog.recursiveTrace = false;
            }
            int returnVal = -1;
            CallableStatement cstmt = null;
            boolean stateout = false;
            try {
                cstmt = this.connection.prepareCall(xa_commit_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, cPhase);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.commit() returnVal=" + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                if (returnVal == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        int n2;
        block14: {
            try {
                int x_e;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                int returnVal = 0;
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.prepare(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                Xid stackedXid = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    stackedXid = super.suspendStacked(xid);
                }
                returnVal = this.doPrepare(xid);
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.prepare(): return status returnVal = " + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                int n3 = x_e = returnVal == 0 ? 0 : OracleXAException.errorConvert(returnVal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.prepare(): x_e = " + x_e);
                    OracleLog.recursiveTrace = false;
                }
                if (x_e != 0 && x_e != 3) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing OracleXAException: " + returnVal);
                        OracleLog.recursiveTrace = false;
                    }
                    throw new OracleXAException(returnVal);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + x_e);
                    OracleLog.recursiveTrace = false;
                }
                n2 = x_e;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPrepare(Xid xid) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            int returnVal = 0;
            boolean stateout = false;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_prepare_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.prepare() returnVal=" + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                if (returnVal == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                int returnVal = 0;
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.forget(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                returnVal = this.doForget(xid);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.forget(): return status returnVal = " + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                this.checkError(returnVal);
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doForget(Xid xid) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            int returnVal = 0;
            boolean stateout = false;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_forget_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.forget() returnVal=" + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                if (returnVal == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xid));
                    OracleLog.recursiveTrace = false;
                }
                int returnVal = 0;
                boolean stateout = false;
                if (xid == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.rollback(): XAER_INVAL: xid is null");
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-5);
                }
                Xid stackedXid = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    stackedXid = super.suspendStacked(xid);
                } else {
                    this.exitGlobalTxnMode();
                    this.currentXidListEntry = null;
                }
                returnVal = this.doRollback(xid);
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.rollback(): return status returnVal = " + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                this.checkError(returnVal);
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doRollback(Xid xid) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            int returnVal = 0;
            boolean stateout = false;
            CallableStatement cstmt = null;
            try {
                cstmt = this.connection.prepareCall(xa_rollback_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                returnVal = s2.getErrorCode();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.rollback() returnVal=" + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                if (returnVal == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new XAException(-6);
                }
            }
            finally {
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s3) {}
                cstmt = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTwoPhaseAction(int nsites, int action, String[] dbnames, Xid[] xids) throws XAException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(nsites) + ", " + OracleLog.argument(action) + ", " + OracleLog.argument(dbnames) + ", " + OracleLog.argument(xids));
                    OracleLog.recursiveTrace = false;
                }
                this.doDoTwoPhaseAction(nsites, action, dbnames, xids);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAResource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    protected int doDoTwoPhaseAction(int nsites, int action, String[] dbnames, Xid[] xids) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nsites) + ", " + OracleLog.argument(action) + ", " + OracleLog.argument(dbnames) + ", " + OracleLog.argument(xids));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(Level.SEVERE, "Throwing XAException: -6");
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-6);
        }
        catch (Throwable throwable) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedBytes(Xid xid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                OracleLog.recursiveTrace = false;
            }
            try {
                byte[] byArray = Util.serializeObject(xid);
                return byArray;
            }
            catch (IOException ioe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_20, "Debug: OracleXAResource.getSerializedBytes() got exception: " + ioe);
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return byArray;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

