/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.DataPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetOutputStream
extends OutputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetOutputStream(SessionAtts sAtts) {
        this.sAtts = sAtts;
        this.daPkt = new DataPacket(sAtts);
    }

    public NetOutputStream(SessionAtts sAtts, int sdu) {
        this.sAtts = sAtts;
        this.daPkt = new DataPacket(sAtts, sdu);
    }

    @Override
    public void write(int b2) throws IOException {
        this.tmpBuf[0] = (byte)b2;
        this.write(this.tmpBuf);
    }

    @Override
    public void write(byte[] userBuffer) throws IOException {
        this.write(userBuffer, 0, userBuffer.length);
    }

    @Override
    public void write(byte[] userBuffer, int off, int len) throws IOException {
        int dataFlags = 0;
        for (int bytesCopied = 0; len > bytesCopied; bytesCopied += this.daPkt.putDataInBuffer(userBuffer, off + bytesCopied, len - bytesCopied)) {
            if (!this.daPkt.isBufferFull) continue;
            dataFlags = len > bytesCopied ? 32 : 0;
            this.daPkt.send(dataFlags);
        }
    }

    public int available() throws IOException {
        return this.daPkt.availableBytesToSend;
    }

    @Override
    public void flush() throws IOException {
        if (this.daPkt.availableBytesToSend > 0) {
            this.daPkt.send(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.daPkt.send(64);
    }
}

