/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import oracle.net.jdbc.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected byte[] header = new byte[8];
    public SessionAtts sAtts;

    public Packet(SessionAtts sAtts) {
        this.sAtts = sAtts;
        this.sdu = sAtts.getSDU();
        this.tdu = sAtts.getTDU();
    }

    public Packet(SessionAtts sAtts, int bufferSize) {
        this(sAtts);
        this.createBuffer(bufferSize);
    }

    public Packet(SessionAtts sAtts, int bufferSize, int type, int flags) {
        this(sAtts);
        this.createBuffer(bufferSize, type, flags);
    }

    public Packet(Packet pkt) {
        this(pkt.sAtts);
        this.length = pkt.length;
        this.type = pkt.type;
        this.flags = pkt.flags;
        this.dataLen = pkt.dataLen;
        this.dataOff = pkt.dataOff;
        this.buffer = pkt.buffer;
    }

    protected void createBuffer(int length) {
        this.buffer = new byte[length];
        this.buffer[0] = (byte)(length / 256);
        this.buffer[1] = (byte)(length % 256);
    }

    protected void createBuffer(int length, int type, int flags) {
        this.buffer = new byte[length];
        this.buffer[0] = (byte)(length / 256);
        this.buffer[1] = (byte)(length % 256);
        this.buffer[5] = (byte)flags;
        this.buffer[4] = (byte)type;
    }

    protected void receive() throws IOException, NetException {
        int bytesRead = 0;
        while (bytesRead < this.header.length) {
            try {
                if ((bytesRead += this.sAtts.ntInputStream.read(this.header, bytesRead, this.header.length - bytesRead)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException exp) {
                throw new NetException(504);
            }
        }
        this.length = this.header[0] & 0xFF;
        this.length <<= 8;
        this.length |= this.header[1] & 0xFF;
        this.type = this.header[4];
        this.flags = this.header[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > Short.MAX_VALUE || this.length > this.sdu) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
        this.buffer[5] = (byte)this.flags;
        this.buffer[4] = (byte)this.type;
        while (bytesRead < this.length) {
            try {
                if ((bytesRead += this.sAtts.ntInputStream.read(this.buffer, bytesRead, this.length - bytesRead)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws IOException {
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
        }
    }

    protected void extractData() throws IOException, NetException {
        if (this.dataLen <= 0) {
            this.data = new String();
        } else if (this.length > this.dataOff) {
            this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
        } else {
            byte[] dataBuffer = new byte[this.dataLen];
            if (this.sAtts.nsInputStream.read(dataBuffer) < 0) {
                throw new NetException(0);
            }
            this.data = new String(dataBuffer, 0);
        }
    }

    protected String getData() {
        return this.data;
    }

    protected void dump(byte[] buffer, int offset, int len) {
        int bytes = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + buffer.length);
        System.out.println("offset       =" + offset);
        System.out.println("len          =" + len);
        for (int i2 = offset; i2 < len; i2 += 8) {
            System.out.print("|");
            for (int j2 = 0; j2 < 8 && bytes < len - 1; ++j2) {
                bytes = i2 + j2;
                RepConversion.printInHex(buffer[bytes]);
                System.out.print(" ");
            }
            System.out.println("|");
        }
        System.out.println("finish dump");
    }
}

