/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetGB18030
extends CharacterSetWithConverter {
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:19_PDT_2008";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetGB18030(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetGB18030 getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            if (charConverter.getGroupId() == 9) {
                CharacterSetGB18030 __result__ = new CharacterSetGB18030(oracleId, charConverter);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetGB18030 characterSetGB18030 = __result__;
                return characterSetGB18030;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            CharacterSetGB18030 characterSetGB18030 = null;
            return characterSetGB18030;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        try {
            int c2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(walker));
                OracleLog.recursiveTrace = false;
            }
            if ((c2 = walker.bytes[walker.next] & 0xFF) > 127) {
                if (walker.bytes.length > walker.next + 1) {
                    if ((walker.bytes[walker.next] & 0xFF) >= 129 && (walker.bytes[walker.next] & 0xFF) <= 254 && (walker.bytes[walker.next + 1] & 0xFF) >= 48 && (walker.bytes[walker.next + 1] & 0xFF) <= 57) {
                        if (walker.bytes.length > walker.next + 3) {
                            if ((walker.bytes[walker.next + 2] & 0xFF) >= 129 && (walker.bytes[walker.next + 2] & 0xFF) <= 254 && (walker.bytes[walker.next + 3] & 0xFF) >= 48 && (walker.bytes[walker.next + 3] & 0xFF) <= 57) {
                                c2 = (walker.bytes[walker.next] & 0xFF) << 24 | (walker.bytes[walker.next + 1] & 0xFF) << 16 | (walker.bytes[walker.next + 2] & 0xFF) << 8 | walker.bytes[walker.next + 3] & 0xFF;
                                walker.next += 4;
                            } else {
                                c2 = walker.bytes[walker.next] & 0xFF;
                                ++walker.next;
                            }
                        } else {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                CharacterSetGB18030.logger().log(Level.SEVERE, "Throwing SQLException: 182destination too small");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                        }
                    } else {
                        c2 = (walker.bytes[walker.next] & 0xFF) << 8 | walker.bytes[walker.next + 1] & 0xFF;
                        walker.next += 2;
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        CharacterSetGB18030.logger().log(Level.SEVERE, "Throwing SQLException: 182destination too small");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_30, "return: " + c2);
                OracleLog.recursiveTrace = false;
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            int bytesToShift = 0;
            int bytesNeeded = 0;
            while (c2 >> bytesToShift != 0) {
                bytesToShift = (short)(bytesToShift + 8);
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            if (c2 >> 16 != 0) {
                bytesToShift = 3;
                bytesNeeded = 4;
            } else if (c2 >> 8 != 0) {
                bytesToShift = 1;
                bytesNeeded = 2;
            } else {
                bytesToShift = 0;
                bytesNeeded = 1;
            }
            CharacterSetGB18030.need(buffer, bytesNeeded);
            while (bytesToShift >= 0) {
                buffer.bytes[buffer.next++] = (byte)(c2 >> bytesToShift & 0xFF);
                bytesToShift = (short)(bytesToShift - 8);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetGB18030.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetGB18030"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

