/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetZHTEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
    static final int MAX_7BIT = 127;
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:19_PDT_2008";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetZHTEUC(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            this.m_leadingCodes = charConverter.getLeadingCodes();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetZHTEUC getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                OracleLog.recursiveTrace = false;
            }
            if (charConverter.getGroupId() == 5) {
                CharacterSetZHTEUC __result__ = new CharacterSetZHTEUC(oracleId, charConverter);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                CharacterSetZHTEUC characterSetZHTEUC = __result__;
                return characterSetZHTEUC;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            CharacterSetZHTEUC characterSetZHTEUC = null;
            return characterSetZHTEUC;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(walker));
                OracleLog.recursiveTrace = false;
            }
            if (walker.next + 1 < walker.bytes.length) {
                int leadingCode = walker.bytes[walker.next] << 8 | walker.bytes[walker.next + 1];
                for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                    if (leadingCode != this.m_leadingCodes[i2]) continue;
                    if (walker.bytes.length - walker.next < 4) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            CharacterSetZHTEUC.logger().log(Level.SEVERE, "Throwing SQLException: 182destination too small");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                    }
                    int c2 = 0;
                    for (int j2 = 0; j2 < 4; ++j2) {
                        c2 = c2 << 8 | walker.bytes[walker.next++];
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "return: " + c2);
                        OracleLog.recursiveTrace = false;
                    }
                    int n2 = c2;
                    return n2;
                }
            }
            int c3 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (c3 > 127) {
                if (walker.bytes.length > walker.next) {
                    c3 = c3 << 8 | walker.bytes[walker.next];
                    ++walker.next;
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        CharacterSetZHTEUC.logger().log(Level.SEVERE, "Throwing SQLException: 182");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "return: " + c3);
                OracleLog.recursiveTrace = false;
            }
            int n3 = c3;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            int leadingCode = c2 >> 16;
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                CharacterSetZHTEUC.need(buffer, 4);
                for (int j2 = 0; j2 < 4; ++j2) {
                    buffer.bytes[buffer.next++] = (byte)c2;
                    c2 >>= 8;
                }
                return;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(Level.SEVERE, "Throwing SQLException: 181Failed to find valid leading code");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 181, "Failed to find valid leading code");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharacterSetZHTEUC.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetZHTEUC"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

