/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:19_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.physicalConnection == null) {
                try {
                    this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_30, "return: " + this.physicalConnection);
                OracleLog.recursiveTrace = false;
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.physicalConnection;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatumWithConnection(byte[] elements) throws SQLException {
        super(elements);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(elements));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatumWithConnection() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertNotNull(Connection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            if (conn == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68Connection is null");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 68, "Connection is null");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertNotNull(TypeDescriptor desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (desc == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(Level.SEVERE, "Throwing SQLException: 61");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 61);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalConnectionOf(Connection conn) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            this.physicalConnection = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getJavaSqlConnection() throws SQLException {
        oracle.jdbc.OracleConnection oracleConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                oracle.jdbc.OracleConnection __result__ = this.getPhysicalConnection().getWrapper();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        oracle.jdbc.OracleConnection oracleConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                oracle.jdbc.OracleConnection __result__ = this.getPhysicalConnection().getWrapper();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                oracle.jdbc.internal.OracleConnection __result__ = this.getPhysicalConnection();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnection getConnection() throws SQLException {
        OracleConnection oracleConnection;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                OracleConnection ret = null;
                try {
                    ret = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
                }
                catch (ClassCastException ex) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DatumWithConnection.logger().log(Level.SEVERE, "Throwing SQLException: 103");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 103);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            DatumWithConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "return: " + this.physicalConnection);
                OracleLog.recursiveTrace = false;
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.physicalConnection;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DatumWithConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.DatumWithConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

