/*--------------------------------------------------------------------------*
 * File Name: 	matrixObj.h													*
 * Purpose:		Demonstrate how to access an Origin matrix					*
 * Creation:	March 24, 2000												*
 * Copyright Microcal Software Inc. 2000									*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _MATRIXOBJ_H
#define _MATRIXOBJ_H

#include "mocamain.h"	// Required header file


//---------------------------------------------------------------------------
// Define main object class
//---------------------------------------------------------------------------
class CMatrixDemo : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties, methods or SubObjects
	MOCA_DECLARE_PROP_MAP(CMatrixDemo)

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CMatrixDemo)

	// Declare SubObject Map if object has LabTalk SubObjects
	//MOCA_DECLARE_SUBOBJ_MAP(CMatrixDemo)

public: // constructors and destructors
	CMatrixDemo();
	~CMatrixDemo();

private:
	CString		m_MatrixName;	// Property for storing the matrix name.

public: // member functions for handling LabTalk properties
	BOOL GetDataType(int &iVal);		// Get obj.DataType
	BOOL SetDataType(int iVal);			// Set obj.DataType
	BOOL GetNumColumns(int &iVal);		// Get obj.NumColumns
	BOOL GetNumRows(int &iVal);			// Get obj.NumRows
	BOOL GetXMin(double &dVal);			// Get obj.XMin
	BOOL GetXMax(double &dVal);			// Get obj.XMax
	BOOL GetYMin(double &dVal);			// Get obj.YMin
	BOOL GetYMax(double &dVal);			// Get obj.YMax

private: // member functions for handling LabTalk methods
	BOOL MethodGetValue(double &dReturn, CStringArray &argarray);		// obj.GetValue()
	BOOL MethodSetValue(double &dReturn, CStringArray &argarray);		// obj.SetValue()
	BOOL MethodGetRows(double &dReturn, CStringArray &argarray);		// obj.GetRows()
	BOOL MethodGetColumns(double &dReturn, CStringArray &argarray);		// obj.GetColumns()
	BOOL MethodSetDims(double &dReturn, CStringArray &argarray);		// obj.SetDims()
	BOOL MethodSetXY(double &dReturn, CStringArray &argarray);			// obj.SetXY()
	BOOL MethodFillValues(double &dReturn, CStringArray &argarray);		// obj.fill()
};

#endif //_MATRIXOBJ_H
