/*--------------------------------------------------------------------------*
 * File Name:	ScopeObj.h													*
 * Purpose:		Demostrate realtime update on a graph						*
 * Creation:	April 04, 2000												*
 * Copyright (c) 2000 Microcal Software, Inc.								*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _SCOPEOBJ_H
#define _SCOPEOBJ_H  

#include "mocamain.h" // Required header file
#include "ThreadSubObj.h"


//---------------------------------------------------------------------------
// CScopeObj (main object class)
//
//---------------------------------------------------------------------------
class CScopeObj : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties
	MOCA_DECLARE_PROP_MAP(CScopeObj);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CScopeObj)

	// Declare SubObject Map if object has LabTalk methods
	MOCA_DECLARE_SUBOBJ_MAP(CScopeObj)

public: // constructors and deconstructors
	CScopeObj();
	~CScopeObj();

private: // data members for LabTalk Properties

public: // member functions for LabTalk Properties
	BOOL GetNumPoints(int &iValue);
	BOOL SetNumPoints(int iValue);

	BOOL GetWksName(LPSTR lpstr);
	BOOL SetWksName(LPCSTR lpcstr);

private: // member functions for LabTalk Methods

public: // data members for LabTalk subobjects
	CThreadSubObj m_ThreadSubObj;
};


//---------------------------------------------------------------------------
// Error Codes:
//
// The 'MoDLL' library has a centralized system for storing error messages.
// You can store up to MAX_NUM_ERRORS error messages at one time.  Each error
// is stored in one object of the type 'MoError'.  The entry contains two
// pieces of information:
//		1) Error Code
//      2) The name of the class that produced the error
//
// The way error messages are sent to the MoDLL library is demonstrated in
// the 'Process' functions for the methods in this example.
//
// The errors beyond MAX_NUM_ERRORS overwrite the previously stored errors. 
//
// You can list all the error messages currently stored in your object by
// issuing the command 'objname.listerr();' in the script window, where
// 'objname' is the name which you associate with your DLL when loading the
// library from script.
//
// You can get the Id of the last error stored by issuing the command
// 'objname.lasterrid()=;' in the script window.  The best way to define the
// Id's for your errors is with the help of an enumeration, as shown below.
// Your error ids should start from a number which will not cause conflict
// with other messages.
//---------------------------------------------------------------------------
#define		SCOPE_ERROR		1500       
enum
{
	SCOPE_COMMON_ERROR = SCOPE_ERROR,
	SCOPE_INVALID_DATASET_NAME_ERROR, 
	SCOPE_DATA_NAME_EMPTY_ERROR,

	SCOPE_APPENDXY_WKS_NAME_ERROR,
	SCOPE_APPENDXY_NPTS_TOO_FEW,
	SCOPE_APPENDXY_NPTS_TOO_MANY,

	SCOPE_DOTHREAD_INVALID_ACTION,
	SCOPE_DOTHREAD_CANNOT_CREATE_THREAD,
	SCOPE_DOTHREAD_INVALID_PRIORITY_LEVEL,
};
 


#endif //_SCOPEOBJ_H
