/*--------------------------------------------------------------------------*
 * File Name:	ThreadSubObj.h												*
 * Purpose:		Demostrate realtime update on a graph						*
 * Creation:	April 04, 2000												*
 * Copyright (c) 2000 Microcal Software, Inc.								*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _THREADSUBOBJ_H
#define _THREADSUBOBJ_H  

#include "mocamain.h" // Required header file


//---------------------------------------------------------------------------
// The thread status:
//---------------------------------------------------------------------------
#define DOTHREAD_STATUS_RUNNING				1
#define DOTHREAD_STATUS_SUSPENDED			2
#define DOTHREAD_STATUS_NOT_PRESENT			3
#define DOTHREAD_STATUS_INVALID				4

#define IS_THREAD_RUNNING(status)			(status == DOTHREAD_STATUS_RUNNING)
#define IS_THREAD_SUSPENDED(status)			(status == DOTHREAD_STATUS_SUSPENDED)
#define IS_THREAD_STARTED(status)			(IS_THREAD_RUNNING(status) || IS_THREAD_SUSPENDED(status))

//---------------------------------------------------------------------------
// The thread's priority level (0 - 6)
//---------------------------------------------------------------------------
#define DOTHREAD_PRIORITY_NORMAL		3
#define DOTHREAD_PRIORITY_MAXIMUM		6


//---------------------------------------------------------------------------
// CSubObjThread
//
//---------------------------------------------------------------------------
class CThreadSubObj : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties
	MOCA_DECLARE_PROP_MAP(CThreadSubObj);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CThreadSubObj)

public:
	CThreadSubObj();
	~CThreadSubObj();

	UINT Run();

public: // data members for LabTalk properties
	CString m_strWksName;				// obj.WksName
	int m_iNumPoints;					// obj.NumPoints
	int m_iPriority;					// obj.Thread.Priority
	int m_iStatus;						// obj.Thread.Status

public: // member functions for LabTalk properties
	BOOL GetPriority(int &iValue);
	BOOL SetPriority(int iValue);

	BOOL GetStatusStr(LPSTR lpstr);

public: // member functions for LabTalk methods
	BOOL Meth_Start(double &dValue, CStringArray &strArgArray);
	BOOL Meth_Suspend(double &dValue, CStringArray &strArgArray);
	BOOL Meth_Resume(double &dValue, CStringArray &strArgArray);
	BOOL Meth_Kill(double &dValue, CStringArray &strArgArray);

public:
	CWinThread *m_pThread;
	BOOL m_bKill;
};

#endif // _THREADSUBOBJ_H
