/*--------------------------------------------------------------------------*
 * File Name:	ScrollObj.h													*
 * Purpose:		Demostrate realtime update on a graph						*
 * Creation:	April 04, 2000												*
 * Copyright (c) 2000 Microcal Software, Inc.								*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _SCROLLOBJ_H
#define _SCROLLOBJ_H  
//---------------------------------------------------------------------------
//								top of file
//---------------------------------------------------------------------------

#include "mocamain.h" // Required header file
#include "ThreadSubObj.h"


//---------------------------------------------------------------------------
// CScrollObj (main object class)
//
//---------------------------------------------------------------------------
class CScrollObj : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties
	MOCA_DECLARE_PROP_MAP(CScrollObj);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CScrollObj)

	// Declare SubObject Map if object has LabTalk methods
	MOCA_DECLARE_SUBOBJ_MAP(CScrollObj)

public: // constructors and deconstructors
	CScrollObj();
	~CScrollObj();

private: // data members for LabTalk Properties

public: // member functions for LabTalk Properties
	BOOL GetNumPoints(int &iValue);
	BOOL SetNumPoints(int iValue);

	BOOL GetMaxNumPoints(int &iValue);
	BOOL SetMaxNumPoints(int iValue);

	BOOL GetWksName(LPSTR lpstr);
	BOOL SetWksName(LPCSTR lpcstr);

private: // member functions for LabTalk Methods

public: // data members for LabTalk subobjects
	CThreadSubObj m_ThreadSubObj;
};

//---------------------------------------------------------------------------
//								end of file
//---------------------------------------------------------------------------
#endif //_SCROLLOBJ_H
