/*------------------------------------------------------------------------------*
 *	File Name: 	orgdll.h     													*
 *	Purpose:	Origin and DLL interface constants and other def   				*
 *   	Date:		1/1/92														* 
 *  	Copyright Microcal Software Inc. 1992-1995								*
 *	Modification log                                                        	*
 *		SB v3.77 add WCB_DATA_SET_NO_X  and WCB_DATA_CLEAN_TEMP_DATASET			*
 *		STH v3.78 4/4/95 FIND_INI written qcao added by sth						*
 *	CPY v3.781 add WCB_DATA_GET_RAW_VALUE										*
 *	CPY v3.781 copied over Dr. Cao's changes in /// QZCao v3.78, March,20,95	*
 *	CPY v3.781 copied over Dr. Cao's changes in /// QZCao v3.78, March 19, 95	*
 *	CPY v3.781 removed STH v3.78 4/4/95 FIND_INI, as it has already been added	*
 *		by Dr. Cao in March 20													*
 *	QZCao v3.782, 4/13/95, Added WCB_STATUS_MSG, it will replace				*
 *		WCB_DATA_MSG_STATUS eventually.											*
 *	CPY v3.782 add WCB_DATA_GET_COL_ID 4/14/95									*
 *	QZCao v3.782, 4/24/95 WCB_DATA_CHECK_RANGE2, similar to WCB_DATA_CHECK_RANGE*
 *		to be merged in the future.												*
 *	QZCao, v3.782, 4/24/95, added WCB_DATA_CREATE_DATA to create all types of 	*
 *		datasets																*
 * 	QZCao, V3.7841, 5/12/95, WCB_GET_DOUBLE_VALUE, get double value				* 
 *	QZCao, v3.8, 7/18/95, WCB_CAL_EXPRESSION, cal expression					*
 *	QZCao, v3.8, 7/20/95, add label to plot and type to script, WCB_ADD_LABEL,	*
 *		WCB_TYPE_SCRIPT															* 
 *	QZCao, v3.8, WCB_DATA_GET_XY_RANGE, get dataset both x & y range			*
 *	QZCao, v3.8, 7/21/95, del a variable, WCB_DEL_VARIABLE:						*
 *	CPY v3.8 INTERIM_MODATA 6/25/95, add SET_XY_VALUE as needed in MoData 		*
 *	CPY v3.8 WCB_DATA_CHECK_INC 8/3/95, check dataset instead of X dataset		*
 *	QZCao, v3.8, 8/14/95, get init path,	WCB_GET_INI_PATH					*
 *	QZCao, v3.8, 8/21/95, get window name and ptr WCB_GET_WIN_NAME & 			*
 *		WCB_GET_WIN_ID 															*
 *	QZCao, v3.8, 8/23/95, load a dll in origin standard way	WCB_LOAD_DLL:		*
 *  ML v3.821 8/30/95 ONE_DATASET_ONLY											*   
 *	jliu v3.83 	9/7/95, MATRIX_SET                                       		*
 *	QZCao, v3.83, 9/19/95, set modaless:WCB_SET_MODALESS						*
 *  ML v3.84 9/25/95 KILL_DATASET_TOGETHER_WITH_ITS_DEPENDENT                   *
 *	CPY v3.84 CPP_UPDATE, make this file includable in cpp files				*
 *  ML v3.840 10/13/95 WCB_GET_DLL_PATH                                         *
 *	QZCao, v3.85, 10/31/95, WCB_DLL_BALOON 										*
 *  ML v3.850 11/1/95 REMOVE_COMMENTS                                           *
 * QZCao, 11/6/95, v3.85, GET_X_COL_VAL_IN_PLOT									*
 *  ML v3.97 12/11/95 WCB_DATA_IS_TEXT_DATASET                                  *
 *  ML v3.970 12/11/95 TEXT_DATASET_VALUE                                       *
 *	DSB v3.980 12/15/95 TITLE_DEFS												*
 *  ML v3.980 1/4/96 MOMASK_IMPLEMENTATION                                      *
 *	CPY v3.98 VECTOR_ASSIGNMENT                                                 *
 *	CPY v3.98 1/15/96 EGO_MESSAGE                                               *
 *  ML v3.980 1/15/96 WCB_DATA_GET_COL_FROM_COLNAME								*
 *	CPY v3.98 1/16/95 EGO_MSG_CONSISTANT										*
 *  ML v3.980 1/17/96 WCB_WKS_GET_NUM_COLS										*
 *  ML 3.981 1/23/96 MOVED_FROM_MARK_H_TO_ORGDLL_H								*
 *  ML v3.981 1/23/96 WCB_DATA_GET_NUM_VALUE_AS_TEXT							*
 *  ML v4.00 1/25/96 TO_PROVIDE_COMMUNICATION_WITH_LABMASK						*
 *	CPY v4.01 2/13/96 MERGE_CONTOUR_3D_COLOR	                                *
 *	JL  v4.03 3/5/96  DEFINE_O_CALLBACK											*
 *	CPY v4.05 3/8/96 WCB_WKS_HANDLING											*
 *  ML v4.08 4/7/96 STORE_GAPSIZE_IN_MEMORY_OBJECT								*
 *	sth v4.08 4/8/96 DOUBLE_ANOVA_WKS											*
 *  ML v4.08 4/11/96 NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS*
 *  ML v4.08 4/12/96 STORING_NAMES_OF_SUBJECT_AND_RESPONSE_COLUMNS				*
 *	ML v4.08 4/17/96 STORE_THE_NAME_OF_THE_SECOND_FACTOR_COLUMN					*
 *	EJP v4.08 04-19-96 WCB_GET_CTRL_HWND										*
 *	ML 4/20/96 ONE_WAY_MEMORY_OBJECT_FOR_ONEWAY_REPEATED_MEASUREMENT_PURPOSES 	*
 *	ML v4.09 4/26/96 MOVED_TO_PSDLL_H											*
 *	ML 5/1/96 GET_COLUMN_LABEL													*
 *	ML v4.090 5/3/96 VARIOUS_WORKSHEET_MANIPULATIONS 							*
 *	ML v4.090 5/17/96 CREATE_NEW_EMPTY_WORKSHEET								*
 *	ML v4.090 5/17/96 DESTROY_WORKSHEET											*
 *	ML v4.090 5/17/96 RANK_ONE_DATASET											*
 *	ML v4.090 5/19/96 VARIOUS_COLUMN_SETTINGS									*
 *	ML v4.090 5/19/96 CREATE_DATA_AND_PLOT										*
 *	sth v4.09 5/21/96 REMOVING_DOUBLE_EGO_CMD_DEFINITION						*
 *	ML v4.090 5/22/96 MORE_WORKSHEET_STUFF										*
 *  ML v4.090 5/23/96 CREATE_NON_EMPTY_WORKSHEET_ON_OPTION                      *
 *	ML v4.090 5/24/96 SET_COLUMN_NAME											*
 *  YN v4.090 5/28/96 SET_WKS_LABEL                                             *
 *	EJP v4.09 05-29-96 WNDBASED_UIM_OBJ_EVENTS, define WCB_EVENT_WNDBASED		*
 *	ML 6/3/96 SET_COLUMN_TYPE_AS												*
 *	CPY v4.10 6/10/96 WKS_DLL_MODIFICATION_SUPPORT								*
 *  YN  v4.10 6/14/96  ADD_GetColumnWidth_FUNCTIONS                             *
 *	ML v4.10 6/18/96 GET_COLUMN_TYPE											*
 *	ML v4.11 7/1/96 MOVED_FROM_COMMON_H_TO_ORGDLL_H_SO_THAT_STSDLL_CAN_ACCESS_IT*
 *	ML v4.11 7/1/96 SHOW_WORKSHEET_NAME_LABEL_OR_BOTH							*
 *	ML v4.11 7/8/96 CHANGE_OFFSET (only comment changes)						*
 *	CPY v4.133 8/29/96 WCB_FRAME_ACCESS											*
 *	ML v4.133 8/30/96 FRAME_AND_MEMORY_OBJECT_ACCESS							*
 *	ML v4.133 9/5/96 CREATE_NEW_GRAPH											*
 *	ML v4.133 9/5/96 CREATE_ONE_TEMPORARY_SERIES								*
 *	ML v4.133 9/6/96 PLOT_TYPES_AND_STRUCTURE									*
 *	CPY v4.133 9/9/96 CREATE_TEXT_LABEL											*
 *	ML v4.133 9/24/96 EXE_CALLING_DLL_FOR_GRAPH									*
 *	ML v4.133 9/27/96 IDS_OF_BASIC_POWERSTAT_METHODS							*
 *	ML v4.133 9/27/96 WCB_POWERSTAT_GET_TEMPLATE_PATHS							*
 *  YN  11/18/96  ADD_CONDITIONAL_COMPILATION									*
 *	ANU v4.14 12/23/96 SETCOLUMNTITLE, new public function in Mowks class		*
 *	CPY v4.97 3/11/97 TEST_CELL_NUMERIC_OR_NOT									*
 *	ANU	v4.97 03/19/97 MOVE_DISK_OBJ_TO_UIM										*
 *	ANU v4.979 4/25/97 CREATE_OBJ												*
 *  JLIU nad DSC v4.982 5/7/97 MOVE_FROM_ORGDLL_TO_MODLL for the ati dll		*
 *	sth v4.982 b2083 5/7/97 RIGHT_MOUSE_DOWN_CODE_BLOCK							*
 *	ANU v4.983 5/9/97 CREATE_OBJ_STRUCT_MEMORY									*
 *	YL CPY v4.983 5/9/97 ADD_SET_LABEL_FROM_ID									*
 *  YN v4.986 5/16/97 CHECK_USING_SYSTEM_VARIABLES_IN_NLSF						*
 *	HYYU v4.997 t2341 DISABLE_OR_ENABLE_LABEL_WORKSHEET_EDIT					*
 *	CPY v4.9994 b2800 7/23/97 LAYER_NUMBER_ACCESS_FROM_WCB						*
 *	HYYU v4.9994 t1462 CHANGE_NUMERIC_FORMAT_FROM_WCB							*
 *	CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS							*	
 *	CPY v5.002 7/30/97 b2869 X_RANGE_FOR_X_DATASET								*
 *	CPY v5.004 8/4/97 t2897 FDLOG_SETDEFAULT_MUST_ALWAYS_SET_PATH				*
 *	CPY v5.005 8/5/97 FITTER_HELP_TO_GENERAL_CONTENTS							*
 *	CPY v5.028 11/24/97 b3252 STAT_NAME_COUNT_INDEP_DATASET						*
 *	CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE							*
 *	CPY v5.039 b3558 REALTIME_DRAW_BUFFERRING									*
 *	ML 3/23/98 OK_NEW_COLORMAP_FOR_CONTOUR										*
 *	ML 7/20/98 SCRIPT_RESOURCE_DLL_DIALOGS										*
 *	RB 9/15/98 v6.0129 t4194 FFT_EXPONENT_SIGN_CHOICE							*
 *	GCJ 11/6/98 t4423 v6.0136 WRONG_STEREO_WAVEFILE_IMPORT						*
 *	CPY v6.0142 t4628 12/7/98 READ_ONLY_LAYER									*
 *	DVT 3/1/99 v6.0169 t5373 AVAILABLE_SERIES_FROM_CUR_FOLDER					*
 *	GCJ 3/4/99 t5510 v6.0169 ENUMERATE_WORKSHEET_PROPERTY						*
 *	ML 4/19/99 t4345 ADDING_SUPPORT_FOR_SCRIPT_BASED_RESOURCE_DLLS				*
 *	CPY v6.0187 4/22/99 OPP_SCOPE_MODE											*
 *	ML 5/25/99 WCB_MESSAGE_FOR_GETTING_EMF										*
 *	SFX 6/15/99 ADD_ENTRY_TO_RESDLL												*
 *	RB 6/21/99 CALLING_OBJFUNCTIONS_FROM_OBJVECTORS								*
 *	ML 8/13/99 t6811 LABTALK_VARIABLENAME_CHECKING								*
 *	RB 8/20/99 INITIALIZE_SCRIPT_RESOURCE_DLL									*
 *  IV 9/7/99 t6811 ADD_FOR_LABTALKEDITOR                                       *
 *	EJP 09-21-99 t6660 MOCA_NEED_ABILITY_TO_SET_DOUBLE_VALUES					*
 *  IV 10/4/99 t6811 ADD_FOR_LABTALKEDITOR_BREAKPTS                             *
 *	ML 10/11/99 v6.0234 t6995 PROPER_DECIMAL_CHARACTER_WHEN_USING_GERMAN_SETTING_INSIDE_CRT_LIBRARY
 *	RB 10/19/99 t2289 v6.0235 SET_HORIZONTAL_SCROLL_SIZE_FOR_LISTBOX			*
 *  IV 10/4/99 t6811 ADD_FOR_LABTALKEDITOR_GET_PATH                             *
 *	EJP	11-29-99 v6.0240 t6662 SET_MATRIX_DATA_TYPE_FROM_MOCA_DLL				*
 *	RB 12/8/99 v6.0244 CLOSE_DDK_DIALOGS_BEFORE_CLOSING_ORIGIN					*
 *	RB 12/10/99 t7244 v6.0245 SHOW_HIDE_DDK_TOOLS_ON_MDI_SWITCH					*
 *	EJP 02-01-2000 v6.0254 EXPORT_GRAPH_TO_PDF_AS_BITMAP						*
 *  IV 2/7/2000 ADD_FOR_LABTALKEDITOR_SET_FUNCTION_PTR							*
 *	TD	03-07/2000 MOVED_CONSTANTS_FROM_LAGOBJ_H_TO_ORGDLL_H					*   
 *	TD 4/19/2000 t7588	CRASH_WITH_TOO_MANY_COLUMNS_IN_CREATE					*
 *	CPY v6.0287 6/3/00 8072 INCREASE_SCRIPT_BUFFERS_CLEANUP						*
 *  IV 6/19/2000, t7996, v6.0291 EXPORT_USERDEF_CATEGORY                        * 
 *	CPY v6.0297 t8155 7/5/00 MORE_EFFICIENT_DATASET_ACCESS_FROM_MOCA			*
 *	CPY 8/8/00 t8321 v6.1022 WCB_FOR_LAYER_GR_TEXT_LABEL_ACCESS					*
 *	TD 8/11/2000 t8358 v6.1022 WCB_FOR_WKS_DISPLAY_PROPERTIES					*
 *	EJP 08-15-2000 t8153 v6.1026 WCB_GET_USER_INFO								*
 *	DSC 08-28-2000 v6.1037 ADD_ORIGIN_TYPE_LEASED								*
 *	CPY v6.1046 9/8/00 t8539 NEED_COLUMN_PLOT_AS_IN_WCB							*
 *	TD 12/08/2000 v6.1073 t8767 WCB_TO_INTERUPT_SERIES_DELETION					*
 *	CPY 3/12/01 t8965 v6.1100 WCB_GET_FUNC_POINTERS_FOR_SERIES_ELEMENTS			*
 *	CPY 3/15/01 7.0 PRINT_STRING												*
 *	CPY 3/20/01 t8928 COMPILE_USER_DEFINED_FIT_FUNC								*
 *	TD 4/3/01 t9034	OVECTOR_SUPPORT												*
 *	ML 4/18/2001 VARIABLE_ARG_LIST_CALLS										*
 *  IV 4/30/2001	MOVE_DEFINES_FOR_OKRESPR_PROJECT_CUSTOM_CTRL                *
 *	TD 5-16-01	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC							*
 *	CPY t9154 5/26/01 COMPILE_PARA_INIT											*
 *	CPY 7/10/01 t9307 FILE_LINE_SUPPORT_IN_MACRO								*
 *	CPY 8/13/01 t9329 v6.9071 LOAD_WORKSPACE									* 
 *	EJP 08-16-2001 v6.9069 t9177 ADD_LABTALK_IMPORT_BMP_TO_LAYER				*
 *	EJP 10-24-2001 v6.9108 t9637 IMPORT_IMAGE_TO_GR_OBJECT						*
 *	TD 10-29-01	CATEGORICAL_DATA												*
 *	EJP 11-02-2001 v6.9114 t9518 COPY_PROTECT_MODULES							*
 *	TD 11-05-01 t9676 OGS_SECTIONS_ONACTIVATE_ONDEACTIVATE						*
 *	CPY 11-10-2001 v6.9122 MATRIX_Z1_Z2_CONTROL									*
 *	CPY 11/12/01 v6.9122 MATRIX_IMPORT_AS_DATA_WHEN_VIEW_IMAGE					*
 *  IV 11/21/2001 t9696 ADD_FITTING_FUNCTIONS_FROM_SCRIPT                       *
 *	CPY v6.9139 11/29/01 t9756 MATRIX_FROM_LAYER								*
 *  LY	11/29/01 REMOVE_USER_BTN_FROM_CODE										*
 *	LY	12/14/01 t9798 SERIESPTR_MANAGER										*
 *	LY	1/9/02	ACCESS_OKU_BROWSE_FOR_FOLBER_FUNCTION							*
 *	LY  1/9/02  IMPROVE_GET_USER_INFO											*
 *	SFX 1/16/2002 QA70_388 ADD_ONLAYERACTIVATE_EVENT_TO_DDK						*
 *	LY	1/18/02 QA70-414 CREATE_INVISIBLE_TEXT_OBJ								*
 *  IV 1/22/2001 QA79-468 ENUMERATE_VAR_COVAR_MATRIX_FOR_NLSF					*
 *	RVD 1/24/2002 QA70-525 v6.9192 IMPLEMENT_VERBATIM_TEXT						*
 *	TD 1-29-02 QA70-592 v6.9197 PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL	*
 *	SFX 1/30/2002 ADD_ONDATASETACTIVATE_EVENT_TO_DDK							*
 *	EJP 02-27-2002 QA70_985 ENABLE_SOFTDEV_PDF									*
 *	TD 3-13-02 t1081 INDEPENDENT_FLAGS_REMOVE_AMBIGUITY							*
 *	ML 3/18/2002 t9975, QA70-1124 ALLOW_MATRIX_SIZE_OVER_TWO_BYTES				*
 *	TD 3-19-02 WCB_TO_SET_IMAX_WITH_REDRAW_OPTIONS								*
 *	TD 3-27-02 UPDATE_MUST_UNLOCK_HANDLE										*
 *	RVD 4/1/2002 t1309 v7.0262 IMPROVE_DEBUG_ORIGIN_C_LABTALK					*
 *	TD 4-16-02 ADD_EFFICENT_ONIDLE_FOR_DDK_DIALOG_CASHED_FROM_OGS_SECTION		*
 *	YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT						*
 *	CPY IV 4/24/2002 COPY_NLSF_FUNCS_TO_CLIENT_ON_USE							*
 *	YuI 4/24/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT						*
 *	YuI 5/01/02 v7.0298 QA70-1654 NLSF_BUTTON_FOR_CODE_BUILDER					*
 *	YuI 5/06/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION				*
 *	YuI 5/21/02 v7.0307 QA70-1649 NLSF_FUNCTION_EDIT_VIEW						*
 *	YuI 6/10/02 v7.0314 QA70-2020 INTERFACE_CLASS_NLSFMANAGER					*
 *	YuI 6/11/02 v7.0317 QA70-2035 UI_TWEAK_FOR_NLSF_COMPILED_FUNCTIONS			*
 *	YuI 6/14/02 v7.0320 NEED_TO_PASS_BRIEF_DESRIPTION_TO_CODE_BUILDER			*
 *	YuI 6/18/02 v7.0324 QA70-1861 NLSF_ANALYTIC_DERIVATIVES						*
 *	YuI 7/3/02 v7.0336 QA70-2216 READ_ONLY_PARA_INIT							*
 *	RVD 7/19/2002 QA70-1860 v7.0346 NLSF_BETTER_ADD_FUNCTION					*
 *	TD 7-24-02 QA70-2439 v7.0348 RELATIVE_FOR_BMP_AND_THROW_AWAY_BS_OGS			*
 *  CPY 8/5/02 QA70-2436 v7.0363 OPS_FILE_NAME_SHOULD_BE_SET_BY_USER			*
 *	YuI 9/27/02 v7.0406 QA70-3066 DISPLAY_NAME_IMPLEMENTATION					*
 *	YuI 10/1/02 v 7.0408 QA70-3074 UID_FOR_SERIES_POINTER						*
 *	TD 10-15-02 QA70-3150 v7.0413  MSG_TO_INITIALIZE_CUSTOM_DLL_AFTER_CREATION	*
 *	YuI 10/15/02 v7.0415 QA70-3087 COLUMN_FORMULA_AUTOMATION					*
 *	TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS					*
 *	YuI 11/5/02 v7.0427 QA70-3272 UID_FOR_FRAME_GRAPH_OBJ						*
 *	YuI 11/12/02 v7.0436 QA70-3341 BASE_CLASS_FOR_ALL_FUTURE_OBJECTS			*
 *	CPY 11/18/02 v7.0428 QA70-3213  ADD_FONT_INIT_TO_TREE_EDITOR				*
 *	YuI 12/31/02 QA70-3592 v7.0477 ORIGIN_C_AND_INTERNAL_DATA_PROTECTION		*
 *	YuI 1/16/03 v7.0489 QA70-3698 COLUMNS_DESIGNATIONS_FOR_WORKSHEET_CLASS		*
 *	YuI 1/20/03 v7.0492 QA-3641 ADDITIONAL_EDITABLE_PART_TO_FITTING_FUNCTION	*
 *	CPY 1/28/03 QA70-3796 v7.0500 COL_CHANGE_NOTIFICATIONS						*
 *	YuI 2/26/03 QA70-3975 v7.0523 GUI_CONTROL_FOR_INCREMENTOR					*
 *	RVD 3/10/2003 QA70-4031 v7.0532 DISPLAY_INC_ARRAY							*
 *	CPY 4/16/03 QA70-4601 v7.0564 OC_ADD_PLOT_KEEP_CURVE_X						*
 *	DVT 5/27/03 QA70-4433 v7.0580 DELETE_OPERATION_WITH_WKS_OPTION				*
 *	ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS				*
 *  SY 06-11-2003 QA70-3774 v7.0601 CHECK_FOR_UPDATES_FOR_CLIENTS				*
 *  SY 06-16-2003 QA70-4469 v7.0603 ADD_TITLESHOW_PROPERTY_FOR_PAGE				*
 *	TD 7-22-03 QA70-4868 DISPLAY_POINTERS_AND_WINDOW_OBJECTS					*
 *	TD 11-6-03 QAx70-5481 PARTIAL_DETACH_MOCA_ON_TYPE_CANGE						*					
 *	ML 11/12/2003 QA70-3921 PROPER_BITMAP_SIZE_FOR_RASTER_EXPORT				*
 *------------------------------------------------------------------------------*/      

#ifndef _ORGDLL_H

#define	_ORGDLL_H

#ifdef	__cplusplus
extern "C" {
#endif
   

#ifndef	NAME_SIZE
//-------------- CPY v6.0287 6/3/00 t8072 INCREASE_SCRIPT_BUFFERS_CLEANUP
//#define MAXLINE		80
#define MAXLINE		120
//-------------- end CPY v6.0287 6/3/00 t8072 INCREASE_SCRIPT_BUFFERS_CLEANUP
#define NAME_SIZE	25
#endif    //NAME_SIZE
///ANU v4.983 5/9/97 CREATE_OBJ_STRUCT_MEMORY
#define SNAME_SIZE		NAME_SIZE
#ifndef WKS_NAME_SIZE
	//---------------- CPY v6.0297 7/5/00 WKS_NAME_SIZE_CLEAN_UP
	//#define WKS_NAME_SIZE	12
	#define WKS_NAME_SIZE	13
	//----------------
#endif // WKS_NAME_SIZE
///

#ifndef USHORT
#define	ULONG		DWORD
#define	USHORT		WORD
#endif

/// CPY v3.74
#ifndef	X_AXIS
	#define	X_AXIS	0x0002
	#define	Y_AXIS	0x0004
#endif


#ifndef	NANUM	/* the missing value */
#define	NANUM		(-1.23456789E-300)
#endif

/// JL  v4.03 3/5/96  DEFINE_O_CALLBACK	 consistence with ScriptCallBack in ToolBar.c
typedef DWORD (CALLBACK*      O_CALLBACK)(HWND,UINT,WPARAM,LPARAM);
///


/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
#ifdef		__EXTENDED_CURVE_CLASS_WITH_RELATED__
enum {
	EXTCURVEREL_INVALID = 0,
	
	EXTCURVEREL_Y,
	EXTCURVEREL_X,
	EXTCURVEREL_Z,
	
	EXTCURVEREL_Y_ERROR = 6,	// leave room just in case
	EXTCURVEREL_X_ERROR,
	EXTCURVEREL_Y_PLUS_ERROR,
	EXTCURVEREL_Y_MINUS_ERROR,
	EXTCURVEREL_X_PLUS_ERROR,
	EXTCURVEREL_X_MINUS_ERROR,
	
	EXTCURVEREL_Z_ERROR,
	EXTCURVEREL_Z_PLUS_ERROR,
	EXTCURVEREL_Z_MINUS_ERROR,
};

#endif		// __EXTENDED_CURVE_CLASS_WITH_RELATED__


typedef	struct	tagOSERIESTAG
{
	DWORD	dwSeriesPtr;
	UINT	nType;			// from EXTCURVEREL_* enum 
} OSERIESTAG,	*POSERIESTAG;



/// end CURVE_EXTENSION_WITH_RELATED_DATASETS



//------------- CPY 8/13/01 t9329 v6.9071 LOAD_WORKSPACE
#ifndef OC_WORKSPACE_EXT
#define OC_WORKSPACE_EXT	"ocw"
#endif //OC_WORKSPACE_EXT
//-------------
/* 
 * Messages sent to Origin to get access
 * to Origin's data
 * 
 */

#define	WM_DLL_BEGIN		(WM_USER+100)

#define WM_DLL_OPEN_DATA	(WM_DLL_BEGIN+ 1)
	/* return FAR pointer to beginning of data
	 * double only
	 */
	 
#define	WM_DLL_GET_RANGE		(WM_DLL_BEGIN + 2)
	/* return in LoWord the beginning index and
	 * in HiWord the end index.
	 * These are C type index so they start from
	 * zero and end at the next element. 
	 * LabTalk index starts at 1 and end at the
	 * end element.
	 */

#define	WM_DLL_GET_RANGE_EXT		(WM_DLL_BEGIN + 3)

#define	WM_DLL_GET_SIZE			(WM_DLL_BEGIN + 4)
	/* return data element size in loword
	 * 8 = double, 4 = float
	 * hiword is non zero if not real numbers 
	 */
	 
#define WM_DLL_CLOSE_DATA		(WM_DLL_BEGIN + 11)
	/* close the data set specified by the string
	 * pointed to by lParam.
	 * Update the data if wParam == 1.
	 */

#define	WM_DLL_OPEN_MATRIX		(WM_DLL_BEGIN + 13)
	/* similar to OPEN_DATA but also
	 * setup a matrix for DLL control
	 * return FAR pointer to beginning of matrix
	 * data array.
	 * lParam = (LPSTR)matrix_name
	 */

/// EJP	11-29-99 v6.0240 t6662 SET_MATRIX_DATA_TYPE_FROM_MOCA_DLL
#define WM_DLL_MATRIX_GET_DATATYPE (WM_DLL_BEGIN + 14)
#define WM_DLL_MATRIX_SET_DATATYPE (WM_DLL_BEGIN + 15)
// internal data type is the same as the dropdown list in column dialog
// 0 = double, 1 = float, 2 = short int, 3 = long int

/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
#define WM_DLL_MATRIX_SWITCH_DATATYPE (WM_DLL_BEGIN + 16)
/// end MULTIFRAME_TIFF_IMPORT

//-------- CPY 11/12/01 v6.9122 MATRIX_IMPORT_AS_DATA_WHEN_VIEW_IMAGE
// add flag for additional meanings
#define WM_DLL_MATRIX_SET_DATATYPE_BITS		0x00FF
#define SET_DATATYPE_WPARAM_INIT_SHOW_DATA	0x4000

/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
#define SET_DATATYPE_WPARAM_SYNCHRONIZE		0x8000//relates to MoMatrix defines id SetInternalDataType should set data type to all objects in matrix layer
/// end MULTIFRAME_TIFF_IMPORT

//-------- end CPY 11/12/01 v6.9122 MATRIX_IMPORT_AS_DATA_WHEN_VIEW_IMAGE
/// end SET_MATRIX_DATA_TYPE_FROM_MOCA_DLL
	 
#define	WM_DLL_CLOSE_MATRIX		(WM_DLL_BEGIN + 18)
	
#define	WM_DLL_OPEN_WKSHEET		(WM_DLL_BEGIN + 20)
	/* worksheet name in lParam
	 * wParam = 0
	 */
///HYYU v4.997 t2341 DISABLE_OR_ENABLE_LABEL_WORKSHEET_EDIT	
#define WM_DLL_UPDATEEDIT_WKSHEET	(WM_DLL_BEGIN + 21)
	/* worksheet name in lParam
	 * wParam is the value of worksheet editable
	 */
///end DISABLE_OR_ENABLE_LABEL_WORKSHEET_EDIT 

#define	WM_DLL_WKS_COL_NAME		(WM_DLL_BEGIN + 22)
	/* get name of column specified by wParam
	 * lParam must point to a buffer to receive the
	 * the name, which has a maximum size of NAME_SIZE
	 */

#define	WM_DLL_MATRIX_GET_DIM		(WM_DLL_BEGIN + 24)
	/* get Ncols x Nrows of the opened matrix
	 * reutrn MAKELONG(nCols,nRows)
	 */

#define	WM_DLL_MATRIX_GET_XY		(WM_DLL_BEGIN + 25)
	/* get matrix X and Y boundaries
	 * wParam is ingored and must be set to zero
	 * lParam is LPDOUBLE to x1,y1,x2,y2
	 */
	 
#define	WM_DLL_WKS_OPEN_COL		(WM_DLL_BEGIN + 26)
	/* Similar to WM_DLL_OPEN_DATA
	 * If lParam == NULL opens the column specified
	 * by wParam (1,2,3..)
	 * If lParam != NULL, opens the column 
	 * specified by the string in lParam, which
	 * can be either the name of the column or
	 * the numeric string for the column number.
	 */
	 
#define	WM_DLL_WKS_CLOSE_COL	(WM_DLL_BEGIN + 27)
	/* Similar to WM_DLL_CLOSE_DATA
	 * The interpretation of lParam is the same
	 * as WM_DLL_WKS_OPEN_COL, but only the
	 * LOBYTE of wParam is used for column number
	 * if lParam == NULL.
	 * the HIBYTE is used to indicate updating of the
	 * column.
	 */
#define	WM_DLL_WKS_SETRANGE		(WM_DLL_BEGIN + 30)
	/* MAKELONG(i,i2) as lParam */

#define	WM_DLL_WKS_PUT_DATA		(WM_DLL_BEGIN + 32)
	/* use the DataWorksheet format to set worksheet data
	 * lParam == LP to DataWorksheet structure
	 * wParam is ignored and must set to zero
	 */
	 
#define	WM_DLL_PASTE_ASCII		(WM_DLL_BEGIN + 35)

#define	WM_DLL_WKS_SET_ROW		(WM_DLL_BEGIN + 40)
	/* set current row, this is for accessing the worksheet
	 * row by row.
	 * row number is in wParam, lParam must be NULL
	 */

#define	WM_DLL_WKS_GET_CELL		(WM_DLL_BEGIN + 42)
	/* get cell content in the current row and the
	 * specified column (wParam)
	 * lParam must point to a buffer to receive the
	 * the content, which has a maximum size of MAXLINE
	 */

#define	WM_DLL_WKS_CREATE_OBJ	(WM_DLL_BEGIN + 44)
	/* create a memory object in the open worksheet
	 * with a name and specified size.
	 * lParam = LPSTR to the name of the obj, must be less than 8 chars
	 * wParam = intended size of the object.
	 *
	 * returns 1 if error, 0 if obj is created.
	 * obj must be open before use and close after use
	 */

/// CPY 4/12/94 v3.31
#define	WM_DLL_CREATE_OBJ	WM_DLL_WKS_CREATE_OBJ
#define	WM_DLL_OPEN_OBJ	WM_DLL_WKS_OPEN_OBJ
#define	WM_DLL_CLOSE_OBJ	WM_DLL_WKS_CLOSE_OBJ

#define	WM_DLL_WKS_OPEN_OBJ		(WM_DLL_BEGIN + 45)
	/* open the named obj, 
	 * lParam = LPSTR to the obj's name.
	 * wParam = required size of the obj, if the obj
	 * has a smaller size, it is increased to the specified size
	 *
	 * returns LPSTR to the obj's data buffer
	 * or return NULL if the obj does not exist
	 */
	 
#define	WM_DLL_WKS_CLOSE_OBJ	(WM_DLL_BEGIN + 46)
	/* close the currently open obj, lParam and wParam
	 * are both ignored
	 */

#define	WM_DLL_WKS_SET_DIM_EXT		(WM_DLL_BEGIN + 47)
	/* lParam is LPLONG to nCols and nRows */

#define	WM_DLL_WKS_GET_DIM		(WM_DLL_BEGIN + 48)
	/* get Ncols x Nrows of the opened worksheet
	 * nRows is the size of a column, which is
	 * greater or equal
	 * reutrn MAKELONG(nCols,nRows)
	 */
#define	WM_DLL_WKS_GET_DIM_EXT		(WM_DLL_BEGIN + 49)
	/* same but use LPLONG to return the dim
	 * return 0 if OK 1 if err
	 */

#define	WM_DLL_CLOSE_WKSHEET	(WM_DLL_BEGIN + 50)
	/* close the currently open worksheet
	 * All open columns are closed by this message.
	 * Updating is indicated by the wParam, while
	 * the lParam is ignored.
	 */

#define	WM_DLL_OPEN_LAYER		(WM_DLL_BEGIN + 60)
	/* PlotWindow name in lParam, NULL if current plot
	 * layer numer in wParam, 0 if current layer
	 */

#define	WM_DLL_CLOSE_LAYER		(WM_DLL_BEGIN + 90)
	/* Updating is indicated by the wParam, while
	 * the lParam is ignored.
	 */  

///jliu 9/7/95 MATRIX_SET
#define	WM_DLL_MATRIX_SET_DIM		(WM_DLL_BEGIN + 95)
	/* set Ncols x Nrows of the opened matrix
	 * reutrn MAKELONG(nCols,nRows)
	 */

#define	WM_DLL_MATRIX_SET_XY		(WM_DLL_BEGIN + 96)
	/* set matrix X and Y boundaries
	 * wParam is ingored and must be set to zero
	 * lParam is LPDOUBLE to x1,y1,x2,y2
	 */
//--------  CPY 11-10-2001 v6.9122 MATRIX_Z1_Z2_CONTROL
// lParam is LPDOUBLE to z1 z2
// wParam = 1 to set, 0 to get, 
#define ZRANGE_WPARAM_SET		0x01
#define ZRANGE_WPARAM_SET_ROUND	0x02
#define ZRANGE_GET_RETURN_NO_COLORMAP 0x1000
#define WM_DLL_MATRIX_GETSET_Z1_Z2		(WM_DLL_BEGIN + 97)
//-------- end CPY 11-10-2001 v6.9122 MATRIX_Z1_Z2_CONTROL
/// ML 3/18/2002 t9975, QA70-1124 ALLOW_MATRIX_SIZE_OVER_TWO_BYTES
#define WM_DLL_MATRIX_GET_DIM_EX		(WM_DLL_BEGIN + 98)
/// end ALLOW_MATRIX_SIZE_OVER_TWO_BYTES

/// YuI 4/24/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
#define DATA_CONVERTED_WPARAM_SET	0x01
#define WM_DLL_MATRIX_GETSET_DATA_CONVERTED		(WM_DLL_BEGIN + 99)
/// end MULTIFRAME_TIFF_IMPORT

///MATRIX_SET	 	 

#define	WM_DLL_SET_VARIABLE			(WM_DLL_BEGIN + 190)
#define	WM_DLL_GET_VARIABLE			(WM_DLL_BEGIN + 191)
	/* set or get one variable in Origin
	 * wParam ignored.
	 * lParam is LP to the following structurn */
typedef	struct	VARSETGET {
	double	value;
	char	name[NAME_SIZE];
}VARSETGET, FAR *LPVARSETGET;
	 /* return 1 if WM_GET_VARIABLE does not
	  * exist, WM_SET_VARIABLE always return zero
	  * variable name must be all upper case
	  */

#define	WM_DLL_SET_STRING			(WM_DLL_BEGIN + 194)
#define	WM_DLL_GET_STRING			(WM_DLL_BEGIN + 196)
	/* set or get one string variable in Origin
	 * wParam = 0,1,2,.. for %A,%B, %C.
	 * lParam is LPSTR to to set or get the string variable
	 * return 1 if OK, return 0 if error
	 */
	  
	  
	  
#define	WM_DLL_GETINITFILENAME	(WM_DLL_BEGIN + 200)

#define	WM_DLL_GET_MEMORY		(WM_DLL_BEGIN + 210)


/// ML 3/23/98 OK_NEW_COLORMAP_FOR_CONTOUR 
#define	WM_DLL_GET_COLORMAP_CLBCK		(WM_DLL_BEGIN + 230)
/// end OK_NEW_COLORMAP_FOR_CONTOUR 


#define	WM_DLL_NOTIFY			(WM_DLL_BEGIN+ 295)
/* message to the nofify function
 *
 * DWORD FAR PASCAL Notify(hWnd,wMsg,wParam,lParam)
 *
 * This function must be exported with the name "NOTIFY"
 */

///HYYU v4.9994 t1462 CHANGE_NUMERIC_FORMAT_FROM_WCB
#define WM_DLL_CHANGENUMFORMAT	(WM_DLL_BEGIN+ 296)
///end CHANGE_NUMERIC_FORMAT_FROM_WCB


#define	NOTIFY_GET_MSG_ID		0
	/* must return the registered WM message id
	 * wParam and lParam are both zeros
	 */
#define	NOTIFY_NOTIFY			1
	/* wParam and lParam are valid values */ 


#define	WM_DLL_SETUP			(WM_DLL_BEGIN+ 298) ///CPY v4.01 2/13/96 MERGE_CONTOUR_3D_COLOR
#define	WM_DLL_CLEAN_UP			(WM_DLL_BEGIN+ 299)
#define WM_DLL_END		(WM_DLL_BEGIN+ 300)


/* internal ids, these ids may be in conflict with
 * other WM_ ids, but they are sent only internally
 */
#define	DDM_TEST_ID			0
#define	DDM_SET_NOTIFY		1	/* in lparam */

/* use this to test whether id is within range */ 


/* To support LabEngine, there must a function
 * with the following ordinal number
 */
#define	ID_DLL_SET_CALLBACK	9999


/* function prototype within Origin for extern DLL messages */
//----------- CPY v6.9139 11/29/01 t9756 MATRIX_FROM_LAYER
//ULONG	do_DLL_message(HWND, USHORT, USHORT, ULONG);
ULONG	do_DLL_message(HWND, USHORT, DWORD, ULONG);
//-----------



/***********************************************************
 * The struct and msg defined below are implemented for
 * Data Acquisition purpose, but is generally available.
 * A DLL can use a callback function instead of SendMessage
 * to communicate with Origin, and is thus much faster.
 * To use this mechanizm, the DLL must be decleared through
 * the ORIGIN.EXT file and the DLL is invoked directly through
 * the command defined in origin.ext, for example, a LabData.DLL
 * can be defined as the command DAS as follows:
 * 
 * das labdata
 *
 * in a line in Origin.ext file
 *
 * The DLL function must be defined as
 * int FAR PASCAL LabData(HWND,LPSTR,LPCALLBK);
 *
 * please note that one can continue to use the SendMessage 
 * mechanism to communicate with Origin
 *
 ***********************************************************/

typedef	ULONG	(FAR PASCAL *LPCALLBK)(HWND,USHORT,LPSTR,LPSTR);

/* WCB_* messages must all be bigger than WM_DLL_END which is 1424
 * and smaller then WM_DLL_BEGIN which is 1124
 */
#define	MASK_WCB_TYPE			0xF000
#define	MASK_WCB_NO_HWND		0x1000///
#define	MASK_WCB_OPTION_HWND	0x2000///


#define	MASK_DATASET			0x3000///
#define	MASK_DATASET_SERIES		0x0400

#define	MASK_FIT				0x4000///

#define	MASK_NEED_DRAW			0x5000///
#define	MASK_DRAWING_MODE		0x0400 // share DATA_SERIES 
	// must in between _BEGIN and _END
#define	MASK_DRAWING_OPTN_COOR	0x0800

#define	MASK_WCB_WKS			0x6000///CPY v4.05 3/8/96 WCB_WKS_HANDLING
#define	MASK_PKFIT				0x8000///
	///CPY v4.133 8/29/96 WCB_FRAME_ACCESS
#ifdef WCB_FRAME_ACCESS
	#define MASK_FRAME			0x9000
#endif ///WCB_FRAME_ACCESS
///
		
/*********************************************************
 * the callback function takes the following command id
 * as the wParam argument
 *********************************************************/
 
#define	WCB_SCRIPT_MSG		MASK_WCB_NO_HWND
#define	WCB_SET_VAR		(MASK_WCB_NO_HWND+1)
#define	WCB_GET_VAR		(MASK_WCB_NO_HWND+2)
#define	WCB_GET_HWND		(MASK_WCB_NO_HWND+3)

#define	WCB_EXECUTE		(MASK_WCB_NO_HWND+4)

#define	WCB_TEST		(MASK_WCB_NO_HWND+5)
#define	WCB_SET_INDEX		(MASK_WCB_NO_HWND+6)
#define	WCB_SET_TIME		(MASK_WCB_NO_HWND+7)
#define	WCB_GET_VALUE		(MASK_WCB_NO_HWND+8)

#define WCB_GET_OBJ		(MASK_WCB_NO_HWND+9)

#define	WCB_SET_DATASET		(MASK_WCB_NO_HWND+10)
#define	WCB_GET_DATASET		(MASK_WCB_NO_HWND+11)

#define	WCB_SET_STRING		(MASK_WCB_NO_HWND+12)
/// QZC 4/10/94
#define	WCB_GET_STRING		(MASK_WCB_NO_HWND+18)

#define	WCB_TYPE_ASCII		(MASK_WCB_NO_HWND+13)
#define	WCB_CVT_ASCII		(MASK_WCB_NO_HWND+14)

#define	WCB_GET_BUFFER		(MASK_WCB_NO_HWND+15)

#define	WCB_GET_PATH		(MASK_WCB_NO_HWND+16)

#define	WCB_GET_PROCESS_FN	(MASK_WCB_NO_HWND+17)

#define	WCB_GET_INIT_TIME	(MASK_WCB_NO_HWND+19)

/// QZCao v3.78, March,20,95
#define	WCB_NEXT_TERM		(MASK_WCB_NO_HWND+20)
#define	WCB_ARG_COPY		(MASK_WCB_NO_HWND+21)
#define	WCB_SET_PLOT_TITLE	(MASK_WCB_NO_HWND+22)
#define	WCB_OPEN_MC_FILE	(MASK_WCB_NO_HWND+23)
#define	WCB_SHOW_I		(MASK_WCB_NO_HWND+24)
#define	WCB_GET_INIT_FILE	(MASK_WCB_NO_HWND+25)
#define	WCB_ADD_VARIABLE	(MASK_WCB_NO_HWND+26)
///

/// QZCao v3.782, 4/13/95
#define	WCB_STATUS_MSG		(MASK_WCB_NO_HWND+27)
///

/// QZCao, V3.7841, 5/12/95, WCB_GET_DOUBLE_VALUE, get double value 
#define	WCB_GET_DOUBLE_VALUE	(MASK_WCB_NO_HWND+28)
///

/// QZCao, v3.8, cal expression
#define	WCB_CAL_EXPRESSION	(MASK_WCB_NO_HWND+29)
///

/// QZCao, v3.8, 7/20/95, add label to plot and type to script
#define	WCB_ADD_LABEL		(MASK_WCB_NO_HWND+30)
#define	WCB_TYPE_SCRIPT		(MASK_WCB_NO_HWND+31)
///

/// QZCao, v3.8, 7/21/95, del a variable
#define	WCB_DEL_VARIABLE	(MASK_WCB_NO_HWND+32)

/// QZCao, v3.8, 8/14/95, get init path
#define	WCB_GET_INI_PATH	(MASK_WCB_NO_HWND+33)

/// QZCao, v3.8, 8/21/95, get window name and ptr
#define	WCB_GET_WIN_NAME	(MASK_WCB_NO_HWND+34)
#define	WCB_GET_WIN_ID		(MASK_WCB_NO_HWND+35)
///

/// QZCao, v3.8, 8/23/95, load a dll in origin standard way
#define	WCB_LOAD_DLL		(MASK_WCB_NO_HWND+36)
///

/// QZCao, v3.83, 9/19/95, set modaless
#define	WCB_SET_MODALESS	(MASK_WCB_NO_HWND+37)
///
/// ML v3.840 10/13/95 WCB_GET_DLL_PATH
#define	WCB_GET_DLL_PATH		(MASK_WCB_NO_HWND+38)
/// end 10/13/95 WCB_GET_DLL_PATH

///	QZCao, v3.85, 10/31/95, WCB_DLL_BALOON
#define	WCB_DLL_BALOON		(MASK_WCB_NO_HWND+39)
///                        
/// ML v3.850 11/1/95 REMOVE_COMMENTS
#define	WCB_STRIP_COMMENTS		(MASK_WCB_NO_HWND + 40)	
/// end REMOVE_COMMENTS

/// EJP v4.08 04-19-96 WCB_GET_CTRL_HWND
/// callback msg to get a window handle for a window based UIM object.
#define WCB_GET_CTRL_HWND		(MASK_WCB_NO_HWND + 41)
/// end WCB_GET_CTRL_HWND

/// EJP v4.09 05-29-96 WNDBASED_UIM_OBJ_EVENTS
///	callback msg to process script associated with WndBased UIM object events.
#ifdef WNDBASED_UIM_OBJ_EVENTS
	#define WCB_WNDBASED_EVENT				(MASK_WCB_NO_HWND + 42)
#endif // WNDBASED_UIM_OBJ_EVENTS
/// end WNDBASED_UIM_OBJ_EVENTS
/// ML v4.133 9/27/96 WCB_POWERSTAT_GET_TEMPLATE_PATHS
#define	WCB_POWERSTAT_GET_TEMPLATE_PATHS	(MASK_WCB_NO_HWND + 43)
/// end WCB_POWERSTAT_GET_TEMPLATE_PATHS

///ANU	v4.97 03/19/97 MOVE_DISK_OBJ_TO_UIM	
///this is needed to use the new O_PAGE_ID instead
///of hwnd to do things
#define	WCB_GET_PAGE_ID						(MASK_WCB_NO_HWND + 44)
///end MOVE_DISK_OBJ_TO_UIM

//------------- CPY v4.9994 b2800 7/23/97 LAYER_NUMBER_ACCESS_FROM_WCB
#define WCB_GET_ACTIVE_LAYER_NUMBER			(MASK_WCB_NO_HWND + 45)
#define WCB_SET_ACTIVE_WIN_LAYER			(MASK_WCB_NO_HWND + 46)
//------------- LAYER_NUMBER_ACCESS_FROM_WCB

//-------------- CPY v5.004 8/4/97 t2897 FDLOG_SETDEFAULT_MUST_ALWAYS_SET_PATH
#define WCB_GET_DEFAULT_PATH				(MASK_WCB_NO_HWND + 47)
//-------------- FDLOG_SETDEFAULT_MUST_ALWAYS_SET_PATH

//--------------- CPY v5.005 8/5/97 FITTER_HELP_TO_GENERAL_CONTENTS
#define WCB_GET_ONLINE_HELP					(MASK_WCB_NO_HWND + 48)
//--------------- FITTER_HELP_TO_GENERAL_CONTENTS


//---------- CPY v5.028 11/24/97 b3252 STAT_NAME_COUNT_INDEP_DATASET
#define WCB_IS_WKSNAME_USED					(MASK_WCB_NO_HWND + 49)
//---------- STAT_NAME_COUNT_INDEP_DATASET

/// RB 9/15/98 v6.0129 t4194 FFT_EXPONENT_SIGN_CHOICE
#define WCB_GET_FFT_EXPONENT_SIGN			(MASK_WCB_NO_HWND + 50)
/// end  FFT_EXPONENT_SIGN_CHOICE

/// DVT 3/1/99 v6.0169 t5373 AVAILABLE_SERIES_FROM_CUR_FOLDER
#define WCB_IS_SERIES_FROM_CUR_FOLDER			(MASK_WCB_NO_HWND + 51)
#define WCB_TOGGLE_SAVE_SERIES_FROM_CUR_FOLDER	(MASK_WCB_NO_HWND + 52)
/// end  AVAILABLE_SERIES_FROM_CUR_FOLDER

/// ML 5/25/99 WCB_MESSAGE_FOR_GETTING_EMF
#define	WCB_CREATE_EMF_FOR_WINDOW				(MASK_WCB_NO_HWND + 53)
/// end WCB_MESSAGE_FOR_GETTING_EMF

//IV 9/7/99 t6811 ADD_FOR_LABTALKEDITOR
#define	WCB_LABTALKEDITOR_CHECK_OBJECT_NAME				(MASK_WCB_NO_HWND + 54)
//end ADD_FOR_LABTALKEDITOR

/// EJP 09-21-99 t6660 MOCA_NEED_ABILITY_TO_SET_DOUBLE_VALUES
#define WCB_SET_DOUBLE_VALUE (MASK_WCB_NO_HWND + 55)
/// end MOCA_NEED_ABILITY_TO_SET_DOUBLE_VALUES

//IV 9/7/99 t6811 ADD_FOR_LABTALKEDITOR
//check whether the passed string is a Labtlak command or keyword
#define	WCB_LABTALKEDITOR_CHECK_COMMAND					(MASK_WCB_NO_HWND + 56)
//end ADD_FOR_LABTALKEDITOR
//IV 10/4/99 t6811 ADD_FOR_LABTALKEDITOR_BREAKPTS
//call-back message for debugging a section in an OGS file is:
/// RVD 4/1/2002 t1309 v7.0262 IMPROVE_DEBUG_ORIGIN_C_LABTALK
//#define	WCB_LABTALKEDITOR_BREAKPTS						(MASK_WCB_NO_HWND + 57)
/// end IMPROVE_DEBUG_ORIGIN_C_LABTALK
//end ADD_FOR_LABTALKEDITOR_BREAKPTS

/// ML 10/11/99 v6.0234 t6995 PROPER_DECIMAL_CHARACTER_WHEN_USING_GERMAN_SETTING_INSIDE_CRT_LIBRARY
#define	WCB_REAL_TO_STRING								(MASK_WCB_NO_HWND + 58)
/// end PROPER_DECIMAL_CHARACTER_WHEN_USING_GERMAN_SETTING_INSIDE_CRT_LIBRARY

/// RB 10/19/99 t2289 v6.0235 SET_HORIZONTAL_SCROLL_SIZE_FOR_LISTBOX
#define WCB_GET_TEXT_WIDTH								(MASK_WCB_NO_HWND + 59)
/// end SET_HORIZONTAL_SCROLL_SIZE_FOR_LISTBOX

//IV 10/4/99 t6811 ADD_FOR_LABTALKEDITOR_GET_PATH                             
#define	WCB_APPEND_PATH_TO_FILENAME						(MASK_WCB_NO_HWND + 60)
//end ADD_FOR_LABTALKEDITOR_GET_PATH                             

/// EJP 02-01-2000 v6.0254 EXPORT_GRAPH_TO_PDF_AS_BITMAP
/// Origin can export graphs to BMP, WMF, and EMF.
/// This capability should be available to all MOCA DLLs without having to use LabTalk.
/// If other formats are needed then LabTalk's Image object must be used.
/// This message return 0 for success or non-zero for error.
/// On error caller should check Error in struct for specific error.
#define WCB_EXPORT_GRAPH								(MASK_WCB_NO_HWND + 61)

typedef struct { // common.  following structs must start with these fields.  should combine these later.
	int iFormat;
	LPCTSTR lpFileName;
} stWCBEG, FAR *LPWCBEG;

typedef struct { // Bitmap
	int iFormat;
	LPCTSTR lpFileName;
	int iBitsPerPixel;
	int iWidth;
	int iHeight;
	int iReturn;
} stWCBEGBMP, FAR *LPWCBEGBMP;

typedef struct { // Enhanced Meta File
	int iFormat;
	LPCTSTR lpFileName;
	BOOL bReturn;
} stWCBEGEMF, FAR *LPWCBEGEMF;

typedef struct { // Windows Meta File
	int iFormat;
	LPCTSTR lpFileName;
	BOOL bPlaceable;
	BOOL bReturn;
} stWCBEGWMF, FAR *LPWCBEGWMF;

enum {
	WCBEG_FORMAT_BMP = 1,
	WCBEG_FORMAT_EMF,
	WCBEG_FORMAT_WMF
};
/// end	EXPORT_GRAPH_TO_PDF_AS_BITMAP

//IV 2/7/2000 ADD_FOR_LABTALKEDITOR_SET_FUNCTION_PTR                             
//pass a pointer to the Labtalk editor call back function; Origin uses
//this function to communicate with the editor
/// RVD 4/1/2002 t1309 v7.0262 IMPROVE_DEBUG_ORIGIN_C_LABTALK
//#define	WCB_LABTALKEDITOR_SET_FUNCTION_PTR				(MASK_WCB_NO_HWND + 62)
/// end IMPROVE_DEBUG_ORIGIN_C_LABTALK
//end ADD_FOR_LABTALKEDITOR_SET_FUNCTION_PTR                             

//IV 6/19/2000, t7996, v6.0291 EXPORT_USERDEF_CATEGORY
#define WCB_USER_CATEGORY_ADD     (MASK_WCB_NO_HWND + 63)      
//end EXPORT_USERDEF_CATEGORY

/// EJP 08-15-2000 t8153 v6.1026 WCB_GET_USER_INFO
#define WCB_GET_USER_INFO     (MASK_WCB_NO_HWND + 64)
typedef struct {
	DWORD dwOriginType;
	LPSTR lpstrSerialNumber;
	LPSTR lpstrRegistrationID;
	DWORD dwSerialNumber;
	//LY  1/9/02  IMPROVE_GET_USER_INFO
	LPSTR lpstrLanguageCharater;
	LPSTR lpstrServiceReleaseStr;
	float fVersionNumber;
	//end IMPROVE_GET_USER_INFO
	/// SY 06-11-2003 QA70-3774 v7.0601 CHECK_FOR_UPDATES_FOR_CLIENTS
	BOOL bIsClient; 
	/// end CHECK_FOR_UPDATES_FOR_CLIENTS
} stWCBUSERINFO;
//------------------------------ CPY 4/3/02 t9661 COMBINED_EVAL_STUDENT_VERSION
// must refer to okconst.h 
// for ORGPRODUCTTYPE_ related macros
//
//enum {
//	ORIGIN_TYPE_FULL = 1,
//	ORIGIN_TYPE_STUDENT,
//	ORIGIN_TYPE_DEMO,
//	///DSC 08-28-2000 v6.1037 ADD_ORIGIN_TYPE_LEASED
//	ORIGIN_TYPE_LEASED	 
//	///end ADD_ORIGIN_TYPE_LEASED
//	//LY  1/9/02  IMPROVE_GET_USER_INFO
//	//end  IMPROVE_GET_USER_INFO
//};
//------------------------------ 
/// end WCB_GET_USER_INFO

//-------------- CPY 3/15/01 7.0 PRINT_STRING
#define WCB_PRINT_STRING	(MASK_WCB_NO_HWND + 65)	// a more general version compared with WCB_SCRIPT_MSG
	// lParam definitions, must be same as RDIR_ADD_CR,RDIR_OUTPUTLOG
	// set lParam to zero to bring up message box 
	#define WPS_ADD_CRLF		0x00000008 // RDIR_ADD_CR
	#define WPS_OUTPUT_LOG		0x00000010 // RDIR_OUTPUTLOG
	#define WPS_SCRIPT_WINDOW	0x00000001 // RDIR_SCRIPT
	// if no WPS_OUTPUT_LOG/WPS_SCRIPT_WINDOW/WPS_COMPILER_OUTPUT specified, output will be dump to print_complain which is the script window typically
	#define WPS_COMPILER_OUTPUT	0x00000020	 	//------- CPY 7/10/01 t9307 FILE_LINE_SUPPORT_IN_MACRO	
//-------------- end CPY 3/15/01 PRINT_STRING

//----------------- CPY 3/20/01 t8928 COMPILE_USER_DEFINED_FIT_FUNC
/// YuI 5/06/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION
typedef struct tagCOMPILEFUNCPARAMS
{
	LPCTSTR lpcszName;
	LPCTSTR lpcszBody;
	LPCTSTR	lpcszParams;
	LPCTSTR lpcszIndep;
	LPCTSTR lpcszDep;
	LPCTSTR	lpcszConst;
	/// YuI 6/14/02 v7.0320 NEED_TO_PASS_BRIEF_DESRIPTION_TO_CODE_BUILDER
	LPCTSTR lpcszDescription;//brief description fie
	/// end NEED_TO_PASS_BRIEF_DESRIPTION_TO_CODE_BUILDER
	/// YuI 6/18/02 v7.0324 QA70-1861 NLSF_ANALYTIC_DERIVATIVES
	LPCTSTR lpcszDeriv;//for analytic 
	/// end NLSF_ANALYTIC_DERIVATIVES
	/// YuI 7/3/02 v7.0336 QA70-2216 READ_ONLY_PARA_INIT
	BOOL	bReadOnly;
	/// READ_ONLY_PARA_INIT
	/// YuI 1/20/03 v7.0492 QA-3641 ADDITIONAL_EDITABLE_PART_TO_FITTING_FUNCTION
	LPCTSTR lpcszEditableHeader;
	/// end ADDITIONAL_EDITABLE_PART_TO_FITTING_FUNCTION
}	COMPILEFUNCPARAMS, *LPCOMPILEFUNCPARAMS;
/// end NLSF_CODE_BUILDER_COMMUNICATION

/// YuI 5/21/02 v7.0307 QA70-1649 NLSF_FUNCTION_EDIT_VIEW

/// YuI 6/10/02 v7.0314 QA70-2020 INTERFACE_CLASS_NLSFMANAGER
//	//set of messages for communication from Code Builder to NLSF
//	typedef enum tagOIDENLSFMESSAGE
//	{
//		OIDE_NLSF_MSG_SAVE_FIT_FUNC,//sent to NLSF when user saves NLSF file in code builder
//		OIDE_NLSF_MSG_SAVE_PARA_INIT,//sent to NLSF when user saves NLSF file in code builder
//		OIDE_NLSF_MSG_COMPILE_FIT_FUNC,//sent to NLSF when user compiles file in COde builder
//		OIDE_NLSF_MSG_COMPILE_PARA_INIT,//sent to NLSF when user compiles file in COde builder
//		OIDE_NLSF_MSG_CLOSE_FIT_FUNC,//sent to NLSF when user closes file in COde builder
//		OIDE_NLSF_MSG_CLOSE_PARA_INIT,//sent to NLSF when user closes file in COde builder
//	}	OIDENLSFMESSAGE;

//set of messages for communication with NLSF from other DLL's
//it is number based (not bit based)
//they are passed to nitify_fitter_ex as wParam
typedef enum tagNLSFCOMMUNICATIONMESSAGE
{
	NLSF_MSG_OIDE_SAVE_FIT_FUNC			= 0x00000001,//sent to NLSF when user saves NLSF file in code builder
	NLSF_MSG_OIDE_CLOSE_FIT_FUNC		= 0x00000002,//sent to NLSF when user closes file in COde builder
	NLSF_MSG_COMPILE_FIT_FUNC			= 0x00000003,//sent to NLSF when user wants to compile function from outside
	NLSF_MSG_IS_FIT_FUNC_COMPILED		= 0x00000004,//to ask NLSF if fit func compiled or not
	NLSF_MSG_FIT_FUNC_MASK				= 0x000000ff,//mask for messages related to fitfunction

	NLSF_MSG_OIDE_SAVE_PARA_INIT		= 0x00000100,//sent to NLSF when user saves NLSF file in code builder
	NLSF_MSG_OIDE_CLOSE_PARA_INIT		= 0x00000200,//sent to NLSF when user closes file in COde builder
	NLSF_MSG_COMPILE_PARA_INIT			= 0x00000300,//sent to NLSF when user compiles file from outside
	NLSF_MSG_IS_PARA_INIT_COMPILED		= 0x00000400,//to ask NLSF if fit func compiled or not
	NLSF_MSG_PARA_INIT_MASK				= 0x0000ff00,//mask for messages related to parameter initialization
}	NLSFCOMMUNICATIONMESSAGE;
/// end INTERFACE_CLASS_NLSFMANAGER
//set of return values for communication between Code Builder and NLSF
typedef enum tagNLSFCOMMUNICATIONRETURNVALUE
{
	NLSF_COMM_RV_GENERAL_ERROR						= -1,
	NLSF_COMM_RV_NOT_OPEN_IN_CODE_BUILDER			= -2,
	NLSF_COMM_RV_OPERATION_FAILED_WHILE_IN_DEBUG	= -3,
	NLSF_COMM_RV_GENERIC_FALSE						= 0,
	NLSF_COMM_RV_GENERIC_TRUE						= 1,
}	NLSFCOMMUNICATIONRETURNVALUE;
/// end INTERFACE_CLASS_NLSFMANAGER

#define		NLSF_FUNC_C_FILE_NAME_ONLY		_T("_nlsffunc.fit")
#define		NLSF_PARA_C_FILE_NAME_ONLY		_T("_nlsfparam.fit")
/// end NLSF_FUNCTION_EDIT_VIEW

/// YuI 5/06/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION
//typedef DWORD	(CALLBACK* OKLT_COMPILEFITFUNC)(LPCTSTR lpszBody, LPCTSTR lpcszIndep, LPCTSTR lpcszDep, LPCTSTR lpcszParams, LPCTSTR lpcszCurve);
//typedef int	(CALLBACK* OKLT_CALLFITFUNC)(DWORD dwFitFunc, UINT nRow, LPDOUBLE lpx, LPDOUBLE lpy, LPDOUBLE lpdydp);
//typedef BOOL	(CALLBACK* OKLT_DELFITFUNC)(DWORD dwFitFunc);
//typedef BOOL	(CALLBACK* OKLT_BEFOREAFTER_CALL)(DWORD dwFitFunc, short nParams, LPDOUBLE lpParams, LPDOUBLE lpConsts);
//typedef int	(CALLBACK* OKLT_CALLPARAINIT)(DWORD dwFitFunc, short nParams, LPDOUBLE lpParams, LPDOUBLE lpConsts, LPDWORD lpdwDatasetIDs, LPDWORD lpdwCurveIDs);

#define	OIDE_ADD_TO_WORKSPACE_FROM_SCRIPT	_T("TRUE")

//DWORD is overkill for now but may be needed later
typedef enum tagCOMPILEDFUNCTSTATE
{
	CFS_READY_TO_CALL	= 0x00000001,
}	COMPILEDFUNCTSTATE;

typedef DWORD	(CALLBACK* OKLT_GETFUNCTIONSTATE)(DWORD dwFitFunc);
typedef DWORD	(CALLBACK* OKLT_COMPILEFUNC)(LPCOMPILEFUNCPARAMS lpParams, BOOL bFromCodeBuilder);

typedef BOOL	(CALLBACK* OKLT_BEFOREAFTER_CALL_FITFUNC)(DWORD dwFitFunc, LPDOUBLE lpParams);
/// YuI 6/18/02 v7.0324 QA70-1861 NLSF_ANALYTIC_DERIVATIVES
//	typedef int		(CALLBACK* OKLT_CALLFITFUNC)(DWORD dwFitFunc, LPDOUBLE lpIndep, LPDOUBLE lpDep);
typedef int		(CALLBACK* OKLT_CALLFITFUNC)(DWORD dwFitFunc, LPDOUBLE lpIndep, LPDOUBLE lpDep, LPDOUBLE lpDeriv);
/// end NLSF_ANALYTIC_DERIVATIVES

typedef BOOL	(CALLBACK* OKLT_BEFOREAFTER_CALL_PARAINIT)(DWORD dwFitFunc, LPDWORD lpdwDatasetIDs);

/// YuI 4/28/03 v7.0572 QA70-4294 ERROR_CODE_IN_NLSF_PARA_INIT_FUNCTION
//	typedef int		(CALLBACK* OKLT_CALLPARAINIT)(DWORD dwFitFunc, LPDOUBLE lpParams);
typedef int		(CALLBACK* OKLT_CALLPARAINIT)(DWORD dwFitFunc, LPDOUBLE lpParams, LPINT pAuxErr);
/// end ERROR_CODE_IN_NLSF_PARA_INIT_FUNCTION

//---------- CPY 7/22/02 QA70-2414 v7.0348 NLSF_FIT_FUNC_FILE_NODE_SHOULD_BE_REMOVE_ON_END_FIT
//typedef BOOL	(CALLBACK* OKLT_DELCOMPILEDFUNC)(DWORD dwFitFunc);
typedef BOOL	(CALLBACK* OKLT_DELCOMPILEDFUNC)(DWORD dwFitFunc, BOOL bRemoveFileNode);
//---------- end CPY 7/22/02 QA70-2414 v7.0348 NLSF_FIT_FUNC_FILE_NODE_SHOULD_BE_REMOVE_ON_END_FIT

typedef BOOL	(CALLBACK* OKLT_CALLCODEBUILDER)(UINT msg, LPCOMPILEFUNCPARAMS lpParams);

typedef enum tagCALLCODEBUILDERMESSAGE
{
	CALL_CB_MSG_OPEN_CODE_BUILDER = 1,
	CALL_CB_MSG_BEGIN_FUNC_EDIT,
	CALL_CB_MSG_END_FUNC_EDIT,
	CALL_CB_MSG_BEGIN_PARAINI_EDIT,
	CALL_CB_MSG_END_PARAINI_EDIT,
}	CALLCODEBUILDERMESSAGE;

typedef struct tagCompilerExportCFunctions
{
	OKLT_COMPILEFUNC				pCompileFitFunc;
	OKLT_BEFOREAFTER_CALL_FITFUNC	pBeforeAfterCallFitFunc;
	OKLT_CALLFITFUNC				pCallFitFunc;

	OKLT_COMPILEFUNC				pCompileParaInit;
	OKLT_BEFOREAFTER_CALL_PARAINIT	pBeforeAfterCallParaInit;
	OKLT_CALLPARAINIT				pCallParaInit;
	
	OKLT_DELCOMPILEDFUNC			pDeleteCompiled;
	OKLT_CALLCODEBUILDER			pCallCodeBuilder;
	OKLT_GETFUNCTIONSTATE			pGetFunctionState;
}	CompilerExportCFunctions;
/// end NLSF_CODE_BUILDER_COMMUNICATION

//------------- CPY t9154 5/26/01 COMPILE_PARA_INIT

//-------------

/// YuI 5/22/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION
/// those are not needed any more
//	// if lpParams==NULL in pBeforeAfterCallFitFunc, nParams = 0 to indicate after, 1 to ask if BeforeCall was made
//	#define NPARAMS_BEFOREAFTER_AFTER						0
//	#define NPARAMS_BEFOREAFTER_WAS_BEFORE_CALLED			1
/// end NLSF_CODE_BUILDER_COMMUNICATION

/// YuI 5/15/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION
//	typedef struct tagCompilerExportCFunctions
//	{
//		OKLT_COMPILEFITFUNC		pCompileFitFunc;
//		OKLT_CALLFITFUNC		pCallFitFunc;
//		OKLT_DELFITFUNC			pDeleteFitFunc;
//		OKLT_BEFOREAFTER_CALL	pBeforeAfterCallFitFunc;
//		//------------- CPY t9154 5/26/01 COMPILE_PARA_INIT
//		OKLT_COMPILEFITFUNC		pCompileParaInit;
//		OKLT_CALLPARAINIT		pCallParaInit;
//		//-------------
//	}CompilerExportCFunctions;
/// end NLSF_CODE_BUILDER_COMMUNICATION
#define WCB_GET_COMPILER_FUNCTIONS	(MASK_WCB_NO_HWND + 66)
	// lpstr = struct pointer
	// lParam = struct size
	// return 0 if OK, otherwise return error codes
//----------------- end CPY 3/20/01 t8928 COMPILE_USER_DEFINED_FIT_FUNC

////////////////////////////////////////////////////////////////////////////
/// EJP 08-16-2001 v6.9069 t9177 ADD_LABTALK_IMPORT_BMP_TO_LAYER
// Currently this is used to pass Origin a handle to a DIB.
#define WCB_MATRIX_IMAGE			(MASK_WCB_NO_HWND + 67)
typedef struct {
	HANDLE hDIB;
	LPCSTR lpcstrName; // window name, NULL for current
	BOOL bBegin;
} STWCBMI;
/// end ADD_LABTALK_IMPORT_BMP_TO_LAYER
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
/// EJP 10-24-2001 v6.9108 t9637 IMPORT_IMAGE_TO_GR_OBJECT
#define WCB_GROBJ_DIB				(MASK_WCB_NO_HWND + 68)
typedef struct {
	LPCSTR lpcstrWinName;	// window name, NULL for current
	LPCSTR lpcstrObjName;	// object name, when setting can be NULL for default name
	HANDLE hDIB;			// set to NULL to get DIB
	BOOL bReplace;			// if named object exists: TRUE = replace DIB, FALSE = make name unique
} STWCBGROBJDIB;
/// end IMPORT_IMAGE_TO_GR_OBJECT
////////////////////////////////////////////////////////////////////////////

// EJP 11-02-2001 v6.9114 t9518 COPY_PROTECT_MODULES
// Pass Module ID str to have it checked in the license file.
// Returns zero if everything is OK else returns non-zero.
#define WCB_MODULE_KEY				(MASK_WCB_NO_HWND + 69)
/// end COPY_PROTECT_MODULES

//IV 11/21/2001 t9696 ADD_FITTING_FUNCTIONS_FROM_SCRIPT
//Need to process string arguments with spaces correctly...
#define WCB_SEPARATE_STRING_TO_TOKENS	  (MASK_WCB_NO_HWND + 70)
//end ADD_FITTING_FUNCTIONS_FROM_SCRIPT


// LY	11/29/01 REMOVE_USER_BTN_FROM_CODE	
#define	WCB_REMOVE_USER_BUTTON_FROM_CODE	(MASK_WCB_NO_HWND + 71)	
// end REMOVE_USER_BTN_FROM_CODE

//LY	1/9/02	ACCESS_OKU_BROWSE_FOR_FOLBER_FUNCTION
#define	WCB_ACCESS_BROWSE_FOR_FOLDER_FUNCTION	(MASK_WCB_NO_HWND + 72)	
//end  ACCESS_OKU_BROWSE_FOR_FOLBER_FUNCTION

//IV 1/22/2001 QA79-468 ENUMERATE_VAR_COVAR_MATRIX_FOR_NLSF
#define WCB_CHECK_WINDOW_NAME     (MASK_WCB_NO_HWND + 73)	
//end ENUMERATE_VAR_COVAR_MATRIX_FOR_NLSF

/// EJP 02-27-2002 QA70_985 ENABLE_SOFTDEV_PDF
#define WCB_DLL_GETPROCADDRESS (MASK_WCB_NO_HWND + 74)
typedef struct {
	LPCTSTR lpcszDLLName;	// DLL name
	LPCTSTR lpcszFuncName;	// exported function name
	BOOL bSysPath;			// search system path?
	BOOL bAddIfNeeded;		// load DLL if not already loaded?
} STWCBGETPROCADDR;
/// end ENABLE_SOFTDEV_PDF

//-------- CPY IV 4/24/2002 COPY_NLSF_FUNCS_TO_CLIENT_ON_USE
#define WCB_MAKE_FULL_PATH	(MASK_WCB_NO_HWND + 75)
//-------- end 4/24/2002 COPY_NLSF_FUNCS_TO_CLIENT_ON_USE

/// YuI 6/11/02 v7.0317 QA70-2035 UI_TWEAK_FOR_NLSF_COMPILED_FUNCTIONS
#define WCB_REMINDER_MESSAGE	(MASK_WCB_NO_HWND + 76)
//I am introducing callback mechanism to call optional message box.
//moved all these definitions from okUtil.h
/// end UI_TWEAK_FOR_NLSF_COMPILED_FUNCTIONS

///	DVT 5/27/03 QA70-4433 v7.0580 DELETE_OPERATION_WITH_WKS_OPTION
//moved to OC_Const.h
/*
typedef enum tagOPTIONALMESSAGEBOXFLAGS
{
	OM_OK				= 1,
	OM_OK_CANCEL		= 2,
	OM_YES_NO			= 3,
	OM_YES_NO_CANCEL	= 4,
}	OPTIONALMESSAGEBOXFLAGS;

typedef enum tagOPTIONALMESSAGEBOXRETURN
{
	OM_RETURN_NOT_PRESENT		= -1,
	OM_RETURN_YNC_CANCEL		= 2,
	OM_RETURN_OK				= 1,
	OM_RETURN_CANCEL			= 0,
	OM_RETURN_YES				= OM_RETURN_OK,
	OM_RETURN_NO				= OM_RETURN_CANCEL,
}	OPTIONALMESSAGEBOXRETURN;

typedef struct tagREMINDERMESSAGEPARAM
{
	OPTIONALMESSAGEBOXFLAGS		flags;
	UINT						nResID;
	UINT						nResIDTitle;
	LPCTSTR						lpcsz1;
	LPCTSTR						lpcsz2;
	BOOL						bCheckExistence;
}	REMINDERMESSAGEPARAM, *LPREMINDERMESSAGEPARAM;
*/

#define	OM_OK				MB_OK
#define OM_OK_CANCEL		MB_OKCANCEL
#define OM_YES_NO			MB_YESNO
#define	OM_YES_NO_CANCEL	MB_YESNOCANCEL	

typedef struct tagREMINDERMESSAGEPARAM
{
	int							flags;
	UINT						nResID;
	UINT						nResIDTitle;
	LPCTSTR						lpcsz1;
	LPCTSTR						lpcsz2;
	BOOL						bCheckExistence;
}	REMINDERMESSAGEPARAM, *LPREMINDERMESSAGEPARAM;
///	end DELETE_OPERATION_WITH_WKS_OPTION


//--------- CPY 11/18/02 v7.0428 QA70-3213  ADD_FONT_INIT_TO_TREE_EDITOR
#define WCB_CREATE_PRINTER	(MASK_WCB_NO_HWND + 77)
//---------

/// TD 7-22-03 QA70-4868 DISPLAY_POINTERS_AND_WINDOW_OBJECTS
#define WCB_GET_TYPE_NAME	(MASK_WCB_NO_HWND + 78)
/// end DISPLAY_POINTERS_AND_WINDOW_OBJECTS


/// ML 11/12/2003 QA70-3921 PROPER_BITMAP_SIZE_FOR_RASTER_EXPORT
#define WCB_GET_PAGE_RECT_FOR_EXPORT		(MASK_WCB_NO_HWND + 79)
/// end PROPER_BITMAP_SIZE_FOR_RASTER_EXPORT



///CPY v4.133 8/29/96 WCB_FRAME_ACCESS
#ifdef WCB_FRAME_ACCESS
/// ML v4.133 8/30/96 FRAME_AND_MEMORY_OBJECT_ACCESS
// possible values for wOption:
enum {
	MOLAYER_WKS = 1,
	MOLAYER_GRAPH,	// nLayer contains the layer number, -1 for active
	/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
	MOLAYER_MATRIX,
	/// end MULTIFRAME_TIFF_IMPORT
};
/// end FRAME_AND_MEMORY_OBJECT_ACCESS
	#define WCB_FRAME_GET_ID			(MASK_FRAME + 1) 
	/// ML v4.133 9/5/96 CREATE_NEW_GRAPH
	#define	WCB_FRAME_CREATE_NEW_GRAPH	(MASK_FRAME + 2)
	/// end CREATE_NEW_GRAPH
	/// ML v4.133 9/6/96 PLOT_TYPES_AND_STRUCTURE
	#define	WCB_FRAME_STAT_PLOT			(MASK_FRAME + 3)
	/// ML end PLOT_TYPES_AND_STRUCTURE
	


	typedef	struct FR_LAYER_OPTION
	{
		int		nLayer;
		WORD	wOption;
	}FR_LAYER_OPTION, FAR *LP_FR_LAYER_OPTION;
	#define	MASK_FRAME_OBJ			0x0400
	typedef struct FR_MEM_OBJ_SIZE
	{
		DWORD 	id_fr;
		WORD	wSize;
		///CPY v4.133 9/9/96 CREATE_TEXT_LABEL
		LPSTR	lpBuffer;/// use for  MASK_FRAME_TEXT_OBJ only, ignore for mem obj
	}FR_MEM_OBJ_SIZE, FAR *LP_FR_MEM_OBJ_SIZE;

	/// RVD 1/24/2002 QA70-525 v6.9192 IMPLEMENT_VERBATIM_TEXT
	// this struct can grow, but never shrink
	typedef struct tagFROBJACCESS
	{
		FR_MEM_OBJ_SIZE	fmo;	// for compatibility with old FR_MEM_OBJ_SIZE
		DWORD	dwSize;			// sizeof(FROBJACCESS) for backward/forward compatibility
		BOOL	bInvalidate;	// redraw object
		DWORD	dwValue;		// data bits
		DWORD	dwMask;			// mask bits
		DWORD	dwUndo;			// undo bits
	}	FROBJACCESS, *PFROBJACCESS, FAR *LPFROBJACCESS;	
	
	#define MASK_FRAME_GROBJ			0x0100
	#define	WCB_FRAME_GROBJ_BOOL_SET	(MASK_FRAME | MASK_FRAME_OBJ | MASK_FRAME_GROBJ)
	#define	WCB_FRAME_GROBJ_BOOL_GET	(WCB_FRAME_GROBJ_BOOL_SET + 1)

	typedef enum tagFOAERROR
	{
		FOAE_SUCCESS		= 0,
		FOAE_UNKNOWN,
		FOAE_NOT_FOUND,
		FOAE_MEMORY,
		FOAE_COMMAND,
	}	FOAERROR;

	typedef enum tagFOABOOL
	{
		FOAB_AUTO			= 0x00000001,
		FOAB_BEHINDDATA		= 0x00000002,
		FOAB_ENABLE			= 0x00000004,
		FOAB_EVENT			= 0x00000008,
		FOAB_KEEPINSIDE		= 0x00000010,
		FOAB_LINKVAR		= 0x00000020,
		FOAB_MOUSE			= 0x00000040,
		FOAB_REALTIME		= 0x00000080,
		FOAB_REVERSEVIDEO	= 0x00000100,
		FOAB_SYSTEMFONT		= 0x00000200,
		FOAB_SHOW			= 0x00000400,
		FOAB_VERBATIM		= 0x00000800,
		FOAB_STATES			= 0xFFF00000,
		FOAB_HMOVE			= 0x00100000,
		FOAB_VMOVE			= 0x00200000,
		FOAB_RESIZE			= 0x00400000,
		FOAB_ROTATE			= 0x00800000,
		FOAB_SKEW			= 0x01000000,
		FOAB_EDIT			= 0x02000000,
		FOAB_IPEDIT			= 0x04000000,
		FOAB_BORDERSIZE		= 0x08000000,
	}	FOABOOL;
	/// end IMPLEMENT_VERBATIM_TEXT

	#define	WCB_FRAME_OBJ_CREATE		(MASK_FRAME | MASK_FRAME_OBJ)	
	#define	WCB_FRAME_OBJ_OPEN			(WCB_FRAME_OBJ_CREATE + 1)	
	#define	WCB_FRAME_OBJ_CREATE_OPEN	(WCB_FRAME_OBJ_CREATE + 2)	
	#define	WCB_FRAME_OBJ_CLOSE			(WCB_FRAME_OBJ_CREATE + 3)
	#define	WCB_FRAME_OBJ_CHECK  		(WCB_FRAME_OBJ_CREATE + 4)
	///CPY v4.133 9/9/96 CREATE_TEXT_LABEL 
	#define MASK_FRAME_TEXT_OBJ			0x0200
	#define	WCB_FRAME_TEXT_GET			(MASK_FRAME | MASK_FRAME_OBJ | MASK_FRAME_TEXT_OBJ)
	#define	WCB_FRAME_TEXT_SET			(WCB_FRAME_TEXT_GET + 1)
	/// CREATE_TEXT_LABEL
//----------------- CPY 8/8/00 t8321 v6.1022 WCB_FOR_LAYER_GR_TEXT_LABEL_ACCESS
	#define WCB_FRAME_TEXT_GET_STYLE		(WCB_FRAME_TEXT_GET + 2)
	#define WCB_FRAME_TEXT_SET_STYLE		(WCB_FRAME_TEXT_GET + 3)
	/// RVD 1/24/2002 QA70-525 v6.9192 IMPLEMENT_VERBATIM_TEXT
	////LY	1/18/02 QA70-414 CREATE_INVISIBLE_TEXT_OBJ
	//#define WCB_FRAME_TEXT_HIDE				(WCB_FRAME_TEXT_GET + 4)
	////LY	1/18/02 QA70-414 CREATE_INVISIBLE_TEXT_OBJ
	/// end IMPLEMENT_VERBATIM_TEXT
		// lpstr will be pointer to the following struct for input and output
		// this function returns 0 if success, and return the following errors
		#define	R_WCB_FRAME_TEXT_NOT_FOUND	1
		#define	R_WCB_FRAME_TEXT_WRONG_TYPE	2	// named obj is not a text object
		#define R_WCB_FRAME_TEXT_DATA_ERR	3

		typedef struct LAYER_GET_TEXT_LABEL_STYLE
		{
			DWORD	dwColor; // output
			short	nJustification; // only support TA_LEFT, TA_RIGHT and TA_CENTER
			LOGFONT	lf;
		}LAYER_GET_TEXT_LABEL_STYLE;
//----------------- end CPY 8/8/00 t8321 v6.1022 WCB_FOR_LAYER_GR_TEXT_LABEL_ACCESS	

#endif //WCB_FRAME_ACCESS


///CPY v4.05 3/8/96 WCB_WKS_HANDLING, change WCB_WKS_GET_NUM_COLS's def
/// ML v3.980 1/17/96 WCB_WKS_GET_NUM_COLS
//#define	WCB_WKS_GET_NUM_COLS	(MASK_WCB_NO_HWND + 41)
/// end WCB_WKS_GET_NUM_COLS
#define	WCB_WKS_GET_ID						(MASK_WCB_WKS + 1)
/// ML v4.090 5/19/96 CREATE_DATA_AND_PLOT
#define	WCB_WKS_CREATE_DATA_AND_PLOT		(MASK_WCB_WKS + 2)
///ANU v4.979 4/25/97 CREATE_OBJ
#define WCB_CREATE_DATA_WKS					(MASK_WCB_WKS + 3)
	///-------------------------------------------- TD 4/19/2000 t7588	CRASH_WITH_TOO_MANY_COLUMNS_IN_CREATE
	//#define MAX_NUM_CREATE_OBJS			20
	#define MAX_NUM_CREATE_OBJS			100
	//--------------------------------------------- end TD 4/19/2000 t7588
	typedef struct CREATE_OBJ_INFO
	{
		BYTE	nColType[MAX_NUM_CREATE_OBJS]; //column type	
		int		nNumTypes;						//number of types actually used
		char	szWksName[MAX_PATH];		//name of the new wks
		char	szTemplate[MAX_PATH];	//name of the template
		int		nPts;		///total rows in the  column
		//------------------------------------------------------------- CPY v6.0142 t4628 12/7/98 READ_ONLY_LAYER
		//BOOL	bEnum;		//enumerate the col names or not
		USHORT	wCntrl;// read_only, enumerate_col_names etc.
		//------------------------------------------------------------- end READ_ONLY_LAYER
		/// GCJ 3/4/99 t5510 v6.0169 ENUMERATE_WORKSHEET_PROPERTY
		char	szWksLabel[MAX_PATH];		//label of the new wks
		/// ENUMERATE_WORKSHEET_PROPERTY
		int		nTypeN;		//type to repeat if there are more columns than types
		///ANU v4.983 5/9/97 CREATE_OBJ_STRUCT_MEMORY
		///char*	strDataName[MAX_NUM_CREATE_OBJS]; //names of the dataset created
		char	strDataName[MAX_NUM_CREATE_OBJS][SNAME_SIZE]; //names of the dataset created
		///end CREATE_OBJ_STRUCT_MEMORY
	}CREATE_OBJ_INFO, FAR *LPCREATE_OBJ_INFO;
	//------------------------------------------------------------- CPY v6.0142 t4628 12/7/98 READ_ONLY_LAYER
	#define COI_READ_ONLY 0x1000
	#define COI_ENUM_COL_NAME	0x2000
	//------------------------------------------------------------- end READ_ONLY_LAYER
	/// GCJ 3/4/99 t5510 v6.0169 ENUMERATE_WORKSHEET_PROPERTY
	#define COI_ENUM_WKS_NAME	0x4000
	/// ENUMERATE_WORKSHEET_PROPERTY
BOOL	CreateDataWks( LPCREATE_OBJ_INFO lpCreateInfo, LPSTR lpstrColNames );
BOOL	MakeColStr( LPSTR	lpstInput );
BOOL	DeleteDataSet(LPCREATE_OBJ_INFO lpCreateInfo, LPSTR pstrColName);

#define WCB_DELETE_DATA_WKS_COLS					(MASK_WCB_WKS + 4)
//end	CREATE_OBJ

/// end CREATE_DATA_AND_PLOT
#define	MASK_WCB_WKS_NEED_ID		0x0800 /// 0xF000 is wks type mask
#define	WCB_WKS_GET_NUM_COLUMNS		(MASK_WCB_WKS | MASK_WCB_WKS_NEED_ID ) /// have to change name to ensure no old codes are using this
#define	WCB_WKS_GET_COL_NAME		(WCB_WKS_GET_NUM_COLUMNS + 1)
/// ML 5/1/96 GET_COLUMN_LABEL
#define	WCB_WKS_GET_COL_LABEL		(WCB_WKS_GET_NUM_COLUMNS + 2)
/// end GET_COLUMN_LABEL
/// ML v4.090 5/3/96 VARIOUS_WORKSHEET_MANIPULATIONS 
#define WCB_WKS_CLEAR_WORKSHEET_OF_DATA		(WCB_WKS_GET_NUM_COLUMNS + 3)
#define WCB_WKS_REMOVE_COLUMN_BY_NUMBER		(WCB_WKS_GET_NUM_COLUMNS + 4)
#define WCB_WKS_REMOVE_COLUMN_BY_NAME		(WCB_WKS_GET_NUM_COLUMNS + 5)
#define WCB_WKS_INSERT_COLUMN				(WCB_WKS_GET_NUM_COLUMNS + 6)
#define WCB_WKS_SET_BY_NUM_COLUMN_LABEL		(WCB_WKS_GET_NUM_COLUMNS + 7)
#define WCB_WKS_SET_BY_NAME_COLUMN_LABEL	(WCB_WKS_GET_NUM_COLUMNS + 8)
/// end VARIOUS_WORKSHEET_MANIPULATIONS
/// ML v4.090 5/17/96 CREATE_NEW_EMPTY_WORKSHEET
/// ML v4.090 5/23/96 CREATE_NON_EMPTY_WORKSHEET_ON_OPTION
//#define	WCB_WKS_CREATE_NEW_EMPTY			(WCB_WKS_GET_NUM_COLUMNS + 9)
#define	WCB_WKS_CREATE_NEW					(WCB_WKS_GET_NUM_COLUMNS + 9)
/// end CREATE_NON_EMPTY_WORKSHEET_ON_OPTION
/// end CREATE_NEW_EMPTY_WORKSHEET
/// ML v4.090 5/17/96 DESTROY_WORKSHEET
#define WCB_WKS_DESTROY						(WCB_WKS_GET_NUM_COLUMNS + 10)
/// end DESTROY_WORKSHEET
/// ML v4.090 5/19/96 VARIOUS_COLUMN_SETTINGS
#define WCB_WKS_SET_COLUMN_AS				(WCB_WKS_GET_NUM_COLUMNS + 11)
#define WCB_WKS_SET_COL_WIDTH				(WCB_WKS_GET_NUM_COLUMNS + 12)
#define WCB_WKS_SET_COL_NUM_DEC_PLACES		(WCB_WKS_GET_NUM_COLUMNS + 13)
/// end VARIOUS_COLUMN_SETTINGS
/// ML v4.090 5/22/96 MORE_WORKSHEET_STUFF
#define WCB_WKS_SHOW_COLUMN_LABELS			(WCB_WKS_GET_NUM_COLUMNS + 14)
#define WCB_WKS_SHOW_COLUMN_NAMES			(WCB_WKS_GET_NUM_COLUMNS + 15)
#define WCB_WKS_SET_COL_HEADING_HEIGHT		(WCB_WKS_GET_NUM_COLUMNS + 16)
#define WCB_WKS_GET_COL_LABEL_BY_NAME		(WCB_WKS_GET_NUM_COLUMNS + 17)
/// end MORE_WORKSHEET_STUFF
/// ML v4.090 5/24/96 SET_COLUMN_NAME
#define WCB_WKS_SET_COL_NAME				(WCB_WKS_GET_NUM_COLUMNS + 18)
/// end SET_COLUMN_NAME
/// YN v4.090 5/28/96 SET_WKS_LABEL
#define WCB_WKS_SET_WKS_LABEL				(WCB_WKS_GET_NUM_COLUMNS + 19)
/// end SET_WKS_LABEL
/// ML 6/3/96 SET_COLUMN_TYPE_AS
#define	WCB_WKS_SET_COL_TYPE				(WCB_WKS_GET_NUM_COLUMNS + 20)
// see below for possible types:
/// end SET_COLUMN_TYPE_AS  
///  YN  v4.10 6/14/96  ADD_GetColumnWidth_FUNCTIONS
#define WCB_WKS_GET_COL_WIDTH				(WCB_WKS_GET_NUM_COLUMNS + 21)
///  end  ADD_GetColumnWidth_FUNCTIONS
/// ML v4.10 6/18/96 GET_COLUMN_TYPE
#define WCB_WKS_GET_COL_TYPE				(WCB_WKS_GET_NUM_COLUMNS + 22)
/// end GET_COLUMN_TYPE
/// ML v4.11 7/1/96 SHOW_WORKSHEET_NAME_LABEL_OR_BOTH
#define	WCB_WKS_SHOW_WIN_NAME_LABEL_BOTH	(WCB_WKS_GET_NUM_COLUMNS + 23)
/// end SHOW_WORKSHEET_NAME_LABEL_OR_BOTH
///ANU v4.14 12/23/96 SETCOLUMNTITLE, new public function
#define	WCB_WKS_SET_BY_NUM_COLUMN_TITLE		(WCB_WKS_GET_NUM_COLUMNS + 24)
///end SETCOLUMNTITLE

//-------------	CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
#define	WCB_WKS_SET_RANGE					(WCB_WKS_GET_NUM_COLUMNS + 25)
/// additional constants for redraw options in the lpLong[4] parameter
/// GCJ 11/6/98 t4423 v6.0136 WRONG_STEREO_WAVEFILE_IMPORT
#define WCB_WKS_SET_MAX_ROW_SIZE			(WCB_WKS_GET_NUM_COLUMNS + 26)
/// TD 8/11/2000 t8358 v6.1022 WCB_FOR_WKS_DISPLAY_PROPERTIES
#define WCB_WKS_GET_DISPLAY_PROPS			(WCB_WKS_GET_NUM_COLUMNS + 27)
#define WCB_WKS_SET_DISPLAY_PROPS			(WCB_WKS_GET_NUM_COLUMNS + 28)
/// end WCB_FOR_WKS_DISPLAY_PROPERTIES
/// end  WRONG_STEREO_WAVEFILE_IMPORT
	#define	WSR_SETRANGE_EXPAND	0x0200
	/* data range has been increased, need to update
	 * all the plots to the new range.
	 */
	#define	WSR_SETRANGE_DRAW_ALL	0x0100
	/* Redraw all the data points */
	
	#define	WSR_SETRANGE_DRAW_RANGE	0x4000
	/* Redraw only the specified range, must
	 * use together with WSR_SETRANGE_EXPAND
	 */
//-------------	end CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE

//------------------ CPY v6.1046 9/8/00 t8539 NEED_COLUMN_PLOT_AS_IN_WCB
#define WCB_WKS_GET_COLUMN_AS				(WCB_WKS_GET_NUM_COLUMNS + 29)
//------------------ end CPY v6.1046 9/8/00 t8539 NEED_COLUMN_PLOT_AS_IN_WCB

/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
#define WCB_WKS_GET_NUM_OBJECT_PTR		(WCB_WKS_GET_NUM_COLUMNS + 30)
#define	WCB_WKS_MATRIX_RESET_DIM		(WCB_WKS_GET_NUM_COLUMNS + 31)
/// end MULTIFRAME_TIFF_IMPORT


//// WCB_WKS_HANDLING




/// ML v4.10 6/18/96 MOVED_TO_ORGDLL_H
///// ML 6/3/96 SET_COLUMN_TYPE_AS
////  possible types for WCB_WKS_SET_COL_TYPE and WCB_WKS_INSERT_COLUMN: 
//enum {
//	WKSCOL_NUMERIC = 0,
//	WKSCOL_TEXTUAL,
//	WKSCOL_MIXED,
//};
/// end SET_COLUMN_TYPE_AS
///	CPY v4.97 3/11/97 TEST_CELL_NUMERIC_OR_NOT
//#define	LABELS_TYPE		0x000F	// numberic, date, text-from-data
#define	LABELS_TYPE			OKCOLTYPE_MASK 

//
	///CPY 11/7/96 EXTERANL_DATA, introduce OKCOLTYPE_ 
#define	LABELS_NUMERIC		OKCOLTYPE_NUMERIC	//0
#define	LABELS_TEXT			OKCOLTYPE_TEXT		//1
#define	LABELS_TIME			OKCOLTYPE_TIME		//2
#define	LABELS_DATE			OKCOLTYPE_DATE		//3
#define	LABELS_MONTH		OKCOLTYPE_MONTH		//4
#define	LABELS_DAY			OKCOLTYPE_WEEKDAY	//5
#define	LABELS_COLUMN		OKCOLTYPE_COLUMN	//6
#define	LABELS_DATASET		OKCOLTYPE_DATASET	//7
#define	LABELS_DATASET_X	OKCOLTYPE_DATASET_X	//8
#define	LABELS_MIXED		OKCOLTYPE_TEXT_NUMERIC	//9 ///CPY v4.09 5/6/96 VAR_SIZE_COL
/// YuI 09/27/01 v6.9091 t9456 IMPLEMENTATION_OF_CATEGORICAL_PLOT
#define LABELS_CATEGORICAL	OKCOLTYPE_CATEGORICAL//0x000A
/// end IMPLEMENTATION_OF_CATEGORICAL_PLOT
// if you introduce new format be sure to modify LABELS_LAST_FORMAT

/// YuI 1/16/03 v7.0489 QA70-3698 COLUMNS_DESIGNATIONS_FOR_WORKSHEET_CLASS
#define	LABELS_LAST_FORMAT	LABELS_CATEGORICAL
/// end COLUMNS_DESIGNATIONS_FOR_WORKSHEET_CLASS
/// end MOVED_TO_ORGDLL_H

/// ML v4.11 7/1/96 MOVED_FROM_COMMON_H_TO_ORGDLL_H_SO_THAT_STSDLL_CAN_ACCESS_IT
#define	PLOT_CNTRL3_WIN_TITLE_BITS			0x0300
#define	PAGE_WIN_TITLE_STYLE(p)				(((p)->cntrl3 & PLOT_CNTRL3_WIN_TITLE_BITS) >> 8)
#define	SET_PAGE_WIN_TITLE_STYLE(p,n)	 	(p)->cntrl3 &= ~PLOT_CNTRL3_WIN_TITLE_BITS,(p)->cntrl3 |= ((n)&0x0003) << 8

/// SY 06-16-2003 QA70-4469 v7.0603 ADD_TITLESHOW_PROPERTY_FOR_PAGE
// Move to OC_Const.h
///	#define	WIN_TITLE_AUTO			0
///	#define	WIN_TITLE_SHOW_LABEL	1
///	#define	WIN_TITLE_SHOW_NAME		2
///	#define	WIN_TITLE_SHOW_BOTH		3
///
///	///EJP v4.03 03-07-96 WIN_TITLE_SHOW_AUTO
///	#define WIN_TITLE_SHOW_AUTO		WIN_TITLE_SHOW_NAME
///	///end WIN_TITLE_SHOW_AUTO
/// end ADD_TITLESHOW_PROPERTY_FOR_PAGE
///	 WIN_TITLE_SHOW_NAME_LABEL
//-------------------------------------------------
/// end MOVED_FROM_COMMON_H_TO_ORGDLL_H_SO_THAT_STSDLL_CAN_ACCESS_IT











#define	WCB_DOBUTTON		MASK_WCB_OPTION_HWND
/// CPY v3.69
#define	WCB_AXIS_SCALE_CVT	(MASK_WCB_OPTION_HWND+1) /// use axis transform to cvt double
///

/****************************************************
 * the following command need a valid worksheet hWnd
 ****************************************************/
 
#define	WCB_PUT_DATA		0
#define	WCB_CNTRL_DATA		1
#define	WCB_GET_PROCESSES	2
#define	WCB_GET_CELL		10 /* single cell */
#define	WCB_GET_DATA		11 /* pass HPSHORT to get data */
#define	WCB_GET_WKS_SIZE	13 /* LP long array of two # = nRows,nCols */
#define	WCB_SETUP_OBJ		17 /* set up real-time object */

#define	WCB_SET_UPDATE		18 /* check animation properties of all related plots */

// drawing related commands
#define	WCB_DRAW_BEGIN		MASK_NEED_DRAW
// the following has to be between BEGIN and END

#define	WCB_DRAW_END		(MASK_NEED_DRAW | MASK_DRAWING_MODE)
#define	WCB_DRAW_AP_TO_LP	(WCB_DRAW_END+1)
	// cvt axes point to logical point
#define	WCB_DRAW_LP_TO_AP	(WCB_DRAW_END+2)

// basic drawing lines
#define	WCB_DRAW_MOVETO		(MASK_DRAWING_OPTN_COOR | MASK_NEED_DRAW | MASK_DRAWING_MODE)
#define WCB_DRAW_LINETO		(WCB_DRAW_MOVETO+1)

///CPY v4.05 3/8/96 WCB_WKS_HANDLING
ULONG	WCB_wks_callback(HWND hWnd,USHORT msg,DWORD lParam,LPSTR lpStr);
/// WCB_WKS_HANDLING

// dataset access to Origin
ULONG	DataSetAccess(HWND hWnd,USHORT msg,DWORD lParam,LPSTR lpStr);

#define	WCB_DATA_GET_ID		MASK_DATASET	// get a column id from a given name
/// CPY v3.782 GET_WKS_COL_ID
#define	WCB_DATA_GET_COL_ID	(MASK_DATASET + 1) // col number is specified in range[0] and starts from 1
///
#define WCB_DATA_SET_SX_4_SY	(MASK_DATASET + 2)	 //CPY 4/16/03 QA70-4601 v7.0564 OC_ADD_PLOT_KEEP_CURVE_X
#define	WCB_DATA_ADD_CURVE	(MASK_DATASET + 3) // add a curve to current layer
#define	WCB_DATA_RMV_CURVE	(MASK_DATASET + 4) // remove a curve from the current layer
#define	WCB_DATA_SET_XVAL_4_Y	(MASK_DATASET + 5) // Set a y column's x values
#define	WCB_DATA_SET_XCOL_4_Y	(MASK_DATASET + 6) // Set a x col for y col.
#define	WCB_DATA_GET_XCOL_4_Y	(MASK_DATASET + 7) // Get a x col for y col.
#define	WCB_DATA_CREATE_XDATA	(MASK_DATASET + 8) // Create an x col
#define	WCB_DATA_CREATE_YDATA	(MASK_DATASET + 9) // Create a y col
#define	WCB_DATA_SET_SAME_X	(MASK_DATASET + 10) // assign x col of one col to another   
/// CPY v3.69
#define	WCB_DATA_SET_INTERNAL	(MASK_DATASET + 11) // set internal flags to enable/disable using axes transform for GET_XY_VALUES
	/// flags defined so far
	#define	WDSI_X_TRANSFORM	X_AXIS
	#define	WDSI_Y_TRANSFORM	Y_AXIS     
///SB v3.77 3/7/95
#define WCB_DATA_CLEAN_TEMP_DATASET (MASK_DATASET + 12) //clean temporary dataset
///
/// QZCao, 11/6/95, v3.85, GET_X_COL_VAL_IN_PLOT
#define	WCB_DATA_GET_X_4_Y_PLOT  (MASK_DATASET + 13)// Get x col or value for y col when the dataset is inside a plot.
///
/// ML v3.980 1/15/96 WCB_DATA_GET_COL_FROM_COLNAME
#define WCB_DATA_GET_COL_FROM_COLNAME	(MASK_DATASET + 14)
/// end WCB_DATA_GET_COL_FROM_COLNAME
/// ML v4.133 9/5/96 CREATE_ONE_TEMPORARY_SERIES
#define	WCB_DATA_CREATE_ONE_TEMPORARY	(MASK_DATASET + 15)
/// end CREATE_ONE_TEMPORARY_SERIES

//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_ID_FROM_COL_NUM	(WCB_DATA_GET_VALUE + 37)
//#define	WCB_DATA_ID_FROM_COL_NAME	(WCB_DATA_GET_VALUE + 38)
#define	WCB_DATA_ID_FROM_COL_NUM	(MASK_DATASET + 16)
#define	WCB_DATA_ID_FROM_COL_NAME	(MASK_DATASET + 17)

#define	WCB_DATA_OPEN_OBJ	(MASK_DATASET + 18) // Open an object for saving the peak fitting data such as parameters
#define	WCB_DATA_CLOSE_OBJ	(MASK_DATASET + 19) // Open an object for saving the peak fitting data such as parameters
#define WCB_DATA_CHECK_STOP	(MASK_DATASET + 20)
#define	WCB_DATA_MSG_BOX	(MASK_DATASET + 21)
#define WCB_DATA_MSG_STATUS	(MASK_DATASET + 22)

#define WCB_CHK_SYSTEM_VAR	(MASK_DATASET + 23)
#define	WCB_DATA_GET_WKS_INFO	(MASK_DATASET + 24)

#define	WCB_DATA_GET_SCR_VAL	(MASK_DATASET + 25) // Get screen space value
#define	WCB_DATA_GET_ACT_VAL	(MASK_DATASET + 26) // Get real value
#define	WCB_DATA_SET_PARA_VALUE	(MASK_DATASET + 27) // Set para value 2 origin.
#define	WCB_DATA_DEL_VARIABLE	(MASK_DATASET + 28) // del a variable
#define	WCB_DATA_ADD_VARIABLE	(MASK_DATASET + 29) // Add a variable
#define	WCB_DATA_CAL_YSCRIPT	(MASK_DATASET + 30)	// Calculate yscript
#define	WCB_DATA_CAL_EXPRESSION	(MASK_DATASET + 31)	// Calculate expression
#define	WCB_DATA_GET_DATASET_LIST	(MASK_DATASET + 32)
#define	WCB_DATA_CREATE_DATA	(MASK_DATASET + 33)
#define	WCB_DATA_CHECK_LINEAR	(MASK_DATASET + 34)
#define	WCB_DATA_LINEAR_FIT		(MASK_DATASET + 35)
/// YuI 10/1/02 v 7.0408 QA70-3074 UID_FOR_SERIES_POINTER
#define	WCB_DATA_GET_DATASET_UID_LIST	(MASK_DATASET + 36)
#define	WCB_DATA_ID_FROM_UID	(MASK_DATASET + 37)
/// end UID_FOR_SERIES_POINTER
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
//--------------- SIMULATE_USE_SEPARATE_WKS



#define	WCB_DATA_GET_VALUE	(MASK_DATASET | MASK_DATASET_SERIES)
#define	WCB_DATA_SET_VALUE	(WCB_DATA_GET_VALUE + 1)
#define	WCB_DATA_GET_2VALUE	(WCB_DATA_GET_VALUE + 2)
#define	WCB_DATA_GET_XY_VALUE	(WCB_DATA_GET_VALUE + 3)
#define	WCB_DATA_GET_Y_FROM_X	(WCB_DATA_GET_VALUE + 4)
#define	WCB_DATA_GET_X_FROM_Y	(WCB_DATA_GET_VALUE + 5) // get x val for given y col
#define	WCB_DATA_TEST_ID	(WCB_DATA_GET_VALUE + 6)
#define	WCB_DATA_SET_RANGE	(WCB_DATA_GET_VALUE + 7)
	
//---------	CPY 4/29/03 QA70-4256 v7.0573 SOURCE_RANGE_IN_CURVEBASE_RET_FIX
enum {RANGE_I1, RANGE_I2, RANGE_I1_SEL, RANGE_I2_SEL, RANGE_IS_SEL, RANGE_SIZE};
// WCB_DATA_GET_RANGE used to need only size of 4, but now, must have buffer of RANGE_SIZE
#define	WCB_DATA_GET_RANGE	(WCB_DATA_GET_VALUE + 8) // get a column range;
//--------- end SOURCE_RANGE_IN_CURVEBASE_RET_FIX
#define	WCB_DATA_CHECK_RANGE	(WCB_DATA_GET_VALUE + 9)

/// QZCao, v3.8, get dataset both x & y range
#define	WCB_DATA_GET_XY_RANGE	(WCB_DATA_GET_VALUE + 10)
///
//-------------	CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
#define	WCB_DATA_SET_RANGE_REDRAW	(WCB_DATA_GET_VALUE + 11)	
//-------------	end CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
///
#define	WCB_DATA_SET_XY_VALUE	(WCB_DATA_GET_VALUE + 12)
///

//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_TEST_DATA	(WCB_DATA_GET_VALUE + 21) // test if a column of given name exists
//#define	WCB_DATA_GET_SCR_VAL	(WCB_DATA_GET_VALUE + 22) // Get screen space value
//#define	WCB_DATA_GET_ACT_VAL	(WCB_DATA_GET_VALUE + 23) // Get real value
//#define	WCB_DATA_SET_PARA_VALUE	(WCB_DATA_GET_VALUE + 24) // Set para value 2 origin.
//#define	WCB_DATA_DEL_VARIABLE	(WCB_DATA_GET_VALUE + 25) // del a variable
//#define	WCB_DATA_ADD_VARIABLE	(WCB_DATA_GET_VALUE + 26) // Add a variable
/// QZCao, v3.781, 4/12/95, no need for this removed
//#define	WCB_DATA_RUN_SCRIPT	(WCB_DATA_GET_VALUE + 27) // run a piece of scripts
///
//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_OPEN_OBJ	(WCB_DATA_GET_VALUE + 28) // Open an object for saving the peak fitting data such as parameters
//#define	WCB_DATA_CLOSE_OBJ	(WCB_DATA_GET_VALUE + 29) // Open an object for saving the peak fitting data such as parameters
//#define WCB_DATA_CHECK_STOP	(WCB_DATA_GET_VALUE + 30)
//#define	WCB_DATA_MSG_BOX	(WCB_DATA_GET_VALUE + 31)
//#define WCB_DATA_MSG_STATUS	(WCB_DATA_GET_VALUE + 32)
//---------------

//#define	WCB_DATA_CAL_YSCRIPT	(WCB_DATA_GET_VALUE + 33)	// Calculate yscript
//#define	WCB_DATA_CAL_EXPRESSION	(WCB_DATA_GET_VALUE + 34)	// Calculate expression

//#define	WCB_DATA_GET_DATASET_LIST	(WCB_DATA_GET_VALUE + 35)
#define	WCB_DATA_GET_ERRORBAR_COL	(WCB_DATA_GET_VALUE + 13)
//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_GET_WKS_INFO		(WCB_DATA_GET_VALUE + 39)

/// CPY v3.74 apparent fit and increment checking
#define	WCB_DATA_X_GET_VALUE	(WCB_DATA_GET_VALUE + 14)
#define	WCB_DATA_Y_GET_VALUE    (WCB_DATA_X_GET_VALUE + 1)
#define	WCB_DATA_X_SET_VALUE    (WCB_DATA_X_GET_VALUE + 2)
#define	WCB_DATA_Y_SET_VALUE    (WCB_DATA_X_GET_VALUE + 3)

#define	WCB_DATA_CHECK_X_INC	(WCB_DATA_X_GET_VALUE + 4) /// return 1 if inc test failed, 0 if OK
/// CPY v3.781
#define	WCB_DATA_GET_RAW_VALUE	(WCB_DATA_X_GET_VALUE + 5)
///
#define	WCB_DATA_CHECK_INC		(WCB_DATA_X_GET_VALUE + 6) /// return 1 if inc test failed, 0 if OK
/// QZCao v3.78, 4/24/95
//#define	WCB_DATA_CREATE_DATA	(WCB_DATA_GET_VALUE + 57)
#define	WCB_DATA_CHECK_RANGE2	(WCB_DATA_X_GET_VALUE + 7)

/// QZCao v3.78, March 19, 95
#define	WCB_DATA_CREATE_NAME	(WCB_DATA_X_GET_VALUE + 8)
#define	WCB_DATA_GET_ELEMENT	(WCB_DATA_X_GET_VALUE + 9) /// return ptr to element array
#define	WCB_DATA_I_FROM_X	(WCB_DATA_X_GET_VALUE + 10) ///
//#define	WCB_DATA_CHECK_LINEAR	(WCB_DATA_X_GET_VALUE + 11)
//#define	WCB_DATA_LINEAR_FIT	(WCB_DATA_X_GET_VALUE + 12)
///

/// ML v3.821 8/30/95 ONE_DATASET_ONLY
#define WCB_DATA_GET_ONE_TEMP		(WCB_DATA_X_GET_VALUE + 13)
#define WCB_DATA_KILL_ONE_TEMP		(WCB_DATA_X_GET_VALUE + 14)
/// end ONE_DATASET_ONLY
/// ML v3.840 9/22/95 PICKING_PEAKS_ORIGIN_WAY
#define	WCB_DATA_PICK_PEAKS_ORIGIN_WAY	(WCB_DATA_X_GET_VALUE + 15)
/// end PICKING_PEAKS_ORIGIN_WAY

//-------- CPY v5.002 7/30/97 b2869 X_RANGE_FOR_X_DATASET
#define WCB_DATA_GET_DEPENDENT_ID		(WCB_DATA_X_GET_VALUE + 20)
#define	WCB_DATA_GET_MATH_LIMITS		(WCB_DATA_X_GET_VALUE + 21)
//-------- X_RANGE_FOR_X_DATASET

//LY	12/14/01 t9798 SERIESPTR_MANAGER
//----------------- TD 12/08/2000 v6.1073 t8767 WCB_TO_INTERUPT_SERIES_DELETION
//#define	WCB_DATA_ATTACH_MOCA	(WCB_DATA_X_GET_VALUE + 22)
//----------------- end WCB_TO_INTERUPT_SERIES_DELETION
#define	WCB_DATA_ATTACH_COOKIE_MANAGER	(WCB_DATA_X_GET_VALUE + 22)
//end t9798 SERIESPTR_MANAGER

/// YuI 9/27/02 v7.0406 QA70-3066 DISPLAY_NAME_IMPLEMENTATION
typedef struct tagDISPLAYNAMESTRUCT
{
	LPSTR	lpszBuffer;
	int		nBufferSize;
	DWORD	dwCntrl;
}	DISPLAYNAMESTRUCT;

//possible bits in dwCntrl of SERIESDISPLAYNAMESTRUCT;
typedef enum tagDISPLAYNAMECTRL
{
	DNC_DO_NOT_MODIFY							= 0x00000000,
	DNC_GENERAL_MASK							= 0x0000ffff,
	DNC_SERIES_SPECIFIC_MASK					= 0x00ff0000,
	DNC_PAGE_SPECIFIC_MASK						= 0xff000000,
	DNC_REPLACE_TAB_WITH_SPACE					= 0x00000001,
	DNC_REPLACE_CARRIAGE_RETURN_WITH_SPACE		= 0x00000002,
	DNC_SERIES_ADD_PAGE_NAME					= 0x00010000,
	DNC_SERIES_COL_NAME_AS_SERIES_NAME			= 0x00020000,//this bit if series has name Data1_A will change it to A
}	DISPLAYNAMECTRL;

#define	WCB_DATA_GET_DISPLAY_NAME		(WCB_DATA_X_GET_VALUE + 23)
/// end DISPLAY_NAME_IMPLEMENTATION

//---------------------------- CPY 8/6/01 t8777 CURVE_SORT
//	WCB_DATA_X_GET_VALUE based ids can go from 1 to 52, since  WCB_DATA_KILL_WITH_DEPENDENT
// below is defined as (WCB_DATA_GET_VALUE + 67) and WCB_DATA_X_GET_VALUE as (WCB_DATA_GET_VALUE + 14)
//
#define WCB_DATA_SORT		(WCB_DATA_X_GET_VALUE + 24)
//---------------------------- end CPY 8/6/01 t8777 CURVE_SORT

/// YuI 12/31/02 QA70-3592 v7.0477 ORIGIN_C_AND_INTERNAL_DATA_PROTECTION
#define	WCB_DATA_GET_WRITE_PROTECTED	(WCB_DATA_X_GET_VALUE + 25)
/// end ORIGIN_C_AND_INTERNAL_DATA_PROTECTION			

/// ML v3.84 9/25/95 KILL_DATASET_TOGETHER_WITH_ITS_DEPENDENT
#define	WCB_DATA_KILL_WITH_DEPENDENT	(WCB_DATA_GET_VALUE + 67)
/// end KILL_DATASET_TOGETHER_WITH_ITS_DEPENDENT
/// ML v3.97 12/11/95 WCB_DATA_IS_TEXT_DATASET
#define	WCB_DATA_IS_TEXT_DATASET		(WCB_DATA_GET_VALUE + 68)
/// end WCB_DATA_IS_TEXT_DATASET
/// ML v3.970 12/11/95 TEXT_DATASET_VALUE
#define	WCB_DATA_SET_TEXT_VALUE			(WCB_DATA_GET_VALUE + 69)
#define	WCB_DATA_GET_TEXT_VALUE			(WCB_DATA_GET_VALUE + 70)
/// end TEXT_DATASET_VALUE 
/// ML v3.980 1/4/96 MOMASK_IMPLEMENTATION
#define	WCB_DATA_SET_MASK				(WCB_DATA_GET_VALUE + 71)
/// end MOMASK_IMPLEMENTATION
/// ML v3.981 1/23/96 WCB_DATA_GET_NUM_VALUE_AS_TEXT
#define	WCB_DATA_GET_NUM_VALUE_AS_TEXT	(WCB_DATA_GET_VALUE + 72)
/// end WCB_DATA_GET_NUM_VALUE_AS_TEXT
/// ML v4.090 5/17/96 RANK_ONE_DATASET
#define WCB_DATA_RANK					(WCB_DATA_GET_VALUE + 73)
/// end RANK_ONE_DATASET


//----- YL CPY v4.983 5/9/97 ADD_SET_LABEL_FROM_ID
#define WCB_DATA_SET_COL_LABEL			(WCB_DATA_GET_VALUE + 74)
//-----

//------------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
////#define	WCB_DATA_GET_DATA_NAME	(MASK_DATASET + 2) // get a column name from a given id
#define WCB_DATA_GET_WKS_NAME			 (WCB_DATA_GET_VALUE + 76)
#define WCB_DATA_GET_DATA_NAME			 (WCB_DATA_GET_VALUE + 77)
#define WCB_DATA_GET_COL_NAME			 (WCB_DATA_GET_VALUE + 78)
//------------------- SIMULATE_USE_SEPARATE_WKS

//------------ CPY v6.0297 t8155 7/5/00 MORE_EFFICIENT_DATASET_ACCESS_FROM_MOCA
#define WCB_DATA_GETSET_VALUE			 (WCB_DATA_GET_VALUE + 80)
typedef struct tagCellValue {
	WORD		wFlags;
	DWORD		index;
	double		dbValue;
	float		fValue;
	long		lValue;
	short		sValue;
} OCELL_VALUE;
#define OCV_SET				0x1000	// if not then get
#define	OCV_NO_CHK_BOUND	0x2000	// otherwise do normal bounds check, slower but can expand range automatically
// return values, for both set and get values
#define RCV_WRONG_INTERNAL_TYPE		1
#define	RCV_ERROR_CHECKSET_RANGE	2
//------------ end CPY v6.0297 t8155 7/5/00 MORE_EFFICIENT_DATASET_ACCESS_FROM_MOCA

//-------------- CPY 3/12/01 t8965 v6.1100 WCB_GET_FUNC_POINTERS_FOR_SERIES_ELEMENTS
#define WCB_DATA_GET_BUFFER				 (WCB_DATA_GET_VALUE + 81)	// lpData = GET_DATA_BUFFER *
//#define WCB_DATA_RELEASE_BUFFER	// lpData = NULL  to release buffer
	typedef struct tagGetDataBuffer
	{
		DWORD	dwSize;	// in row indexing, must provide as input, and will be updated in return
		short	nElementSize;// 1 = BYTE, 2= short and etc.
		short	nElementType;//FSI_DOUBLE, FSI_LONG, FSI_TEXT ...FSI_MIXED, FSI_CHAR
		/// TD 5-16-01	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC
		LPBYTE	lpMask;
		/// end	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC
	} GET_DATA_BUFFER;
//-------------- end CPY 3/12/01 t8965 v6.1100 WCB_GET_FUNC_POINTERS_FOR_SERIES_ELEMENTS
/// TD 4/3/01 t9034	OVECTOR_SUPPORT	 (Moved from Series.h so this can be used from MOCA)
//#ifdef _WIN32
#pragma pack(push,1)
//#endif ///_WIN32	
#define MIXED_ELEMENT_ARRAY_MIN_SIZE	8	/// assume extended is 8 bytes
typedef struct MIXED_ELEMENT {
	BYTE		m_type;
	BYTE		format;
	//----- CPY v4.977 4/23/97 t1993 MIXED_TEXT_AS_PTR 
	//extended	v;
	#ifdef MIXED_TEXT_AS_PTR
		union {
			double	v;
			PTSTR		pstr;
			TCHAR		str[MIXED_ELEMENT_ARRAY_MIN_SIZE];		
		};
	#else
		double	v;
	#endif /// !MIXED_TEXT_AS_PTR
	//-----
}MIXED_ELEMENT,  * LPMIXED_ELEMENT;
//#ifdef _WIN32
#pragma pack(pop)
//#endif ///_WIN32	
/// end t9034	OVECTOR_SUPPORT
/// TD 5-16-01	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC
typedef double (*LPFNElemVal )(void*, long);
typedef int		(*LPFNDataMask)(void*, WORD, LONG, LPARAM);
typedef struct DataElementAccessFns
{
	LPFNElemVal		m_lpfnElemVal;
	LPFNDataMask	m_lpfnDataMask;


} *LPDataElementAccessFns;
/// end	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC
///
///STH v3.78 4/4/95 FIND_INI written qcao added by sth
/// CPY v3.781 removed after adding Dr. Cao's
//#define	WCB_GET_INIT_FILE	(MASK_WCB_NO_HWND+25)
///

///sb v 3.77 3/7/95 removed 3/8/95 because same as     WCB_DATA_SET_XVAL_4_Y
//#define WCB_DATA_SET_NO_X       (WCB_DATA_GET_VALUE + 52) // assign x col when none exists


///

/*
#define	WCB_DATA_GETINITFILE	(WCB_DATA_GET_VALUE + 45)
#define	WCB_DATA_GETPATH1	(WCB_DATA_GET_VALUE + 46)
#define	WCB_DATA_GETPATH2	(WCB_DATA_GET_VALUE + 47)
#define	WCB_DATA_OPENFITFUNC	(WCB_DATA_GET_VALUE + 48)
#define	WCB_DATA_READ1LINE	(WCB_DATA_GET_VALUE + 49)
#define	WCB_DATA_CLOSEFITFUNC	(WCB_DATA_GET_VALUE + 50)
*/
/// TD 10-29-01	CATEGORICAL_DATA
#define WCB_DATA_CATEGORICAL_MAP				 (WCB_DATA_GET_VALUE + 82)

/// TD 1-29-02 QA70-592 v6.9197 PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL
#define SERIES_RANGE_SET_NEW_RANGE					0x0001
#define SERIES_RANGE_GET_CURRENT_RANGE				0x0002
#define WCB_DATA_SET_SERIES_RANGE				 (WCB_DATA_GET_VALUE + 83)	//Only Changes s->i1[i2] and nothing else
/// end PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL
/// TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE
#define WCB_DATA_GET_ALL_X_FROM_Y					(WCB_DATA_GET_VALUE + 84)	
#define WCB_DATA_TRIM_LEFT							(WCB_DATA_GET_VALUE + 85)
#define WCB_DATA_TRIM_RIGHT							(WCB_DATA_GET_VALUE + 86)

/// TD 3-13-02 t1081 INDEPENDENT_FLAGS_REMOVE_AMBIGUITY
//#define		TRIMSERDWCTRL_CONSIDER_X					0x00010000UL	// take x-dataset into account when scanning for missing values
//#define		TRIMSERDWCTRL_PLOTTING						0x00020000UL	// the mask consideration inside check_missing_values() 
//#define		TRIMSERDWCTRL_LEFT_WITH_SHIFT_LEFT			0x00040000UL	// do shift left when TRIMSERMSG_LEFT 
//#define		TRIMSERDWCTRL_RIGHT_WITH_SHRINK_RIGHT		0x00080000UL	// do size shrinking when TRIMSERMSG_RIGHT 

#define		TRIMSERDWCTRL_CONSIDER_MISSINGVALS_IN_X		0x00010000UL	// take x-dataset into account when scanning for missing values
#define		TRIMSERDWCTRL_PLOTTING						0x00020000UL	// the mask consideration inside check_missing_values() 
#define		TRIMSERDWCTRL_LEFT_WITH_SHIFT_LEFT			0x00040000UL	// do shift left when TRIMSERMSG_LEFT 
#define		TRIMSERDWCTRL_RIGHT_WITH_SHRINK_RIGHT		0x00080000UL	// do size shrinking when TRIMSERMSG_RIGHT 
#define		TRIMSERDWCTRL_SHRINK_OR_SHIFT_X_WITH_Y		0x00100000UL	// do size shrinking when TRIMSERMSG_RIGHT 
/// end INDEPENDENT_FLAGS_REMOVE_AMBIGUITY
/// end TEMP_CURVE_FROM_YDATA_VALUE

/// TD 3-19-02 WCB_TO_SET_IMAX_WITH_REDRAW_OPTIONS
#define WCB_DATA_SET_IMAX							(WCB_DATA_GET_VALUE + 87)
/// end WCB_TO_SET_IMAX_WITH_REDRAW_OPTIONS
/// TD 3-27-02 UPDATE_MUST_UNLOCK_HANDLE
#define WCB_DATA_UPDATE_OBJECT						(WCB_DATA_GET_VALUE + 88)
/// end UPDATE_MUST_UNLOCK_HANDLE
// Size of UINT array sent with this msg
#define CM_WCBDATA_SIZE_DWARRAY					4
//DWORD	dwWCBData[4];	//[0]Sub WCB Msg(CM_SUBWCB_SETNEW_SAVEOLD, CM_SUBWCB_GETMAP, CM_SUBWCB_RESET_TO_OLD) defined in Orgdll.h
						//[1]Type of Catagorical dataset (Nominal, Ordinal)
						//[2]Type before construction(Nominal, Ordinal, NULL)
						//[3]LPVOID If Older type was different and Not null store the Map for reset

/// Sub Messages for categorical data
#define	CM_SUBWCB_SETNEW_SAVEOLD				 0
#define	CM_SUBWCB_SETNEW_DONOT_SAVEOLD			 1
#define	CM_SUBWCB_GETMAP						 2
#define	CM_SUBWCB_RESET_TO_OLD					 3
/// end	CATEGORICAL_DATA


/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
#define WCB_DATA_CURVE_GET_RELATED_SERIES			(WCB_DATA_GET_VALUE + 89)
// lpStr in DataSetAccess points at this structure:
#define		MAX_NUM_CURVE_RELATED_SERIES			10	// just for this message
typedef	struct	tagGETCURVERELATEDSERIES
{
	DWORD			dwSeriesPtr;			// the source (curve) y-dataset whose related are being sought.
	OSERIESTAG		stSeriesPtsAngTags[MAX_NUM_CURVE_RELATED_SERIES];
	int				nNumInArray;		// how many are actually put in the array
} GETCURVERELATEDSERIES,	*PGETCURVERELATEDSERIES;
/// end CURVE_EXTENSION_WITH_RELATED_DATASETS



// QZCao & H v3.71, begin
typedef LPSTR FAR* LPPSTR;

#ifndef	MASK_FIT
	#define	MASK_WCB_NO_HWND	0x1000
	#define	MASK_WCB_OPTION_HWND	0x2000
	#define	MASK_FIT		0x4000
#endif

#ifndef	MASK_PKFIT
	#define	MASK_WCB_NO_HWND	0x1000
	#define	MASK_WCB_OPTION_HWND	0x2000
	#define	MASK_FIT		0x4000
	#define	MASK_PKFIT		0x8000
#endif

#define	FIT_CURVE_COLOR		0
#define	FIT_CURVE_KIND		1
#define	FIT_CURVE_SIZE		2
#define	FIT_CURVE_DASH		3
#define	FIT_CURVE_WIDTH		4
#define	FIT_CURVE_SYMBCNTRL	5
#define	FIT_CURVE_ENUMMER	6
#define	FIT_CURVE_CONNECT	7

#define	WPI_PARAM	0
#define WPI_INVALID	1
#define	WPI_NUMERIC	2
#define WPI_VARIABLE	3
/* return 
 * 0 : fitting paramter
 * 1 : invalid name
 * 2 : numeric constants
 * 3 : variable constants
 * lpstr1 is lpstr to parameter name
 * lpstr2 is lpint to parameter index
 */
// QZCao & H v3.71, end


typedef	struct	DataElement {
	LONG	index;
	double	value;
	double	xvalue;
	DWORD	dwMoData;	//LY	12/14/01 t9798 SERIESPTR_MANAGER
	void	*lpfn;		//LY	12/14/01 t9798 SERIESPTR_MANAGER
} DataElement, DATAELEMENT, FAR *LPDATAELEMENT;

//----------- CPY v7.0352 7/25/02 QA70-2469 MATRX_DATA_CHANGE_MUST_UPDATE_Z_RANGE
// xvalue = 1 is used to indicate data value is changed
// we now add additional bits
#define DEXV_DATA_MODIFIED	0x0001
#define DEXV_NO_Z_UPDATE	0x0002
#define DEXV_SIZE_MODIFIED	0x0004
//----------- end 

typedef struct	DATASETGET {
	LONG	i1;/* offset, starts from 0 */
	LONG	npts;
	USHORT	cntrl;
	char	name[NAME_SIZE];
} DATASETGET,FAR *LPDATASETGET;


/// ML v3.970 12/11/95 TEXT_DATASET_VALUE
typedef struct	DataTextValue {       
	LONG	index;
	LPSTR	lpszValue;
} DATATEXTVALUE, FAR *LPDATATEXTVALUE;
/// end TEXT_DATASET_VALUE


typedef	struct	WKSGETDATA {
	short	nCol1;
	LONG	nRow1;
	short	nCols;
	LONG	nRows;
	int	format;	/* data format, same as DDE_DATA_SHORT */
	int	size;	/* for string format, need to have size */
	float	max,min;/* if convert is needed, ends float values */
}WKSGETDATA,FAR *LPWKSGETDATA;

/// TD 8/11/2000 t8358 v6.1022 WCB_FOR_WKS_DISPLAY_PROPERTIES
#define UBF unsigned

typedef struct tagWCBWKSDisp  {
//Show
	UBF	    ShowTitle		: 1; //0,1
	UBF	    ShowHGrid		: 1; //0,1
	UBF	    ShowVGrid		: 1; //0,1
	UBF	    ShowRowHeading	: 1; //0,1
	UBF	    MultiLineTitle	: 1; //0,1
	UBF		ShowLabel		: 1; //0,1
//TextColor
	UBF		EnableTxtColor	: 1; //0,1
	UBF		SystemFont		: 1; //0,1
//Coloring Options
	UBF		CellColorEnabled: 1; //0,1
	UBF		LineWidth		: 6;//(0.5 -5 ==>5 - 50, 10 time the actual value)
	UBF						: 0; //Padding ( 15 Used)
//End Bit Field Storage
	//BYTE	FontFace;
	DWORD	dwCellTxtColor;
	DWORD	dwHeadingTxtColor;
	DWORD	dwGridColor;
	DWORD	dwCellColor;
	DWORD	dwHeaderColor;
	DWORD	dwDevLineColor;
	LOGFONT	lfFontAttributes;
	BYTE	TitleHeihgt;
	BYTE    RowHeadingWidth;
} WCBWKSDisp, *LPWCBWKSDisp;
/// end WCB_FOR_WKS_DISPLAY_PROPERTIES

//////////////////////////////////////////////////////////////////////////////
/// EGO  section
//////////////////////////////////////////////////////////////////////////////
/// CPY v3.98 1/16/95 EGO_MSG_CONSISTANT 
#define MASK_DRAWING    			0x0100  /* need hDC */
#define MASK_MEASURE    			0x0200  /* need common size calculation */
#define	MASK_MSG_NEED_CALLBACK		0x0400
#define MASK_COMMON_MSG				0x0800
#define MASK_OBJ_MSG    			0x00FF  /* 256 obj message? */
#define MASK_SYS_MSG    			0x1000  /* related to DLL init or other system level message */
#define MASK_GLOBAL_MSG 			0x2000  /* need global handling before and after dispatch */
#define MASK_LOCAL_MSG  			0x4000
/// ML 8/13/99 t6811 LABTALK_VARIABLENAME_CHECKING
#define	MASK_CHECK_NAME_EGO_MSG		0x8000	// used only inside MoDLL
/// end LABTALK_VARIABLENAME_CHECKING

///CPY v3.98 1/15/95 EGO_MESSAGE, remove below
//#ifndef	EGO_CMD
/* return codes for set_value, get_value */
#define	EGOR_NO		0
#define	EGOR_YES	1
#define	EGOR_ERR	2
#define	EGO_SET_VALUE	17	/* set single value */
#define	EGO_GET_VALUE	18	/* get single value */
#define	EGO_SET_STR	19
#define	EGO_GET_STR	20
/// SFX 6/15/99 ADD_ENTRY_TO_RESDLL
#define	EGO_SET_VALUE_FROM_SHORT_CMD	21	
#define	EGO_GET_VALUE_FROM_SHORT_CMD	22	
#define	EGO_SET_STR_FROM_SHORT_CMD	23
#define	EGO_GET_STR_FROM_SHORT_CMD	24

#define	EGO_SET_VALUE_FROM_FULL_CMD	25	
#define	EGO_GET_VALUE_FROM_FULL_CMD	26	
#define	EGO_SET_STR_FROM_FULL_CMD	27
#define	EGO_GET_STR_FROM_FULL_CMD	28
/// end ADD_ENTRY_TO_RESDLL
/// TD 3-13-02 MOCA_SAWND


#define	IS_EGO_TRANSLATION_FOR_ORESPR( _EGO_MSG )\
		(((_EGO_MSG) <= 	EGO_GET_STR_FROM_FULL_CMD) &&\
		((_EGO_MSG) >= 	EGO_SET_VALUE_FROM_SHORT_CMD))


#define EGO_FROM_ORESPR_EGO(_EGO_ORESPR_MSG )\
		((_EGO_ORESPR_MSG > EGO_GET_STR_FROM_FULL_CMD) ?	 EGOR_ERR :\
		(_EGO_ORESPR_MSG >= EGO_SET_VALUE_FROM_FULL_CMD) ? _EGO_ORESPR_MSG - 8 :\
		(_EGO_ORESPR_MSG >= EGO_SET_VALUE_FROM_SHORT_CMD) ? _EGO_ORESPR_MSG - 4 :_EGO_ORESPR_MSG)

/// end MOCA_SAWND
/// ML 8/13/99 t6811 LABTALK_VARIABLENAME_CHECKING
#define	EGO_GET_CHECK_NAME_RESULT	30
/// end LABTALK_VARIABLENAME_CHECKING
///////////////////////////////////////////////////////////////////
//TD	03-07-2000 MOVED_CONSTANTS_FROM_LAGOBJ_H_TO_ORGDLL_H 
////////////////////////////////////////////////////////////////////
#define EGO_INIT                MASK_SYS_MSG
#define EGO_UNINIT              (MASK_SYS_MSG+1)
#define EGO_BEGIN_CALLBACK      ( MASK_SYS_MSG  + 2 )
#define EGO_END_CALLBACK        ( MASK_SYS_MSG  + 3 )
//----------- CPY v6.0159 2/9/99 t4802 NUMERIC_FORMAT_ON_SPECTRUM
#define EGO_BEFORE_DRAW			EGO_BEGIN_CALLBACK
#define EGO_AFTER_DRAW			EGO_END_CALLBACK
//----------- end  NUMERIC_FORMAT_ON_SPECTRUM
#define EGO_TEST_SDK            ( MASK_SYS_MSG  + 4 )
#define EGO_GET_PROCESS         ( MASK_SYS_MSG  + 5 )
#define EGO_SET_CALLBK          ( MASK_SYS_MSG  + 6 )
	/// call back function pinter is in LPRECT

///EJP v3.98 12-27-95 NEW_EGO_WIN_MSG
/// system msgs to notify labgobj of a Button Edit mode change.
#define EGO_BTNEDIT_BEGIN		(MASK_SYS_MSG + 7)
#define EGO_BTNEDIT_END			(MASK_SYS_MSG + 8)
#define EGO_SET_SCRIPT_CALLBACK	(MASK_SYS_MSG + 9)
///end NEW_EGO_WIN_MSG
///sth v4.09 5/30/96 JAPANESE_DIALOG_FONTS
#define EGO_SET_LANGUAGE		(MASK_SYS_MSG + 10)
///end JAPANESE_DIALOG_FONTS
///sth v4.09 6/3/96 ONE_UIM_VERSION
#define EGO_SET_UIM_VERSION		(MASK_SYS_MSG + 11)
#define EGO_SET_UIM_FONT		(MASK_SYS_MSG + 12)

///////////////////////////////////////////////////////////////////
//END	03-07-2000 MOVED_CONSTANTS_FROM_LAGOBJ_H_TO_ORGDLL_H 
////////////////////////////////////////////////////////////////////


///CPY v3.98 1/15/95 EGO_MESSAGE, move here from labgobj.h
//#define	EGO_CMD		21
///EJP v3.98 01-02-96 UIM_OBJ_HANDLING
///sth v4.09 5/21/96 REMOVING_DOUBLE_EGO_CMD_DEFINITION
//#ifdef WNDBASED_UIM_OBJ
///end REMOVING_DOUBLE_EGO_CMD_DEFINITION
	//CPY v3.98 1/16/95 EGO_MSG_CONSISTANT
	//#define EGO_CMD         (21 + (MASK_COMMON_MSG | MASK_MSG_NEED_CALLBACK))
	//#define EGO_CMD_INIT    (22 + (MASK_COMMON_MSG))
	#define EGO_CMD         (1 + (MASK_COMMON_MSG | MASK_MSG_NEED_CALLBACK))
	#define EGO_CMD_INIT    (2 + (MASK_COMMON_MSG))
	///
///sth v4.09 5/21/96 REMOVING_DOUBLE_EGO_CMD_DEFINITION
//#else
	//#define EGO_CMD         21
	//#define EGO_CMD_INIT    22
//#endif // NO_WNDBASED_UIM_OBJ
///end REMOVING_DOUBLE_EGO_CMD_DEFINITION
///end UIM_OBJ_HANDLING

//#endif //EGO_CMD

///CPY v3.98 VECTOR_ASSIGNMENT, can not use 22 and 23
///EJP v3.98 UIM_OBJ_HANDLING, add common mask for wndbased uim objs.
///#define	EGO_GET_VECTOR_SIZE	37
///#define	EGO_SET_VECTOR_SIZE	38
#define EGO_GET_VECTOR_SIZE	(3 + (MASK_COMMON_MSG)) //CPY v3.98 1/16/95 EGO_MSG_CONSISTANT, after EGO_CMD_INIT
#define EGO_SET_VECTOR_SIZE	(4 + (MASK_COMMON_MSG))
/// see labgobj.h for range of other numbers

#ifndef	LFS_NOT_IN_LIST

/* copied from labstr.h on 7/28/93 */

typedef struct	STRLIST {
	USHORT	id;
	LPSTR	str;
}STRLIST,FAR *LPSTRLIST;

int FAR PASCAL LABUTIL_FindString(LPSTRLIST lpList,LPSTR lpstr);
#define	LFS_NOT_IN_LIST	32764

#endif







/*******************
 * LabCntrl definitions and messages
 *******************/
typedef	ULONG	(FAR PASCAL *LPFNPROCESS)(HWND,USHORT,LPSTR,LPSTR,LPCALLBK);

#define	LABCNTRL_PROCESS	2
#define	LABCNTRL_STATE_CHANGE	3
#define	LABCNTRL_WIN_OPEN	4/* any window opens */
#define	LABCNTRL_WIN_CLOSE	5
#define	LABCNTRL_BEGIN_EDIT	6
#define	LABCNTRL_END_EDIT	7

#define	LABCNTRL_START		10
#define	LABCNTRL_STOP		11



#ifdef	DDE_DATA_STRING		
/******** lpwks processing ********/
int ProcessOneCol(LPDATAWKS lpWks,int nCol,FARPROC lpfn,ULONG lParam1,ULONG lParam2);
#define	POC_BEGIN	0
#define POC_END		1
#define POC_PROCESS	2

/** callback function has the following form

int FAR PASCAL callback(LPSTR lpData,USHORT wFormat,ULONG lParam1,ULONG lParam2,USHORT msg);

**/

#endif

/* process info function
 * ULONG FAR PASCAL ProcInfo(int type,int msg,LPSTR lpstr)
 * and msg is defined below
 */
#define	PIF_LPFN_BY_TYPE	0
#define	PIF_LPFN_BY_NAME	1
	/* get function ptr of specified type */
#define	PIF_GET_TOTAL_OBJS	2	/* number of objects */
#define	PIF_GET_BMP		3	/* get the bmp of the specified obj */
#define PIF_RELEASE_BMP		4
#define PIF_GET_NAME		5	/* get the name of the spec obj */

/// Module Error codes  12/6/94

// error message groups
#define 	ERRGP_ORIGIN 		0x0000  // from A
#define		ERRGP_SETTING		0x2000
#define 	ERRGP_ARGUMENT		0x4000
#define 	ERRGP_HARDWARE		0x6000
#define 	ERRGP_EXTERNAL    	0x8000
#define 	ERRGP_MEMORY	 	0xA000
#define  	ERRGP_MISC              0xC000
// 12/28 km, the above errors are all in a module error    
//#define  	ERRGP_MODULE		0xC000 /// interface to Origin 
// 0xE000 reserved for later use 
// error message handling methods, IN .errout
enum {
	ERROUT_NO_OUTPUT,
	ERROUT_SCRIPT_WINDOW,
	ERROUT_SAVE_FILE,
	ERROUT_DIALOG_BOX,
	ERROUT_STATIS_WINDOW,
}; 


//------------- CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
// constants for when data is changed in a series(dataset), what kind of redraw should take place
// used mainly in the SET_RANGE_REDRAW callback function
#define SR_REDRAW_NONE			0x8000	/// for debug purpose to ensure proper calling parameter range
#define SR_REDRAW_REALTIME		0x8001
#define	SR_REDRAW_REFRESH		0x8002
#define	SR_REDRAW_REALTIME_WKS	(SR_REDRAW_REALTIME | 0x8004)
#define SR_REDRAW_REALTIME_SCOPE (SR_REDRAW_REALTIME |0x8008) // CPY v6.0187 4/22/99 OPP_SCOPE_MODE
#define	SR_MASK_REALTIME_ON_IDLE	0x0010	///---- CPY v5.039 b3558 REALTIME_DRAW_BUFFERRING
//------------- MODATA_SET_RANGE_CHANGE



/// ML v4.09 4/26/96 MOVED_TO_PSDLL_H
/*

#ifdef ORG_DATA_MASK

/// ML 3.981 1/23/96 MOVED_FROM_MARK_H_TO_ORGDLL_H
#define		MAX_NUM_MASKS					255
#define		MASK_VARIABLE_NAME_SIZE			WORD_SIZE
/// end MOVED_FROM_MARK_H_TO_ORGDLL_H


/// ML v4.00 1/25/96 TO_PROVIDE_COMMUNICATION_WITH_LABMASK

/// ML v4.08 4/11/96 NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS
// Must be a multiple of 8, because it will be in a structure
#define		TW_COLUMN_NAME_SIZE				32		
/// end NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS

#define		TWOWAYMEMOBJNAME	"_TWY"

typedef	struct	tagTwoWayMemObjHeader {
	ULONG	ulSizeOfThisHeader;	// it has to be set to the size of this header when created.
	DWORD	dwKindOfWorksheet;	// 0 for the original (masked) worksheet (it should be when object is
								//	 created),
								// 1 for the fully (two-way) extracted cells
								// 2 for the twoway-ANOVA arranged worksheet (after 'mark.BoxesToCols()')
	ULONG	ulNumLevsFirstWay;
	ULONG	ulNumLevsSecondWay;
	DWORD	dwOnlyNumTextSize;	// HIWORD contains the size of the strings
								// used to store formatted numeric levels for
								// the first way if it is numeric (otherwise it has to be zero)
								// LOWORD for the second way.
/// ML v4.08 4/7/96 STORE_GAPSIZE_IN_MEMORY_OBJECT
	//DWORD	dwNotUsed;
	DWORD	dwGapSize;			// Used by MARK object (Boxes To Cols) to store the size
								// of the gap.
/// end STORE_GAPSIZE_IN_MEMORY_OBJECT
	DWORD	dwKinds;			// first bit for first way, second bit for second way
	DWORD	dwSizes;			// HIWORD contains the size of the first way variable 
								// (for example: for double it will be eight (which is automatic
								// if the kind is numeric), for textual it will be the string
								// length).
								// LOWORD contains the size of the second way variable
	ULONG	ulTotNumMasks;
	ULONG	dwNumCellObservations;	// the size of the cell with the maximum number of observations
	/// ML v4.08 4/11/96 NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS
	// The two character buffers are used to store the names of the two columns
	// to which the masks are set. The first one must be the name of the subject
	// column, the second one the name of the response column. 
	// If these two are empty, then it is not any of the two repeated measurement
	// cases (subject column is relevant only if it is a repeated measurements case).
	char	szSubjectColumnName[TW_COLUMN_NAME_SIZE];		// multiple of 8
	char	szResponseColumnName[TW_COLUMN_NAME_SIZE];		// multiple of 8
	/// ML v4.08 4/17/96 STORE_THE_NAME_OF_THE_SECOND_FACTOR_COLUMN
	// We need to store the name of the second factor column so that we can 
	// know those names when transforming the worksheet in mark object
	char	szSecFactColumnName[TW_COLUMN_NAME_SIZE];
	/// end STORE_THE_NAME_OF_THE_SECOND_FACTOR_COLUMN
	DWORD	dwUnusedOne;
	DWORD	dwUnusedTwo;
	DWORD	dwUnusedThree;
	DWORD	dwUnusedFour;
	DWORD	dwUnusedFive;
	DWORD	dwUnusedSix;
	DWORD	dwUnusedSeven;
	DWORD	dwUnusedEight;
	/// end NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS
} TWHEADER,	FAR *	LPTWHEADER;

// Total size of the memory that follows the header must be:
//         HIWORD(dwSizes) * ulNumLevsFirstWay + LOWORD(dwSizes) * ulNumLevsSecondWay + 
//			+ HIWORD(dwOnlyNumTextSize) * ulNumLevsFirstWay + 
//			+ LOWORD(dwOnlyNumTextSize) * ulNumLevsSecondWay + 
//			+ ulTotNumMasks * [ HIWORD(dwSizes) + LOWORD(dwSizes) ]
//	The first row stores the levels for both ways, while the second stores the
//	associations for each mask (starting with mask number 1).
//
//	The memory structure that follows the header looks like this:
//	1)	a series of ulNumLevsFirstWay elements of size HIWORD(dwSizes),
//	2)	a series of ulNumLevsSecondWay elements of size LOWORD(dwSizes),
//	3)	a series of ulNumLevsFirstWay elements of size HIWORD(dwOnlyNumTextSize)
//		(does not exist if the first way is textual).
//	4)	a series of ulNumLevsSecondWay elements of size LOWORD(dwOnlyNumTextSize)
//		(does not exist if the second way is textual).
//	5)	a series of ulTotNumMasks elements of the size [ HIWORD(dwSizes) + LOWORD(dwSizes) ].
//
// The purposes are the following:
//	1) and 2) store the levels for the first and second factor. If any of these factors
//				is numeric, they are stored as numbers (not text).
//	3) and 4) are used to store according to the numeric format
//				of the orginal column the numeric levels (they do not exist for textual).
//	5) stores the mask associations (beginning with the mask number one).
//

/// end TO_PROVIDE_COMMUNICATION_WITH_LABMASK
///sth v4.08 4/8/96 DOUBLE_ANOVA_WKS
#define TWH_TWO_ANOVA_ARRANGED	2
///end DOUBLE_ANOVA_WKS




/// ML 4/20/96 ONE_WAY_MEMORY_OBJECT_FOR_ONEWAY_REPEATED_MEASUREMENT_PURPOSES 
#define		OW_COLUMN_NAME_SIZE		TW_COLUMN_NAME_SIZE
#define		ONEWAYMEMOBJNAME		"_OWY"

typedef	struct	tagOWHEADER {
	ULONG		ulSizeOfThisHeader;		
	DWORD		dwKindOfWorksheet;	// 0 for the original worksheet (with masks set), 1 for fully extracted
	DWORD		dwNumLevels;
	DWORD		dwUnused;
	char		szSubjectColumnName[OW_COLUMN_NAME_SIZE];		// multiple of 8
	char		szResponseColumnName[OW_COLUMN_NAME_SIZE];		// multiple of 8
	DWORD		dwUnusedOne;
	DWORD		dwUnusedTwo;
} OWHEADER, FAR	*LPOWHEADER;
/// end ONE_WAY_MEMORY_OBJECT_FOR_ONEWAY_REPEATED_MEASUREMENT_PURPOSES



#endif	// ORG_DATA_MASK
*/

///JLIU nad DSC v4.982 5/7/97 MOVE_FROM_ORGDLL_TO_MODLL for the ati modll
///#ifdef		POWER_STAT
///	#include	"psdll.h"
///#endif
///	end MOVE_FROM_ORGDLL_TO_MODLL


/// end MOVED_TO_PSDLL_H





///CPY v4.10 6/11/96 WKS_DLL_MODI_ADD_CALLBACK, add last argument as lpCallBack, define this as a separate one for used in Origin
#define	ORG_WKS_DLL_MODI_PARAMS						HWND hWnd,UINT msg,LONG nParam,DWORD lParam
///CPY v4.10 6/10/96 WKS_DLL_MODIFICATION_SUPPORT
/// DLL export this function as ORDINAL number 30
#define	WKS_DLL_MODI_PARAMS							ORG_WKS_DLL_MODI_PARAMS, LPCALLBK lpOriginCallBack						
typedef DWORD (CALLBACK* O_WKS_DLL_MODI)(WKS_DLL_MODI_PARAMS);
///hWnd=wks window for all messages
/// messages are defined as

	/// All the messages should return this if no handling:
	#define	DLL_DID_NOT_HANDLE		0xEDCBABCD


	#define WDM_BEGIN		0x1000				/// nParam=0, lParam = (LPSTR) wksName, return 0 if OK, DLL_DID_NOT_HANDLE if no handling
	#define	WDM_END			(WDM_BEGIN + 1)		/// nParam=lParam=0, hWnd=wks window, return 0 if OK, 1 if error 
	
	
	#define	WDM_START_MSG				0x0100
	#define	WDM_GET_CELL_COLOR_INDEX	(WDM_START_MSG + 1) 
	/// lParam = lpLong is pointer to two LONGs:
	///////  lpLong[0] = col number, 1,2,3,..., lpLong[1] =row num. = 0,1,2,..., 
	//  lpLong[0] = col number, 0,1,2,3,..., lpLong[1] =row num. = 0,1,2,...,  // ML v4.11 7/8/96 CHANGE_OFFSET (only comment changes)
	// nParam shoould contain the color number which needs to be skipped
	// return color index :0,1,2,.., or -1 for the particular cell not to be colored
	// WDM_WILL_COLOR should be sent first to see if the DLL will
	// bother to color at all.
	
	#define	WDM_WILL_COLOR				(WDM_START_MSG + 2)
	// returns FALSE if nothing colored
	
	#define	WDM_COLUMN_DLG				(WDM_START_MSG + 3)		
	// when doubleclicking on a column header. nParam = col. number 1-offset
	///CPY: lParam contains the Origin instance handle HINSTANCE
	// returns DLL_DID_NOT_HANDLE to indicate proceeding as usual
	// 0 if handled.
	
	/// more messages are defined with base id + n
/// end WKS_DLL_MODIFICATION_SUPPORT


/// ML v4.133 9/24/96 EXE_CALLING_DLL_FOR_GRAPH 
#ifdef		EXE_CALLING_DLL_FOR_GRAPH
	#define	ORG_GRAPH_DLL_ACCESS_PARAMS						HWND hWnd, UINT msg, DWORD dwParam, LPARAM lParam
	#define	GRAPH_DLL_ACCESS_PARAMS							ORG_GRAPH_DLL_ACCESS_PARAMS, LPCALLBK lpOriginCallBack

	// the function must be exported at ID_EXPORT_GRAPH_ACCESS:						
	typedef DWORD (CALLBACK* O_GRAPH_DLL_ACCESS)(GRAPH_DLL_ACCESS_PARAMS);

	// Possible values of msg: 
	#define		GDA_MESSAGE_START		1
	enum {
		GDA_BOXCHARTS_ETC = GDA_MESSAGE_START, 
		/// ML v4.133 9/27/96 IDS_OF_BASIC_POWERSTAT_METHODS
		GDA_GET_METHOD_TEMPL_SUBDIR,
		/// end IDS_OF_BASIC_POWERSTAT_METHODS
	};

///  YN  11/18/96  ADD_CONDITIONAL_COMPILATION
#else		// ! EXE_CALLING_DLL_FOR_GRAPH
	#define	ORG_GRAPH_DLL_ACCESS_PARAMS						
	#define	GRAPH_DLL_ACCESS_PARAMS							
///  end  ADD_CONDITIONAL_COMPILATION
#endif		// EXE_CALLING_DLL_FOR_GRAPH
/// end EXE_CALLING_DLL_FOR_GRAPH 


/// ML 7/20/98 SCRIPT_RESOURCE_DLL_DIALOGS
#ifdef SCRIPT_RESOURCE_DLL_DIALOGS /// added by CPY 8/11/98
typedef double FAR *LPDOUBLE;///CPY 4/19/99 added for compile release problem
/// ML 4/19/99 t4345 ADDING_SUPPORT_FOR_SCRIPT_BASED_RESOURCE_DLLS
//#define		ORESPRDLLENTRYARGUMENTS		DWORD dwMsg, LPSTR lpszFirst, LPSTR lpszSecond, LPSTR lpszThird, LPSTR lpszArg, LPDOUBLE lpValue

// dwCtrl: 
#define				OKSCRIPTRESDLL_EXECUTE					1UL 
#define				OKSCRIPTRESDLL_UNINIT					2UL 
#define				OKSCRIPTRESDLL_SET_CALLBACK				3UL 
#define				OKSCRIPTRESDLL_SET_TEXTCALLBACK			4UL 
#define				OKSCRIPTRESDLL_OBJEXECUTE				5UL 
/// SFX 6/15/99 ADD_ENTRY_TO_RESDLL
#define				OKSCRIPTRESDLL_CHECK_EXECUTE			6UL 
/// end ADD_ENTRY_TO_RESDLL
/// RB 8/20/99 INITIALIZE_SCRIPT_RESOURCE_DLL
#define				OKSCRIPTRESDLL_INIT						7UL 
/// end INITIALIZE_SCRIPT_RESOURCE_DLL
/// RB 12/8/99 v6.0244 CLOSE_DDK_DIALOGS_BEFORE_CLOSING_ORIGIN
#define				OKSCRIPTRESDLL_CLOSE_ALL_DLGS			8UL
/// end CLOSE_DDK_DIALOGS_BEFORE_CLOSING_ORIGIN
/// RB 12/10/99 t7244 v6.0245 SHOW_HIDE_DDK_TOOLS_ON_MDI_SWITCH
#define				OKSCRIPTRESDLL_SHOW_HIDE_DLGS_ON_MDI_SWITCH			9UL
	// These will be passed to okScriptResourceDLLDialog() with dwCntrl=OKSCRIPTRESDLL_SHOW_HIDE_DLGS_ON_MDI_SWITCH
#define				OKSCRIPTRESDLL_ORIGIN_PAGE_TYPE_WKS					0x0001	
#define				OKSCRIPTRESDLL_ORIGIN_PAGE_TYPE_PLOT				0x0002	
#define				OKSCRIPTRESDLL_ORIGIN_PAGE_TYPE_MATRIX				0x0004	
#define				OKSCRIPTRESDLL_ORIGIN_PAGE_TYPE_LAYOUT				0x0008	
#define				OKSCRIPTRESDLL_ORIGIN_PAGE_TYPE_WKS_EXTERNAL		0x0010	
#define				OKSCRIPTRESDLL_ORIGIN_PAGE_TYPE_ANY					0xFFFF
/// end SHOW_HIDE_DDK_TOOLS_ON_MDI_SWITCH

#define				OKSCRIPTRESDLL_HIDE_DLGS_ON_LAST_PAGE_CLOSE		   10UL

/// TD 11-05-01 t9676 OGS_SECTIONS_ONACTIVATE_ONDEACTIVATE
#define				OKSCRIPTRESDLL_ONACTIVATE_FOR_VISIBLE_DLGS		   11UL
#define				OKSCRIPTRESDLL_ONDEACTIVATE_FOR_VISIBLE_DLGS	   12UL
/// end OGS_SECTIONS_ONACTIVATE_ONDEACTIVATE
/// SFX 1/16/2002 QA70_388 ADD_ONLAYERACTIVATE_EVENT_TO_DDK
#define				OKSCRIPTRESDLL_ONLAYERACTIVATE						13UL
/// end ADD_ONLAYERACTIVATE_EVENT_TO_DDK
/// SFX 1/30/2002 ADD_ONDATASETACTIVATE_EVENT_TO_DDK
#define				OKSCRIPTRESDLL_ONDATASETACTIVATE					14UL
/// end ADD_ONDATASETACTIVATE_EVENT_TO_DDK
/// TD 4-16-02 ADD_EFFICENT_ONIDLE_FOR_DDK_DIALOG_CASHED_FROM_OGS_SECTION
#define				OKSCRIPTRESDLL_ONIDLE								15UL
/// end ADD_EFFICENT_ONIDLE_FOR_DDK_DIALOG_CASHED_FROM_OGS_SECTION
/// TD 10-21-02 QA70-3181 ORIGINC_CLASSES_FOR_DIALOG_MEMBERS
#define				OKSCRIPTRESDLL_SAPTR_FROM_RESIDS					16UL
/// end ORIGINC_CLASSES_FOR_DIALOG_MEMBERS

//---------- CPY 1/28/03 QA70-3796 v7.0500 COL_CHANGE_NOTIFICATIONS
#define	 OKSCRIPTRESDLL_ON_ORIGIN_CHANGE								17UL
// the following struct will be used
#define MAX_WIN_LAYER_SPEC 256
typedef struct tagObjChangeInfo
{
	char	szWinLayerSpec[MAX_WIN_LAYER_SPEC]; // winName!layerName, or just winName
	char	szObjName[NAME_SIZE];
	int		nObjType;
	int		nIndex;	  // index into layer 
	DWORD	lParam;
} ObjChangeInfo; 
//---------- end QA70-3796

/// RB 6/21/99 CALLING_OBJFUNCTIONS_FROM_OBJVECTORS
#define				OKSCRIPTRESDLL_VECTOR_ASSIGNMENT		0x10000000 
/// end CALLING_OBJFUNCTIONS_FROM_OBJVECTORS
#define		ORESPRDLLENTRYARGUMENTS		DWORD dwCtrl, DWORD dwMsg, LPSTR lpszFirst, LPSTR lpszSecond, LPSTR lpszThird, LPSTR lpszArg, LPDOUBLE lpValue	
/// end ADDING_SUPPORT_FOR_SCRIPT_BASED_RESOURCE_DLLS
typedef	LONG	(WINAPI	*PFNORESPRDLL)(ORESPRDLLENTRYARGUMENTS);

#endif //SCRIPT_RESOURCE_DLL_DIALOGS

/// end SCRIPT_RESOURCE_DLL_DIALOGS


/// DSB v3.980 12/15/95 TITLE_DEFS
#define ORIGIN_EXE_TITLE	"ORIGIN40.EXE"
#define LABENG_DLL_TITLE	"LABENG40.DLL" 
/// End TITLE_DEFS

///sth v4.982 b2083 5/7/97 RIGHT_MOUSE_DOWN_CODE_BLOCK
#define SM_WPARAM_DO_NOT_PROCESS_LBUP_SCRIPT	99
///end RIGHT_MOUSE_DOWN_CODE_BLOCK


//IV 4/30/2001	MOVE_DEFINES_FOR_OKRESPR_PROJECT_CUSTOM_CTRL
#define		OCTRLENTRYARGUMENTS		DWORD dwCtrl, UINT msg, LPARAM lParam, DWORD dwParam, DWORD dw1, DWORD dw2	

#define		CTRLDLL_CREATE_NEW_PTR					1
#define		CTRLDLL_EXECUTE_FUNCTION				2
#define		CTRLDLL_GET_PROPERTY					3
#define		CTRLDLL_SET_PROPERTY					4
#define		CTRLDLL_UPDATE							5
#define		CTRLDLL_INITIALIZE_OBJECT				6 /// TD 10-15-02 QA70-3150 v7.0413  MSG_TO_INITIALIZE_CUSTOM_DLL_AFTER_CREATION
#define		CTRLDLL_DESTROY_OBJECT					7 /// YuI 2/26/03 QA70-3975 v7.0523 GUI_CONTROL_FOR_INCREMENTOR
#define		CTRLDLL_ENABLE_OBJECT					8 /// YuI 2/26/03 QA70-3975 v7.0523 GUI_CONTROL_FOR_INCREMENTOR
#define		CTRLDLL_SHOW_OBJECT						9 /// RVD 3/10/2003 QA70-4031 v7.0532 DISPLAY_INC_ARRAY

#define		CTRLDLL_CHECK_LABTALK_NAME			0x0100
#define		CTRLDLL_CHECK_LABTALK_MASK			0x000f
#define		GET_CTRDLL_MESSAGE(_cntrl)			(_cntrl & CTRLDLL_CHECK_LABTALK_MASK)


typedef	LONG	(WINAPI	*PFNOCTRLDLL)(OCTRLENTRYARGUMENTS);
//end	MOVE_DEFINES_FOR_OKRESPR_PROJECT_CUSTOM_CTRL

/// RVD 7/19/2002 QA70-1860 v7.0346 NLSF_BETTER_ADD_FUNCTION
#define		MAX_TOKEN_COUNT						10
/// end NLSF_BETTER_ADD_FUNCTION

/// TD 7-24-02 QA70-2439 v7.0348 RELATIVE_FOR_BMP_AND_THROW_AWAY_BS_OGS
typedef struct _tagUDBAttr
{
	LPCTSTR m_lpcszScriptFileName;
	LPCTSTR m_lpcszScriptSectionName;
	LPCTSTR m_lpcszScriptSectionArguments;
	LPCTSTR m_lpcszToolTipText;
	LPCTSTR m_lpcszStatusBarText;
} UDBAttr, *LPUDBAttr;

typedef struct _tagUsrDefButton
{
	LPCTSTR m_lpcszSubPath;			//-------- CPY 8/5/02 QA70-2436 v7.0363 OPS_FILE_NAME_SHOULD_BE_SET_BY_USER
	LPCTSTR m_lpcszCategoryName;
	LPCTSTR m_lpcszToolbarName;
	LPCTSTR m_lpcszBitmapFileName;
	INT		m_nIndexIntoBitmap;
	UDBAttr m_ButtonAttributes;
} UsrDefButton, *LPUsrDefButton;


/// end RELATIVE_FOR_BMP_AND_THROW_AWAY_BS_OGS

/// YuI 10/1/02 v 7.0408 QA70-3074 UID_FOR_SERIES_POINTER
#define	OUID_UNKNOWN	0
//////////////////////////////////////////////////////////////////////////////////
// !!!! Check OPJ forward/backward compatibility before changing this type !!!!
// must be similar to tagOPLOT::uid, etc
//////////////////////////////////////////////////////////////////////////////////
typedef	DWORD	OUID, *POUID;	// flat UIDs - all objects share the same pool of IDs
typedef	enum
{
	OUIDT_UNKNOWN = 0,
	OUIDT_PLOT,
	OUIDT_FRAME,
	OUIDT_OBJECT,
	OUIDT_SERIES,/// YuI 10/1/02 v 7.0408 QA70-3074 UID_FOR_SERIES_POINTER
	OUIDT_OPERATION,/// YuI 10/15/02 v7.0415 QA70-3087 COLUMN_FORMULA_AUTOMATION
	OUIDT_GRAPHOBJ,/// YuI 11/5/02 v7.0427 QA70-3272 UID_FOR_FRAME_GRAPH_OBJ
	OUIDT_UIDELEMENT,/// YuI 11/12/02 v7.0436 QA70-3341 BASE_CLASS_FOR_ALL_FUTURE_OBJECTS
	/////////////////////////////////////////////////////
	// new TYPEs should be above:
	/////////////////////////////////////////////////////

}	OUIDTYPE;
/// end UID_FOR_SERIES_POINTER


/// TD 11-6-03 QAx70-5481 PARTIAL_DETACH_MOCA_ON_TYPE_CANGE
//Link Manager Messages
enum
{
	LMMSG_TypeChanged = 1,
};
/// end PARTIAL_DETACH_MOCA_ON_TYPE_CANGE




///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
#ifdef	__cplusplus
} /* end of __cplusplus */
#endif




/////////////////////////////////////////////////////////////////////////////////
#endif //#ifndef _ORGDLL_H
