/*--------------------------------------------------------------------------*
 * File Name:	worksheetObj.cpp											*
 * Purpose:		Demonstrate how to access an Origin worksheet				*
 * Creation:	March 24, 2000												*
 * Copyright Microcal Software Inc. 2000									*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      


#include "worksheetObj.h"

//---------------------------------------------------------------------------
// MOCA_ENTRY_POINT( <main object class> )
//
// The MOCA_ENTRY_POINT macro is used to define the exported function that
// Origin will use to communicate with your DLL.  The macro takes a single
// argument, the class name of your main object.
//---------------------------------------------------------------------------
MOCA_ENTRY_POINT(CWksDemo)


//---------------------------------------------------------------------------
// Property Map:
//
// The Property Map is for declaring the properties of your LabTalk object.
//
// A property is mapped to Get and Set function.  These functions allow
// you to do error checking or any necessary conversions.  A read-only
// property can be declared by using the _GET macro.
//
// MOCA_PROP_INT( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_REAL( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_STR( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_INT_GET( <GetFunction>,<PropertyNameStr> )
// MOCA_PROP_REAL_GET( <GetFunction>,<PropertyNameStr> )
// MOCA_PROP_STR_GET( <GetFunction>,<PropertyNameStr> )
//
// A Simple Property is mapped to a data member.  There are no Get/Set
// functions for a Simple Property.  MOCA will take care of the assignment.
// A simple read-only property can be declared by using the _GET macro.
//
// MOCA_SIMPLE_PROP_INT( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_REAL( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_STR( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_INT_GET( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_REAL_GET( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_STR_GET( <DataMember>,<PropertyNameStr> )
//---------------------------------------------------------------------------
MOCA_BEGIN_PROP_MAP(CWksDemo, CMOCAObjBase)
	MOCA_SIMPLE_PROP_STR(m_WksName, "WksName")
	MOCA_PROP_INT_GET(GetIsValid, "IsValid")
	MOCA_PROP_INT_GET(GetNumColumns, "NumColumns")
	MOCA_PROP_STR_VECTOR(GetColumnName, SetColumnName, GetNumColumns, SetNumColumns, "ColumnName")
	MOCA_PROP_STR_VECTOR(GetColumnLabel, SetColumnLabel, GetNumColumns, SetNumColumns, "ColumnLabel")
	MOCA_PROP_REAL_VECTOR(GetColumnType, SetColumnType, GetNumColumns, SetNumColumns, "ColumnType")
MOCA_END_PROP_MAP(CWksDemo, CMOCAObjBase)

//---------------------------------------------------------------------------
// Method Map:
//
// INPORTANT: To have a Method Map or a SubObject Map, you must
// have a property map.  A property map can be empty.
//
// MOCA_METH_ENTRY( <MemberFunction>,<MethodNameStr> )
//
// <MemberFunction> must be declared as "BOOL foo(double &, CStringArray &);"
// The double is used for storing LabTalk's return value.
// The CStringArray contains the arguments passed from LabTalk.
//---------------------------------------------------------------------------
MOCA_BEGIN_METH_MAP(CWksDemo, CMOCAObjBase)
	MOCA_METH_ENTRY(MethodInsertColumn, "InsertColumn")	
	MOCA_METH_ENTRY(MethodRemoveColumn, "RemoveColumn")	
	MOCA_METH_ENTRY(MethodPlot, "Plot")	
MOCA_END_METH_MAP(CWksDemo, CMOCAObjBase)

//---------------------------------------------------------------------------
// SubObject Map:
//
// IMPORTANT: To have a Method Map or a SubObject Map, you must
// have a property map.  A property map can be empty.
//
// MOCA_SUBOBJ_ENTRY( <m_SubObject>,<SubObjectNameStr> )
//
//---------------------------------------------------------------------------
// This MOCA example has no subobjects.
// The following is an example of how a SubObject table is declared.
//MOCA_BEGIN_SUBOBJ_MAP(CLASSNAME, BASECLASSNAME)
//	MOCA_SUBOBJ_ENTRY(m_SubObject, "SUBOBJECT")
// 	MOCA_SUBOBJ_ENTRY(m_SubObject2, "SUBOBJECT2")
//MOCA_END_SUBOBJ_MAP(CLASSNAME, BASECLASSNAME)


//---------------------------------------------------------------------------
// Constructors and Destructors
//---------------------------------------------------------------------------
CWksDemo::CWksDemo()
{
	m_WksName = "Data1";
}

CWksDemo::~CWksDemo()
{
}

//---------------------------------------------------------------------------
// CWksDemo::GetIsValid
//
// LabTalk Property: ISVALID
//---------------------------------------------------------------------------
BOOL CWksDemo::GetIsValid(int &iValue)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
		iValue = 1;
	else
		iValue = 0;

	return TRUE;
}

//---------------------------------------------------------------------------
// CWksDemo::GetNumColumns
//
// LabTalk Property: NUMCOLUMNS
//---------------------------------------------------------------------------
BOOL CWksDemo::GetNumColumns(int &iValue)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
		iValue = myWks.GetNumCols();
	else
		iValue = 0;

	return TRUE;
}

//---------------------------------------------------------------------------
// CWksDemo::SetNumColumns
//
// LabTalk Property: NUMCOLUMNS
//---------------------------------------------------------------------------
BOOL CWksDemo::SetNumColumns(int iValue)
{
	return FALSE;
}

//---------------------------------------------------------------------------
// CWksDemo::GetColumnName
//
// LabTalk Property: COLNAME
//---------------------------------------------------------------------------
BOOL CWksDemo::GetColumnName(LPSTR lpstr, int iIndex)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
		myWks.GetColName(iIndex + 1, lpstr);
	else
		*lpstr = '\0';

	return TRUE;
}
//---------------------------------------------------------------------------
// CWksDemo::SetColumnName
//
// LabTalk Property: COLNAME
//---------------------------------------------------------------------------
BOOL CWksDemo::SetColumnName(LPCSTR lpcstr, int iIndex)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
	{
		CString str = lpcstr;
		myWks.SetColName(iIndex + 1, str.GetBuffer(str.GetLength()));
		str.ReleaseBuffer();
	}

	return TRUE;
}

//---------------------------------------------------------------------------
// CWksDemo::GetColumnLabel
//
// LabTalk Property: COLLABEL
//---------------------------------------------------------------------------
BOOL CWksDemo::GetColumnLabel(LPSTR lpstr, int iIndex)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
		myWks.GetColLabel(iIndex + 1, lpstr);
	else
		*lpstr = '\0';

	return TRUE;
}

//---------------------------------------------------------------------------
// CWksDemo::SetColumnLabel
//
// LabTalk Property: COLLABEL
//---------------------------------------------------------------------------
BOOL CWksDemo::SetColumnLabel(LPCSTR lpcstr, int iIndex)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
	{
		CString str = lpcstr;
		myWks.SetColumnLabel(iIndex + 1, str.GetBuffer(str.GetLength()));
		str.ReleaseBuffer();
	}

	return TRUE;
}

//---------------------------------------------------------------------------
// CWksDemo::GetColumnType
//
// LabTalk Property: COLTYPE
//---------------------------------------------------------------------------
BOOL CWksDemo::GetColumnType(double & dValue, int iIndex)
{
	MoOriginWks myWks(m_WksName);
	if( myWks.IsValid() )
		dValue = myWks.GetColumnType(iIndex + 1);
	else
		dValue = 0;

	return TRUE;
}

//---------------------------------------------------------------------------
// CWksDemo::SetColumnType
//
// LabTalk Property: COLTYPE
//---------------------------------------------------------------------------
BOOL CWksDemo::SetColumnType(double dValue, int iIndex)
{
	return FALSE;
}

//---------------------------------------------------------------------------
// CWksDemo::MethodInsertColumn
//
// Insert a column into the worksheet.
//---------------------------------------------------------------------------
BOOL CWksDemo::MethodInsertColumn(double &dReturn, CStringArray &argarray)
{
	dReturn = NANUM;

	// Method requires 3 arguments: column name, label, and index
	if( argarray.GetSize() != 3 )
		return FALSE; // LabTalk command error

	// Create a reference to a worksheet by name.
	MoOriginWks myWks(m_WksName);
	if( !myWks.IsValid() )
	{
		MessageBox(NULL, "InsertCol method received invalid worksheet", "MOCA Worksheet Example", MB_OK);
		return FALSE; // LabTalk command error
	}

	// Get and check column index
	int iColumnIndex = atoi(argarray[2]);
	if( iColumnIndex <= 0 )
		return FALSE; // LabTalk command error

	myWks.InsertColumn((LPSTR)(LPCSTR)argarray[0], iColumnIndex , argarray[1]);

	dReturn = 0;

	return TRUE; // LabTalk command error 
}

//---------------------------------------------------------------------------
// CWksDemo::MethodRemoveColumn
//
// Remove a column from the worksheet
//---------------------------------------------------------------------------
BOOL CWksDemo::MethodRemoveColumn(double &dReturn, CStringArray &argarray)
{
	dReturn = NANUM;

	// Method requires 1 arguments: column name
	if( argarray.GetSize() != 1 )
		return FALSE; // LabTalk command error

	// Create a reference to a worksheet by name.
	MoOriginWks myWks(m_WksName);
	if( !myWks.IsValid() )
	{
		MessageBox(NULL, "RemoveCol method received invalid worksheet", "MOCA Worksheet Example", MB_OK);
		return FALSE; // LabTalk command error
	}

	// Remove column from worksheet
	myWks.RemoveColumn(argarray[0]);

	dReturn = 0;

	return TRUE; // LabTalk command error 
}

//---------------------------------------------------------------------------
// CWksDemo::MethodPlot
//
// Plot datasets in the worksheet arguments(X_column_number, Y_column_number, plot_type)
//---------------------------------------------------------------------------
BOOL CWksDemo::MethodPlot(double &dReturn, CStringArray &argarray)
{
	dReturn = NANUM;

	// Method requires 3 arguments: x col num, y col num, plot type
	if( argarray.GetSize() != 3 )
		return FALSE; // LabTalk command error

	// Create a reference to a worksheet by name.
	MoOriginWks myWks(m_WksName);
	if( !myWks.IsValid() )
	{
		MessageBox(NULL, "Plot method received invalid worksheet", "MOCA Worksheet Example", MB_OK);
		return FALSE; // LabTalk command error
	}

	// Get and check x col num, y col num, and plot type
	int iXColNum = atoi(argarray[0]);
	int iYColNum = atoi(argarray[1]);
	int iPlotType = atoi(argarray[2]);
	if( iXColNum <= 0 || iYColNum <= 0 || iPlotType <= 0 )
		return FALSE; // LabTalk command error

	if( iPlotType < 193 || iPlotType > 279 )
		iPlotType = 200;

	myWks.CreateDataAndPlot(iXColNum, iYColNum, iPlotType);

	dReturn = 0;

	return TRUE; // LabTalk command error 
}
