/*--------------------------------------------------------------------------*
 * File Name:	worksheetObj.h												*
 * Purpose:		Demonstrate how to access an Origin worksheet				*
 * Creation:	March 24, 2000												*
 * Copyright Microcal Software Inc. 2000									*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _WKSHEETOBJ_H
#define _WKSHEETOBJ_H

#include "mocamain.h"	// Required header file


//---------------------------------------------------------------------------
// Define main object class
//---------------------------------------------------------------------------
class CWksDemo : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties, methods or SubObjects
	MOCA_DECLARE_PROP_MAP(CWksDemo)

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CWksDemo)

	// Declare SubObject Map if object has LabTalk SubObjects
	//OMOCA_DECLARE_SUBOBJECT_MAP(CDataSetDemo)

public: // constructors and destructors
	CWksDemo();
	~CWksDemo();

private: // data members for storing LabTalk properties
	CString		m_WksName;

public:	// member functions for handling LabTalk properties
	BOOL GetIsValid(int &iValue);

	BOOL GetNumColumns(int &iValue);
	BOOL SetNumColumns(int iValue);

	BOOL GetColumnName(LPSTR lpstr, int iIndex);
	BOOL SetColumnName(LPCSTR lpcstr, int iIndex);

	BOOL GetColumnLabel(LPSTR lpstr, int iIndex);
	BOOL SetColumnLabel(LPCSTR lpcstr, int iIndex);

	BOOL GetColumnType(double &dValue, int iIndex);
	BOOL SetColumnType(double dValue, int iIndex);

private: // member functions for handling LabTalk methods
	BOOL MethodInsertColumn(double &dReturn, CStringArray &argarray);
	BOOL MethodRemoveColumn(double &dReturn, CStringArray &argarray);
	BOOL MethodPlot(double &dReturn, CStringArray &argarray);
};     

#endif // _WKSHEETOBJ_H
