VERSION 4.00
Begin VB.Form ORIGIN_DDE 
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Origin DDE"
   ClientHeight    =   4920
   ClientLeft      =   2085
   ClientTop       =   1845
   ClientWidth     =   4080
   BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   5325
   Icon            =   "DDETEST.frx":0000
   Left            =   2025
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   4920
   ScaleWidth      =   4080
   Top             =   1500
   Width           =   4200
   Begin VB.TextBox Shutdown 
      Appearance      =   0  'Flat
      Height          =   375
      Left            =   2880
      TabIndex        =   20
      Top             =   480
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Shut Down Origin via DDE"
      Height          =   375
      Left            =   480
      TabIndex        =   18
      Top             =   3840
      Width           =   3495
   End
   Begin VB.TextBox OriginCommandLine 
      Appearance      =   0  'Flat
      Height          =   375
      Left            =   480
      ScrollBars      =   1  'Horizontal
      TabIndex        =   12
      Text            =   "c:\origin60\origin60.exe test"
      Top             =   120
      Width           =   3495
   End
   Begin VB.CommandButton GetDocName 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Get Origin File Name"
      Height          =   375
      Left            =   480
      TabIndex        =   10
      Top             =   1080
      Width           =   3495
   End
   Begin VB.CommandButton Integrate 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Integrate Area Under Curve"
      Height          =   375
      Left            =   480
      TabIndex        =   7
      Top             =   3000
      Width           =   3495
   End
   Begin VB.TextBox PokeLabel 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   2040
      TabIndex        =   6
      Top             =   480
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.CommandButton Command2 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Pass Data"
      Height          =   375
      Left            =   480
      TabIndex        =   3
      Top             =   2160
      Width           =   3495
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   1320
      Top             =   360
   End
   Begin VB.CommandButton Command1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Load Origin"
      Height          =   375
      Left            =   480
      TabIndex        =   2
      Top             =   600
      Width           =   3495
   End
   Begin VB.Label Label3 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "6"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   120
      TabIndex        =   19
      Top             =   3840
      Width           =   255
   End
   Begin VB.Label Label9 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "5"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   120
      TabIndex        =   17
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label Label8 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "4"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   120
      TabIndex        =   16
      Top             =   2160
      Width           =   255
   End
   Begin VB.Label Label7 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "3"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   120
      TabIndex        =   15
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label6 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "2"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   120
      TabIndex        =   14
      Top             =   600
      Width           =   255
   End
   Begin VB.Label Label5 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "1"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   120
      TabIndex        =   13
      Top             =   120
      Width           =   255
   End
   Begin VB.Label OrgDocName 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Origin document file name will go here"
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   480
      TabIndex        =   11
      Top             =   1560
      Width           =   3495
   End
   Begin VB.Label LabTalkCommand 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "LabTalk commands sent via DDE appear here as they are sent"
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   480
      TabIndex        =   9
      Top             =   4320
      Width           =   3495
   End
   Begin VB.Label AreaLabel 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Area under curve will go here"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   480
      TabIndex        =   8
      Top             =   3480
      Width           =   3495
   End
   Begin VB.Label YData 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   2880
      TabIndex        =   4
      Top             =   2640
      Width           =   1095
   End
   Begin VB.Label Label2 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Y"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   2520
      TabIndex        =   1
      Top             =   2640
      Width           =   255
   End
   Begin VB.Label Xdata 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   840
      TabIndex        =   5
      Top             =   2640
      Width           =   1095
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "X"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   480
      TabIndex        =   0
      Top             =   2640
      Width           =   255
   End
End
Attribute VB_Name = "ORIGIN_DDE"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' This project demonstrates using Origin as a DDE Server.
' Data can be sent to and retrieved from Origin via DDE.
' LabTalk commands and macros can be executed through DDE as well.
' It is rather crude and incomplete in that no checking is performed
'    to see that users have completed each step.
'    Operating out-of sequence could produce an error.
' You could also, for example, use DDE to check if Origin is running
'    already and simply hide the first two steps.
' This version adds some code that demonstrates how to shut down Origin
'    through the DDE interface since some customers found this difficult.

Private Sub Command1_Click()
    
    'Start Origin with Visual Basic Shell Function
    'Edit the command string to suit your setup
    'Z% = Shell("C:\Origin\Origin.exe Test", 4)
    
    CmdLine$ = OriginCommandLine.Text

' This is the only difference between 16 and 32 bit versions
' for this project.
' Note that functions which return Integer in 16 bit
' now return Long in 32 bit.
#If Win32 Then
    Z& = Shell(CmdLine$, 4)
#Else
    Z% = Shell(CmdLine$, 4)
#End If
    
    'If you need to specify your own configuration script file
    'or your own ini file, you can use
    'Z% = Shell("Origin -i my.ini TEST",4)
    'Z% = Shell("Origin -c my.cnf TEST",4)

 End Sub

Private Sub Command2_Click()

' complete link setup commands for client operation to Origin as server
' PokeLabel is an assumed label used for conversation

    Command2.Caption = "Busy"
    PokeLabel.LinkTopic = "Origin|ORG" ' Set link topic, Origin is Application Name
                                       ' ORG is the topic name for unknown document name.
    PokeLabel.LinkItem = "DDEData"     ' Set link item, DDEData is WorkSheet name.
    PokeLabel.LinkMode = COLD          ' Set link mode.
    
' ClearWorkSheet is an Origin Predefined Macro,
    LabTalkCommand.Caption = "ClearWorkSheet DDEDATA"
    PokeLabel.LinkExecute LabTalkCommand.Caption 'execute the command
' Use DDE to execute a Script command for scaling the Axis of the Plot window, DDEPlot
    LabTalkCommand.Caption = "win -O DDEPlot (x1=0;x2=80;y1=-1;y2=10)"
    PokeLabel.LinkExecute LabTalkCommand.Caption

' Initialize first data point and use timer to poke data every 0.1 seconds
    
    X = -4
    Timer1.Interval = 100              'Timer1 is set for .1 seconds
    Timer1.Enabled = True              'Timer1.Enabled = False for Form Load
    Call Timer1_Timer

End Sub


Private Sub DataPass()

'SubRoutine to generate curve and poke values into Origin Worksheet
'Generates a Gaussian curve
    
    X = X + 0.1
    Y = (20 / Sqr(2 * 3.14)) * Exp(-(X * X) / 2)

'Put X/Y data into label boxes for display in form

    XData.Caption = Format$(((4 + X) * 10), "   ##0.0")
    YData.Caption = Format$(Y, "    ##0.00")
    
'Create String to pass to Origin
'Separate each data value by a space then end each line by carraige return and line feed

    PokeLabel.Text = XData.Caption + Chr$(9) + YData.Caption + Chr$(13) + Chr$(10)
    PokeLabel.LinkPoke   'Poke value to cell

'Stop passing data when X=3.9

    If X >= 3.9 Then
       Timer1.Enabled = False
       Command2.Caption = "Pass Data"
       PokeLabel.LinkMode = 0   ' Terminate the DDE conversation
    End If

End Sub

Private Sub Command4_Click()

' Since Origin normally warns users if an attempt is made to shut down Origin
' while a DDE link is in use, it becomes problematic how to shut down Origin via DDE.
' The answer is to define a macro which commands Origin to shutdown, and then delay
' execution of the macro until after we terminate the DDE links.
    ShutDown.LinkTopic = "Origin|Variable"
    ShutDown.LinkItem = "system.version"
    ShutDown.LinkMode = COLD
    LabTalkCommand.Caption = "doc -s;def TimerProc {exit};timer 5;"
        ' doc -s;   forces Origin not to prompt for a File Save
        ' def TimerProc {exit}; defines the macro that shuts down Origin
        ' timer 5;  delays the running of the TimerProc macro by 5 seconds
    ShutDown.LinkExecute LabTalkCommand.Caption
    ShutDown.LinkMode = 0
    
End Sub

Private Sub GetDocName_Click()

'Start another conversation with topic variable
    
    OrgDocName.LinkTopic = "Origin|Variable" ' Set link topic, Origin is Application Name
                                             ' Variable is the topic name.
    OrgDocName.LinkItem = "%B"               ' Set link item, %B is the variable that
                                             ' holds the result.
    OrgDocName.LinkMode = COLD               ' Set link mode.

    LabTalkCommand.Caption = "%B=%G.OPJ is open using Origin in %Y" ' in Origin, %Y holds the Origin path
                                             ' and %G the document name (no extension)
    OrgDocName.LinkExecute LabTalkCommand.Caption
    OrgDocName.LinkRequest
    OrgDocName.LinkMode = 0                  'Terminate the converstaion

End Sub

Private Sub Integrate_Click()

'Start another conversation with topic variable
    
    AreaLabel.LinkTopic = "Origin|Variable" ' Set link topic, Origin is Application Name
                                            ' Variable is the topic name.
    AreaLabel.LinkItem = "Integ.Area"       ' Set link item, Integ.Area is the variable
                                            ' that holds the integration result.
    AreaLabel.LinkMode = COLD               ' Set link mode.
    LabTalkCommand.Caption = "win -o DDEPLOT {integ %C}"
    AreaLabel.LinkExecute LabTalkCommand.Caption
    AreaLabel.LinkRequest
    AreaLabel.LinkMode = 0                  'Terminate the converstaion

End Sub

Private Sub Timer1_Timer()

'Timer1 will call the subroutine DataPass every 0.1 seconds
   
   Call DataPass

End Sub

