/* ---------------------------------------------------------------- *
 *   File name: 	FitFuncDef.h                        	    	*
 *   Purpose:       Definitions for the Fitting function dlls		*
 *   Author:		Jie Wang                               			*
 *   Date:          10/31/2000							   			*	
 *							                               			*
 *   Copyright OriginLab 2000                 			            *
 * ---------------------------------------------------------------- */



typedef	double	far* 	LPDOUBLE;
typedef short	far*	LPSHORT;

//fitting function input/output parameters
#define FIT_PARA_LIST  short cntrl, DWORD lpProc, short nParam, DWORD lParam1, DWORD lParam2, LPDOUBLE p, LPDOUBLE c, LPDOUBLE x, LPDOUBLE y, LPDOUBLE dy

//	short			cntrl,		 general control, defined as HAS_FUNC_DERIV/GET_FUNC_VALUE/GET_FUNC_DERIV
//	short			nParam,		 number of parameters
//	DWORD			lParam1		 call back function for more info
//	DWORD			lParam2
//	LPDOUBLE		p,			 parameter array
//	LPDOUBLE		c,			 constants
//	LPDOUBLE		x,			 input (x[])
//	LPDOUBLE		y,			 output (y[])
//	LPDOUBLE		dy,			 dy/dp derivatives (i.e. derivatives with respect to the parameters)


#define HAS_FUNC_DERIV	cntrl & 0x0001	// return YES if the function has analytical derivative
                                        // in its implementation; otherwise return NONE; this sets
                                        // a flag in the Origin NLSF to either use the analytical derivative provided
                                        // or to use numerical differentiation
#define GET_FUNC_VALUE	cntrl & 0x0002	// get func. value;
#define GET_FUNC_DERIV	cntrl & 0x0004	// get both func. value and func. derivative.
#define NONE 	0
#define YES		1


//fitting function prototype
typedef	int (FAR PASCAL* LPMATHFUNC) (FIT_PARA_LIST);


#define	NANUM	(-1.23456789E-300)
#define MATH_ERR	(errno==ERANGE)||(errno==EDOM)
//#define RETURN_ERR	errno = 0; ycol = NANUM; return 1
#define RETURN_ERR	errno = 0; y[1] = NANUM; return 1
