/***************************************************************
 *
 *     Specification for the DataWorkSheet clipboard format
 *		
 *     Chao Ping Yang,  11/8/90
 *
 *     This format is used between Origin and a DDE client for
 *     real time transfer of DDE data.
 *     It is a more efficient alternative to the CF_TEXT 
 *     format
 *
 * revised 10/26/93 to add DDE_DATA_LPSTR
 * revised 8/24/94, add msc check for the DataWorksheet def
 *	CPY 12/11/99 v6.0245 t7257 PLOT_DASH_A_SHOULD_ALLOW_NEGATIVE_NUMBERS
 *	CPY v6.0287 6/3/00 8072 INCREASE_SCRIPT_BUFFERS_CLEANUP*
 ***************************************************************/

#ifndef	NAME_SIZE
//-------------- CPY v6.0287 6/3/00 t8072 INCREASE_SCRIPT_BUFFERS_CLEANUP
//#define MAXLINE		80
#define MAXLINE		120
//-------------- end CPY v6.0287 6/3/00 t8072 INCREASE_SCRIPT_BUFFERS_CLEANUP
#define NAME_SIZE	25
#endif     //NAME_SIZE

#ifndef USHORT
#define	ULONG		DWORD
#define	USHORT		WORD
#endif


#ifdef _MSC_VER
typedef struct {
	USHORT 	wFormat;	/* Data format as well as cntrl info */
	short 	nColumns;	/* number of data sets to receive data */
	USHORT 	nRows;		/* number of rows in each data set 0->64K */
	USHORT 	nRowBegin;	/* beginning row number , 0,1,2 ...64K */
	short	nColumnBegin;/* beginning column number, 0,1,2.. */
	BYTE 	data[0];	/* data start from here */
}  DataWorkSheet, FAR *LPDATAWKS;
#endif

/* DataWorkSheet starts from the Value byte in DDEDATA
 * so the hData from WM_DDE_DATA will be as follows
 *
 *  {
 *	USHORT	wReleaseAck;
 *	int		cfFormat; clipboard format 
 *  USHORT	wFormat;  DataWorkSheet format
 *  short	nColumns;
 *  ....
 *   }
 *
 * data will be placed in the worksheet that has the
 * same name as the item given in WM_DDE_DATA
 */



/* 
 * DataWorkSheet format can take
 * various data types. You can also
 * specify whether to replace existing
 * worksheet contents or to append the
 * specified worksheet.
 * These are all determined by the wFormat
 * parameter.
 *
 * The the meaning of wFormat in DataWorkSheet
 */

/* bit 0,1,2 set the data type in the DDE data */
enum { 
DDE_DATA_CHAR=0, 
DDE_DATA_SHORT,
DDE_DATA_LONG, 
DDE_DATA_FLOAT,
DDE_DATA_DOUBLE,
DDE_DATA_USHORT,
};

#define	DDE_DATA_STRING	7

#define	DDE_DATA_TYPE(wFormat)	((wFormat) & 0x0007)

#define	DDE_DATA_APPEND		0x0010
#define	DDE_DATA_BY_ROW		0x0020
//------- CPY 12/11/99 v6.0245 t7257 PLOT_DASH_A_SHOULD_ALLOW_NEGATIVE_NUMBERS
// if this bit is not set, Origin will force column types to Numeric when dde data
// are transfered into a TextNumeric column
#define	DDE_DATA_KEEP_TYPE	0x0040
//------- end t7257
#define DDE_DATA_ADD		0x0100 /* must not used with APPEND */
#define	DDE_DATA_NO_DISPLAY	0x1000
#define	DDE_DATA_PTR		0x2000
#define	DDE_DATA_HAVE_TIME	0x4000
#define DDE_DATA_GOTO_WKS	0x0200 /* skip process objs */
#define	DDE_DATA_MODIFIED	0x0400 
/* data has been modified by at least one obj */

/* bit 4 is set if appending to 
 * the worksheet, (nRowBegin is ignored as a result.)
 * If bit 4 is NOT set,
 * worksheet data beginning with (nColumnBegin, nRowBegin)
 * will be replaced with new data.
 */

#define	IS_DDE_DATA_APPEND(wFormat)	(wFormat & DDE_DATA_APPEND)

/* if DDE_DATA_PTR, the LPDATAWKS will have
 * following form
 */
typedef struct	PUTWKS {
	USHORT 	wFormat;	/* Data format as well as cntrl info */
	short 	nColumns;	/* number of data sets to receive data */
	USHORT 	nRows;		/* number of rows in each data set 0->64K */
	USHORT 	nRowBegin;	/* beginning row number , 0,1,2 ...64K */
	short	nColumnBegin;/* beginning column number, 0,1,2.. */
	LPSTR	lpData;
} PUTWKS, FAR *LPPUTWKS;

#define	LPPTRDATA(lpwks)	(LPSTR) ((LPPUTWKS)lpwks)->lpData
#define	LPARRAYDATA(lpwks)	((lpwks)->wFormat & DDE_DATA_PTR)? LPPTRDATA(lpwks) : (LPSTR)(lpwks)->data
