// ODDE.h : main header file for the ODDE application
//

#if !defined(AFX_ODDE_H__9753FEA4_B2FD_11D2_9F2A_00C04F79FBFB__INCLUDED_)
#define AFX_ODDE_H__9753FEA4_B2FD_11D2_9F2A_00C04F79FBFB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols
#include <dde.h>
#include "OriginServer.h"

/////////////////////////////////////////////////////////////////////////////
// CODDEApp:
// See ODDE.cpp for the implementation of this class
//

class CODDEApp : public CWinApp
{
public:
	CODDEApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CODDEApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CODDEApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	BOOL		IsServerRunning() {return m_OriginServer.IsServerRunning();}
	BOOL		IsServerNotFound() {return m_OriginServer.IsServerNotFound();}
	BOOL		DoOneTimeDataTransfer();
	BOOL		DoOpenServer(CWnd *pWnd);
	BOOL		DoWindowProc(CWnd *pWnd, UINT message, WPARAM wParam, LPARAM lParam);
	void		OnClose(CWnd *pWnd) {m_OriginServer.On_WM_CLOSE(pWnd->m_hWnd);}

	BOOL		SendData(int nRows, LPCTSTR lpszWksName, WORD wOrginDDEFormat); // we will have several dataset prepared before hand

	void		StartRealTimeTransfer(CWnd *pWnd);
	void		StopRealTimeTransfer(CWnd *pWnd);
	void		ProcessRealTimeTransfer(int nEventID, CWnd *pWnd);
	//IV 04/07/99 t3291 FINISH_MOVE_DDEDEMO_32BIT
	BOOL		OnCommandString(LPCTSTR lptsrCommand);
	//end FINISH_MOVE_DDEDEMO_32BIT

	void		ToggleUseFloat()	{m_bUseFloatDataType = m_bUseFloatDataType? FALSE:TRUE;}
	BOOL		IsUseFloat()		{return m_bUseFloatDataType;}

	void		ToggleKeepColumnType()	{m_bKeepColumnType = m_bKeepColumnType? FALSE:TRUE;}
	BOOL		IsKeepColumnType()		{return m_bKeepColumnType;}

private:
	OriginServer	m_OriginServer;
	//HANDLE			m_hData[NUM_DATASETS];
	int				m_nTimerID;
	int				m_nTimerRate;
	BOOL			m_bUseFloatDataType;
	BOOL			m_bKeepColumnType;
public:
	CString			m_strCmdLine;
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ODDE_H__9753FEA4_B2FD_11D2_9F2A_00C04F79FBFB__INCLUDED_)
