// ODDEDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ODDE.h"
#include "ODDEDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CODDEDlg dialog

CODDEDlg::CODDEDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CODDEDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CODDEDlg)
	m_chk_continuous_transfer = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CODDEDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CODDEDlg)
	DDX_Control(pDX, IDC_KEEP_TEXT_NUMERIC, m_chkKeepColumnType);
	DDX_Control(pDX, IDC_USE_FLOAT_TYPE, m_chkUseFloat);
	DDX_Control(pDX, IDC_EDIT_ORGIN_CMD_LINE, m_btn_cmd_line_edit);
	DDX_Control(pDX, IDC_NO_SERVER_MSG, m_btn_no_server_msg);
	DDX_Control(pDX, IDC_SERVER_RUNNING, m_btn_server_running);
	DDX_Control(pDX, IDC_SERVER_NOT_FOUND, m_btn_server_not_found);
	DDX_Control(pDX, IDC_CONTINUOUS_TRANSFER, m_btn_continuous_transfer);
	DDX_Control(pDX, IDC_ONE_TIME_TRANSTER, m_btn_one_time_transfer);
	DDX_Control(pDX, IDC_OPEN_SERVER, m_btn_open_server);
	DDX_Control(pDX, IDC_CP_CLIPBOARD_GR1, m_btn_copy_gr1);
	DDX_Control(pDX, IDC_CP_CLIPBOARD_GR2, m_btn_copy_gr2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CODDEDlg, CDialog)
	//{{AFX_MSG_MAP(CODDEDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_ONE_TIME, OnOneTimeDataTransfer)
	ON_BN_CLICKED(IDC_OPEN_SERVER, OnOpenServer)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_CONTINUOUS_TRANSFER, OnContinuousTransfer)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CP_CLIPBOARD_GR1, OnCopyToClipboardGraph1)
	ON_BN_CLICKED(IDC_CP_CLIPBOARD_GR2, OnCopyToClipboardGraph2)
	ON_BN_CLICKED(IDC_USE_FLOAT_TYPE, OnUseFloatTypeChange)
	ON_BN_CLICKED(IDC_KEEP_TEXT_NUMERIC, OnKeepTextNumericChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CODDEDlg message handlers
///	iv 5/17/99 CHANGE_USER_INTERFACE
///const char		szcStartOriginCommandLine[] = "c:\\c\\vc32\\Origin60 /h ddetest";
const char		szcStartOriginCommandLine[] = "c:\\program files\\origin60\\origin60 /h ddetest";
///end CHANGE_USER_INTERFACE

BOOL CODDEDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	if(pApp->IsUseFloat())
		m_chkUseFloat.SetCheck(1);
	else
		m_chkUseFloat.SetCheck(0);

	if(pApp->IsKeepColumnType())
		m_chkKeepColumnType.SetCheck(1);
	else
		m_chkKeepColumnType.SetCheck(0);

	// TODO: Add extra initialization here
	m_btn_cmd_line_edit.SetWindowText(szcStartOriginCommandLine);
	ShowControls();
	//
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CODDEDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CODDEDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CODDEDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

///////////////////////////////////////////////////

void CODDEDlg::ShowControls()
{
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);

	m_btn_open_server.EnableWindow(pApp->IsServerRunning() || pApp->IsServerNotFound() ? FALSE : TRUE);
	m_btn_continuous_transfer.EnableWindow(pApp->IsServerRunning());
	m_btn_server_running.ShowWindow(pApp->IsServerRunning());
	m_btn_server_not_found.ShowWindow(pApp->IsServerNotFound());
	m_btn_open_server.ShowWindow(!pApp->IsServerNotFound());
	m_btn_no_server_msg.ShowWindow(pApp->IsServerNotFound());
	//IV 04/07/99 t3291 FINISH_MOVE_DDEDEMO_32BIT
	m_btn_copy_gr1.EnableWindow(pApp->IsServerRunning());
	m_btn_copy_gr2.EnableWindow(pApp->IsServerRunning());
	//end FINISH_MOVE_DDEDEMO_32BIT
	///	iv 5/17/99 CHANGE_USER_INTERFACE
	GetDlgItem(IDC_STATIC_DATA_TR)->EnableWindow(pApp->IsServerRunning());
	GetDlgItem(IDC_STATIC_COPY_CLIP)->EnableWindow(pApp->IsServerRunning());
	///	end CHANGE_USER_INTERFACE
	if(pApp->IsServerRunning() && !m_chk_continuous_transfer)
		m_btn_one_time_transfer.EnableWindow(TRUE);
	else
		m_btn_one_time_transfer.EnableWindow(FALSE);

	m_btn_cmd_line_edit.ShowWindow(m_btn_open_server.IsWindowEnabled());
}

void CODDEDlg::OnOneTimeDataTransfer() 
{
	// TODO: Add your control notification handler code here
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	pApp->DoOneTimeDataTransfer();
}

void CODDEDlg::OnOpenServer() 
{
	// TODO: Add your control notification handler code here
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	char	szTemp[200];
	m_btn_cmd_line_edit.GetWindowText(szTemp,200);
	pApp->m_strCmdLine = szTemp;
	pApp->DoOpenServer(this);
	
	ShowControls();
}



LRESULT CODDEDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);

	if(pApp->DoWindowProc(this, message, wParam, lParam))
	{
		if(WM_DDE_TERMINATE == message)
			ShowControls();

		return 0;
	}
//	if(WM_DDE_ACK == message)
//	{
//		TRACE("DDE message arrived\n");
//	}
	
	return CDialog::WindowProc(message, wParam, lParam);
}



void CODDEDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	pApp->OnClose(this);
	CDialog::OnClose();
}


///	iv 5/17/99 CHANGE_USER_INTERFACE
/*void CODDEDlg::OnContinuousTransfer() 
{
	// TODO: Add your control notification handler code here
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	// this is called before the value is changed.
	m_chk_continuous_transfer = m_chk_continuous_transfer? FALSE:TRUE;
	if(m_chk_continuous_transfer)
		pApp->StartRealTimeTransfer(this);
	else
		pApp->StopRealTimeTransfer(this);
} */

void CODDEDlg::OnContinuousTransfer() 
{
	// TODO: Add your control notification handler code here
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	// this is called before the value is changed.
	m_chk_continuous_transfer = m_chk_continuous_transfer? FALSE:TRUE;
	CString strText;
	if(m_chk_continuous_transfer)
	{
		pApp->StartRealTimeTransfer(this);
		strText.LoadString(IDS_STOP_SEND_DATA );
		m_btn_continuous_transfer.SetWindowText(strText);
	}
	else
	{
		pApp->StopRealTimeTransfer(this);
		strText.LoadString(IDS_START_SEND_DATA );
		m_btn_continuous_transfer.SetWindowText(strText);
	}
}


void CODDEDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	pApp->ProcessRealTimeTransfer(nIDEvent, this);

	CDialog::OnTimer(nIDEvent);
}


//IV 04/07/99 t3291 FINISH_MOVE_DDEDEMO_32BIT
void CODDEDlg::OnCopyToClipboardGraph1()
{
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	pApp->OnCommandString("Clipboard -Copy Graph1");

}


void CODDEDlg::OnCopyToClipboardGraph2()
{
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	ASSERT_VALID(pApp);
	pApp->OnCommandString("Clipboard -Copy Graph2");

}
//end FINISH_MOVE_DDEDEMO_32BIT

void CODDEDlg::OnUseFloatTypeChange() 
{
	// TODO: Add your control notification handler code here
	// this is called before the value is changed.
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	pApp->ToggleUseFloat();
	BOOL	bb = m_chkUseFloat.GetCheck();
	ASSERT(pApp->IsUseFloat() == bb);
}


void CODDEDlg::OnKeepTextNumericChange() 
{
	CODDEApp *pApp = (CODDEApp *)AfxGetApp();
	pApp->ToggleKeepColumnType();
	BOOL	bb = m_chkKeepColumnType.GetCheck();
	ASSERT(pApp->IsKeepColumnType() == bb);
}
