/*------------------------------------------------------------------------------*
 * File Name:ApplyFormats.c	 													*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Apply Formats Dialog						*
 * Copyright (c) Originlab Corp.	2002										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Project.h>
#include <Dialog.h>
#include <TreeEditor.h>
#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
#include <utilities.h>
#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <Selection.h>
#include "theme_utils.h"

static Dialog MyDlg("ApplyFormats", "ODlg");


static	string s_strThemeFilename;
static	string	s_strTempThemeFilename;

static	void	FilteredFileCleanup()
{
	if (s_strTempThemeFilename.IsFile())
		DeleteFile(s_strTempThemeFilename);
	
	s_strTempThemeFilename = "";
}

// need to place theme file into local static s_strThemeFilename
static bool prepare_theme_for_Dialog(LPCSTR lpcszThemeFile = NULL) // NULL means from clibpoard
{
	ASSERT(s_strThemeFilename.IsEmpty());
	
	if(lpcszThemeFile)
		s_strThemeFilename = lpcszThemeFile;
	else
	{
		if(!theme_is_in_clipboard())
			return false;
		
		if(!GetTempFileName(s_strThemeFilename))
			return false;
		
		if(!CopyThemeFromClipboard(s_strThemeFilename))
		{
			DeleteFile(s_strThemeFilename);
			return false;
		}
	}
	
	if(!GetTempFileName(s_strTempThemeFilename))
		return false;
	
	if(s_strThemeFilename.IsFile())
		return true;
	
	return false;
}

// from LabTalk, use DoModal
//nOpenDlg
// 1=Shift,Must Open
// 0=From Context menu, no shift key, check IsShiftShow
// 2=From Edit, MustOpen
bool PasteFormatsDialog(int nOpenDlg) 
{
	prepare_theme_for_Dialog();
	
	if(nOpenDlg > 0) //CPY 1/17/03, no ShiftShow check box, always assume checked
		MyDlg.DoModal();
	else
	{
		apply_formats(false, Selection.Objects.Count() > 0 ? THEMEAPPLY_SELECTION : THEMEAPPLY_ACTIVE);
	}
	
	return true;
}

// from LabTalk, this will create Modeless dialog	
bool StartApplyFormatsDialog(string strThemeFilename = "")
{
	if(strThemeFilename.IsEmpty())
		prepare_theme_for_Dialog(NULL);
	else
		prepare_theme_for_Dialog(strThemeFilename);
	
	return MyDlg.Create();
}

BEGIN_EVENT_MAP
	ON_INIT(OnInitDialog) 
	ON_BN_CLICKED(IDC_APPLYSTYLE_DOIT, OnApply)
	ON_BN_CLICKED(IDC_APPLYSTYLE_SELECTED, OnApplySelected)
	ON_BN_CLICKED(IDC_APPLYSTYLE_LIST_VIEW, OnListViewCheck)
	ON_CBN_SELCHANGE(IDC_APPLYSTYLE_TREE, OnTreeSelChange)
	ON_DESTROY(OnDestroy)
END_EVENT_MAP

static BOOL OnListViewCheck(Control oCntrl)
{
	theme_update_tree_list_view(MyDlg, IDC_APPLYSTYLE_LIST_VIEW, IDC_APPLYSTYLE_TREE);
	return TRUE;
}


///////////////////////////////////////////////////////
/// Initialization
///////////////////////////////////////////////////////
static BOOL OnInitDialog()
{
	ComboBox comboApplyTo = MyDlg.GetItem(IDC_APPLYSTYLE_TO);
	comboApplyTo.SetCurSel(Selection.Objects.Count() > 0 ? THEMEAPPLY_SELECTION : THEMEAPPLY_ACTIVE);

	MyDlg.Tree.SetRef(2); // 0 = to disable controls movement, 1 for page dialog, 2 for simple dialog
	
	TreeEditor tree 	= MyDlg.GetItem(IDC_APPLYSTYLE_TREE);
	tree.Load(s_strThemeFilename);
	theme_update_tree_list_view(MyDlg, IDC_APPLYSTYLE_LIST_VIEW, IDC_APPLYSTYLE_TREE);

	MyDlg.GetItem(IDC_APPLYSTYLE_SELECTED).Enable = false;
	return true;
}

///////////////////////////////////////////////////////
//// Cleanup
///////////////////////////////////////////////////////
static BOOL OnDestroy(void)
{
	FilteredFileCleanup();
	
	if(s_strThemeFilename.IsFile())
		DeleteFile(s_strThemeFilename);

	s_strThemeFilename.Empty();
	
	return TRUE;
}

//nApplyTo = -1 if called from inside dialog, if nApplyTo is not -1, then we
//are using this outside dialog so there should be no call to MyDlg to GetDlgItem 
static bool apply_formats(bool bSelected = false, int nApplyTo = -1)
{
	string		strApplyFile = s_strThemeFilename;
	
	if( nApplyTo < 0 )
	{
		TreeEditor tree = MyDlg.GetItem(IDC_APPLYSTYLE_TREE);
	
		if( bSelected )
		{
			int nCount = tree.GetSelectedRows(NULL, TRUE);

			if( nCount <= 0 )
				return false;
		}
		
		if( !tree.Save(s_strTempThemeFilename, bSelected, TRUE) )
			return false;
		
		strApplyFile = s_strTempThemeFilename;
		
		ComboBox comboApplyTo = MyDlg.GetItem(IDC_APPLYSTYLE_TO);
		nApplyTo = comboApplyTo.GetCurSel();
	}

	if(	THEMEAPPLY_SELECTION == nApplyTo )
	{
		if( Selection.Objects.Count() <= 0 )
			nApplyTo = THEMEAPPLY_ACTIVE;
	}

	return theme_apply(nApplyTo, strApplyFile);
}

static BOOL OnApply(Control oCntrl)
{
	return apply_formats();
}

static BOOL OnApplySelected(Control oCntrl)
{
	return apply_formats(true);
}

/// notification from OTreeEditor grid changes
static BOOL OnTreeSelChange(Control oCntrl)
{
	TreeEditor tree = oCntrl;
	int nCount = tree.GetSelectedRows(NULL, TRUE);
	//out_int("Num leafs selected=", nCount);
	Button btnApplySelected = MyDlg.GetItem(IDC_APPLYSTYLE_SELECTED);
	btnApplySelected.Enable = nCount>0? TRUE:FALSE;
	return FALSE; // no need for further processing
}
