/*------------------------------------------------------------------------------*
 * File Name: BinImp.h		 													*
 * Creation: LY 11/4/2002														*
 * Purpose: OriginC header file													*
 * Copyright (c) Originlab Corp. 2002											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP						*
 * EJP 09-12-2003 v7.5693 QA70-5073 ADD_READROWS_TO_BINIMP						*
 *------------------------------------------------------------------------------*/

#ifndef _BIN_IMP_H
#define _BIN_IMP_H

typedef struct tagBINIMP {
	int iHeaderBytes;				//number of bytes for header
	int iAutoColTypes;				//indicate if set col type explicitly
	int iNumColumns;				//number of columns
	int iPartial;					//indicate partial data will be read from the file
	int iPartialC1;					//partial reading start column number, 0 based, include this column
	int iPartialC2;					//partial reading end column number, this column will not be included
	int iPartialR1;					//partial reading start row number, 0 based, this row will be included
	int iPartialR2;					//partial reading end row number, this row will not be included
	int iRenameWks;					//if rename worksheet name to the file name
	int iBigEndian;					//numeric value byte order, use big endian if TRUE
	int iApplyRange;				//
	int iMode;						// Data destination in worksheet. See ASCIMP_MODE_* constants in OC_Types.h
	/// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
	int iSkipRows;					// number of data rows to skip for each row of data read
	/// end ADD_SKIPROWS_TO_BINIMP
	/// EJP 09-12-2003 v7.5693 QA70-5073 ADD_READROWS_TO_BINIMP
	int iReadRows;
	/// end ADD_READROWS_TO_BINIMP
	vector<BYTE> vParamType;		//data type for each column
	vector<WORD> vParamSize;		//size of the data type for each column, bytes
	vector<WORD> vParamCount;		//number of consective columns with same data type
} BINIMP;


enum {
	BIN_SUCCEED = 0,				// the import succeeded
	BIN_INVALID_ARGUMENT,			// invalid argument passed to the fucntion
	BIN_OPEN_FILE_FAILURE,			// fail to open the binary data file
	BIN_FAIL_INIT_WKS,				// fail to intialize the worksheet
	BIN_FAIL_RENAME_WKS,			// fail to rename the worksheet
	BIN_INVALID_TYPE,				// invalid data type found in the BINIMP struct 
	BIN_INVALID_SIZE				// invalid data element size
};
	

/**
		Import binary data file into a worksheet based on the description struct filled in by user.
	Example:
		
	Parameters:
		wks		= The worksheet object
		lpcszFile	= Binary data file name
		pbi		= Struct defined in OC_types.h file to descript binary data format
	Return:
		Returns 0 to indicate import successful. Non-zero value means error
*/
int wuImportBinary(Worksheet &wks, LPCSTR lpcszFile, BINIMP *pbi); 

/**
		Read a binary header parameter from a file into a string.
	Parameters:
		strDest = destination string to receive the header parameter value
		fil	= source file to read the header parameter from
		nType = header parameter data type
		nOffset = byte offset from the begining of the file
		nSize = size of data in bytes
	Return:
		true for success, else false.
*/
bool ReadBinaryHeaderParam(string &strDest, file &fil, int nType, int nOffset, int nSize, bool bLittleEndian=true);

#endif //_BIN_IMP_H