/*--------------------------------------------------------------------------------------*
 * File Name: ConvertSparseMatrix.c														*
 * Creation: ER (02/25/2003)															*
 * Purpose: OriginC code for converting sparse data to matrix							*
 * Copyright (c) OriginLab Corp., 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved																	*
 * 																						*
 * Modification Log:																	*
 * ER, 1/28/02: Changed xb, xe... variables to type double						      	*
 * LAS, 1/23/03:  Changed sparse_returnstep from type int to type double 		        *
 * and 'step=vSortedDATA[2]-vSortedDATA[1];' to 'step=vSortedDATA[1]-vSortedDATA[0];' 	*
 *																						*
 * LAS, 7/17/03:  QA-3648																*
 * SDB, 11/24/03: QA-5610 SET_XY_LIMITS, set the X and Y limits from user input.		*
 *--------------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <origin.h>
#include <getnbox.h>

////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////
// Prototypes of functions in this file:
int convert_sparse_find_min_max_step(vector& vec, double& dMin, double& dMax, double& dStep);
int convert_sparse_xyz_to_matrix(vector& vecX, vector& vecY, vector& vecZ, matrix& matResult, double dXbegin, double dXend, double dXstep, double dYbegin, double dYend, double dYstep, int iPrecision);

//////////////////////////////////////////////////////////////////////////////////////
// The following function converts data in X,Y,Z columns in a worksheet, to a 
// sparse matrix. This function needs to be passed the min, max, step value in X, Y.
// csmMakeMatrix:
// Parameters:
//				dXb:		Start value for X
//				dXe:		End value for X
//				dXs:		Step value for X
//				dYb:		Start value for Y
//				dYe:		End value for Y
//				dYs:		Step value for Y
//				strWksData:	Name of worksheet with input data
//				iColx:		Column number of X column
//				iColy:		Column number of Y column
//				iColz:		Column number of Z column
//				iPrec:		precision used to locate values; same as in Data_list() function
// Return:
//				0:			All points were converted
//				positive:	Number of points that did not get converted
//				-1:			Too many steps in x/y; no conversion was done
//
int ConvertSparseXYZ(string strWksName, int nXcol, int nYcol, int nZcol)
{
	Dataset dsX(strWksName,nXcol);
	Dataset dsY(strWksName,nYcol);
	Dataset dsZ(strWksName,nZcol);
	vector vecX = dsX;
	vector vecY = dsY;
	vector vecZ = dsZ;
	double dXmin,dXmax,dXstep,dYmin,dYmax,dYstep;
	convert_sparse_find_min_max_step(vecX, dXmin, dXmax, dXstep);
	convert_sparse_find_min_max_step(vecY, dYmin, dYmax, dYstep);
	GETN_TREE(tr)
	GETN_NUM(dXmin, _L("Minimum X Value"), dXmin)
	GETN_NUM(dXmax, _L("Maximum X Value"), dXmax)
	GETN_NUM(dXstep, _L("X Step Value"), dXstep)
	GETN_NUM(dYmin, _L("Minimum Y Value"), dYmin)
	GETN_NUM(dYmax, _L("Maximum Y Value"), dYmax)
	GETN_NUM(dYstep, _L("Y Step Value"), dYstep)
//	GETN_STR(strMatName,"", "")
//	tr.strMatName.Show=0;
	if (GetNBox(tr, _L("Sparse XYZ Conversion"), _L("Gridding Parameters"), NULL, NULL) )
	{
		MatrixPage matPg;						
		matPg.Create("Matrix.OTP", CREATE_HIDDEN);				
		string strMatName = matPg.GetName();
		tr.strMatName.strVal=strMatName;
		Matrix matResult(strMatName);
		int iCount = convert_sparse_xyz_to_matrix(vecX, vecY, vecZ, matResult, tr.dXmin.dVal, tr.dXmax.dVal, tr.dXstep.dVal, tr.dYmin.dVal, tr.dYmax.dVal, tr.dYstep.dVal, 8);
		//SDB, 11/24/03: QA-5610 SET_XY_LIMITS, set the X and Y limits from user input.
		matResult.SetXMin(tr.dXmin.dVal);
		matResult.SetXMax(tr.dXmax.dVal);
		matResult.SetYMin(tr.dYmin.dVal);
		matResult.SetYMax(tr.dYmax.dVal);
		// iCount has number of points that were rejected
		// If iCount is same as data size, then conversion failed completely - report to user and delete matrix
		if(iCount == dsZ.GetSize())
		{
			matPg.Destroy();
			MessageBox( GetWindow(), _L("Data is irregular. Please try Random conversion.") );
		}
		// If conversion worked, unhide matrix
		else
			matPg.SetShow();
	}
	return 0;
}
