/*------------------------------------------------------------------------------*
 * File Name:LT_Math.c		 													*
 * Creation: ER July 18 2003													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-10-2003 v7.0622 QA70-4745 SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT		*
 * Prithvi Maddi 07-10-2003 v7.0622 ADDING_THE_NAG_SPECIAL_FUNCTIONS_FOR_LABTALK*  		
 *------------------------------------------------------------------------------*/
 
#include <origin.h> // main Origin C header that is precompiled and already include most headers 


// This file will add new math functions to LabTalk

#define SHOW_ERR(_str)	out_str(_str)

// NAG functions from the Special Functions chapter.
// Those functions already available in LabTalk are not added.

/**
	NAG Polygamma function
	Parameters:
		x = value at which function should be evaluated
		k = ??
*/		
double real_polygamma(double x, int k)
{
	double y = nag_real_polygamma(x, k);
	return y;
}

double exp_integral(double x)
{
	double y = nag_exp_integral(x);
	return y;
}

// cosine integral
double cos_integral(double x)
{
	double y = nag_cos_integral(x);
	return y;
}


// sine integral
double sin_integral(double x)
{
	double y = nag_sin_integral(x);
	return y;
}

// Gamma function
double gamma(double x)
{
	double y = nag_gamma(x);
	return y;
}

// Gamma function
double log_gamma(double x)
{
	double y = nag_log_gamma(x);
	return y;
}



// Incomplete gamma function
double incomplete_gamma(double a, double x)
{
	double p, q;
	double tol = 1e-5;
	int ierr = nag_incomplete_gamma(a, x, tol, &p, &q);
	return p;
}

// Cumulative normal distribution function
double cumul_normal(double x)
{
	double y = nag_cumul_normal(x);
	return y;
}

// Complement of the cumulative normal distribution function
double cumul_normal_complem(double x)
{
	double y = nag_cumul_normal_complem(x);
	return y;
}

// Complement of the error function
double erfc(double x)
{
	double y = nag_erfc(x);
	return y;
}

// Error function
// Use Erf instead as erf for name - to avoid conflict with built-in error function
double Erf(double x)
{
	double y = nag_erf(x);
	return y;
}


// Bessel Y0
double bessel_y0(double x)
{
	double y = nag_bessel_y0(x);
	return y;
}


// Bessel Y1
double bessel_y1(double x)
{
	double y = nag_bessel_y1(x);
	return y;
}

// Bessel J0
double bessel_j0(double x)
{
	double y = nag_bessel_j0(x);
	return y;
}

// Bessel J1
double bessel_j1(double x)
{
	double y = nag_bessel_j1(x);
	return y;
}

// Airy function Ai
double airy_ai(double x)
{
	double y = nag_airy_ai(x);
	return y;
}

// Airy function Bi
double airy_bi(double x)
{
	double y = nag_airy_bi(x);
	return y;
}

// Derivative of Airy function Ai
double airy_ai_deriv(double x)
{
	double y = nag_airy_ai_deriv(x);
	return y;
}

// Derivative of Airy function Bi
double airy_bi_deriv(double x)
{
	double y = nag_airy_bi_deriv(x);
	return y;
}

// Modified Bessel Function K0
double bessel_k0(double x)
{
	double y = nag_bessel_k0(x);
	return y;
}

// Modified Bessel Function K1
double bessel_k1(double x)
{
	double y = nag_bessel_k1(x);
	return y;
}

// Modified Bessel Function I0
double bessel_i0(double x)
{
	double y = nag_bessel_i0(x);
	return y;
}

// Modified Bessel Function I1
double bessel_i1(double x)
{
	double y = nag_bessel_i1(x);
	return y;
}

// Scaled Modified Bessel Function K0
double bessel_k0_scaled(double x)
{
	double y = nag_bessel_k0_scaled(x);
	return y;
}

// Scaled Modified Bessel Function K1
double bessel_k1_scaled(double x)
{
	double y = nag_bessel_k1_scaled(x);
	return y;
}

// Scaled Modified Bessel Function I0
double bessel_i0_scaled(double x)
{
	double y = nag_bessel_i0_scaled(x);
	return y;
}

// Scaled Modified Bessel Function I1
double bessel_i1_scaled(double x)
{
	double y = nag_bessel_i1_scaled(x);
	return y;
}


// Scaled Modified Bessel Function I_nu
double bessel_i_nu_scaled(double x, int nu)
{
	double y = nag_bessel_i_nu_scaled(x, nu);
	return y;
}

// Scaled Modified Bessel Function K_nu
double bessel_k_nu_scaled(double x, int nu)
{
	double y = nag_bessel_k_nu_scaled(x, nu);
	return y;
}

// Modified Bessel Function I_nu
double bessel_i_nu(double x, int nu)
{
	double y = nag_bessel_i_nu(x, nu);
	return y;
}

// Modified Bessel Function K_nu
double bessel_k_nu(double x, int nu)
{
	double y = nag_bessel_k_nu(x, nu);
	return y;
}

// Kelvin Function berx
double kelvin_ber(double x)
{
	double y = nag_kelvin_ber(x);
	return y;
}

// Kelvin Function beix
double kelvin_bei(double x)
{
	double y = nag_kelvin_bei(x);
	return y;
}

// Kelvin Function kerx
double kelvin_ker(double x)
{
	double y = nag_kelvin_ker(x);
	return y;
}

// Kelvin Function keix
double kelvin_kei(double x)
{
	double y = nag_kelvin_kei(x);
	return y;
}

// Fresnel Integral S
double fresnel_s(double x)
{
	double y = nag_fresnel_s(x);
	return y;
}

// Fresnel Integral C
double fresnel_c(double x)
{
	double y = nag_fresnel_c(x);
	return y;
}

// Elliptical Integral rc
double elliptic_integral_rc(double x, double y)
{
	double yret = nag_elliptic_integral_rc(x, y);
	return yret;
}

// Elliptical Integral rf
double elliptic_integral_rf(double x, double y, double z)
{
	double yret = nag_elliptic_integral_rf(x, y, z);
	return yret;
}

// Elliptical Integral rd
double elliptic_integral_rd(double x, double y, double z)
{
	double yret = nag_elliptic_integral_rd(x, y, z);
	return yret;
}

// Elliptical Integral rj
double elliptic_integral_rj(double x, double y, double z, double r)
{
	double yret = nag_elliptic_integral_rj(x, y, z, r);
	return yret;
}

// Jacobian Theta Function
double jacobian_theta(int k, double x, double q)
{
	double y = nag_jacobian_theta(k, x, q);
	return y;
}


void List_NAG_SF()
{
	printf("----------------------------------------------------------------------------------------\n");
	printf("List of NAG Special Functions:\n");
	printf("----------------------------------------------------------------------------------------\n");
	printf("  exp_integral(x): \tExponential Integral.\n");
	printf("  cos_integral(x): \tCosine Integral.\n");
	printf("  sin_integral(x): \tSine Integral.\n");
	printf("\n");
	printf("  gamma(x): \t\tGamma Function.\n");
	printf("  log_gamma(x): \tLogarithm of Gamma Function.\n");
	printf("  real_polygamma(x,k): \tkth derivative of the psi function psi(x); k = 0 to 6.\n");
	printf("  incomplete_gamma(a, x): \tLower Incomplete Gamma Function (upper = 1 - lower).\n");
	printf("\n");
	printf("  cumul_normal(x): \tCumulative Normal Distribution Function.\n");
	printf("  cumul_normal_complem(x): \tComplement of the Cumulative Normal Distribution Function.\n");
	printf("  erfc(x): \t\tComplementary Error Function.\n");
	printf("  erf(x): \t\tError Function.\n");
	printf("  airy_ai(x): \t\tAiry Function Ai.\n");
	printf("  airy_bi(x): \t\tAiry Function Bi.\n");
	printf("  airy_ai_deriv(x): \tDerivative of Airy Function Ai.\n");
	printf("  airy_bi_deriv(x): \tDerivative of Airy Function Bi.\n");
	printf("\n");
	printf("  bessel_y0(x): \tBessel Function Y0.\n");
	printf("  bessel_y1(x): \tBessel Function Y1.\n");
	printf("  bessel_j0(x): \tBessel Function J0.\n");
	printf("  bessel_j1(x): \tBessel Function J1.\n");
	printf("  bessel_k0(x): \tModified Bessel Function K0.\n");
	printf("  bessel_k1(x): \tModified Bessel Function K1.\n");
	printf("  bessel_i0(x): \tModified Bessel Function I0.\n");
	printf("  bessel_i1(x): \tModified Bessel Function I1.\n");
	printf("  bessel_i_nu(x, nu): \tModified Bessel Function I_nu.\n");
	printf("  bessel_k_nu(x, nu): \tModified Bessel Function K_nu.\n");
	printf("  bessel_k0_scaled(x): \tScaled Modified Bessel Function K0.\n");
	printf("  bessel_k1_scaled(x): \tScaled Modified Bessel Function K1.\n");
	printf("  bessel_i0_scaled(x): \tScaled Modified Bessel Function I0.\n");
	printf("  bessel_i1_scaled(x): \tScaled Modified Bessel Function I1.\n");
	printf("  bessel_i_nu_scaled(x, nu): \tScaled Modified Bessel Function I_nu.\n");
	printf("  bessel_k_nu_scaled(x, nu): \tScaled Modified Bessel Function K_nu.\n");
	printf("  kelvin_ber(x): \tKelvin Function ber.\n");
	printf("  kelvin_bei(x): \tKelvin Function bei.\n");
	printf("  kelvin_ker(x): \tKelvin Function ker.\n");
	printf("  kelvin_kei(x): \tKelvin Function kei.\n");
	printf("  fresnel_s(x): \tFresnel Integral S.\n");
	printf("  fresnel_c(x): \tFresnel Integral C.\n");
	printf("  jacobian_theta(k, x, q): \tJacobian Theta Function.\n");
	printf("\n");
	printf("  elliptic_integral_rc(x, y): \tEllipitcal Integral rc.\n");
	printf("  elliptic_integral_rf(x, y, z): \tEllipitcal Integral rf.\n");
	printf("  elliptic_integral_rd(x, y, z): \tEllipitcal Integral rd.\n");
	printf("  elliptic_integral_rj(x, y, z, r): \tEllipitcal Integral rj.\n");
	printf("\n  For more information, please refer to NAG - Approximation of Special Functions\n");
	printf("  chapter of the Origin C Language Reference Help File.\n");
	printf("----------------------------------------------------------------------------------------\n");
	printf("\n");
}

