/*------------------------------------------------------------------------------*
 * File Name: OMat.h															*
 * Creation: GJL 5/13/02														*
 * Purpose: Origin C header file for OMat.c										*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _OMAT_H
#define _OMAT_H

//////////////////////////////////////////////////////////////////////////////////
// Direct Matrix Conversion (DMC) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define DMC_WKS_SEL_ERROR_MSG		"Invalid Selected Range. Select a contiguous range of worksheet/workbook data and click the Update Selected Range\nbutton or enter a valid range similar to Data1_A[1]:K[8] or [Book1]Sheet1!$A$1:$K$8."
#define DMC_INPUT_WKS_ERROR_MSG		"Unable to get the selected worksheet/workbook range."
#define DMC_OUTPUT_MAT_ERROR_MSG	"Unable to create an output matrix."
#define DMC_XMAP_WARNING_MSG		"X values not uniformly spaced - default X coordinates 1 to number of columns used.\nSelect the Matrix:Set Dimensions menu item to specify new X coordinates." 
#define DMC_YMAP_WARNING_MSG		"Y values not uniformly spaced - default Y coordinates 1 to number of rows used.\nSelect the Matrix:Set Dimensions menu item to specify new Y coordinates." 
#define DMC_MATRIX_PAGE_LABEL		"From selected range "

//////////////////////////////////////////////////////////////////////////////////
// Matrix Replace (MR) constants needing localization
//////////////////////////////////////////////////////////////////////////////////
#define MR_TITLE					"Matrix Replace"
#define MR_COND_VAL_NOT_OK_MSG		"The Condition value must be a single numeric value."
#define MR_REPL_VAL_NOT_OK_MSG		"The Replace with value must be a single numeric value."
#define MR_ABS_COND_ERROR_MSG		"Absolute value function not compatible with negative or missing Condition value.\nMatrix Replace not performed." 
#define MR_ACT_MAT_ERROR_MSG		"Unable to get active matrix. Matrix Replace not performed."
#define MR_UNDO_WARNING_MSG			"Undo for this Matrix Replace operation will not be available.\nDo you want to continue?"
#define MR_FAILED_UNDO_ERROR_MSG	"Matrix Replace failed. Original matrix values have been restored."
#define MR_FAILED_ERROR_MSG			"Matrix Replace failed."

#define MR_UNDO_FAILED_ERROR_MSG	"Unable to perform Undo Matrix Replace."
#define MR_UNDO_SUCCESS_MSG			"Undo Matrix Replace has been completed."

//////////////////////////////////////////////////////////////////////////////////
// Non-Localzed constants and literals used in Direct Matrix Conversion
//////////////////////////////////////////////////////////////////////////////////
//
#define DMC_ESCAPE						-1
#define DMC_NO_ERROR					0
#define DMC_XMAP_WARNING				1
#define DMC_YMAP_WARNING				2
#define DMC_WKS_SEL_ERROR				100
#define DMC_INPUT_WKS_PAGE_ERROR		101
#define DMC_INPUT_ORIGIN_WKSHT_ERROR	102
#define DMC_INPUT_EXCEL_WKSHT_ERROR		103
#define DMC_UPDATE_ORIGIN_ERROR			104
#define DMC_CPY_WKS_TO_MAT_ERROR		105
#define DMC_TRANSPOSE_MATRIX_ERROR		106
#define DMC_ATTACH_OUTPUT_MAT_ERROR		107
#define DMC_SUB_MAT_ERROR				108

#define DMC_UNIFORM_SPACING_TOL			0.05
#define DMC_X_VARIES_ACROSS_ROWS		1

//////////////////////////////////////////////////////////////////////////////////
// Non-Localzed constants and literals used in Matrix Replace
//////////////////////////////////////////////////////////////////////////////////
//
#define MR_NO_ERROR						0
#define MR_ABS_COND_ERROR				100
#define MR_ACT_MATRIX_ERROR				101
#define MR_NO_UNDO_QUIT_ERROR			102
#define MR_FAILED_ERROR					103
#define MR_UNDO_FAILED_ERROR			104

#define MR_UNDO_WKS_NAME				"MRUndo"

//////////////////////////////////////////////////////////////////////////////////
// Function Prototypes in OMat.c
//////////////////////////////////////////////////////////////////////////////////
//

/**
		HLOC function to directly convert an Origin worksheet or Excel workbook range
		selection to a matrix.
	Example:
		See the OnClickConvert function in OMatDlgDMC.c for a sample call.
	Parameters:
		trDMC=Input DirectMatConvert tree containing all dialog settings
	Return:
		Returns DMC_NO_ERROR on success and a DMC_ERROR code on failure.
*/
int ConvertWksToMatrixDirect(Tree& trDMC);

/**
		LLOC function to directly convert an Origin worksheet or Excel workbook range
		selection to a matrix according to a bitwise data format description code.
	Example:
		See the ConvertWksToMatrixDirect function in OMat.c for a sample call.
	Parameters:
		strWksSelection=Input worksheet/workbook range selection string like "Worksheet_A[1]:B[7]" or
			"[Book1]Sheet1!$A$1:$B$7"
		iDataFormat=Bitwise data format description: Bit 0=1 X varies across columns or Bit 0=0 Y varies
			across columns, Bit 1=1 First row contains X/Y values, Bit 2=1 First column contains X/Y values
		mpOut=Output matrix page
	Return:
		Returns DMC_NO_ERROR and a valid matrix page on success or a DMC_ERROR code on failure.
*/
int convert_wks_to_matrix_direct(string strWksSelection, int iDataFormat, MatrixPage& mpOut);

/**
		Create and initialize a DirectMatConvert tree.
	Return:
		Returns a newly created DirectMatConvert tree.
*/
Tree CreateDirectMatConvertTree();

/**
		Initialize a DirectMatConvert tree.
	Parameters:
		trDMC=DirectMatConvert tree to initialize
	Return:
		Returns an initialized DirectMatConvert tree by reference.
*/
BOOL InitDirectMatConvertTree(Tree& trDMC);

/**
		HLOC function to perfrom conditional replace on an internal Origin matrix.
	Example:
		See the OnClickReplace function in OMatDlgMR.c for a sample call.
	Parameters:
		trMR=Input MatrixReplace tree containing all dialog settings
	Return:
		Returns MR_NO_ERROR or a MR_ERROR code on failure.
*/
int MatrixReplace(Tree& trMR);

/**
		HLOC to undo matrix replace.
	Example:
		iRet = UndoMatrixReplace();
	Return:
		Returns MR_NO_ERROR on success or MR_UNDO_FAILED_ERROR on failure.
*/
int UndoMatrixReplace();

/**
		Create and initialize a MatrixReplace tree.
	Return:
		Returns a newly created MatrixReplace tree.
*/
Tree CreateMatrixReplaceTree();

/**
		Initialize a MatrixReplace tree.
	Parameters:
		trMR=MatrixReplace tree to initialize
	Return:
		Returns an initialized MatrixReplace tree by reference.
*/
BOOL InitMatrixReplaceTree(Tree& trMR);

#endif //_OMAT_H