/*------------------------------------------------------------------------------*
 * File Name: OMatDlgMR.h														*
 * Creation: GJL 2/20/03														*
 * Purpose: Origin C header file for OMatDlgMR.c								*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _OMAT_DLG_MR_H
#define _OMAT_DLG_MR_H

// Needed resource ID From HelpID.h
#define IDD_MR                          115

// Non-localized constants
#define MR_INPUT_ERROR                  100

/**
		MATRIX.OGS calls this function to launch modeless MatrixReplace dialog.
	Return:
		Returns TRUE on success and FALSE on failure.
*/
BOOL OnOpenMR();

/**
		Dialog Builder calls this function after the MatrixReplace dialog is
		launched.
	Return:
		Returns TRUE.
*/
static BOOL OnInitMR();

/**
		Dialog Builder calls this function when an edit change is made in a
		MatrixReplace edit box. This function ensures that no non-numeric
		characters are entered.
	Parameters:
		ctrl=Edit box control on MatrixReplace dialog box 
	Return:
		Returns TRUE.
*/
static BOOL	DisallowNonNumericsOnEditChange(Control ctrl);

/**
		Dialog Builder calls this function when the Replace push button is clicked.
	Parameters:
		ctrl=Replace push button control on MatrixReplace dialog box 
	Return:
		Returns MR_NO_ERROR on success and a MR_ERROR code on failure.
*/
static int OnClickReplace(Control ctrl);

/**
		Dialog Builder calls this function when the Undo push button is clicked.
	Parameters:
		ctrl=Undo push button control on MatrixReplace dialog box 
	Return:
		Returns MR_NO_ERROR on success and a MR_ERROR code on failure.
*/
static int OnClickUndo(Control ctrl);

/**
		Dialog Builder calls this function when the MatrixReplace dialog box
		is closed.
	Return:
		Returns TRUE.
*/
static BOOL OnClickCancel();

#endif //_OMAT_DLG_MR_H