/*------------------------------------------------------------------------------*
 * File Name:	SurvivalAnalysis.h: Contains OriginC definitions and			*
 *	declarations for all Survival Analysis features.							*
 * Creation: GJL 1/28/2002														*
 * Purpose: Origin C Header for SurvivalAnalysis.c								*
 * Copyright ( c ) OriginLab Corp.	2000-2002									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *					GJL 1/28/2002: Split off from OStat.h						*
 *------------------------------------------------------------------------------*/

#ifndef _SURVIVAL_ANAYSIS_H
#define _SURVIVAL_ANAYSIS_H

// Declare functions in SurvivalAnalysis.c
int saKaplanMeier( int nPts, int nResults, double dConLevel, string strSurvivalWKS );
int saKaplanMeier_Compute_Percentiles( int nd, vector<double> &vTP, vector<double> &vP, double *ardPercentile );
int saKaplanMeier_Compute_Con_Limits( double dConLevel, int nd, vector<double> &vTP, vector<double> &vP,
	 vector<double> &vPSIG, double *ardPerLLim, double *ardPerULim );
int saKaplanMeier_Output_to_ResultsLog( int nPts, vector<double> &vTIME, vector<int> &vCENSOR, double dCensoredPts,
	 vector<double> &vP, vector<double> &vPSIG, double dConLevel, double *ardPercentile, double *ardPerLLim,
	 double *ardPerULim );
int saKaplanMeier_Output_to_Worksheet( int nResults, string strSurvivalWKS, int nPts, vector<double> &vTIME, vector<int> &vCENSOR,
	 int nd, vector<double> &vP, vector<double> &vPSIG, double dConLevel, double *ardPercentile, double *ardPerLLim,
	 double *ardPerULim );

int saCoxPHM( int nPts, int nCovars, int nResults, string strSurvivalWKS );
int saCoxPHM_Compute_ChiSq_Prob_Hazard( int nCovars, vector<double> &vB, vector<double> &vSE, vector<double> &vCHISQ,
	 vector<double> &vPVAL, vector<double> &vHAZARD );
int saCoxPHM_Output_to_ResultsLog( int nResults, string strSurvivalWKS, int nPts, int nCovars, vector<double> &vTIME,
	 vector<int> &vCENSOR, double dCensoredPts, double ddev, vector<double> &vSUR, vector<double> &vB,
	 vector<double> &vSE, vector<double> &vCHISQ, vector<double> &vPVAL, vector<double> &vHAZARD );
int saCoxPHM_Output_to_Worksheet( string strSurvivalWKS, int nPts, int nCovars, vector<double> &vTIME,
	 vector<int> &vCENSOR, int nd, vector<double> &vSUR, vector<double> &vB, vector<double> &vSE,
	 vector<double> &vCHISQ, vector<double> &vPVAL, vector<double> &vHAZARD );

static int saSurvival_Analysis_ResultsLog_Summary( string strDB, string strTimeData, string strCensorData, string strCensorValue,
	 int nPts, double dCensoredPts );
// End declare functions in SurvivalAnalysis.c

// Define SurvivalAnalysis.c constants NOT needing localization
#define SA_NO_ERROR						0
#define SA_CHI_SQ_ERROR1				100
#define SA_CHI_SQ_ERROR2				101
#define SA_NORMAL_ERROR					102
#define SA_PROD_LIMIT_ERROR				103
#define SA_SURVIV_COX_ERROR				104
#define SA_DATA_SUM_ERROR1				105
#define SA_DATA_SUM_ERROR2				106
#define SA_GET_TEXT_ERROR				107
#define SA_SET_TEXT_ERROR				108
#define SA_ABORT_NO_ERROR_MSG			999

#define COX_MODEL_TOLERANCE				5e-6
#define COX_MODEL_ITERATIONS			100

#define SA_PERCENT_FORMAT			"%.4g%%"
#define SA_OGW_SUBFOLDER			"Tables"
	 
#define SA_CENSOR_DATASET_NAME		"_CENSOR"
#define SA_TIME_DATASET_NAME		"_Time"
#define SA_SURVIVAL_DATASET_NAME	"_Survival"
#define SA_STDERROR_DATASET_NAME	"_StdError"

#define KM_SURLLIM_DATASET_NAME		"_SurLLim" 
#define KM_SURULIM_DATASET_NAME		"_SurULim"
#define KM_PERCENT_DATASET_NAME		"_Percent" 
#define KM_ESTIMATE_DATASET_NAME	"_Estimate" 
#define KM_PERLLIM_DATASET_NAME		"_PerLLim"
#define KM_PERULIM_DATASET_NAME		"_PerULim"

#define COX_SORT_COVAR_DATA_NAME	"%s_COVAR%d"
#define COX_COVARIATE_DATASET_NAME	"_Covariate"
#define COX_PARAMEST_DATASET_NAME	"_ParamEst"
#define COX_CHISQ_DATASET_NAME		"_ChiSq"
#define COX_PVALUE_DATASET_NAME		"_PValue"
#define COX_HAZARD_DATASET_NAME		"_Hazard"
// End Define SurvivalAnalysis.c constants NOT needing localization

//// Subset of basic NAG definitions from <NAG\nag_types> needed by SurvivalAnalysis.c 
//#ifndef _ONAG_BASIC
//#define _ONAG_BASIC
//
//#define NE_NOERROR 0
//#define NE_REAL_ARG_CONS 9
//#define NE_ZERO_DOF_RESID 426
//#define NAG_ERROR_BUF_LEN 512
//
//#define Nag_TailProbability_start 264
//#define Nag_IncludeMean_start 285
//#define Nag_DummyType_start 384
//#define Nag_IntervalType_start 389
//
//typedef enum {Nag_LowerTail=Nag_TailProbability_start, Nag_UpperTail, Nag_TwoTailSignif,
	//Nag_TwoTailConfid, Nag_TwoTail, Nag_Central} Nag_TailProbability;
//typedef enum {Nag_TukeyInterval=Nag_IntervalType_start, Nag_BonferroniInterval, Nag_DunnInterval,
	//Nag_FisherInterval, Nag_ScheffeInterval} Nag_IntervalType;
//typedef enum {Nag_Poly=Nag_DummyType_start, Nag_Helmert, Nag_FirstLevel,
	//Nag_LastLevel, Nag_AllLevels} Nag_DummyType;
//typedef enum {Nag_MeanInclude=Nag_IncludeMean_start, Nag_MeanZero} Nag_IncludeMean;
	      //
//typedef struct {
	//int	code;    // Out: Error Code
	//BOOL	print;   // In: print? yes/no, not used in Origin C 
	//char	message[NAG_ERROR_BUF_LEN];      // InOut: Error message
	//UINT	handler; //Error handling function, not used from OriginC
	//int	errnum;  // May hold useful value for some errors
//} NagError;
//
//#endif // !_ONAG_BASIC
//
//// Functions below are implemented in ONAG DLL prepared by OriginLab and are
////	needed by SurvivalAnalysis.c
//#pragma dll(ONAG)
//
//// From <NAG\OCN_g01.h>: g01fcc nag_deviates_chi_sq
//double nag_deviates_chi_sq(
	//double p,	// the probability p from the distribution
	//double df,	// the degree of freedom
	//NagError* fail=NULL // NAG error structure
//);	// Deviates for the chi^2 distribution
//
//// From <NAG\OCN_g01.h>: g01fac nag_deviates_normal
//double nag_deviates_normal(
	//Nag_TailProbability tail,
	//double p,	// the probability from the standard Normal distribution
	//NagError* fail=NULL // NAG error structure
//);	// Deviates for the Normal distribution
//
//// From <NAG\OCN_g01.h>: g01ecc nag_prob_chi_sq
//double nag_prob_chi_sq(
	//Nag_TailProbability tail,
	//double x,	// the value of the x^2 variate
	//double df,	// the degree of freedom
	//NagError* fail=NULL // NAG error structure
//);	// Probabilities for chi^2 distribution
//
//// From <NAG\OCN_g12.h>: g12aac nag_prod_limit_surviv_fn
//int nag_prod_limit_surviv_fn(
	//int n,	//the number of failure and censored times give in t
	//const double t[],	//the failure and censored times;these need not be ordered.
	//const int ic[],	//contains the censoring code of the ith observatio ,
	//const int freq[],	//indicates whether frequencies are provided for each failure and censored time point.
	//int *nd,	//the number of distinct failure times,
	//double tp[],	//contains the ith ordered distinct failure time,
	//double p[],	//contains the Kaplan-Meier estimate of the survival probability,
	//double psig[]	//contains an estimate of the standard deviation
//);	// General block design or completely randomized design
//
//// From <NAG\OCN_g12.h>: g12bac nag_surviv_cox_model
//int nag_surviv_cox_model(
	//int n,	//the number of data points
	//int m,	//the number of covariates
	//int ns,	//the number of strata
	//const double z[],	//the covariates
	//int tdz,	//the second dimension of array z;
	//const int sz[],	//indicates which subset of covariates is to be included
	//int ip,	//the number of covariates included as indicated by sz
	//const double t[],	//the vector of n failure censoring times
	//const int ic[],	//the status of the individual at time t given in t
	//const double omega[],	//if an offset is set, it contain value \omega[i], otherwise it is NULL;
	//const int isi[],	//the stratum indicator
	//double *dev,	//the deviance
	//double b[],	//initial estimates of the covariate coefficient parameters
	//double se[],	//the asymptotic standard error of the estimate
	//double sc[],	//the value of the score function
	//double cov[],	//the variance-covariance matirx of the parameter estimates
	//double res[],	//the residuals
	//int *nd,	//the number of distinct failure times
	//double tp[], //the distinct failure time
	//double sur[],	//the estimated survival function
	//int tdsur,	//the second dimension of the array
	//int ndmax,	//the first dimension of the array
	//double tol,	//the accuracy required for the estimation
	//int max_iter,	//the maximun number of iterations
	//int iprint,	//indicates if the printing information on the iteration is required
	//const char *outfile	//the name of the file into which information is to be output.
//);

#endif // !_SURVIVAL_ANAYSIS_H