/*------------------------------------------------------------------------------*
 * File Name:	TemplateLibrary.c				 								*
 * Creation: 	12/15/2001														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#include <origin.h>

////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
//
/**
		Opens a graph template and extracts an object "templatepict" if it exists.
	Example:
		OpenTemplate(Line);
	Return:
		1 for success extracting to templatepict.
*/
double	openTemplate(string template)
{
	double			isValid;
	GraphPage		grph;
	int				nOption = CREATE_HIDDEN | CREATE_NO_REMOVE_TEMPLATEPICT;
	BOOL bRet1	=	grph.Create(template, nOption);
	string			winName = grph.GetName();
	GraphLayer		lay(winName,0);
	LT_set_str("%Z",winName);
	LT_execute("ii=%Z!templatepict.enable");
	LT_get_var("ii", &isValid);
	if(isValid)
	{
		GraphObject		grPict;
		grPict		=	lay.GraphObjects("TemplatePict");
		string strPath = GetAppPath() + "TemplatePict.bmp";
		BOOL bRet2 	=	grPict.ExtractImageToFile(strPath);
	}
	grph.Destroy();
	return isValid;
}

